/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.CodeSource;
import com.sun.star.lib.sandbox.JarEntry;
import com.sun.star.lib.sandbox.JarInputStream;
import com.sun.star.lib.sandbox.PermissionCollection;
import com.sun.star.lib.sandbox.ProtectionDomain;
import com.sun.star.lib.sandbox.Resource;
import com.sun.star.lib.sandbox.ResourceProxy;
import java.applet.AudioClip;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.applet.AppletAudioClip;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.URLImageSource;

class ResourceImpl
implements Resource {
    private static int instances;
    private static final boolean DEBUG = false;
    private Object object;
    private byte[] bytes;
    private URL url;
    private String type;
    private ProtectionDomain protectionDomain;

    public ResourceImpl(URL uRL, byte[] byArray, ProtectionDomain protectionDomain) {
        ++instances;
        this.protectionDomain = protectionDomain;
        this.url = uRL;
        this.bytes = byArray;
    }

    public void finalize() {
        --instances;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.bytes == null) {
            URLConnection uRLConnection = this.url.openConnection();
            uRLConnection.setAllowUserInteraction(false);
            inputStream = uRLConnection.getInputStream();
        } else {
            inputStream = new ByteArrayInputStream(this.bytes);
        }
        return inputStream;
    }

    @Override
    public synchronized byte[] getBytes() throws IOException {
        if (this.bytes == null) {
            byte[] byArray;
            InputStream inputStream = this.getInputStream();
            int n = 0;
            int n2 = 0;
            Vector<byte[]> vector = new Vector<byte[]>();
            byte[] byArray2 = new byte[4096];
            n = inputStream.read(byArray2, 0, 4096);
            while (n != -1) {
                if (n < 4096) {
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                    byArray2 = byArray;
                }
                vector.addElement(byArray2);
                byArray2 = new byte[4096];
                n2 += n;
                n = inputStream.read(byArray2, 0, 4096);
            }
            inputStream.close();
            byArray = new byte[n2];
            int n3 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                byArray2 = (byte[])vector.elementAt(i);
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                n3 += byArray2.length;
            }
            this.bytes = byArray;
        }
        return this.bytes;
    }

    @Override
    public synchronized ImageProducer getImageProducer() {
        ImageProducer imageProducer = null;
        if (this.object != null) {
            imageProducer = (ImageProducer)this.object;
        } else {
            imageProducer = (ImageProducer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (ResourceImpl.this.bytes != null) {
                        return new ByteArrayImageSource(ResourceImpl.this.bytes, 0, ResourceImpl.this.bytes.length);
                    }
                    return new URLImageSource(ResourceImpl.this.url);
                }
            });
            this.object = imageProducer;
        }
        return imageProducer;
    }

    @Override
    public synchronized AudioClip getAudioClip() {
        AudioClip audioClip = null;
        if (this.object != null) {
            audioClip = (AudioClip)this.object;
        } else {
            audioClip = (AppletAudioClip)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (ResourceImpl.this.bytes != null) {
                        return new AppletAudioClip(ResourceImpl.this.bytes);
                    }
                    return new AppletAudioClip(ResourceImpl.this.url);
                }
            });
            this.object = audioClip;
        }
        return audioClip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadJar(URL uRL) throws IOException {
        if (this.object == null) {
            Vector<ResourceProxy> vector = new Vector<ResourceProxy>();
            JarInputStream jarInputStream = null;
            byte[] byArray = new byte[4096];
            try {
                jarInputStream = new JarInputStream(this.getInputStream());
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                while (jarEntry != null) {
                    int n;
                    String string = null;
                    String string2 = jarEntry.getName();
                    int n2 = string2.lastIndexOf(46);
                    if (n2 != -1) {
                        string = jarEntry.getName().substring(n2);
                        string2 = string2.substring(0, n2);
                    }
                    string2 = string2.replace('.', '/');
                    if (string != null) {
                        string2 = string2 + string;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n = jarInputStream.read(byArray)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    ProtectionDomain protectionDomain = null;
                    if (this.protectionDomain != null) {
                        PermissionCollection permissionCollection = this.protectionDomain.getPermissions();
                        CodeSource codeSource = new CodeSource(uRL, jarEntry.getIdentities());
                        protectionDomain = new ProtectionDomain(codeSource, permissionCollection);
                    }
                    vector.addElement(ResourceProxy.create(new URL(uRL, string2), byArray2, protectionDomain));
                    vector.addElement(ResourceProxy.create(new URL(uRL + "/" + string2), byArray2, protectionDomain));
                    jarEntry = jarInputStream.getNextJarEntry();
                }
            }
            finally {
                if (jarInputStream != null) {
                    jarInputStream.close();
                }
            }
            this.object = vector;
        }
    }

    private void guessType() {
        if (this.type == null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getBytes());
                this.type = URLConnection.guessContentTypeFromStream(byteArrayInputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.type == null) {
            this.type = "input-stream/input-stream";
        }
    }

    @Override
    public Object getContent() throws IOException {
        Object object = null;
        this.guessType();
        if (this.type.startsWith("image")) {
            object = this.getImageProducer();
        } else if (this.type.startsWith("audio")) {
            object = this.getAudioClip();
        } else if (!(this.type.startsWith("application/java-vm") || this.type.startsWith("application/x-java-vm") || this.type.equals("manifest/manifest") || this.type.equals("manifest/signature-bin"))) {
            object = this.getInputStream();
        }
        return object;
    }
}

