/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

public class AnyConverter {
    private static final Type m_XInterface_type = new Type(XInterface.class);

    public static Type getType(Object object) {
        Type type;
        if (null == object) {
            type = m_XInterface_type;
        } else if (object instanceof Any) {
            type = ((Any)object).getType();
            if (14 == type.getTypeClass().getValue()) {
                return AnyConverter.getType(((Any)object).getObject());
            }
        } else {
            type = new Type(object.getClass());
        }
        return type;
    }

    public static boolean isVoid(Object object) {
        return AnyConverter.containsType(TypeClass.VOID, object);
    }

    public static boolean isChar(Object object) {
        return AnyConverter.containsType(TypeClass.CHAR, object);
    }

    public static boolean isBoolean(Object object) {
        return AnyConverter.containsType(TypeClass.BOOLEAN, object);
    }

    public static boolean isByte(Object object) {
        return AnyConverter.containsType(TypeClass.BYTE, object);
    }

    public static boolean isShort(Object object) {
        return AnyConverter.containsType(TypeClass.SHORT, object);
    }

    public static boolean isInt(Object object) {
        return AnyConverter.containsType(TypeClass.LONG, object);
    }

    public static boolean isLong(Object object) {
        return AnyConverter.containsType(TypeClass.HYPER, object);
    }

    public static boolean isFloat(Object object) {
        return AnyConverter.containsType(TypeClass.FLOAT, object);
    }

    public static boolean isDouble(Object object) {
        return AnyConverter.containsType(TypeClass.DOUBLE, object);
    }

    public static boolean isString(Object object) {
        return AnyConverter.containsType(TypeClass.STRING, object);
    }

    public static boolean isEnum(Object object) {
        return AnyConverter.containsType(TypeClass.ENUM, object);
    }

    public static boolean isType(Object object) {
        return AnyConverter.containsType(TypeClass.TYPE, object);
    }

    public static boolean isObject(Object object) {
        int n = AnyConverter.getType(object).getTypeClass().getValue();
        return 22 == n || 17 == n || 19 == n || 20 == n || 15 == n;
    }

    public static boolean isArray(Object object) {
        return AnyConverter.containsType(TypeClass.SEQUENCE, object);
    }

    public static char toChar(Object object) throws IllegalArgumentException {
        Character c = (Character)AnyConverter.convertSimple(TypeClass.CHAR, null, object);
        return c.charValue();
    }

    public static boolean toBoolean(Object object) throws IllegalArgumentException {
        Boolean bl = (Boolean)AnyConverter.convertSimple(TypeClass.BOOLEAN, null, object);
        return bl;
    }

    public static byte toByte(Object object) throws IllegalArgumentException {
        Byte by = (Byte)AnyConverter.convertSimple(TypeClass.BYTE, null, object);
        return by;
    }

    public static short toShort(Object object) throws IllegalArgumentException {
        Short s = (Short)AnyConverter.convertSimple(TypeClass.SHORT, null, object);
        return s;
    }

    public static short toUnsignedShort(Object object) throws IllegalArgumentException {
        Short s = (Short)AnyConverter.convertSimple(TypeClass.UNSIGNED_SHORT, null, object);
        return s;
    }

    public static int toInt(Object object) throws IllegalArgumentException {
        Integer n = (Integer)AnyConverter.convertSimple(TypeClass.LONG, null, object);
        return n;
    }

    public static int toUnsignedInt(Object object) throws IllegalArgumentException {
        Integer n = (Integer)AnyConverter.convertSimple(TypeClass.UNSIGNED_LONG, null, object);
        return n;
    }

    public static long toLong(Object object) throws IllegalArgumentException {
        Long l = (Long)AnyConverter.convertSimple(TypeClass.HYPER, null, object);
        return l;
    }

    public static long toUnsignedLong(Object object) throws IllegalArgumentException {
        Long l = (Long)AnyConverter.convertSimple(TypeClass.UNSIGNED_HYPER, null, object);
        return l;
    }

    public static float toFloat(Object object) throws IllegalArgumentException {
        Float f = (Float)AnyConverter.convertSimple(TypeClass.FLOAT, null, object);
        return f.floatValue();
    }

    public static double toDouble(Object object) throws IllegalArgumentException {
        Double d = (Double)AnyConverter.convertSimple(TypeClass.DOUBLE, null, object);
        return d;
    }

    public static String toString(Object object) throws IllegalArgumentException {
        return (String)AnyConverter.convertSimple(TypeClass.STRING, null, object);
    }

    public static Type toType(Object object) throws IllegalArgumentException {
        return (Type)AnyConverter.convertSimple(TypeClass.TYPE, null, object);
    }

    public static Object toObject(Type type, Object object) throws IllegalArgumentException {
        return AnyConverter.convertSimple(type.getTypeClass(), type, object);
    }

    public static Object toObject(Class clazz, Object object) throws IllegalArgumentException {
        return AnyConverter.toObject(new Type(clazz), object);
    }

    public static Object toArray(Object object) throws IllegalArgumentException {
        return AnyConverter.convertSimple(TypeClass.SEQUENCE, null, object);
    }

    private static boolean containsType(TypeClass typeClass, Object object) {
        return AnyConverter.getType(object).getTypeClass().getValue() == typeClass.getValue();
    }

    private static Object convertSimple(TypeClass typeClass, Type type, Object object) throws IllegalArgumentException {
        Type type2;
        Object object2;
        if (object instanceof Any) {
            Any any = (Any)object;
            object2 = any.getObject();
            type2 = any.getType();
            if (14 == type2.getTypeClass().getValue()) {
                return AnyConverter.convertSimple(typeClass, type, object2);
            }
        } else {
            object2 = object;
            type2 = null == object2 ? m_XInterface_type : new Type(object2.getClass());
        }
        int n = type2.getTypeClass().getValue();
        int n2 = typeClass.getValue();
        if (null == object2) {
            if (22 == n && n2 == n) {
                return null;
            }
        } else {
            switch (n2) {
                case 1: {
                    if (n != 1) break;
                    return object2;
                }
                case 2: {
                    if (n != 2) break;
                    return object2;
                }
                case 3: {
                    if (n != 3) break;
                    return object2;
                }
                case 4: {
                    switch (n) {
                        case 3: {
                            return new Short(((Byte)object2).byteValue());
                        }
                        case 4: {
                            return object2;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (n) {
                        case 5: {
                            return object2;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (n) {
                        case 3: {
                            return new Integer(((Byte)object2).byteValue());
                        }
                        case 4: 
                        case 5: {
                            return new Integer(((Short)object2).shortValue());
                        }
                        case 6: {
                            return object2;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (n) {
                        case 5: {
                            return new Integer(((Short)object2).shortValue());
                        }
                        case 7: {
                            return object2;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (n) {
                        case 3: {
                            return new Long(((Byte)object2).byteValue());
                        }
                        case 4: 
                        case 5: {
                            return new Long(((Short)object2).shortValue());
                        }
                        case 6: 
                        case 7: {
                            return new Long(((Integer)object2).intValue());
                        }
                        case 8: {
                            return object2;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (n) {
                        case 5: {
                            return new Long(((Short)object2).shortValue());
                        }
                        case 7: {
                            return new Long(((Integer)object2).intValue());
                        }
                        case 9: {
                            return object2;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (n) {
                        case 3: {
                            return new Float(((Byte)object2).byteValue());
                        }
                        case 4: {
                            return new Float(((Short)object2).shortValue());
                        }
                        case 10: {
                            return object2;
                        }
                    }
                    break;
                }
                case 11: {
                    switch (n) {
                        case 3: {
                            return new Double(((Byte)object2).byteValue());
                        }
                        case 4: {
                            return new Double(((Short)object2).shortValue());
                        }
                        case 6: {
                            return new Double(((Integer)object2).intValue());
                        }
                        case 10: {
                            return new Double(((Float)object2).floatValue());
                        }
                        case 11: {
                            return object2;
                        }
                    }
                    break;
                }
                case 15: {
                    if (n != 15 || null != typeClass && !type.equals(type2)) break;
                    return object2;
                }
                case 12: {
                    if (n != 12) break;
                    return object2;
                }
                case 13: {
                    if (n != 13) break;
                    return object2;
                }
                case 22: {
                    if (!(object2 instanceof XInterface)) break;
                    return UnoRuntime.queryInterface(type, object2);
                }
                case 17: 
                case 19: {
                    if (!type.isSupertypeOf(type2)) break;
                    return object2;
                }
                case 20: {
                    if (n != 20 || null != type && !type.equals(type2)) break;
                    return object2;
                }
            }
        }
        throw new IllegalArgumentException("The Argument did not hold the proper type");
    }
}

