/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.java.JavaSystem;

public class LockFile {
    protected File f;
    private String cpath = null;
    protected RandomAccessFile raf;
    public static final long HEARTBEAT_INTERVAL = 10000L;
    public static final byte[] MAGIC = "HSQLLOCK".getBytes();
    protected boolean locked;
    protected static final HsqlTimer timer = DatabaseManager.getTimer();
    private Object timerTask;

    private void checkHeartbeat() throws Exception {
        long l;
        String string = "checkHeartbeat(): ";
        String string2 = "lock file [" + this.cpath + "]";
        this.trace(string + "entered.");
        if (!this.f.exists()) {
            this.trace(string + string2 + " does not exist. Check OK.");
            return;
        }
        if (this.f.length() != 16L) {
            this.trace(string + string2 + " length != 16; Check OK.");
            return;
        }
        try {
            l = System.currentTimeMillis() - this.readHeartbeat();
        }
        catch (Exception exception) {
            throw new Exception(Trace.getMessage(143, true, new Object[]{exception.toString(), this.cpath}));
        }
        this.trace(string + string2 + " last heartbeat " + l + " ms ago.");
        if (Math.abs(l) < 10000L) {
            throw new Exception(Trace.getMessage(144, true, new Object[]{string, string2}));
        }
    }

    private void closeRAF() throws Exception {
        String string = "closeRAF(): ";
        this.trace(string + "entered.");
        if (this.raf == null) {
            this.trace(string + "raf was null upon entry. Exiting immediately.");
        } else {
            this.trace(string + "closing " + this.raf);
            this.raf.close();
            this.trace(string + this.raf + " closed successfully. Setting raf null");
            this.raf = null;
        }
    }

    private void setFile(File file) throws Exception {
        if (this.isLocked()) {
            try {
                this.tryRelease();
            }
            catch (Exception exception) {
                this.trace(exception);
            }
        }
        this.f = FileUtil.getDefaultInstance().canonicalFile(file);
        this.cpath = this.f.getPath();
        this.raf = null;
        this.locked = false;
    }

    protected boolean lockImpl() throws Exception {
        String string = "lockImpl(): ";
        this.trace(string + "entered.");
        FileUtil.getDefaultInstance().deleteOnExit(this.f);
        return true;
    }

    private void openRAF() throws Exception {
        this.trace("openRAF(): entered.");
        this.raf = new RandomAccessFile(this.f, "rw");
        this.trace("openRAF(): got new 'rw' mode " + this.raf);
    }

    private long readHeartbeat() throws Exception {
        long l = Long.MIN_VALUE;
        String string = "readHeartbeat(): ";
        String string2 = "lock file [" + this.cpath + "]";
        this.trace(string + "entered.");
        if (!this.f.exists()) {
            this.trace(string + string2 + " does not exist. Return  '" + l + "'");
            return l;
        }
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.f));
        this.trace(string + " got new " + dataInputStream);
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == dataInputStream.readByte()) continue;
            this.trace(string + string2 + " is not lock file. Return '" + l + "'");
            return l;
        }
        l = dataInputStream.readLong();
        this.trace(string + " read:  [" + HsqlDateTime.getTimestampString(l) + "]");
        dataInputStream.close();
        this.trace(string + " closed " + dataInputStream);
        return l;
    }

    protected boolean releaseImpl() throws Exception {
        this.trace("releaseImpl(): no action: returning true");
        return true;
    }

    private void startHeartbeat() {
        this.trace("startHeartbeat(): entered.");
        if (this.timerTask == null || HsqlTimer.isCancelled(this.timerTask)) {
            HeartbeatRunner heartbeatRunner = new HeartbeatRunner();
            this.timerTask = timer.schedulePeriodicallyAfter(0L, 10000L, heartbeatRunner, true);
            this.trace("startHeartbeat(): heartbeat task scheduled.");
        }
        this.trace("startHeartbeat(): exited.");
    }

    private void stopHeartbeat() {
        String string = "stopHeartbeat(): ";
        this.trace(string + "entered");
        if (this.timerTask != null && !HsqlTimer.isCancelled(this.timerTask)) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
        this.trace(string + "exited");
    }

    private void writeMagic() throws Exception {
        String string = "writeMagic(): ";
        String string2 = "lock file [" + this.cpath + "]";
        this.trace(string + "entered.");
        this.trace(string + "raf.seek(0)");
        this.raf.seek(0L);
        this.trace(string + "raf.write(byte[])");
        this.raf.write(MAGIC);
        this.trace(string + "wrote [\"HSQLLOCK\".getBytes()] to " + string2);
    }

    private void writeHeartbeat() throws Exception {
        String string = "writeHeartbeat(): ";
        String string2 = "lock file [" + this.cpath + "]";
        this.trace(string + "entered.");
        long l = System.currentTimeMillis();
        this.trace(string + "raf.seek(" + MAGIC.length + ")");
        this.raf.seek(MAGIC.length);
        this.trace(string + "raf.writeLong(" + l + ")");
        this.raf.writeLong(l);
        this.trace(string + "wrote [" + l + "] to " + string2);
    }

    public static LockFile newLockFile(String string) throws Exception {
        LockFile lockFile;
        Class<?> clazz = null;
        try {
            Class.forName("java.nio.channels.FileLock");
            clazz = Class.forName("org.hsqldb.persist.NIOLockFile");
            lockFile = (LockFile)clazz.newInstance();
        }
        catch (Exception exception) {
            lockFile = new LockFile();
        }
        File file = new File(string);
        FileUtil.getDefaultInstance().makeParentDirectories(file);
        lockFile.setFile(file);
        return lockFile;
    }

    public static LockFile newLockFileLock(String string) throws HsqlException {
        LockFile lockFile = null;
        try {
            lockFile = LockFile.newLockFile(string + ".lck");
        }
        catch (Exception exception) {
            throw Trace.error(29, exception.toString());
        }
        boolean bl = false;
        String string2 = "";
        try {
            bl = lockFile.tryLock();
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        if (!bl) {
            throw Trace.error(1, lockFile + ": " + string2);
        }
        return lockFile;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LockFile) {
            LockFile lockFile = (LockFile)object;
            return this.f == null ? lockFile.f == null : this.f.equals(lockFile.f);
        }
        return false;
    }

    public String getCanonicalPath() {
        return this.cpath;
    }

    public int hashCode() {
        return this.f == null ? 0 : this.f.hashCode();
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(String string) {
        FileInputStream fileInputStream = null;
        try {
            LockFile lockFile = LockFile.newLockFile(string);
            lockFile.checkHeartbeat();
            if (lockFile.f.exists() && lockFile.f.isFile()) {
                fileInputStream = new FileInputStream(lockFile.f);
                fileInputStream.read();
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public boolean isValid() {
        return this.isLocked() && this.f != null && this.f.exists() && this.raf != null;
    }

    public String toString() {
        return super.toString() + "[file =" + this.cpath + ", exists=" + this.f.exists() + ", locked=" + this.isLocked() + ", valid=" + this.isValid() + ", " + this.toStringImpl() + "]";
    }

    protected String toStringImpl() {
        return "";
    }

    public boolean tryLock() throws Exception {
        String string = "tryLock(): ";
        this.trace(string + "entered.");
        if (this.locked) {
            this.trace(string + " lock already held. Returning true immediately.");
            return true;
        }
        this.checkHeartbeat();
        this.openRAF();
        this.locked = this.lockImpl();
        if (this.locked) {
            this.writeMagic();
            this.startHeartbeat();
            try {
                JavaSystem.runFinalizers();
                this.trace(string + "success for System.runFinalizersOnExit(true)");
            }
            catch (Exception exception) {
                this.trace(string + exception.toString());
            }
        } else {
            try {
                this.releaseImpl();
                this.closeRAF();
            }
            catch (Exception exception) {
                this.trace(string + exception.toString());
            }
        }
        this.trace(string + "ran to completion.  Returning " + this.locked);
        return this.locked;
    }

    public boolean tryRelease() throws Exception {
        boolean bl;
        String string = "tryRelease(): ";
        this.trace(string + "entered.");
        boolean bl2 = bl = !this.locked;
        if (bl) {
            this.trace(string + "No lock held. Returning true immediately");
            return true;
        }
        try {
            bl = this.releaseImpl();
        }
        catch (Exception exception) {
            this.trace(string + exception);
        }
        if (!bl) {
            this.trace(string + "releaseImpl() failed. Returning false immediately.");
            return false;
        }
        this.trace(string + "releaseImpl() succeeded.");
        this.stopHeartbeat();
        this.closeRAF();
        this.trace(string + "Starting Thread.sleep(100).");
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            this.trace(string + exception.toString());
        }
        this.trace(string + "Finished Thread.sleep(100).");
        String string2 = "[" + this.cpath + "]";
        if (this.f.exists()) {
            this.trace(string + string2 + " exists.");
            bl = this.f.delete();
            this.trace(string + string2 + (bl ? "" : "not") + " deleted.");
            if (this.f.exists()) {
                this.trace(string + " WARNING!: " + string2 + "still exists.");
            }
        }
        this.locked = !bl;
        this.trace(string + "ran to completion.  Returning " + bl);
        return bl;
    }

    protected void trace(Object object) {
        if (Trace.TRACE) {
            Trace.printSystemOut("[" + super.toString() + "]: " + object);
        }
    }

    protected void finalize() throws Throwable {
        this.trace("finalize(): calling tryRelease()");
        this.tryRelease();
    }

    protected class HeartbeatRunner
    implements Runnable {
        protected HeartbeatRunner() {
        }

        @Override
        public void run() {
            try {
                LockFile.this.trace("HeartbeatRunner.run(): writeHeartbeat()");
                LockFile.this.writeHeartbeat();
            }
            catch (Throwable throwable) {
                LockFile.this.trace("HeartbeatRunner.run(): caught Throwable: " + throwable);
            }
        }
    }
}

