/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

class Arguments
extends IdScriptable {
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int MAX_INSTANCE_ID = 3;
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall nativeCall) {
        this.setMaxId(3);
        this.activation = nativeCall;
        Scriptable scriptable = nativeCall.getParentScope();
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.args = nativeCall.getOriginalArguments();
        this.lengthObj = new Integer(this.args.length);
        NativeFunction nativeFunction = nativeCall.funObj;
        this.calleeObj = nativeFunction;
        this.callerObj = nativeFunction.version <= 130 && nativeFunction.version != 0 ? null : NOT_FOUND;
    }

    @Override
    public String getClassName() {
        return "Arguments";
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (0 <= n && n < this.args.length && this.args[n] != NOT_FOUND) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Object object;
        if (0 <= n && n < this.args.length && (object = this.args[n]) != NOT_FOUND) {
            String string;
            if (this.sharedWithActivation(n) && (object = this.activation.get(string = this.activation.funObj.argNames[n], (Scriptable)this.activation)) == NOT_FOUND) {
                Kit.codeBug();
            }
            return object;
        }
        return super.get(n, scriptable);
    }

    private boolean sharedWithActivation(int n) {
        NativeFunction nativeFunction = this.activation.funObj;
        int n2 = nativeFunction.argCount;
        if (n < n2) {
            if (n < n2 - 1) {
                String string = nativeFunction.argNames[n];
                for (int i = n + 1; i < n2; ++i) {
                    if (!string.equals(nativeFunction.argNames[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (0 <= n && n < this.args.length && this.args[n] != NOT_FOUND) {
            if (this.sharedWithActivation(n)) {
                String string = this.activation.funObj.argNames[n];
                this.activation.put(string, (Scriptable)this.activation, object);
                return;
            }
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[n] != NOT_FOUND) {
                    if (this.args == this.activation.getOriginalArguments()) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[n] = object;
                    return;
                }
            }
        }
        super.put(n, scriptable, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int n) {
        if (0 <= n && n < this.args.length) {
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[n] != NOT_FOUND) {
                    if (this.args == this.activation.getOriginalArguments()) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[n] = NOT_FOUND;
                    return;
                }
            }
        }
        super.delete(n);
    }

    @Override
    protected int getIdAttributes(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
        }
        return super.getIdAttributes(n);
    }

    @Override
    protected boolean hasIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj != NOT_FOUND;
            }
            case 2: {
                return this.lengthObj != NOT_FOUND;
            }
            case 3: {
                return this.callerObj != NOT_FOUND;
            }
        }
        return super.hasIdValue(n);
    }

    @Override
    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                Object object = this.callerObj;
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                } else if (object == null) {
                    NativeCall nativeCall = this.activation.caller;
                    object = nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
                }
                return object;
            }
        }
        return super.getIdValue(n);
    }

    @Override
    protected void setIdValue(int n, Object object) {
        switch (n) {
            case 1: {
                this.calleeObj = object;
                return;
            }
            case 2: {
                this.lengthObj = object;
                return;
            }
            case 3: {
                this.callerObj = object != null ? object : UniqueTag.NULL_VALUE;
                return;
            }
        }
        super.setIdValue(n, object);
    }

    @Override
    protected void deleteIdValue(int n) {
        switch (n) {
            case 1: {
                this.calleeObj = NOT_FOUND;
                return;
            }
            case 2: {
                this.lengthObj = NOT_FOUND;
                return;
            }
            case 3: {
                this.callerObj = NOT_FOUND;
                return;
            }
        }
        super.deleteIdValue(n);
    }

    @Override
    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String string) {
        int n = 0;
        String string2 = null;
        if (string.length() == 6) {
            char c = string.charAt(5);
            if (c == 'e') {
                string2 = "callee";
                n = 1;
            } else if (c == 'h') {
                string2 = "length";
                n = 2;
            } else if (c == 'r') {
                string2 = "caller";
                n = 3;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

