/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.UintMap;

public class Decompiler {
    public static final int ONLY_BODY_FLAG = 1;
    public static final int TO_SOURCE_FLAG = 2;
    public static final int INITIAL_INDENT_PROP = 1;
    public static final int INDENT_GAP_PROP = 2;
    public static final int CASE_GAP_PROP = 3;
    private static final int FUNCTION_END = 125;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private static final boolean printSource = false;

    String getEncodedSource() {
        return this.sourceToString(0);
    }

    int getCurrentOffset() {
        return this.sourceTop;
    }

    int markFunctionStart(int n, String string) {
        int n2 = this.getCurrentOffset();
        this.addToken(87);
        this.append((char)n);
        if (string.length() != 0) {
            this.addName(string);
        }
        return n2;
    }

    int markFunctionEnd(int n) {
        int n2 = this.getCurrentOffset();
        this.append('}');
        return n2;
    }

    void addToken(int n) {
        if (0 > n || n > 124) {
            throw new IllegalArgumentException();
        }
        this.append((char)n);
    }

    void addEOL(int n) {
        if (0 > n || n > 124) {
            throw new IllegalArgumentException();
        }
        this.append((char)n);
        this.append('\u0001');
    }

    void addAssignOp(int n) {
        if (0 > n || n > 124) {
            throw new IllegalArgumentException();
        }
        this.append('O');
        this.append((char)n);
    }

    void addName(String string) {
        this.addToken(39);
        this.appendString(string);
    }

    void addString(String string) {
        this.addToken(41);
        this.appendString(string);
    }

    void addRegexp(String string, String string2) {
        this.addToken(50);
        this.appendString('/' + string + '/' + string2);
    }

    void addNumber(double d) {
        this.addToken(40);
        long l = (long)d;
        if ((double)l != d) {
            l = Double.doubleToLongBits(d);
            this.append('D');
            this.append((char)(l >> 48));
            this.append((char)(l >> 32));
            this.append((char)(l >> 16));
            this.append((char)l);
        } else {
            if (l < 0L) {
                Kit.codeBug();
            }
            if (l <= 65535L) {
                this.append('S');
                this.append((char)l);
            } else {
                this.append('J');
                this.append((char)(l >> 48));
                this.append((char)(l >> 32));
                this.append((char)(l >> 16));
                this.append((char)l);
            }
        }
    }

    private void appendString(String string) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        if (n2 >= 32768) {
            n3 = 2;
        }
        if ((n = this.sourceTop + n3 + n2) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(n);
        }
        if (n2 >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | n2 >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)n2;
        ++this.sourceTop;
        string.getChars(0, n2, this.sourceBuffer, this.sourceTop);
        this.sourceTop = n;
    }

    private void append(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void increaseSourceCapacity(int n) {
        int n2;
        if (n <= this.sourceBuffer.length) {
            Kit.codeBug();
        }
        if ((n2 = this.sourceBuffer.length * 2) < n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceTop);
        this.sourceBuffer = cArray;
    }

    private String sourceToString(int n) {
        if (n < 0 || this.sourceTop < n) {
            Kit.codeBug();
        }
        return new String(this.sourceBuffer, n, this.sourceTop - n);
    }

    public static String decompile(String string, int n, UintMap uintMap) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.length();
        if (n6 == 0) {
            return "";
        }
        int n7 = uintMap.getInt(1, 0);
        if (n7 < 0) {
            Kit.argBug();
        }
        if ((n5 = uintMap.getInt(2, 4)) < 0) {
            Kit.argBug();
        }
        if ((n4 = uintMap.getInt(3, 2)) < 0) {
            Kit.argBug();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = 0 != (n & 1);
        boolean bl2 = 0 != (n & 2);
        int n8 = 0;
        boolean bl3 = false;
        int n9 = 0;
        if (string.charAt(n9) == 'v') {
            ++n9;
            n3 = -1;
        } else {
            n3 = string.charAt(n9 + 1);
        }
        if (!bl2) {
            stringBuffer.append('\n');
            for (n2 = 0; n2 < n7; ++n2) {
                stringBuffer.append(' ');
            }
        } else if (n3 == 2) {
            stringBuffer.append('(');
        }
        block94: while (n9 < n6) {
            switch (string.charAt(n9)) {
                case '\'': 
                case '2': {
                    n9 = Decompiler.printSourceString(string, n9 + 1, false, stringBuffer);
                    continue block94;
                }
                case ')': {
                    n9 = Decompiler.printSourceString(string, n9 + 1, true, stringBuffer);
                    continue block94;
                }
                case '(': {
                    n9 = Decompiler.printSourceNumber(string, n9 + 1, stringBuffer);
                    continue block94;
                }
                case '/': {
                    stringBuffer.append("true");
                    break;
                }
                case '.': {
                    stringBuffer.append("false");
                    break;
                }
                case ',': {
                    stringBuffer.append("null");
                    break;
                }
                case '-': {
                    stringBuffer.append("this");
                    break;
                }
                case 'W': {
                    ++n9;
                    stringBuffer.append("function ");
                    break;
                }
                case '}': {
                    break;
                }
                case 'M': {
                    stringBuffer.append(", ");
                    break;
                }
                case 'I': {
                    ++n8;
                    if (1 == Decompiler.getNext(string, n6, n9)) {
                        n7 += n5;
                    }
                    stringBuffer.append('{');
                    break;
                }
                case 'J': {
                    if (bl && --n8 == 0) break;
                    stringBuffer.append('}');
                    switch (Decompiler.getNext(string, n6, n9)) {
                        case 1: 
                        case 125: {
                            n7 -= n5;
                            break;
                        }
                        case 91: 
                        case 95: {
                            n7 -= n5;
                            stringBuffer.append(' ');
                        }
                    }
                    break;
                }
                case 'K': {
                    stringBuffer.append('(');
                    break;
                }
                case 'L': {
                    stringBuffer.append(')');
                    if (73 != Decompiler.getNext(string, n6, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'G': {
                    stringBuffer.append('[');
                    break;
                }
                case 'H': {
                    stringBuffer.append(']');
                    break;
                }
                case '\u0001': {
                    int n10;
                    if (bl2) break;
                    n2 = 1;
                    if (!bl3) {
                        bl3 = true;
                        if (bl) {
                            stringBuffer.setLength(0);
                            n7 -= n5;
                            n2 = 0;
                        }
                    }
                    if (n2 != 0) {
                        stringBuffer.append('\n');
                    }
                    if (n9 + 1 >= n6) break;
                    int n11 = 0;
                    char c = string.charAt(n9 + 1);
                    if (c == ']' || c == '^') {
                        n11 = n5 - n4;
                    } else if (c == 'J') {
                        n11 = n5;
                    } else if (c == '\'' && string.charAt(n10 = Decompiler.getSourceStringEnd(string, n9 + 2)) == 'Q') {
                        n11 = n5;
                    }
                    while (n11 < n7) {
                        stringBuffer.append(' ');
                        ++n11;
                    }
                    break;
                }
                case 'V': {
                    stringBuffer.append('.');
                    break;
                }
                case '\u001f': {
                    stringBuffer.append("new ");
                    break;
                }
                case ' ': {
                    stringBuffer.append("delete ");
                    break;
                }
                case 'Z': {
                    stringBuffer.append("if ");
                    break;
                }
                case '[': {
                    stringBuffer.append("else ");
                    break;
                }
                case 'a': {
                    stringBuffer.append("for ");
                    break;
                }
                case '6': {
                    stringBuffer.append(" in ");
                    break;
                }
                case 'e': {
                    stringBuffer.append("with ");
                    break;
                }
                case '_': {
                    stringBuffer.append("while ");
                    break;
                }
                case '`': {
                    stringBuffer.append("do ");
                    break;
                }
                case 'E': {
                    stringBuffer.append("try ");
                    break;
                }
                case 'f': {
                    stringBuffer.append("catch ");
                    break;
                }
                case 'g': {
                    stringBuffer.append("finally ");
                    break;
                }
                case '5': {
                    stringBuffer.append("throw ");
                    break;
                }
                case '\\': {
                    stringBuffer.append("switch ");
                    break;
                }
                case 'b': {
                    stringBuffer.append("break");
                    if (39 != Decompiler.getNext(string, n6, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'c': {
                    stringBuffer.append("continue");
                    if (39 != Decompiler.getNext(string, n6, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case ']': {
                    stringBuffer.append("case ");
                    break;
                }
                case '^': {
                    stringBuffer.append("default");
                    break;
                }
                case '\u0005': {
                    stringBuffer.append("return");
                    if (70 == Decompiler.getNext(string, n6, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'd': {
                    stringBuffer.append("var ");
                    break;
                }
                case 'F': {
                    stringBuffer.append(';');
                    if (1 == Decompiler.getNext(string, n6, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'N': {
                    stringBuffer.append(" = ");
                    break;
                }
                case 'O': {
                    switch (string.charAt(++n9)) {
                        case '\u0016': {
                            stringBuffer.append(" += ");
                            break;
                        }
                        case '\u0017': {
                            stringBuffer.append(" -= ");
                            break;
                        }
                        case '\u0018': {
                            stringBuffer.append(" *= ");
                            break;
                        }
                        case '\u0019': {
                            stringBuffer.append(" /= ");
                            break;
                        }
                        case '\u001a': {
                            stringBuffer.append(" %= ");
                            break;
                        }
                        case '\n': {
                            stringBuffer.append(" |= ");
                            break;
                        }
                        case '\u000b': {
                            stringBuffer.append(" ^= ");
                            break;
                        }
                        case '\f': {
                            stringBuffer.append(" &= ");
                            break;
                        }
                        case '\u0013': {
                            stringBuffer.append(" <<= ");
                            break;
                        }
                        case '\u0014': {
                            stringBuffer.append(" >>= ");
                            break;
                        }
                        case '\u0015': {
                            stringBuffer.append(" >>>= ");
                        }
                    }
                    break;
                }
                case 'P': {
                    stringBuffer.append(" ? ");
                    break;
                }
                case 'm': {
                    stringBuffer.append(':');
                    break;
                }
                case 'Q': {
                    if (1 == Decompiler.getNext(string, n6, n9)) {
                        stringBuffer.append(':');
                        break;
                    }
                    stringBuffer.append(" : ");
                    break;
                }
                case 'R': {
                    stringBuffer.append(" || ");
                    break;
                }
                case 'S': {
                    stringBuffer.append(" && ");
                    break;
                }
                case '\n': {
                    stringBuffer.append(" | ");
                    break;
                }
                case '\u000b': {
                    stringBuffer.append(" ^ ");
                    break;
                }
                case '\f': {
                    stringBuffer.append(" & ");
                    break;
                }
                case '0': {
                    stringBuffer.append(" === ");
                    break;
                }
                case '1': {
                    stringBuffer.append(" !== ");
                    break;
                }
                case '\r': {
                    stringBuffer.append(" == ");
                    break;
                }
                case '\u000e': {
                    stringBuffer.append(" != ");
                    break;
                }
                case '\u0010': {
                    stringBuffer.append(" <= ");
                    break;
                }
                case '\u000f': {
                    stringBuffer.append(" < ");
                    break;
                }
                case '\u0012': {
                    stringBuffer.append(" >= ");
                    break;
                }
                case '\u0011': {
                    stringBuffer.append(" > ");
                    break;
                }
                case '7': {
                    stringBuffer.append(" instanceof ");
                    break;
                }
                case '\u0013': {
                    stringBuffer.append(" << ");
                    break;
                }
                case '\u0014': {
                    stringBuffer.append(" >> ");
                    break;
                }
                case '\u0015': {
                    stringBuffer.append(" >>> ");
                    break;
                }
                case '!': {
                    stringBuffer.append("typeof ");
                    break;
                }
                case 'h': {
                    stringBuffer.append("void ");
                    break;
                }
                case '\u001b': {
                    stringBuffer.append('!');
                    break;
                }
                case '\u001c': {
                    stringBuffer.append('~');
                    break;
                }
                case '\u001d': {
                    stringBuffer.append('+');
                    break;
                }
                case '\u001e': {
                    stringBuffer.append('-');
                    break;
                }
                case 'T': {
                    stringBuffer.append("++");
                    break;
                }
                case 'U': {
                    stringBuffer.append("--");
                    break;
                }
                case '\u0016': {
                    stringBuffer.append(" + ");
                    break;
                }
                case '\u0017': {
                    stringBuffer.append(" - ");
                    break;
                }
                case '\u0018': {
                    stringBuffer.append(" * ");
                    break;
                }
                case '\u0019': {
                    stringBuffer.append(" / ");
                    break;
                }
                case '\u001a': {
                    stringBuffer.append(" % ");
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++n9;
        }
        if (!bl2) {
            if (!bl) {
                stringBuffer.append('\n');
            }
        } else if (n3 == 2) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static int getNext(String string, int n, int n2) {
        return n2 + 1 < n ? (int)string.charAt(n2 + 1) : 0;
    }

    private static int getSourceStringEnd(String string, int n) {
        return Decompiler.printSourceString(string, n, false, null);
    }

    private static int printSourceString(String string, int n, boolean bl, StringBuffer stringBuffer) {
        int n2 = string.charAt(n);
        ++n;
        if ((0x8000 & n2) != 0) {
            n2 = (Short.MAX_VALUE & n2) << 16 | string.charAt(n);
            ++n;
        }
        if (stringBuffer != null) {
            String string2 = string.substring(n, n + n2);
            if (!bl) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(ScriptRuntime.escapeString(string2));
                stringBuffer.append('\"');
            }
        }
        return n + n2;
    }

    private static int printSourceNumber(String string, int n, StringBuffer stringBuffer) {
        double d = 0.0;
        char c = string.charAt(n);
        ++n;
        if (c == 'S') {
            if (stringBuffer != null) {
                char c2 = string.charAt(n);
                d = c2;
            }
            ++n;
        } else if (c == 'J' || c == 'D') {
            if (stringBuffer != null) {
                long l = (long)string.charAt(n) << 48;
                l |= (long)string.charAt(n + 1) << 32;
                l |= (long)string.charAt(n + 2) << 16;
                d = c == 'J' ? (double)l : Double.longBitsToDouble(l |= (long)string.charAt(n + 3));
            }
            n += 4;
        } else {
            throw new RuntimeException();
        }
        if (stringBuffer != null) {
            stringBuffer.append(ScriptRuntime.numberToString(d, 10));
        }
        return n;
    }
}

