/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.ScriptRuntime;

public class DefiningClassLoader
extends ClassLoader
implements GeneratedClassLoader {
    private ClassLoader parentLoader;
    private ClassLoader contextLoader;
    private static Method method_getContextClassLoader;

    public DefiningClassLoader() {
        this.init(this.getClass().getClassLoader());
    }

    public DefiningClassLoader(ClassLoader classLoader) {
        this.init(classLoader);
    }

    private void init(ClassLoader classLoader) {
        this.parentLoader = classLoader;
        this.contextLoader = null;
        if (method_getContextClassLoader != null) {
            try {
                this.contextLoader = (ClassLoader)method_getContextClassLoader.invoke((Object)Thread.currentThread(), ScriptRuntime.emptyArgs);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (this.contextLoader == this.parentLoader) {
                this.contextLoader = null;
            }
        }
    }

    @Override
    public Class defineClass(String string, byte[] byArray) {
        return super.defineClass(string, byArray, 0, byArray.length);
    }

    @Override
    public void linkClass(Class clazz) {
        this.resolveClass(clazz);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            if (this.contextLoader == null) {
                clazz = this.loadFromParent(string);
            } else {
                try {
                    clazz = this.loadFromParent(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = this.contextLoader.loadClass(string);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private Class loadFromParent(String string) throws ClassNotFoundException {
        if (this.parentLoader != null) {
            return this.parentLoader.loadClass(string);
        }
        return this.findSystemClass(string);
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.lang.Thread");
            method_getContextClassLoader = clazz.getDeclaredMethod("getContextClassLoader", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

