/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class EcmaError
extends RuntimeException {
    private String errorName;
    private String errorMessage;
    private String sourceName;
    private int lineNumber;
    private int columnNumber;
    private String lineSource;

    EcmaError(String string, String string2, String string3, int n, String string4, int n2) {
        super("EcmaError: " + string + ": " + string2);
        this.errorName = string;
        this.errorMessage = string2;
        this.sourceName = string3;
        this.lineNumber = n;
        this.lineSource = string4;
        this.columnNumber = n2;
    }

    public EcmaError(Scriptable scriptable, String string, int n, int n2, String string2) {
        this("InternalError", ScriptRuntime.toString(scriptable), string, n, string2, n2);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.errorName);
        stringBuffer.append(": ");
        stringBuffer.append(this.errorMessage);
        if (this.sourceName != null || this.lineNumber > 0) {
            stringBuffer.append(" (");
            if (this.sourceName != null) {
                stringBuffer.append(this.sourceName);
                stringBuffer.append("; ");
            }
            if (this.lineNumber > 0) {
                stringBuffer.append("line ");
                stringBuffer.append(this.lineNumber);
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.errorName;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLineSource() {
        return this.lineSource;
    }

    public Scriptable getErrorObject() {
        return Undefined.instance;
    }
}

