/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;

public class EvaluatorException
extends RuntimeException {
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;

    public EvaluatorException(String string) {
        super(string);
        Context context = Context.getCurrentContext();
        if (context != null) {
            int[] nArray = new int[]{0};
            this.sourceName = Context.getSourcePositionFromStack(nArray);
            this.lineNumber = nArray[0];
        }
    }

    public EvaluatorException(String string, String string2, int n, String string3, int n2) {
        super(EvaluatorException.generateErrorMessage(string, string2, n));
        this.sourceName = string2;
        this.lineNumber = n;
        this.lineSource = string3;
        this.columnNumber = n2;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLineSource() {
        return this.lineSource;
    }

    static String generateErrorMessage(String string, String string2, int n) {
        if (string2 == null || n <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" (");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (n > 0) {
            stringBuffer.append('#');
            stringBuffer.append(n);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

