/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class IdFunction
extends BaseFunction {
    IdFunctionMaster master;
    private int methodId;
    private boolean useCallAsConstructor;

    public IdFunction(IdFunctionMaster idFunctionMaster, String string, int n) {
        this.functionName = string;
        this.master = idFunctionMaster;
        this.methodId = n;
    }

    public static void define(Scriptable scriptable, String string, IdFunctionMaster idFunctionMaster, int n) {
        IdFunction.define(scriptable, string, idFunctionMaster, n, 2, false);
    }

    public static void define(Scriptable scriptable, String string, IdFunctionMaster idFunctionMaster, int n, int n2) {
        IdFunction.define(scriptable, string, idFunctionMaster, n, n2, false);
    }

    public static void define(Scriptable scriptable, String string, IdFunctionMaster idFunctionMaster, int n, int n2, boolean bl) {
        IdFunction idFunction = new IdFunction(idFunctionMaster, string, n);
        idFunction.setParentScope(scriptable);
        if (bl) {
            idFunction.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, string, idFunction, n2);
    }

    public final int getMethodId() {
        return this.methodId;
    }

    @Override
    public Scriptable getPrototype() {
        Scriptable scriptable = super.getPrototype();
        if (scriptable == null) {
            scriptable = IdFunction.getFunctionPrototype(this.getParentScope());
            this.setPrototype(scriptable);
        }
        return scriptable;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return this.master.execMethod(this.methodId, this, context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable createObject(Context context, Scriptable scriptable) {
        if (this.useCallAsConstructor) {
            return null;
        }
        throw ScriptRuntime.typeError1("msg.not.ctor", this.functionName);
    }

    @Override
    String decompile(int n, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = 0 != (n2 & 1);
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() { ");
        }
        stringBuffer.append("[native code for ");
        if (this.master instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)((Object)this.master);
            stringBuffer.append(scriptable.getClassName());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append(", arity=");
        stringBuffer.append(this.getArity());
        stringBuffer.append(bl ? "]\n" : "] }\n");
        return stringBuffer.toString();
    }

    @Override
    public int getArity() {
        int n = this.master.methodArity(this.methodId);
        if (n < 0) {
            throw IdFunction.onBadMethodId(this.master, this.methodId);
        }
        return n;
    }

    @Override
    public int getLength() {
        return this.getArity();
    }

    public void initAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        this.useCallAsConstructor = true;
        this.setParentScope(scriptable);
        this.setImmunePrototypeProperty(scriptable2);
    }

    static RuntimeException onBadMethodId(IdFunctionMaster idFunctionMaster, int n) {
        return new RuntimeException("BAD FUNCTION ID=" + n + " MASTER=" + idFunctionMaster);
    }
}

