/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterFunctions;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ImporterTopLevel
extends ScriptableObject {
    private ObjArray importedPackages = new ObjArray();

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context context) {
        this(context, false);
    }

    public ImporterTopLevel(Context context, boolean bl) {
        this.initStandardObjects(context, bl);
    }

    @Override
    public String getClassName() {
        return "global";
    }

    public void initStandardObjects(Context context, boolean bl) {
        context.initStandardObjects(this, bl);
        ImporterFunctions.setup(this);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return super.has(string, scriptable) || this.getPackageProperty(string, scriptable) != NOT_FOUND;
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        object = this.getPackageProperty(string, scriptable);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPackageProperty(String string, Scriptable scriptable) {
        Object[] objectArray;
        Object object = NOT_FOUND;
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            objectArray = this.importedPackages.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)objectArray[i];
            Object object2 = nativeJavaPackage.getPkgProperty(string, scriptable, false);
            if (object2 == null || object2 instanceof NativeJavaPackage) continue;
            if (object == NOT_FOUND) {
                object = object2;
                continue;
            }
            throw Context.reportRuntimeError2("msg.ambig.import", object.toString(), object2.toString());
        }
        return object;
    }

    void importClass(Context context, Scriptable scriptable, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaClass)) {
                throw Context.reportRuntimeError1("msg.not.class", Context.toString(object));
            }
            String string = ((NativeJavaClass)object).getClassObject().getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Object object2 = scriptable.get(string2, scriptable);
            if (object2 != NOT_FOUND && object2 != object) {
                throw Context.reportRuntimeError1("msg.prop.defined", string2);
            }
            scriptable.put(string2, scriptable, object);
        }
    }

    public void importPackage(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        this.importPackage(context, scriptable, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importPackage(Context context, Scriptable scriptable, Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(object));
            }
            ObjArray objArray = this.importedPackages;
            synchronized (objArray) {
                for (int j = 0; j != this.importedPackages.size(); ++j) {
                    if (object != this.importedPackages.get(j)) continue;
                    object = null;
                    break;
                }
                if (object != null) {
                    this.importedPackages.add(object);
                }
                continue;
            }
        }
    }
}

