/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeBoolean
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private boolean booleanValue;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeBoolean nativeBoolean = new NativeBoolean(false);
        nativeBoolean.prototypeFlag = true;
        nativeBoolean.addAsPrototype(4, context, scriptable, bl);
    }

    private NativeBoolean(boolean bl) {
        this.booleanValue = bl;
    }

    @Override
    public String getClassName() {
        return "Boolean";
    }

    @Override
    public Object getDefaultValue(Class clazz) {
        if (clazz == ScriptRuntime.BooleanClass) {
            return this.wrap_boolean(this.booleanValue);
        }
        return super.getDefaultValue(clazz);
    }

    @Override
    public int methodArity(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return 1;
            }
            if (n == 2) {
                return 0;
            }
            if (n == 3) {
                return 0;
            }
            if (n == 4) {
                return 0;
            }
        }
        return super.methodArity(n);
    }

    @Override
    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (n == 1) {
                boolean bl = ScriptRuntime.toBoolean(objectArray, 0);
                if (scriptable2 == null) {
                    return new NativeBoolean(bl);
                }
                return this.wrap_boolean(bl);
            }
            if (n == 2) {
                return NativeBoolean.realThisBoolean(scriptable2, idFunction) ? "true" : "false";
            }
            if (n == 3) {
                if (NativeBoolean.realThisBoolean(scriptable2, idFunction)) {
                    return "(new Boolean(true))";
                }
                return "(new Boolean(false))";
            }
            if (n == 4) {
                return this.wrap_boolean(NativeBoolean.realThisBoolean(scriptable2, idFunction));
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static boolean realThisBoolean(Scriptable scriptable, IdFunction idFunction) {
        if (!(scriptable instanceof NativeBoolean)) {
            throw NativeBoolean.incompatibleCallError(idFunction);
        }
        return ((NativeBoolean)scriptable).booleanValue;
    }

    @Override
    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return "constructor";
            }
            if (n == 2) {
                return "toString";
            }
            if (n == 3) {
                return "toSource";
            }
            if (n == 4) {
                return "valueOf";
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 7) {
            string2 = "valueOf";
            n = 4;
        } else if (n2 == 8) {
            char c = string.charAt(3);
            if (c == 'o') {
                string2 = "toSource";
                n = 3;
            } else if (c == 't') {
                string2 = "toString";
                n = 2;
            }
        } else if (n2 == 11) {
            string2 = "constructor";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

