/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeCallPrototype;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends ScriptableObject {
    NativeCall caller;
    NativeFunction funObj;
    Scriptable thisObj;
    private Object[] originalArgs;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        new NativeCallPrototype(context, scriptable, bl);
    }

    NativeCall() {
    }

    NativeCall(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        int n;
        this.funObj = nativeFunction;
        this.thisObj = scriptable2;
        this.setParentScope(scriptable);
        this.caller = context.currentActivation;
        context.currentActivation = this;
        this.originalArgs = objectArray == null ? ScriptRuntime.emptyArgs : objectArray;
        String[] stringArray = nativeFunction.argNames;
        if (stringArray != null) {
            for (n = 0; n < nativeFunction.argCount; ++n) {
                object = n < objectArray.length ? objectArray[n] : Undefined.instance;
                super.put(stringArray[n], (Scriptable)this, object);
            }
        }
        if (!super.has("arguments", (Scriptable)this)) {
            super.put("arguments", (Scriptable)this, (Object)new Arguments(this));
        }
        if (stringArray != null) {
            for (n = nativeFunction.argCount; n != stringArray.length; ++n) {
                object = stringArray[n];
                if (super.has((String)object, (Scriptable)this)) continue;
                super.put((String)object, (Scriptable)this, (Object)Undefined.instance);
            }
        }
    }

    @Override
    public String getClassName() {
        return "Call";
    }

    NativeCall getActivation(Function function) {
        NativeCall nativeCall = this;
        do {
            if (nativeCall.funObj != function) continue;
            return nativeCall;
        } while ((nativeCall = nativeCall.caller) != null);
        return null;
    }

    public Function getFunctionObject() {
        return this.funObj;
    }

    public Object[] getOriginalArguments() {
        return this.originalArgs;
    }

    public NativeCall getCaller() {
        return this.caller;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }
}

