/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeDate
extends IdScriptable {
    private static final double HalfTimeDomain = 8.64E15;
    private static final double HoursPerDay = 24.0;
    private static final double MinutesPerHour = 60.0;
    private static final double SecondsPerMinute = 60.0;
    private static final double msPerSecond = 1000.0;
    private static final double MinutesPerDay = 1440.0;
    private static final double SecondsPerDay = 86400.0;
    private static final double SecondsPerHour = 3600.0;
    private static final double msPerDay = 8.64E7;
    private static final double msPerHour = 3600000.0;
    private static final double msPerMinute = 60000.0;
    private static final boolean TZO_WORKAROUND = false;
    private static final int MAXARGS = 7;
    private static final String js_NaN_date_str = "Invalid Date";
    private static final int ConstructorId_UTC = -2;
    private static final int ConstructorId_parse = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toTimeString = 3;
    private static final int Id_toDateString = 4;
    private static final int Id_toLocaleString = 5;
    private static final int Id_toLocaleTimeString = 6;
    private static final int Id_toLocaleDateString = 7;
    private static final int Id_toUTCString = 8;
    private static final int Id_toSource = 9;
    private static final int Id_valueOf = 10;
    private static final int Id_getTime = 11;
    private static final int Id_getYear = 12;
    private static final int Id_getFullYear = 13;
    private static final int Id_getUTCFullYear = 14;
    private static final int Id_getMonth = 15;
    private static final int Id_getUTCMonth = 16;
    private static final int Id_getDate = 17;
    private static final int Id_getUTCDate = 18;
    private static final int Id_getDay = 19;
    private static final int Id_getUTCDay = 20;
    private static final int Id_getHours = 21;
    private static final int Id_getUTCHours = 22;
    private static final int Id_getMinutes = 23;
    private static final int Id_getUTCMinutes = 24;
    private static final int Id_getSeconds = 25;
    private static final int Id_getUTCSeconds = 26;
    private static final int Id_getMilliseconds = 27;
    private static final int Id_getUTCMilliseconds = 28;
    private static final int Id_getTimezoneOffset = 29;
    private static final int Id_setTime = 30;
    private static final int Id_setMilliseconds = 31;
    private static final int Id_setUTCMilliseconds = 32;
    private static final int Id_setSeconds = 33;
    private static final int Id_setUTCSeconds = 34;
    private static final int Id_setMinutes = 35;
    private static final int Id_setUTCMinutes = 36;
    private static final int Id_setHours = 37;
    private static final int Id_setUTCHours = 38;
    private static final int Id_setDate = 39;
    private static final int Id_setUTCDate = 40;
    private static final int Id_setMonth = 41;
    private static final int Id_setUTCMonth = 42;
    private static final int Id_setFullYear = 43;
    private static final int Id_setUTCFullYear = 44;
    private static final int Id_setYear = 45;
    private static final int MAX_PROTOTYPE_ID = 45;
    private static final int Id_toGMTString = 8;
    private static TimeZone thisTimeZone;
    private static double LocalTZA;
    private static DateFormat timeZoneFormatter;
    private static DateFormat localeDateTimeFormatter;
    private static DateFormat localeDateFormatter;
    private static DateFormat localeTimeFormatter;
    private double date;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeDate nativeDate = new NativeDate();
        nativeDate.prototypeFlag = true;
        nativeDate.date = ScriptRuntime.NaN;
        nativeDate.addAsPrototype(45, context, scriptable, bl);
    }

    private NativeDate() {
        if (thisTimeZone == null) {
            thisTimeZone = TimeZone.getDefault();
            LocalTZA = thisTimeZone.getRawOffset();
        }
    }

    @Override
    public String getClassName() {
        return "Date";
    }

    @Override
    public Object getDefaultValue(Class clazz) {
        if (clazz == null) {
            clazz = ScriptRuntime.StringClass;
        }
        return super.getDefaultValue(clazz);
    }

    double getJSTimeValue() {
        return this.date;
    }

    @Override
    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        this.addIdFunctionProperty(idFunction, -2, bl);
        this.addIdFunctionProperty(idFunction, -1, bl);
        super.fillConstructorProperties(context, idFunction, bl);
    }

    @Override
    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case -2: {
                    return 1;
                }
                case -1: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 0;
                }
                case 9: {
                    return 0;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 0;
                }
                case 14: {
                    return 0;
                }
                case 15: {
                    return 0;
                }
                case 16: {
                    return 0;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 0;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 1;
                }
                case 33: {
                    return 2;
                }
                case 34: {
                    return 2;
                }
                case 35: {
                    return 3;
                }
                case 36: {
                    return 3;
                }
                case 37: {
                    return 4;
                }
                case 38: {
                    return 4;
                }
                case 39: {
                    return 1;
                }
                case 40: {
                    return 1;
                }
                case 41: {
                    return 2;
                }
                case 42: {
                    return 2;
                }
                case 43: {
                    return 3;
                }
                case 44: {
                    return 3;
                }
                case 45: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    @Override
    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case -2: {
                    return this.wrap_double(NativeDate.jsStaticFunction_UTC(objectArray));
                }
                case -1: {
                    return this.wrap_double(NativeDate.date_parseString(ScriptRuntime.toString(objectArray, 0)));
                }
                case 1: {
                    if (scriptable2 != null) {
                        return NativeDate.date_format(NativeDate.Now(), 2);
                    }
                    return NativeDate.jsConstructor(objectArray);
                }
                case 2: 
                case 3: 
                case 4: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    return NativeDate.date_format(d, n);
                }
                case 5: 
                case 6: 
                case 7: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    return NativeDate.toLocale_helper(d, n);
                }
                case 8: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        return NativeDate.js_toUTCString(d);
                    }
                    return js_NaN_date_str;
                }
                case 9: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    return "(new Date(" + ScriptRuntime.toString(d) + "))";
                }
                case 10: 
                case 11: {
                    return this.wrap_double(NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date);
                }
                case 12: 
                case 13: 
                case 14: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n != 14) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.YearFromTime(d);
                        if (n == 12) {
                            if (context.hasFeature(1)) {
                                if (1900.0 <= d && d < 2000.0) {
                                    d -= 1900.0;
                                }
                            } else {
                                d -= 1900.0;
                            }
                        }
                    }
                    return this.wrap_double(d);
                }
                case 15: 
                case 16: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 15) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.MonthFromTime(d);
                    }
                    return this.wrap_double(d);
                }
                case 17: 
                case 18: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 17) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.DateFromTime(d);
                    }
                    return this.wrap_double(d);
                }
                case 19: 
                case 20: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 19) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.WeekDay(d);
                    }
                    return this.wrap_double(d);
                }
                case 21: 
                case 22: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 21) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.HourFromTime(d);
                    }
                    return this.wrap_double(d);
                }
                case 23: 
                case 24: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 23) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.MinFromTime(d);
                    }
                    return this.wrap_double(d);
                }
                case 25: 
                case 26: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 25) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.SecFromTime(d);
                    }
                    return this.wrap_double(d);
                }
                case 27: 
                case 28: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        if (n == 27) {
                            d = NativeDate.LocalTime(d);
                        }
                        d = NativeDate.msFromTime(d);
                    }
                    return this.wrap_double(d);
                }
                case 29: {
                    double d = NativeDate.realThis((Scriptable)scriptable2, (IdFunction)idFunction).date;
                    if (d == d) {
                        d = (d - NativeDate.LocalTime(d)) / 60000.0;
                    }
                    return this.wrap_double(d);
                }
                case 30: {
                    NativeDate nativeDate = NativeDate.realThis(scriptable2, idFunction);
                    double d = ScriptRuntime.toNumber(objectArray, 0);
                    nativeDate.date = NativeDate.TimeClip(d);
                    return this.wrap_double(nativeDate.date);
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    return this.wrap_double(NativeDate.realThis(scriptable2, idFunction).makeTime(objectArray, n));
                }
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    return this.wrap_double(NativeDate.realThis(scriptable2, idFunction).makeDate(objectArray, n));
                }
                case 45: {
                    return this.wrap_double(NativeDate.realThis(scriptable2, idFunction).js_setYear(ScriptRuntime.toNumber(objectArray, 0)));
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static NativeDate realThis(Scriptable scriptable, IdFunction idFunction) {
        if (!(scriptable instanceof NativeDate)) {
            throw NativeDate.incompatibleCallError(idFunction);
        }
        return (NativeDate)scriptable;
    }

    private static double Day(double d) {
        return Math.floor(d / 8.64E7);
    }

    private static double TimeWithinDay(double d) {
        double d2 = d % 8.64E7;
        if (d2 < 0.0) {
            d2 += 8.64E7;
        }
        return d2;
    }

    private static int DaysInYear(int n) {
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            return 366;
        }
        return 365;
    }

    private static double DayFromYear(double d) {
        return 365.0 * (d - 1970.0) + Math.floor((d - 1969.0) / 4.0) - Math.floor((d - 1901.0) / 100.0) + Math.floor((d - 1601.0) / 400.0);
    }

    private static double TimeFromYear(double d) {
        return NativeDate.DayFromYear(d) * 8.64E7;
    }

    private static int YearFromTime(double d) {
        int n = (int)Math.floor(d / 8.64E7 / 366.0) + 1970;
        int n2 = (int)Math.floor(d / 8.64E7 / 365.0) + 1970;
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 > n) {
            int n4 = (n2 + n) / 2;
            if (NativeDate.TimeFromYear(n4) > d) {
                n2 = n4 - 1;
                continue;
            }
            n = n4 + 1;
            if (!(NativeDate.TimeFromYear(n) > d)) continue;
            return n4;
        }
        return n;
    }

    private static boolean InLeapYear(double d) {
        return NativeDate.DaysInYear(NativeDate.YearFromTime(d)) == 366;
    }

    private static int DayWithinYear(double d) {
        int n = NativeDate.YearFromTime(d);
        return (int)(NativeDate.Day(d) - NativeDate.DayFromYear(n));
    }

    private static double DayFromMonth(int n, boolean bl) {
        int n2 = n * 30;
        n2 = n >= 7 ? (n2 += n / 2 - 1) : (n >= 2 ? (n2 += (n - 1) / 2 - 1) : (n2 += n));
        if (bl && n >= 2) {
            ++n2;
        }
        return n2;
    }

    private static int MonthFromTime(double d) {
        int n = NativeDate.DayWithinYear(d);
        int n2 = 31;
        if (n < 31) {
            return 0;
        }
        n2 = NativeDate.InLeapYear(d) ? (n2 += 29) : (n2 += 28);
        if (n < n2) {
            return 1;
        }
        if (n < (n2 += 31)) {
            return 2;
        }
        if (n < (n2 += 30)) {
            return 3;
        }
        if (n < (n2 += 31)) {
            return 4;
        }
        if (n < (n2 += 30)) {
            return 5;
        }
        if (n < (n2 += 31)) {
            return 6;
        }
        if (n < (n2 += 31)) {
            return 7;
        }
        if (n < (n2 += 30)) {
            return 8;
        }
        if (n < (n2 += 31)) {
            return 9;
        }
        if (n < (n2 += 30)) {
            return 10;
        }
        return 11;
    }

    private static int DateFromTime(double d) {
        int n = NativeDate.DayWithinYear(d);
        int n2 = 30;
        if (n <= 30) {
            return n + 1;
        }
        int n3 = n2;
        n2 = NativeDate.InLeapYear(d) ? (n2 += 29) : (n2 += 28);
        if (n <= n2) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 31)) {
            return n - n3;
        }
        n3 = n2;
        if (n <= (n2 += 30)) {
            return n - n3;
        }
        n3 = n2;
        return n - n3;
    }

    private static int WeekDay(double d) {
        double d2 = NativeDate.Day(d) + 4.0;
        if ((d2 %= 7.0) < 0.0) {
            d2 += 7.0;
        }
        return (int)d2;
    }

    private static double Now() {
        return System.currentTimeMillis();
    }

    private static double DaylightSavingTA(double d) {
        Date date = new Date((long)d);
        if (thisTimeZone.inDaylightTime(date)) {
            return 3600000.0;
        }
        return 0.0;
    }

    private static double LocalTime(double d) {
        return d + LocalTZA + NativeDate.DaylightSavingTA(d);
    }

    private static double internalUTC(double d) {
        return d - LocalTZA - NativeDate.DaylightSavingTA(d - LocalTZA);
    }

    private static int HourFromTime(double d) {
        double d2 = Math.floor(d / 3600000.0) % 24.0;
        if (d2 < 0.0) {
            d2 += 24.0;
        }
        return (int)d2;
    }

    private static int MinFromTime(double d) {
        double d2 = Math.floor(d / 60000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int SecFromTime(double d) {
        double d2 = Math.floor(d / 1000.0) % 60.0;
        if (d2 < 0.0) {
            d2 += 60.0;
        }
        return (int)d2;
    }

    private static int msFromTime(double d) {
        double d2 = d % 1000.0;
        if (d2 < 0.0) {
            d2 += 1000.0;
        }
        return (int)d2;
    }

    private static double MakeTime(double d, double d2, double d3, double d4) {
        return ((d * 60.0 + d2) * 60.0 + d3) * 1000.0 + d4;
    }

    private static double MakeDay(double d, double d2, double d3) {
        d += Math.floor(d2 / 12.0);
        if ((d2 %= 12.0) < 0.0) {
            d2 += 12.0;
        }
        boolean bl = NativeDate.DaysInYear((int)d) == 366;
        double d4 = Math.floor(NativeDate.TimeFromYear(d) / 8.64E7);
        double d5 = NativeDate.DayFromMonth((int)d2, bl);
        double d6 = d4 + d5 + d3 - 1.0;
        return d6;
    }

    private static double MakeDate(double d, double d2) {
        return d * 8.64E7 + d2;
    }

    private static double TimeClip(double d) {
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Math.abs(d) > 8.64E15) {
            return ScriptRuntime.NaN;
        }
        if (d > 0.0) {
            return Math.floor(d + 0.0);
        }
        return Math.ceil(d + 0.0);
    }

    private static double date_msecFromDate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = NativeDate.MakeDay(d, d2, d3);
        double d9 = NativeDate.MakeTime(d4, d5, d6, d7);
        double d10 = NativeDate.MakeDate(d8, d9);
        return d10;
    }

    private static double jsStaticFunction_UTC(Object[] objectArray) {
        double d;
        double[] dArray = new double[7];
        for (int i = 0; i < 7; ++i) {
            if (i < objectArray.length) {
                d = ScriptRuntime.toNumber(objectArray[i]);
                if (d != d || Double.isInfinite(d)) {
                    return ScriptRuntime.NaN;
                }
                dArray[i] = ScriptRuntime.toInteger(objectArray[i]);
                continue;
            }
            dArray[i] = 0.0;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        if (dArray[2] < 1.0) {
            dArray[2] = 1.0;
        }
        d = NativeDate.date_msecFromDate(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
        d = NativeDate.TimeClip(d);
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double date_parseString(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        char c = '\u0000';
        char c2 = '\u0000';
        int n7 = 0;
        int n8 = -1;
        double d = -1.0;
        char c3 = '\u0000';
        int n9 = 0;
        boolean bl = false;
        n9 = string.length();
        block13: while (n7 < n9) {
            int n10;
            c = string.charAt(n7);
            ++n7;
            if (c <= ' ' || c == ',' || c == '-') {
                if (n7 >= n9) continue;
                c2 = string.charAt(n7);
                if (c != '-' || '0' > c2 || c2 > '9') continue;
                c3 = c;
                continue;
            }
            if (c == '(') {
                n10 = 1;
                while (n7 < n9) {
                    c = string.charAt(n7);
                    ++n7;
                    if (c == '(') {
                        ++n10;
                        continue;
                    }
                    if (c != ')' || --n10 > 0) continue;
                    continue block13;
                }
                continue;
            }
            if ('0' <= c && c <= '9') {
                n8 = c - 48;
                while (n7 < n9 && '0' <= (c = string.charAt(n7)) && c <= '9') {
                    n8 = n8 * 10 + c - 48;
                    ++n7;
                }
                if (c3 == '+' || c3 == '-') {
                    bl = true;
                    n8 = n8 < 24 ? (n8 *= 60) : n8 % 100 + n8 / 100 * 60;
                    if (c3 == '+') {
                        n8 = -n8;
                    }
                    if (d != 0.0 && d != -1.0) {
                        return ScriptRuntime.NaN;
                    }
                    d = n8;
                } else if (n8 >= 70 || c3 == '/' && n2 >= 0 && n3 >= 0 && n < 0) {
                    if (n >= 0) {
                        return ScriptRuntime.NaN;
                    }
                    if (c > ' ' && c != ',' && c != '/' && n7 < n9) return ScriptRuntime.NaN;
                    n = n8 < 100 ? n8 + 1900 : n8;
                } else if (c == ':') {
                    if (n4 < 0) {
                        n4 = n8;
                    } else {
                        if (n5 >= 0) return ScriptRuntime.NaN;
                        n5 = n8;
                    }
                } else if (c == '/') {
                    if (n2 < 0) {
                        n2 = n8 - 1;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                } else {
                    if (n7 < n9 && c != ',' && c > ' ' && c != '-') {
                        return ScriptRuntime.NaN;
                    }
                    if (bl && n8 < 60) {
                        d = d < 0.0 ? (d -= (double)n8) : (d += (double)n8);
                    } else if (n4 >= 0 && n5 < 0) {
                        n5 = n8;
                    } else if (n5 >= 0 && n6 < 0) {
                        n6 = n8;
                    } else {
                        if (n3 >= 0) return ScriptRuntime.NaN;
                        n3 = n8;
                    }
                }
                c3 = '\u0000';
                continue;
            }
            if (c == '/' || c == ':' || c == '+' || c == '-') {
                c3 = c;
                continue;
            }
            n10 = n7 - 1;
            while (n7 < n9 && ('A' <= (c = string.charAt(n7)) && c <= 'Z' || 'a' <= c && c <= 'z')) {
                ++n7;
            }
            int n11 = n7 - n10;
            if (n11 < 2) {
                return ScriptRuntime.NaN;
            }
            String string2 = "am;pm;monday;tuesday;wednesday;thursday;friday;saturday;sunday;january;february;march;april;may;june;july;august;september;october;november;december;gmt;ut;utc;est;edt;cst;cdt;mst;mdt;pst;pdt;";
            int n12 = 0;
            int n13 = 0;
            while (true) {
                int n14;
                if ((n14 = string2.indexOf(59, n13)) < 0) {
                    return ScriptRuntime.NaN;
                }
                if (string2.regionMatches(true, n13, string, n10, n11)) break;
                n13 = n14 + 1;
                ++n12;
            }
            if (n12 < 2) {
                if (n4 > 12 || n4 < 0) {
                    return ScriptRuntime.NaN;
                }
                if (n12 == 0) {
                    if (n4 != 12) continue;
                    n4 = 0;
                    continue;
                }
                if (n4 == 12) continue;
                n4 += 12;
                continue;
            }
            if ((n12 -= 2) < 7) continue;
            if ((n12 -= 7) < 12) {
                if (n2 >= 0) return ScriptRuntime.NaN;
                n2 = n12;
                continue;
            }
            switch (n12 -= 12) {
                case 0: {
                    d = 0.0;
                    continue block13;
                }
                case 1: {
                    d = 0.0;
                    continue block13;
                }
                case 2: {
                    d = 0.0;
                    continue block13;
                }
                case 3: {
                    d = 300.0;
                    continue block13;
                }
                case 4: {
                    d = 240.0;
                    continue block13;
                }
                case 5: {
                    d = 360.0;
                    continue block13;
                }
                case 6: {
                    d = 300.0;
                    continue block13;
                }
                case 7: {
                    d = 420.0;
                    continue block13;
                }
                case 8: {
                    d = 360.0;
                    continue block13;
                }
                case 9: {
                    d = 480.0;
                    continue block13;
                }
                case 10: {
                    d = 420.0;
                    continue block13;
                }
            }
            Kit.codeBug();
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            return ScriptRuntime.NaN;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        double d2 = NativeDate.date_msecFromDate(n, n2, n3, n4, n5, n6, 0.0);
        if (d != -1.0) return d2 + d * 60000.0;
        return NativeDate.internalUTC(d2);
    }

    private static String date_format(double d, int n) {
        int n2;
        if (d != d) {
            return js_NaN_date_str;
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        double d2 = NativeDate.LocalTime(d);
        if (n != 3) {
            NativeDate.appendWeekDayName(stringBuffer, NativeDate.WeekDay(d2));
            stringBuffer.append(' ');
            NativeDate.appendMonthName(stringBuffer, NativeDate.MonthFromTime(d2));
            stringBuffer.append(' ');
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.DateFromTime(d2), 2);
            stringBuffer.append(' ');
            n2 = NativeDate.YearFromTime(d2);
            if (n2 < 0) {
                stringBuffer.append('-');
                n2 = -n2;
            }
            NativeDate.append0PaddedUint(stringBuffer, n2, 4);
            if (n != 4) {
                stringBuffer.append(' ');
            }
        }
        if (n != 4) {
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.HourFromTime(d2), 2);
            stringBuffer.append(':');
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.MinFromTime(d2), 2);
            stringBuffer.append(':');
            NativeDate.append0PaddedUint(stringBuffer, NativeDate.SecFromTime(d2), 2);
            n2 = (int)Math.floor((LocalTZA + NativeDate.DaylightSavingTA(d)) / 60000.0);
            int n3 = n2 / 60 * 100 + n2 % 60;
            if (n3 > 0) {
                stringBuffer.append(" GMT+");
            } else {
                stringBuffer.append(" GMT-");
                n3 = -n3;
            }
            NativeDate.append0PaddedUint(stringBuffer, n3, 4);
            if (timeZoneFormatter == null) {
                timeZoneFormatter = new SimpleDateFormat("zzz");
            }
            if (timeZoneFormatter != null) {
                stringBuffer.append(" (");
                Date date = new Date((long)d);
                stringBuffer.append(timeZoneFormatter.format(date));
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    private static Object jsConstructor(Object[] objectArray) {
        NativeDate nativeDate = new NativeDate();
        if (objectArray.length == 0) {
            nativeDate.date = NativeDate.Now();
            return nativeDate;
        }
        if (objectArray.length == 1) {
            Object object = objectArray[0];
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(null);
            }
            double d = object instanceof String ? NativeDate.date_parseString((String)object) : ScriptRuntime.toNumber(object);
            nativeDate.date = NativeDate.TimeClip(d);
            return nativeDate;
        }
        double[] dArray = new double[7];
        for (int i = 0; i < 7; ++i) {
            if (i < objectArray.length) {
                double d = ScriptRuntime.toNumber(objectArray[i]);
                if (d != d || Double.isInfinite(d)) {
                    nativeDate.date = ScriptRuntime.NaN;
                    return nativeDate;
                }
                dArray[i] = ScriptRuntime.toInteger(objectArray[i]);
                continue;
            }
            dArray[i] = 0.0;
        }
        if (dArray[0] >= 0.0 && dArray[0] <= 99.0) {
            dArray[0] = dArray[0] + 1900.0;
        }
        if (dArray[2] < 1.0) {
            dArray[2] = 1.0;
        }
        double d = NativeDate.MakeDay(dArray[0], dArray[1], dArray[2]);
        double d2 = NativeDate.MakeTime(dArray[3], dArray[4], dArray[5], dArray[6]);
        d2 = NativeDate.MakeDate(d, d2);
        d2 = NativeDate.internalUTC(d2);
        nativeDate.date = NativeDate.TimeClip(d2);
        return nativeDate;
    }

    private static String toLocale_helper(double d, int n) {
        DateFormat dateFormat;
        if (d != d) {
            return js_NaN_date_str;
        }
        switch (n) {
            case 5: {
                if (localeDateTimeFormatter == null) {
                    localeDateTimeFormatter = DateFormat.getDateTimeInstance(1, 1);
                }
                dateFormat = localeDateTimeFormatter;
                break;
            }
            case 6: {
                if (localeTimeFormatter == null) {
                    localeTimeFormatter = DateFormat.getTimeInstance(1);
                }
                dateFormat = localeTimeFormatter;
                break;
            }
            case 7: {
                if (localeDateFormatter == null) {
                    localeDateFormatter = DateFormat.getDateInstance(1);
                }
                dateFormat = localeDateFormatter;
                break;
            }
            default: {
                dateFormat = null;
            }
        }
        return dateFormat.format(new Date((long)d));
    }

    private static String js_toUTCString(double d) {
        StringBuffer stringBuffer = new StringBuffer(60);
        NativeDate.appendWeekDayName(stringBuffer, NativeDate.WeekDay(d));
        stringBuffer.append(", ");
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.DateFromTime(d), 2);
        stringBuffer.append(' ');
        NativeDate.appendMonthName(stringBuffer, NativeDate.MonthFromTime(d));
        stringBuffer.append(' ');
        int n = NativeDate.YearFromTime(d);
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        NativeDate.append0PaddedUint(stringBuffer, n, 4);
        stringBuffer.append(' ');
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.HourFromTime(d), 2);
        stringBuffer.append(':');
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.MinFromTime(d), 2);
        stringBuffer.append(':');
        NativeDate.append0PaddedUint(stringBuffer, NativeDate.SecFromTime(d), 2);
        stringBuffer.append(" GMT");
        return stringBuffer.toString();
    }

    private static void append0PaddedUint(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n3 = 1;
        --n2;
        if (n >= 10) {
            if (n < 1000000000) {
                int n4;
                while (n >= (n4 = n3 * 10)) {
                    --n2;
                    n3 = n4;
                }
            } else {
                n2 -= 9;
                n3 = 1000000000;
            }
        }
        while (n2 > 0) {
            stringBuffer.append('0');
            --n2;
        }
        while (n3 != 1) {
            stringBuffer.append((char)(48 + n / n3));
            n %= n3;
            n3 /= 10;
        }
        stringBuffer.append((char)(48 + n));
    }

    private static void appendMonthName(StringBuffer stringBuffer, int n) {
        String string = "JanFebMarAprMayJunJulAugSepOctNovDec";
        n *= 3;
        for (int i = 0; i != 3; ++i) {
            stringBuffer.append(string.charAt(n + i));
        }
    }

    private static void appendWeekDayName(StringBuffer stringBuffer, int n) {
        String string = "SunMonTueWedThuFriSat";
        n *= 3;
        for (int i = 0; i != 3; ++i) {
            stringBuffer.append(string.charAt(n + i));
        }
    }

    private double makeTime(Object[] objectArray, int n) {
        int n2;
        int n3;
        boolean bl = true;
        switch (n) {
            case 32: {
                bl = false;
            }
            case 31: {
                n3 = 1;
                break;
            }
            case 34: {
                bl = false;
            }
            case 33: {
                n3 = 2;
                break;
            }
            case 36: {
                bl = false;
            }
            case 35: {
                n3 = 3;
                break;
            }
            case 38: {
                bl = false;
            }
            case 37: {
                n3 = 4;
                break;
            }
            default: {
                Kit.codeBug();
                n3 = 0;
            }
        }
        double[] dArray = new double[4];
        double d = this.date;
        if (d != d) {
            return d;
        }
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        for (n2 = 0; n2 < objectArray.length && n2 < n3; ++n2) {
            dArray[n2] = ScriptRuntime.toNumber(objectArray[n2]);
            if (dArray[n2] != dArray[n2] || Double.isInfinite(dArray[n2])) {
                this.date = ScriptRuntime.NaN;
                return this.date;
            }
            dArray[n2] = ScriptRuntime.toInteger(dArray[n2]);
        }
        double d2 = bl ? NativeDate.LocalTime(d) : d;
        n2 = 0;
        int n4 = objectArray.length;
        double d3 = n3 >= 4 && n2 < n4 ? dArray[n2++] : (double)NativeDate.HourFromTime(d2);
        double d4 = n3 >= 3 && n2 < n4 ? dArray[n2++] : (double)NativeDate.MinFromTime(d2);
        double d5 = n3 >= 2 && n2 < n4 ? dArray[n2++] : (double)NativeDate.SecFromTime(d2);
        double d6 = n3 >= 1 && n2 < n4 ? dArray[n2++] : (double)NativeDate.msFromTime(d2);
        double d7 = NativeDate.MakeTime(d3, d4, d5, d6);
        double d8 = NativeDate.MakeDate(NativeDate.Day(d2), d7);
        if (bl) {
            d8 = NativeDate.internalUTC(d8);
        }
        this.date = d = NativeDate.TimeClip(d8);
        return d;
    }

    private double makeDate(Object[] objectArray, int n) {
        double d;
        int n2;
        int n3;
        boolean bl = true;
        switch (n) {
            case 40: {
                bl = false;
            }
            case 39: {
                n3 = 1;
                break;
            }
            case 42: {
                bl = false;
            }
            case 41: {
                n3 = 2;
                break;
            }
            case 44: {
                bl = false;
            }
            case 43: {
                n3 = 3;
                break;
            }
            default: {
                Kit.codeBug();
                n3 = 0;
            }
        }
        double[] dArray = new double[3];
        double d2 = this.date;
        if (objectArray.length == 0) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        for (n2 = 0; n2 < objectArray.length && n2 < n3; ++n2) {
            dArray[n2] = ScriptRuntime.toNumber(objectArray[n2]);
            if (dArray[n2] != dArray[n2] || Double.isInfinite(dArray[n2])) {
                this.date = ScriptRuntime.NaN;
                return this.date;
            }
            dArray[n2] = ScriptRuntime.toInteger(dArray[n2]);
        }
        if (d2 != d2) {
            if (objectArray.length < 3) {
                return ScriptRuntime.NaN;
            }
            d = 0.0;
        } else {
            d = bl ? NativeDate.LocalTime(d2) : d2;
        }
        n2 = 0;
        int n4 = objectArray.length;
        double d3 = n3 >= 3 && n2 < n4 ? dArray[n2++] : (double)NativeDate.YearFromTime(d);
        double d4 = n3 >= 2 && n2 < n4 ? dArray[n2++] : (double)NativeDate.MonthFromTime(d);
        double d5 = n3 >= 1 && n2 < n4 ? dArray[n2++] : (double)NativeDate.DateFromTime(d);
        d5 = NativeDate.MakeDay(d3, d4, d5);
        double d6 = NativeDate.MakeDate(d5, NativeDate.TimeWithinDay(d));
        if (bl) {
            d6 = NativeDate.internalUTC(d6);
        }
        this.date = d2 = NativeDate.TimeClip(d6);
        return d2;
    }

    private double js_setYear(double d) {
        if (d != d || Double.isInfinite(d)) {
            this.date = ScriptRuntime.NaN;
            return this.date;
        }
        this.date = this.date != this.date ? 0.0 : NativeDate.LocalTime(this.date);
        if (d >= 0.0 && d <= 99.0) {
            d += 1900.0;
        }
        double d2 = NativeDate.MakeDay(d, NativeDate.MonthFromTime(this.date), NativeDate.DateFromTime(this.date));
        double d3 = NativeDate.MakeDate(d2, NativeDate.TimeWithinDay(this.date));
        d3 = NativeDate.internalUTC(d3);
        this.date = NativeDate.TimeClip(d3);
        return this.date;
    }

    @Override
    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case -2: {
                    return "UTC";
                }
                case -1: {
                    return "parse";
                }
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toTimeString";
                }
                case 4: {
                    return "toDateString";
                }
                case 5: {
                    return "toLocaleString";
                }
                case 6: {
                    return "toLocaleTimeString";
                }
                case 7: {
                    return "toLocaleDateString";
                }
                case 8: {
                    return "toUTCString";
                }
                case 9: {
                    return "toSource";
                }
                case 10: {
                    return "valueOf";
                }
                case 11: {
                    return "getTime";
                }
                case 12: {
                    return "getYear";
                }
                case 13: {
                    return "getFullYear";
                }
                case 14: {
                    return "getUTCFullYear";
                }
                case 15: {
                    return "getMonth";
                }
                case 16: {
                    return "getUTCMonth";
                }
                case 17: {
                    return "getDate";
                }
                case 18: {
                    return "getUTCDate";
                }
                case 19: {
                    return "getDay";
                }
                case 20: {
                    return "getUTCDay";
                }
                case 21: {
                    return "getHours";
                }
                case 22: {
                    return "getUTCHours";
                }
                case 23: {
                    return "getMinutes";
                }
                case 24: {
                    return "getUTCMinutes";
                }
                case 25: {
                    return "getSeconds";
                }
                case 26: {
                    return "getUTCSeconds";
                }
                case 27: {
                    return "getMilliseconds";
                }
                case 28: {
                    return "getUTCMilliseconds";
                }
                case 29: {
                    return "getTimezoneOffset";
                }
                case 30: {
                    return "setTime";
                }
                case 31: {
                    return "setMilliseconds";
                }
                case 32: {
                    return "setUTCMilliseconds";
                }
                case 33: {
                    return "setSeconds";
                }
                case 34: {
                    return "setUTCSeconds";
                }
                case 35: {
                    return "setMinutes";
                }
                case 36: {
                    return "setUTCMinutes";
                }
                case 37: {
                    return "setHours";
                }
                case 38: {
                    return "setUTCHours";
                }
                case 39: {
                    return "setDate";
                }
                case 40: {
                    return "setUTCDate";
                }
                case 41: {
                    return "setMonth";
                }
                case 42: {
                    return "setUTCMonth";
                }
                case 43: {
                    return "setFullYear";
                }
                case 44: {
                    return "setUTCFullYear";
                }
                case 45: {
                    return "setYear";
                }
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 6: {
                string2 = "getDay";
                n = 19;
                break;
            }
            case 7: {
                switch (string.charAt(3)) {
                    case 'D': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getDate";
                            n = 17;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setDate";
                        n = 39;
                        break block0;
                    }
                    case 'T': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getTime";
                            n = 11;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setTime";
                        n = 30;
                        break block0;
                    }
                    case 'Y': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getYear";
                            n = 12;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setYear";
                        n = 45;
                        break block0;
                    }
                    case 'u': {
                        string2 = "valueOf";
                        n = 10;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(3)) {
                    case 'H': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getHours";
                            n = 21;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setHours";
                        n = 37;
                        break block0;
                    }
                    case 'M': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getMonth";
                            n = 15;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setMonth";
                        n = 41;
                        break block0;
                    }
                    case 'o': {
                        string2 = "toSource";
                        n = 9;
                        break block0;
                    }
                    case 't': {
                        string2 = "toString";
                        n = 2;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                string2 = "getUTCDay";
                n = 20;
                break;
            }
            case 10: {
                char c = string.charAt(3);
                if (c == 'M') {
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getMinutes";
                        n = 23;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setMinutes";
                    n = 35;
                    break;
                }
                if (c == 'S') {
                    c = string.charAt(0);
                    if (c == 'g') {
                        string2 = "getSeconds";
                        n = 25;
                        break;
                    }
                    if (c != 's') break;
                    string2 = "setSeconds";
                    n = 33;
                    break;
                }
                if (c != 'U') break;
                c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCDate";
                    n = 18;
                    break;
                }
                if (c != 's') break;
                string2 = "setUTCDate";
                n = 40;
                break;
            }
            case 11: {
                switch (string.charAt(3)) {
                    case 'F': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "getFullYear";
                            n = 13;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "setFullYear";
                        n = 43;
                        break block0;
                    }
                    case 'M': {
                        string2 = "toGMTString";
                        n = 8;
                        break block0;
                    }
                    case 'T': {
                        string2 = "toUTCString";
                        n = 8;
                        break block0;
                    }
                    case 'U': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            c = string.charAt(9);
                            if (c == 'r') {
                                string2 = "getUTCHours";
                                n = 22;
                                break block0;
                            }
                            if (c != 't') break block0;
                            string2 = "getUTCMonth";
                            n = 16;
                            break block0;
                        }
                        if (c != 's') break block0;
                        c = string.charAt(9);
                        if (c == 'r') {
                            string2 = "setUTCHours";
                            n = 38;
                            break block0;
                        }
                        if (c != 't') break block0;
                        string2 = "setUTCMonth";
                        n = 42;
                        break block0;
                    }
                    case 's': {
                        string2 = "constructor";
                        n = 1;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = string.charAt(2);
                if (c == 'D') {
                    string2 = "toDateString";
                    n = 4;
                    break;
                }
                if (c != 'T') break;
                string2 = "toTimeString";
                n = 3;
                break;
            }
            case 13: {
                char c = string.charAt(0);
                if (c == 'g') {
                    c = string.charAt(6);
                    if (c == 'M') {
                        string2 = "getUTCMinutes";
                        n = 24;
                        break;
                    }
                    if (c != 'S') break;
                    string2 = "getUTCSeconds";
                    n = 26;
                    break;
                }
                if (c != 's') break;
                c = string.charAt(6);
                if (c == 'M') {
                    string2 = "setUTCMinutes";
                    n = 36;
                    break;
                }
                if (c != 'S') break;
                string2 = "setUTCSeconds";
                n = 34;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCFullYear";
                    n = 14;
                    break;
                }
                if (c == 's') {
                    string2 = "setUTCFullYear";
                    n = 44;
                    break;
                }
                if (c != 't') break;
                string2 = "toLocaleString";
                n = 5;
                break;
            }
            case 15: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getMilliseconds";
                    n = 27;
                    break;
                }
                if (c != 's') break;
                string2 = "setMilliseconds";
                n = 31;
                break;
            }
            case 17: {
                string2 = "getTimezoneOffset";
                n = 29;
                break;
            }
            case 18: {
                char c = string.charAt(0);
                if (c == 'g') {
                    string2 = "getUTCMilliseconds";
                    n = 28;
                    break;
                }
                if (c == 's') {
                    string2 = "setUTCMilliseconds";
                    n = 32;
                    break;
                }
                if (c != 't') break;
                c = string.charAt(8);
                if (c == 'D') {
                    string2 = "toLocaleDateString";
                    n = 7;
                    break;
                }
                if (c != 'T') break;
                string2 = "toLocaleTimeString";
                n = 6;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

