/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.UintMap;

public class NativeFunction
extends BaseFunction {
    String[] argNames;
    int argCount;
    int version;

    public final void initScriptFunction(int n, String string, String[] stringArray, int n2) {
        if (stringArray == null || 0 > n2 || n2 > stringArray.length) {
            throw new IllegalArgumentException();
        }
        if (this.argNames != null) {
            throw new IllegalStateException();
        }
        this.functionName = string;
        this.argNames = stringArray;
        this.argCount = n2;
        this.version = n;
    }

    @Override
    final String decompile(int n, int n2) {
        String string = this.getEncodedSource();
        if (string == null) {
            return super.decompile(n, n2);
        }
        UintMap uintMap = new UintMap(1);
        uintMap.put(1, n);
        return Decompiler.decompile(string, n2, uintMap);
    }

    @Override
    public int getLength() {
        if (this.version != 120) {
            return this.argCount;
        }
        NativeCall nativeCall = this.getActivation(Context.getContext());
        if (nativeCall == null) {
            return this.argCount;
        }
        return nativeCall.getOriginalArguments().length;
    }

    @Override
    public int getArity() {
        return this.argCount;
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }
}

