/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;

public class NativeGlobal
implements Serializable,
IdFunctionMaster {
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";
    private static final int Id_decodeURI = 1;
    private static final int Id_decodeURIComponent = 2;
    private static final int Id_encodeURI = 3;
    private static final int Id_encodeURIComponent = 4;
    private static final int Id_escape = 5;
    private static final int Id_eval = 6;
    private static final int Id_isFinite = 7;
    private static final int Id_isNaN = 8;
    private static final int Id_parseFloat = 9;
    private static final int Id_parseInt = 10;
    private static final int Id_unescape = 11;
    private static final int Id_uneval = 12;
    private static final int LAST_SCOPE_FUNCTION_ID = 12;
    private static final int Id_new_CommonError = 13;
    private boolean scopeSlaveFlag;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeGlobal nativeGlobal = new NativeGlobal();
        nativeGlobal.scopeSlaveFlag = true;
        for (int i = 1; i <= 12; ++i) {
            String string;
            switch (i) {
                case 1: {
                    string = "decodeURI";
                    break;
                }
                case 2: {
                    string = "decodeURIComponent";
                    break;
                }
                case 3: {
                    string = "encodeURI";
                    break;
                }
                case 4: {
                    string = "encodeURIComponent";
                    break;
                }
                case 5: {
                    string = "escape";
                    break;
                }
                case 6: {
                    string = "eval";
                    break;
                }
                case 7: {
                    string = "isFinite";
                    break;
                }
                case 8: {
                    string = "isNaN";
                    break;
                }
                case 9: {
                    string = "parseFloat";
                    break;
                }
                case 10: {
                    string = "parseInt";
                    break;
                }
                case 11: {
                    string = "unescape";
                    break;
                }
                case 12: {
                    string = "uneval";
                    break;
                }
                default: {
                    Kit.codeBug();
                    string = null;
                }
            }
            IdFunction.define(scriptable, string, nativeGlobal, i, 2, bl);
        }
        ScriptableObject.defineProperty(scriptable, "NaN", ScriptRuntime.NaNobj, 2);
        ScriptableObject.defineProperty(scriptable, "Infinity", new Double(Double.POSITIVE_INFINITY), 2);
        ScriptableObject.defineProperty(scriptable, "undefined", Undefined.instance, 2);
        String[] stringArray = Kit.semicolonSplit("ConversionError;EvalError;RangeError;ReferenceError;SyntaxError;TypeError;URIError;InternalError;JavaException;");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Scriptable scriptable2 = ScriptRuntime.newObject(context, scriptable, "Error", ScriptRuntime.emptyArgs);
            scriptable2.put("name", scriptable2, (Object)string);
            IdFunction idFunction = new IdFunction(nativeGlobal, string, 13);
            idFunction.initAsConstructor(scriptable, scriptable2);
            if (bl) {
                idFunction.sealObject();
                if (scriptable2 instanceof ScriptableObject) {
                    ((ScriptableObject)scriptable2).sealObject();
                }
            }
            ScriptableObject.defineProperty(scriptable, string, idFunction, 2);
        }
    }

    @Override
    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.scopeSlaveFlag) {
            switch (n) {
                case 1: 
                case 2: {
                    String string = ScriptRuntime.toString(objectArray, 0);
                    return NativeGlobal.decode(context, string, n == 1);
                }
                case 3: 
                case 4: {
                    String string = ScriptRuntime.toString(objectArray, 0);
                    return NativeGlobal.encode(context, string, n == 3);
                }
                case 5: {
                    return this.js_escape(context, objectArray);
                }
                case 6: {
                    return this.js_eval(context, scriptable, objectArray);
                }
                case 7: {
                    if (objectArray.length < 1) {
                        return Boolean.FALSE;
                    }
                    double d = ScriptRuntime.toNumber(objectArray[0]);
                    return d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY ? Boolean.FALSE : Boolean.TRUE;
                }
                case 8: {
                    if (objectArray.length < 1) {
                        return Boolean.TRUE;
                    }
                    double d = ScriptRuntime.toNumber(objectArray[0]);
                    return d != d ? Boolean.TRUE : Boolean.FALSE;
                }
                case 9: {
                    return this.js_parseFloat(context, objectArray);
                }
                case 10: {
                    return this.js_parseInt(context, objectArray);
                }
                case 11: {
                    return this.js_unescape(context, objectArray);
                }
                case 12: {
                    Scriptable scriptable3 = objectArray.length != 0 ? objectArray[0] : Undefined.instance;
                    return ScriptRuntime.uneval(context, scriptable, scriptable3);
                }
                case 13: {
                    return NativeError.make(context, scriptable, idFunction, objectArray);
                }
            }
        }
        throw IdFunction.onBadMethodId(this, n);
    }

    @Override
    public int methodArity(int n) {
        if (this.scopeSlaveFlag) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return 1;
                }
            }
        }
        return -1;
    }

    private Object js_parseInt(Context context, Object[] objectArray) {
        char c;
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = ScriptRuntime.toInt32(objectArray, 1);
        int n2 = string.length();
        if (n2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean bl = false;
        int n3 = 0;
        while (Character.isWhitespace(c = string.charAt(n3)) && ++n3 < n2) {
        }
        if (c == '+' || (bl = c == '-')) {
            ++n3;
        }
        if (n == 0) {
            n = -1;
        } else {
            if (n < 2 || n > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (n == 16 && n2 - n3 > 1 && string.charAt(n3) == '0' && ((c = string.charAt(n3 + 1)) == 'x' || c == 'X')) {
                n3 += 2;
            }
        }
        if (n == -1) {
            n = 10;
            if (n2 - n3 > 1 && string.charAt(n3) == '0') {
                c = string.charAt(n3 + 1);
                if (c == 'x' || c == 'X') {
                    n = 16;
                    n3 += 2;
                } else if ('0' <= c && c <= '9') {
                    n = 8;
                    ++n3;
                }
            }
        }
        double d = ScriptRuntime.stringToNumber(string, n3, n);
        return new Double(bl ? -d : d);
    }

    private Object js_parseFloat(Context context, Object[] objectArray) {
        char c;
        if (objectArray.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = string.length();
        if (n == 0) {
            return ScriptRuntime.NaNobj;
        }
        int n2 = 0;
        while (TokenStream.isJSSpace(c = string.charAt(n2)) && n2 + 1 < n) {
            ++n2;
        }
        int n3 = n2;
        if (c == '+' || c == '-') {
            c = string.charAt(++n2);
        }
        if (c == 'I') {
            if (n2 + 8 > n || !string.substring(n2, n2 + 8).equals("Infinity")) {
                return ScriptRuntime.NaNobj;
            }
            double d = string.charAt(n3) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return new Double(d);
        }
        int n4 = -1;
        int n5 = -1;
        block9: while (n2 < n) {
            switch (string.charAt(n2)) {
                case '.': {
                    if (n4 != -1) break block9;
                    n4 = n2;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (n5 != -1) break block9;
                    n5 = n2;
                    break;
                }
                case '+': 
                case '-': {
                    if (n5 == n2 - 1) break;
                    break block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    break block9;
                }
            }
            ++n2;
        }
        string = string.substring(n3, n2);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return ScriptRuntime.NaNobj;
        }
    }

    private Object js_escape(Context context, Object[] objectArray) {
        double d;
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = 7;
        if (objectArray.length > 1 && ((d = ScriptRuntime.toNumber(objectArray[1])) != d || (double)(n = (int)d) != d || 0 != (n & 0xFFFFFFF8))) {
            String string2 = Context.getMessage0("msg.bad.esc.mask");
            Context.reportError(string2);
            n = 7;
        }
        StringBuffer stringBuffer = null;
        int n2 = string.length();
        for (int i = 0; i != n2; ++i) {
            int n3;
            char c = string.charAt(i);
            if (n != 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.' || 0 != (n & 4) && (c == '/' || c == '+'))) {
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n2 + 3);
                stringBuffer.append(string);
                stringBuffer.setLength(i);
            }
            if (c < '\u0100') {
                if (c == ' ' && n == 2) {
                    stringBuffer.append('+');
                    continue;
                }
                stringBuffer.append('%');
                n3 = 2;
            } else {
                stringBuffer.append('%');
                stringBuffer.append('u');
                n3 = 4;
            }
            for (int j = (n3 - 1) * 4; j >= 0; j -= 4) {
                int n4 = 0xF & c >> j;
                int n5 = n4 < 10 ? 48 + n4 : 55 + n4;
                stringBuffer.append((char)n5);
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private Object js_unescape(Context context, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = string.indexOf(37);
        if (n >= 0) {
            int n2 = string.length();
            char[] cArray = string.toCharArray();
            int n3 = n;
            int n4 = n;
            while (n4 != n2) {
                char c = cArray[n4];
                if (c == '%' && ++n4 != n2) {
                    int n5;
                    int n6;
                    if (cArray[n4] == 'u') {
                        n6 = n4 + 1;
                        n5 = n4 + 5;
                    } else {
                        n6 = n4;
                        n5 = n4 + 2;
                    }
                    if (n5 <= n2) {
                        int n7 = 0;
                        for (int i = n6; i != n5; ++i) {
                            n7 = n7 << 4 | TokenStream.xDigitToInt(cArray[i]);
                        }
                        if (n7 >= 0) {
                            c = (char)n7;
                            n4 = n5;
                        }
                    }
                }
                cArray[n3] = c;
                ++n3;
            }
            string = new String(cArray, 0, n3);
        }
        return string;
    }

    private Object js_eval(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        String string = ScriptRuntime.getMessage1("msg.cant.call.indirect", "eval");
        throw NativeGlobal.constructError(context, "EvalError", string, scriptable);
    }

    static boolean isEvalFunction(Object object) {
        if (object instanceof IdFunction) {
            IdFunction idFunction = (IdFunction)object;
            if (idFunction.master instanceof NativeGlobal && idFunction.getMethodId() == 6) {
                return true;
            }
        }
        return false;
    }

    public static EcmaError constructError(Context context, String string, String string2, Scriptable scriptable) {
        return ScriptRuntime.constructError(string, string2);
    }

    public static EcmaError constructError(Context context, String string, String string2, Scriptable scriptable, String string3, int n, int n2, String string4) {
        return ScriptRuntime.constructError(string, string2, string3, n, string4, n2);
    }

    private static String encode(Context context, String string, boolean bl) {
        byte[] byArray = null;
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            int n2;
            int n3;
            int n4 = string.charAt(i);
            if (NativeGlobal.encodeUnescaped((char)n4, bl)) {
                if (stringBuffer == null) continue;
                stringBuffer.append((char)n4);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append(string);
                stringBuffer.setLength(i);
                byArray = new byte[6];
            }
            if (56320 <= n4 && n4 <= 57343) {
                throw Context.reportRuntimeError0("msg.bad.uri");
            }
            if (n4 < 55296 || 56319 < n4) {
                n3 = n4;
            } else {
                if (++i == n) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                n2 = string.charAt(i);
                if (56320 > n2 || n2 > 57343) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                n3 = (n4 - 55296 << 10) + (n2 - 56320) + 65536;
            }
            n2 = NativeGlobal.oneUcs4ToUtf8Char(byArray, n3);
            for (int j = 0; j < n2; ++j) {
                int n5 = 0xFF & byArray[j];
                stringBuffer.append('%');
                stringBuffer.append(NativeGlobal.toHexChar(n5 >>> 4));
                stringBuffer.append(NativeGlobal.toHexChar(n5 & 0xF));
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static char toHexChar(int n) {
        if (n >> 4 != 0) {
            Kit.codeBug();
        }
        return (char)(n < 10 ? n + 48 : n - 10 + 97);
    }

    private static int unHex(char c) {
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static int unHex(char c, char c2) {
        int n = NativeGlobal.unHex(c);
        int n2 = NativeGlobal.unHex(c2);
        if (n >= 0 && n2 >= 0) {
            return n << 4 | n2;
        }
        return -1;
    }

    private static String decode(Context context, String string, boolean bl) {
        char[] cArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 != n3) {
            int n4;
            char c = string.charAt(n2);
            if (c != '%') {
                if (cArray != null) {
                    cArray[n++] = c;
                }
                ++n2;
                continue;
            }
            if (cArray == null) {
                cArray = new char[n3];
                string.getChars(0, n2, cArray, 0);
                n = n2;
            }
            int n5 = n2;
            if (n2 + 3 > n3) {
                throw Context.reportRuntimeError0("msg.bad.uri");
            }
            int n6 = NativeGlobal.unHex(string.charAt(n2 + 1), string.charAt(n2 + 2));
            if (n6 < 0) {
                throw Context.reportRuntimeError0("msg.bad.uri");
            }
            n2 += 3;
            if ((n6 & 0x80) == 0) {
                c = (char)n6;
            } else {
                int n7;
                int n8;
                int n9;
                if ((n6 & 0xC0) == 128) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if ((n6 & 0x20) == 0) {
                    n4 = 1;
                    n9 = n6 & 0x1F;
                    n8 = 128;
                } else if ((n6 & 0x10) == 0) {
                    n4 = 2;
                    n9 = n6 & 0xF;
                    n8 = 2048;
                } else if ((n6 & 8) == 0) {
                    n4 = 3;
                    n9 = n6 & 7;
                    n8 = 65536;
                } else if ((n6 & 4) == 0) {
                    n4 = 4;
                    n9 = n6 & 3;
                    n8 = 0x200000;
                } else if ((n6 & 2) == 0) {
                    n4 = 5;
                    n9 = n6 & 1;
                    n8 = 0x4000000;
                } else {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if (n2 + 3 * n4 > n3) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                for (n7 = 0; n7 != n4; ++n7) {
                    if (string.charAt(n2) != '%') {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    n6 = NativeGlobal.unHex(string.charAt(n2 + 1), string.charAt(n2 + 2));
                    if (n6 < 0 || (n6 & 0xC0) != 128) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    n9 = n9 << 6 | n6 & 0x3F;
                    n2 += 3;
                }
                if (n9 < n8 || n9 == 65534 || n9 == 65535) {
                    n9 = 65533;
                }
                if (n9 >= 65536) {
                    if ((n9 -= 65536) > 1048575) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    n7 = (char)((n9 >>> 10) + 55296);
                    c = (char)((n9 & 0x3FF) + 56320);
                    cArray[n++] = n7;
                } else {
                    c = (char)n9;
                }
            }
            if (bl && URI_DECODE_RESERVED.indexOf(c) >= 0) {
                for (n4 = n5; n4 != n2; ++n4) {
                    cArray[n++] = string.charAt(n4);
                }
                continue;
            }
            cArray[n++] = c;
        }
        return cArray == null ? string : new String(cArray, 0, n);
    }

    private static boolean encodeUnescaped(char c, boolean bl) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c) >= 0) {
            return true;
        }
        if (bl) {
            return URI_DECODE_RESERVED.indexOf(c) >= 0;
        }
        return false;
    }

    private static int oneUcs4ToUtf8Char(byte[] byArray, int n) {
        int n2 = 1;
        if ((n & 0xFFFFFF80) == 0) {
            byArray[0] = (byte)n;
        } else {
            int n3 = n >>> 11;
            n2 = 2;
            while (n3 != 0) {
                n3 >>>= 5;
                ++n2;
            }
            int n4 = n2;
            while (--n4 > 0) {
                byArray[n4] = (byte)(n & 0x3F | 0x80);
                n >>>= 6;
            }
            byArray[0] = (byte)(256 - (1 << 8 - n2) + n);
        }
        return n2;
    }
}

