/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaObject
implements Scriptable,
Wrapper,
Serializable {
    static final int JSTYPE_UNDEFINED = 0;
    static final int JSTYPE_NULL = 1;
    static final int JSTYPE_BOOLEAN = 2;
    static final int JSTYPE_NUMBER = 3;
    static final int JSTYPE_STRING = 4;
    static final int JSTYPE_JAVA_CLASS = 5;
    static final int JSTYPE_JAVA_OBJECT = 6;
    static final int JSTYPE_JAVA_ARRAY = 7;
    static final int JSTYPE_OBJECT = 8;
    public static final byte CONVERSION_TRIVIAL = 1;
    public static final byte CONVERSION_NONTRIVIAL = 0;
    public static final byte CONVERSION_NONE = 99;
    protected Scriptable prototype;
    protected Scriptable parent;
    protected transient Object javaObject;
    protected transient Class staticType;
    protected transient JavaMembers members;
    private transient Hashtable fieldAndMethods;
    private static final Object COERCED_INTERFACE_KEY = new Object();
    private static Method adapter_makeIFGlue;
    private static Method adapter_writeAdapterObject;
    private static Method adapter_readAdapterObject;

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class clazz) {
        this.parent = scriptable;
        this.javaObject = object;
        this.staticType = clazz;
        this.initMembers();
    }

    protected void initMembers() {
        Class<?> clazz = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(this.parent, clazz, this.staticType);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, false);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Object v;
        if (this.fieldAndMethods != null && (v = this.fieldAndMethods.get(string)) != null) {
            return v;
        }
        return this.members.get(this, string, this.javaObject, false);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.prototype == null || this.members.has(string, false)) {
            this.members.put(this, string, this.javaObject, object, false);
        } else {
            this.prototype.put(string, this.prototype, object);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return false;
    }

    @Override
    public void delete(String string) {
    }

    @Override
    public void delete(int n) {
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject instanceof String) {
            return ScriptableObject.getClassPrototype(this.parent, "String");
        }
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(false);
    }

    public static Object wrap(Scriptable scriptable, Object object, Class clazz) {
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, clazz);
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    Function getConverter(String string) {
        Object object = this.get(string, (Scriptable)this);
        if (object instanceof Function) {
            return (Function)object;
        }
        return null;
    }

    Object callConverter(Function function) throws JavaScriptException {
        Function function2 = function;
        return function2.call(Context.getContext(), function2.getParentScope(), this, ScriptRuntime.emptyArgs);
    }

    Object callConverter(String string) throws JavaScriptException {
        Function function = this.getConverter(string);
        if (function == null) {
            return this.javaObject.toString();
        }
        return this.callConverter(function);
    }

    @Override
    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.javaObject.toString();
        }
        try {
            if (clazz == ScriptRuntime.BooleanClass) {
                return this.callConverter("booleanValue");
            }
            if (clazz == ScriptRuntime.NumberClass) {
                return this.callConverter("doubleValue");
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        throw Context.reportRuntimeError0("msg.default.value");
    }

    public static boolean canConvert(Object object, Class clazz) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        return n < 99;
    }

    public static int getConversionWeight(Object object, Class clazz) {
        int n = NativeJavaObject.getJSTypeCode(object);
        switch (n) {
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) break;
                return 1;
            }
            case 1: {
                if (clazz.isPrimitive()) break;
                return 1;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    return 1;
                }
                if (clazz == ScriptRuntime.BooleanClass) {
                    return 2;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 3: {
                if (clazz.isPrimitive()) {
                    if (clazz == Double.TYPE) {
                        return 1;
                    }
                    if (clazz == Boolean.TYPE) break;
                    return 1 + NativeJavaObject.getSizeRank(clazz);
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 9;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 10;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(clazz)) break;
                return 2;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass) {
                    return 1;
                }
                if (clazz.isInstance(object)) {
                    return 2;
                }
                if (!clazz.isPrimitive()) break;
                if (clazz == Character.TYPE) {
                    return 3;
                }
                if (clazz == Boolean.TYPE) break;
                return 4;
            }
            case 5: {
                if (clazz == ScriptRuntime.ClassClass) {
                    return 1;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 6: 
            case 7: {
                if (clazz == ScriptRuntime.StringClass) {
                    return 2;
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE) {
                    return n == 7 ? 0 : 2 + NativeJavaObject.getSizeRank(clazz);
                }
                Object object2 = object;
                if (object2 instanceof Wrapper) {
                    object2 = ((Wrapper)object2).unwrap();
                }
                if (!clazz.isInstance(object2)) break;
                return 0;
            }
            case 8: {
                if (clazz.isArray()) {
                    if (!(object instanceof NativeArray)) break;
                    return 1;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 2;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 3;
                }
                if (clazz == ScriptRuntime.DateClass) {
                    if (!(object instanceof NativeDate)) break;
                    return 1;
                }
                if (clazz.isInterface()) {
                    if (object instanceof Function && clazz.getMethods().length == 1) {
                        return 1;
                    }
                    return 11;
                }
                if (!clazz.isPrimitive() && clazz == Boolean.TYPE) break;
                return 3 + NativeJavaObject.getSizeRank(clazz);
            }
        }
        return 99;
    }

    static int getSizeRank(Class clazz) {
        if (clazz == Double.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Byte.TYPE) {
            return 7;
        }
        if (clazz == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    static int getJSTypeCode(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == Undefined.instance) {
            return 0;
        }
        if (object instanceof String) {
            return 4;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 2;
        }
        if (object instanceof Scriptable) {
            if (object instanceof NativeJavaClass) {
                return 5;
            }
            if (object instanceof NativeJavaArray) {
                return 7;
            }
            if (object instanceof Wrapper) {
                return 6;
            }
            return 8;
        }
        if (object instanceof Class) {
            return 5;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return 7;
        }
        return 6;
    }

    public static Object coerceType(Class clazz, Object object) {
        return NativeJavaObject.coerceType(clazz, object, true);
    }

    static Object coerceType(Class clazz, Object object, boolean bl) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        switch (NativeJavaObject.getJSTypeCode(object)) {
            case 1: {
                if (clazz.isPrimitive()) {
                    NativeJavaObject.reportConversionError(object, clazz, !bl);
                }
                return null;
            }
            case 0: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.reportConversionError("undefined", clazz, !bl);
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE || clazz == ScriptRuntime.BooleanClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 3: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.coerceToNumber(Double.TYPE, object, bl);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass || clazz.isInstance(object)) {
                    return object;
                }
                if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
                    if (((String)object).length() == 1) {
                        return new Character(((String)object).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 5: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.ClassClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 6: 
            case 7: {
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz, !bl);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 8: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz, !bl);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                if (clazz == ScriptRuntime.DateClass && object instanceof NativeDate) {
                    double d = ((NativeDate)object).getJSTimeValue();
                    return new Date((long)d);
                }
                if (clazz.isArray() && object instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)object;
                    long l = nativeArray.getLength();
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object2 = Array.newInstance(clazz2, (int)l);
                    int n = 0;
                    while ((long)n < l) {
                        try {
                            Array.set(object2, n, NativeJavaObject.coerceType(clazz2, nativeArray.get(n, (Scriptable)nativeArray), bl));
                        }
                        catch (EvaluatorException evaluatorException) {
                            NativeJavaObject.reportConversionError(object, clazz, !bl);
                        }
                        ++n;
                    }
                    return object2;
                }
                if (object instanceof Wrapper) {
                    if (clazz.isInstance(object = ((Wrapper)object).unwrap())) {
                        return object;
                    }
                    NativeJavaObject.reportConversionError(object, clazz, !bl);
                    break;
                }
                if (clazz.isInterface()) {
                    Function function;
                    if (object instanceof Function && adapter_makeIFGlue != null && (function = (Function)object) instanceof ScriptableObject) {
                        Object object3;
                        ScriptableObject scriptableObject = (ScriptableObject)((Object)function);
                        Object object4 = Kit.makeHashKeyFromPair(COERCED_INTERFACE_KEY, clazz);
                        Object object5 = scriptableObject.getAssociatedValue(object4);
                        if (object5 != null) {
                            return object5;
                        }
                        Object[] objectArray = new Object[]{clazz, function};
                        try {
                            object3 = adapter_makeIFGlue.invoke(null, objectArray);
                        }
                        catch (Exception exception) {
                            throw Context.throwAsScriptRuntimeEx(exception);
                        }
                        if (object3 != null) {
                            object3 = scriptableObject.associateValue(object4, object3);
                            return object3;
                        }
                    }
                    NativeJavaObject.reportConversionError(object, clazz, !bl);
                    break;
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
            }
        }
        return object;
    }

    static Object coerceToNumber(Class clazz, Object object, boolean bl) {
        Class<?> clazz2 = object.getClass();
        if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
            if (clazz2 == ScriptRuntime.CharacterClass) {
                return object;
            }
            return new Character((char)NativeJavaObject.toInteger(object, ScriptRuntime.CharacterClass, 0.0, 65535.0, bl));
        }
        if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return clazz2 == ScriptRuntime.DoubleClass ? object : new Double(NativeJavaObject.toDouble(object, bl));
        }
        if (clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE) {
            if (clazz2 == ScriptRuntime.FloatClass) {
                return object;
            }
            double d = NativeJavaObject.toDouble(object, bl);
            if (Double.isInfinite(d) || Double.isNaN(d) || d == 0.0) {
                return new Float((float)d);
            }
            double d2 = Math.abs(d);
            if (d2 < (double)1.4E-45f) {
                return new Float(d > 0.0 ? 0.0 : -0.0);
            }
            if (d2 > 3.4028234663852886E38) {
                return new Float(d > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return new Float((float)d);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            if (clazz2 == ScriptRuntime.IntegerClass) {
                return object;
            }
            return new Integer((int)NativeJavaObject.toInteger(object, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9, bl));
        }
        if (clazz == ScriptRuntime.LongClass || clazz == Long.TYPE) {
            if (clazz2 == ScriptRuntime.LongClass) {
                return object;
            }
            double d = Double.longBitsToDouble(4890909195324358655L);
            double d3 = Double.longBitsToDouble(-4332462841530417152L);
            return new Long(NativeJavaObject.toInteger(object, ScriptRuntime.LongClass, d3, d, bl));
        }
        if (clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE) {
            if (clazz2 == ScriptRuntime.ShortClass) {
                return object;
            }
            return new Short((short)NativeJavaObject.toInteger(object, ScriptRuntime.ShortClass, -32768.0, 32767.0, bl));
        }
        if (clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE) {
            if (clazz2 == ScriptRuntime.ByteClass) {
                return object;
            }
            return new Byte((byte)NativeJavaObject.toInteger(object, ScriptRuntime.ByteClass, -128.0, 127.0, bl));
        }
        return new Double(NativeJavaObject.toDouble(object, bl));
    }

    static double toDouble(Object object, boolean bl) {
        Method method;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)object).unwrap(), bl);
            }
            return ScriptRuntime.toNumber(object);
        }
        try {
            method = object.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            try {
                return ((Number)method.invoke(object, null)).doubleValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE, !bl);
            }
            catch (InvocationTargetException invocationTargetException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE, !bl);
            }
        }
        return ScriptRuntime.toNumber(object.toString());
    }

    static long toInteger(Object object, Class clazz, double d, double d2, boolean bl) {
        double d3 = NativeJavaObject.toDouble(object, bl);
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz, !bl);
        }
        if ((d3 = d3 > 0.0 ? Math.floor(d3) : Math.ceil(d3)) < d || d3 > d2) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz, !bl);
        }
        return (long)d3;
    }

    static void reportConversionError(Object object, Class clazz, boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("Cannot convert " + object + " to type " + clazz);
        }
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", object.toString(), JavaMembers.javaSignature(clazz));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.javaObject != null) {
            Class<?> clazz = this.javaObject.getClass();
            if (clazz.getName().startsWith("adapter")) {
                objectOutputStream.writeBoolean(true);
                if (adapter_writeAdapterObject == null) {
                    throw new IOException();
                }
                Object[] objectArray = new Object[]{this.javaObject, objectOutputStream};
                try {
                    adapter_writeAdapterObject.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    throw new IOException();
                }
            } else {
                objectOutputStream.writeBoolean(false);
                objectOutputStream.writeObject(this.javaObject);
            }
        } else {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeObject(this.javaObject);
        }
        if (this.staticType != null) {
            objectOutputStream.writeObject(this.staticType.getClass().getName());
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray;
        objectInputStream.defaultReadObject();
        if (objectInputStream.readBoolean()) {
            if (adapter_readAdapterObject == null) {
                throw new ClassNotFoundException();
            }
            objectArray = new Object[]{this, objectInputStream};
            try {
                this.javaObject = adapter_readAdapterObject.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        } else {
            this.javaObject = objectInputStream.readObject();
        }
        this.staticType = (objectArray = (Object[])objectInputStream.readObject()) != null ? Class.forName((String)objectArray) : null;
        this.initMembers();
    }

    static {
        Class clazz = Kit.classOrNull("org.mozilla.javascript.JavaAdapter");
        if (clazz != null) {
            Class[] classArray = new Class[2];
            try {
                classArray[0] = ScriptRuntime.ClassClass;
                classArray[1] = ScriptRuntime.FunctionClass;
                adapter_makeIFGlue = clazz.getMethod("makeIFGlue", classArray);
                classArray[0] = ScriptRuntime.ObjectClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectOutputStream");
                adapter_writeAdapterObject = clazz.getMethod("writeAdapterObject", classArray);
                classArray[0] = ScriptRuntime.ScriptableClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectInputStream");
                adapter_readAdapterObject = clazz.getMethod("readAdapterObject", classArray);
            }
            catch (Exception exception) {
                adapter_makeIFGlue = null;
                adapter_writeAdapterObject = null;
                adapter_readAdapterObject = null;
            }
        }
    }
}

