/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeJavaPackage
extends ScriptableObject {
    private String packageName;
    private ClassLoader classLoader;

    NativeJavaPackage(boolean bl, String string, ClassLoader classLoader) {
        this.packageName = string;
        this.classLoader = classLoader;
    }

    public NativeJavaPackage(String string, ClassLoader classLoader) {
        this(false, string, classLoader);
    }

    public NativeJavaPackage(String string) {
        this(false, string, Context.getCurrentContext().getApplicationClassLoader());
    }

    @Override
    public String getClassName() {
        return "JavaPackage";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return true;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        return this.getPkgProperty(string, scriptable, true);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return NOT_FOUND;
    }

    void forcePackage(String string) {
        NativeJavaPackage nativeJavaPackage;
        String string2;
        Object object;
        int n = string.indexOf(46);
        if (n == -1) {
            n = string.length();
        }
        if ((object = super.get(string2 = string.substring(0, n), (Scriptable)this)) != null && object instanceof NativeJavaPackage) {
            nativeJavaPackage = (NativeJavaPackage)object;
        } else {
            String string3 = this.packageName.length() == 0 ? string2 : this.packageName + "." + string2;
            nativeJavaPackage = new NativeJavaPackage(true, string3, this.classLoader);
            nativeJavaPackage.setParentScope(this);
            nativeJavaPackage.setPrototype(this.getPrototype());
            super.put(string2, (Scriptable)this, (Object)nativeJavaPackage);
        }
        if (n < string.length()) {
            nativeJavaPackage.forcePackage(string.substring(n + 1));
        }
    }

    synchronized Object getPkgProperty(String string, Scriptable scriptable, boolean bl) {
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        String string2 = this.packageName.length() == 0 ? string : this.packageName + '.' + string;
        Context context = Context.getContext();
        ClassShutter classShutter = context.getClassShutter();
        Scriptable scriptable2 = null;
        if (classShutter == null || classShutter.visibleToScripts(string2)) {
            Class clazz = null;
            clazz = this.classLoader != null ? Kit.classOrNull(this.classLoader, string2) : Kit.classOrNull(string2);
            if (clazz != null) {
                scriptable2 = new NativeJavaClass(NativeJavaPackage.getTopLevelScope(this), clazz);
            }
        }
        if (scriptable2 == null && bl) {
            scriptable2 = new NativeJavaPackage(true, string2, this.classLoader);
        }
        if (scriptable2 != null) {
            scriptable2.setParentScope(this);
            scriptable2.setPrototype(this.getPrototype());
            super.put(string, scriptable, (Object)scriptable2);
        }
        return scriptable2;
    }

    @Override
    public Object getDefaultValue(Class clazz) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }
}

