/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeNumber
extends IdScriptable {
    private static final int MAX_PRECISION = 100;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int Id_toFixed = 6;
    private static final int Id_toExponential = 7;
    private static final int Id_toPrecision = 8;
    private static final int MAX_PROTOTYPE_ID = 8;
    private double doubleValue;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeNumber nativeNumber = new NativeNumber();
        nativeNumber.prototypeFlag = true;
        nativeNumber.addAsPrototype(8, context, scriptable, bl);
    }

    private NativeNumber() {
    }

    private NativeNumber(double d) {
        this.doubleValue = d;
    }

    @Override
    public String getClassName() {
        return "Number";
    }

    @Override
    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        idFunction.defineProperty("NaN", ScriptRuntime.NaNobj, 7);
        idFunction.defineProperty("POSITIVE_INFINITY", this.wrap_double(Double.POSITIVE_INFINITY), 7);
        idFunction.defineProperty("NEGATIVE_INFINITY", this.wrap_double(Double.NEGATIVE_INFINITY), 7);
        idFunction.defineProperty("MAX_VALUE", this.wrap_double(Double.MAX_VALUE), 7);
        idFunction.defineProperty("MIN_VALUE", this.wrap_double(Double.MIN_VALUE), 7);
        super.fillConstructorProperties(context, idFunction, bl);
    }

    @Override
    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    @Override
    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    double d;
                    double d2 = d = objectArray.length >= 1 ? ScriptRuntime.toNumber(objectArray[0]) : 0.0;
                    if (scriptable2 == null) {
                        return new NativeNumber(d);
                    }
                    return this.wrap_double(d);
                }
                case 2: 
                case 3: {
                    double d = NativeNumber.realThisValue(scriptable2, idFunction);
                    int n2 = objectArray.length == 0 ? 10 : ScriptRuntime.toInt32(objectArray[0]);
                    return ScriptRuntime.numberToString(d, n2);
                }
                case 4: {
                    double d = NativeNumber.realThisValue(scriptable2, idFunction);
                    return "(new Number(" + ScriptRuntime.toString(d) + "))";
                }
                case 5: {
                    return this.wrap_double(NativeNumber.realThisValue(scriptable2, idFunction));
                }
                case 6: {
                    return NativeNumber.num_to(idFunction, scriptable2, objectArray, 2, 2, -20, 0);
                }
                case 7: {
                    return NativeNumber.num_to(idFunction, scriptable2, objectArray, 1, 3, 0, 1);
                }
                case 8: {
                    return NativeNumber.num_to(idFunction, scriptable2, objectArray, 0, 4, 1, 0);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static double realThisValue(Scriptable scriptable, IdFunction idFunction) {
        if (!(scriptable instanceof NativeNumber)) {
            throw NativeNumber.incompatibleCallError(idFunction);
        }
        return ((NativeNumber)scriptable).doubleValue;
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }

    private static String num_to(IdFunction idFunction, Scriptable scriptable, Object[] objectArray, int n, int n2, int n3, int n4) {
        int n5;
        double d = NativeNumber.realThisValue(scriptable, idFunction);
        if (objectArray.length == 0) {
            n5 = 0;
            n2 = n;
        } else {
            n5 = ScriptRuntime.toInt32(objectArray[0]);
            if (n5 < n3 || n5 > 100) {
                String string = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(objectArray[0]));
                throw ScriptRuntime.constructError("RangeError", string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, n2, n5 + n4, d);
        return stringBuffer.toString();
    }

    @Override
    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toLocaleString";
                }
                case 4: {
                    return "toSource";
                }
                case 5: {
                    return "valueOf";
                }
                case 6: {
                    return "toFixed";
                }
                case 7: {
                    return "toExponential";
                }
                case 8: {
                    return "toPrecision";
                }
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 7: {
                char c = string.charAt(0);
                if (c == 't') {
                    string2 = "toFixed";
                    n = 6;
                    break;
                }
                if (c != 'v') break;
                string2 = "valueOf";
                n = 5;
                break;
            }
            case 8: {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 4;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
                if (c != 't') break;
                string2 = "toPrecision";
                n = 8;
                break;
            }
            case 13: {
                string2 = "toExponential";
                n = 7;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 3;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

