/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeObjectPrototype
extends NativeObject {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int MAX_PROTOTYPE_ID = 8;

    NativeObjectPrototype(Context context, Scriptable scriptable, boolean bl) {
        this.addAsPrototype(8, context, scriptable, bl);
    }

    @Override
    public int methodArity(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 0;
            }
        }
        return super.methodArity(n);
    }

    @Override
    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        switch (n) {
            case 1: {
                if (scriptable2 != null) {
                    return idFunction.construct(context, scriptable, objectArray);
                }
                if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            }
            case 2: 
            case 3: {
                if (context.hasFeature(4)) {
                    String string = NativeObjectPrototype.toSource(context, scriptable, scriptable2, objectArray);
                    int n2 = string.length();
                    if (n2 != 0 && string.charAt(0) == '(' && string.charAt(n2 - 1) == ')') {
                        string = string.substring(1, n2 - 1);
                    }
                    return string;
                }
                return NativeObjectPrototype.toString(scriptable2);
            }
            case 4: {
                return scriptable2;
            }
            case 5: {
                String string;
                if (objectArray.length != 0 && scriptable2.has(string = ScriptRuntime.toString(objectArray[0]), scriptable2)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 6: {
                ScriptableObject scriptableObject;
                int n3;
                String string;
                if (objectArray.length != 0 && scriptable2.has(string = ScriptRuntime.toString(objectArray[0]), scriptable2) && scriptable2 instanceof ScriptableObject && ((n3 = (scriptableObject = (ScriptableObject)scriptable2).getAttributes(string)) & 2) == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 7: {
                if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
                    Scriptable scriptable3 = (Scriptable)objectArray[0];
                    do {
                        if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
                        return Boolean.TRUE;
                    } while (scriptable3 != null);
                }
                return Boolean.FALSE;
            }
            case 8: {
                return NativeObjectPrototype.toSource(context, scriptable, scriptable2, objectArray);
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    static String toString(Scriptable scriptable) {
        return "[object " + scriptable.getClassName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toSource(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        boolean bl;
        boolean bl2;
        if (context.iterating == null) {
            bl2 = true;
            bl = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl2 = false;
            bl = context.iterating.has(scriptable2);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        if (bl2) {
            stringBuffer.append("(");
        }
        stringBuffer.append('{');
        try {
            if (!bl) {
                context.iterating.intern(scriptable2);
                Object[] objectArray2 = scriptable2.getIds();
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object;
                    Object object2;
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    if ((object2 = objectArray2[i]) instanceof Integer) {
                        int n = (Integer)object2;
                        object = scriptable2.get(n, scriptable2);
                        stringBuffer.append(n);
                    } else {
                        String string = (String)object2;
                        object = scriptable2.get(string, scriptable2);
                        if (ScriptRuntime.isValidIdentifierName(string)) {
                            stringBuffer.append(string);
                        } else {
                            stringBuffer.append('\'');
                            stringBuffer.append(ScriptRuntime.escapeString(string, '\''));
                            stringBuffer.append('\'');
                        }
                    }
                    stringBuffer.append(':');
                    stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object));
                }
            }
        }
        finally {
            if (bl2) {
                context.iterating = null;
            }
        }
        stringBuffer.append('}');
        if (bl2) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "constructor";
            }
            case 2: {
                return "toString";
            }
            case 3: {
                return "toLocaleString";
            }
            case 4: {
                return "valueOf";
            }
            case 5: {
                return "hasOwnProperty";
            }
            case 6: {
                return "propertyIsEnumerable";
            }
            case 7: {
                return "isPrototypeOf";
            }
            case 8: {
                return "toSource";
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 7: {
                string2 = "valueOf";
                n = 4;
                break;
            }
            case 8: {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 8;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
                break;
            }
            case 13: {
                string2 = "isPrototypeOf";
                n = 7;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'h') {
                    string2 = "hasOwnProperty";
                    n = 5;
                    break;
                }
                if (c != 't') break;
                string2 = "toLocaleString";
                n = 3;
                break;
            }
            case 20: {
                string2 = "propertyIsEnumerable";
                n = 6;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

