/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    static final long serialVersionUID = 2762574228534679611L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    private Scriptable prototype;
    private Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private transient Slot[] slots;
    private int count;
    private transient Slot lastAccess = REMOVED;
    private volatile transient Hashtable associatedValues;

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return null != this.getNamedSlot(string);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return null != this.getSlot(null, n);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.getNamedSlot(string);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if ((slot.flags & 1) != 0) {
            return this.getByGetter((GetterSlot)slot, scriptable);
        }
        return slot.value;
    }

    private Object getByGetter(GetterSlot getterSlot, Scriptable scriptable) {
        Object[] objectArray;
        Object object;
        if (getterSlot.delegateTo == null) {
            if (scriptable != this) {
                Class clazz = getterSlot.getter.getDeclaringClass();
                while (!clazz.isInstance(scriptable) && (scriptable = scriptable.getPrototype()) != this) {
                    if (scriptable != null) continue;
                    scriptable = this;
                    break;
                }
            }
            object = scriptable;
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            object = getterSlot.delegateTo;
            objectArray = new Object[]{this};
        }
        return getterSlot.getter.invoke(object, objectArray);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        Slot slot = this.lastAccess;
        if ((string != slot.stringKey || slot.wasDeleted != 0) && (slot = this.getSlot(string, n = string.hashCode())) == null) {
            if (scriptable != this) {
                scriptable.put(string, scriptable, object);
                return;
            }
            slot = this.addSlot(string, n, null);
        }
        if (scriptable == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", string);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            this.setBySetter((GetterSlot)slot, scriptable, object);
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBySetter(GetterSlot getterSlot, Scriptable scriptable, Object object) {
        Object[] objectArray;
        Object object2;
        if (!(scriptable == this || getterSlot.delegateTo == null && getterSlot.setter.getDeclaringClass().isInstance(scriptable))) {
            scriptable.put(getterSlot.stringKey, scriptable, object);
            return;
        }
        Context context = Context.getContext();
        Class[] classArray = getterSlot.setter.argTypes;
        Class clazz = classArray[classArray.length - 1];
        int n = FunctionObject.getTypeTag(clazz);
        Object object3 = FunctionObject.convertArg(context, scriptable, object, n);
        if (getterSlot.delegateTo == null) {
            object2 = scriptable;
            objectArray = new Object[]{object3};
        } else {
            if (scriptable != this) {
                Kit.codeBug();
            }
            object2 = getterSlot.delegateTo;
            objectArray = new Object[]{this, object3};
        }
        if (((ScriptableObject)scriptable).isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", getterSlot.stringKey);
        }
        Object object4 = getterSlot.setter.invoke(object2, objectArray);
        if (getterSlot.setterReturnsValue) {
            Slot slot = new Slot();
            slot.intKey = getterSlot.intKey;
            slot.stringKey = getterSlot.stringKey;
            slot.attributes = getterSlot.attributes;
            slot.value = object4;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int n2 = ScriptableObject.getSlotPosition(this.slots, getterSlot.stringKey, getterSlot.intKey);
                if (n2 >= 0 && this.slots[n2] == getterSlot) {
                    this.slots[n2] = slot;
                    this.lastAccess = slot;
                }
            }
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            if (scriptable != this) {
                scriptable.put(n, scriptable, object);
                return;
            }
            slot = this.addSlot(null, n, null);
        }
        if (scriptable == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", Integer.toString(n));
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    @Override
    public void delete(String string) {
        this.removeSlot(string, string.hashCode());
    }

    @Override
    public void delete(int n) {
        this.removeSlot(null, n);
    }

    public final int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        return this.getAttributes(string);
    }

    public final int getAttributes(int n, Scriptable scriptable) throws PropertyException {
        return this.getAttributes(n);
    }

    public final void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        this.setAttributes(string, n);
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) throws PropertyException {
        this.setAttributes(n, n2);
    }

    public int getAttributes(String string) {
        Slot slot = this.getSlot(string, string.hashCode());
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", string);
        }
        return slot.attributes;
    }

    public int getAttributes(int n) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(n));
        }
        return slot.attributes;
    }

    public void setAttributes(String string, int n) {
        n &= 7;
        Slot slot = this.getSlot(string, string.hashCode());
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", string);
        }
        slot.attributes = (short)n;
    }

    public void setAttributes(int n, int n2) {
        n2 &= 7;
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(n));
        }
        slot.attributes = (short)n2;
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true);
    }

    @Override
    public Object getDefaultValue(Class clazz) {
        Context context = null;
        try {
            for (int i = 0; i < 2; ++i) {
                Object object;
                Object object2;
                Object object3;
                if (clazz == ScriptRuntime.StringClass ? i == 0 : i == 1) {
                    object3 = ScriptableObject.getProperty((Scriptable)this, "toString");
                    if (!(object3 instanceof Function)) continue;
                    object2 = (Function)object3;
                    if (context == null) {
                        context = Context.getContext();
                    }
                    object = object2.call(context, object2.getParentScope(), this, ScriptRuntime.emptyArgs);
                } else {
                    if (clazz == null) {
                        object3 = "undefined";
                    } else if (clazz == ScriptRuntime.StringClass) {
                        object3 = "string";
                    } else if (clazz == ScriptRuntime.ScriptableClass) {
                        object3 = "object";
                    } else if (clazz == ScriptRuntime.FunctionClass) {
                        object3 = "function";
                    } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                        object3 = "boolean";
                    } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                        object3 = "number";
                    } else {
                        throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                    }
                    object2 = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                    if (!(object2 instanceof Function)) continue;
                    Function function = (Function)object2;
                    Object[] objectArray = new Object[]{object3};
                    if (context == null) {
                        context = Context.getContext();
                    }
                    object = function.call(context, function.getParentScope(), this, objectArray);
                }
                if (!(object == null || object != Undefined.instance && object instanceof Scriptable && clazz != ScriptRuntime.ScriptableClass && clazz != ScriptRuntime.FunctionClass)) {
                    return object;
                }
                if (!(object instanceof NativeJavaObject) || !((object3 = ((Wrapper)object).unwrap()) instanceof String)) continue;
                return object3;
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        String string = clazz == null ? "undefined" : clazz.getName();
        throw ScriptRuntime.typeError1("msg.default.value", string);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public static void defineClass(Scriptable scriptable, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scriptable, clazz, false);
    }

    public static void defineClass(Scriptable scriptable, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        FunctionObject functionObject;
        Executable executable;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            executable = methodArray[i];
            if (!((Method)executable).getName().equals("init")) continue;
            Class<?>[] classArray = ((Method)executable).getParameterTypes();
            if (classArray.length == 3 && classArray[0] == ScriptRuntime.ContextClass && classArray[1] == ScriptRuntime.ScriptableClass && classArray[2] == Boolean.TYPE && Modifier.isStatic(((Method)executable).getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                ((Method)executable).invoke(null, objectArray);
                return;
            }
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(((Method)executable).getModifiers())) continue;
            Object[] objectArray = new Object[]{scriptable};
            ((Method)executable).invoke(null, objectArray);
            return;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        executable = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != 0) continue;
            executable = constructorArray[i];
            break;
        }
        if (executable == null) {
            throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
        }
        Scriptable scriptable2 = (Scriptable)((Constructor)executable).newInstance(ScriptRuntime.emptyArgs);
        scriptable2.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String string = scriptable2.getClassName();
        Executable executable2 = FunctionObject.findSingleMethod(methodArray, "jsConstructor");
        if (executable2 == null) {
            if (constructorArray.length == 1) {
                executable2 = constructorArray[0];
            } else if (constructorArray.length == 2) {
                if (constructorArray[0].getParameterTypes().length == 0) {
                    executable2 = constructorArray[1];
                } else if (constructorArray[1].getParameterTypes().length == 0) {
                    executable2 = constructorArray[0];
                }
            }
            if (executable2 == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
            }
        }
        if ((functionObject = new FunctionObject(string, executable2, scriptable)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", executable2.getName());
        }
        functionObject.addAsConstructor(scriptable, scriptable2);
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Object object2;
            if (methodArray[i] == executable2) continue;
            String string2 = methodArray[i].getName();
            if (string2.equals("finishInit") && ((Class<?>[])(object2 = methodArray[i].getParameterTypes())).length == 3 && object2[0] == ScriptRuntime.ScriptableClass && object2[1] == FunctionObject.class && object2[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(methodArray[i].getModifiers())) {
                method = methodArray[i];
                continue;
            }
            if (string2.indexOf(36) != -1 || string2.equals("jsConstructor")) continue;
            object2 = null;
            if (string2.startsWith("jsFunction_")) {
                object2 = "jsFunction_";
            } else if (string2.startsWith("jsStaticFunction_")) {
                object2 = "jsStaticFunction_";
                if (!Modifier.isStatic(methodArray[i].getModifiers())) {
                    throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                }
            } else if (string2.startsWith("jsGet_")) {
                object2 = "jsGet_";
            } else {
                if (!string2.startsWith("jsSet_")) continue;
                object2 = "jsSet_";
            }
            string2 = string2.substring(((String)object2).length());
            if (object2 == "jsSet_") continue;
            if (object2 == "jsGet_") {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), string2);
                }
                object = FunctionObject.findSingleMethod(methodArray, "jsSet_" + string2);
                int n = 6 | (object != null ? 0 : 1);
                ((ScriptableObject)scriptable2).defineProperty(string2, null, methodArray[i], (Method)object, n);
                continue;
            }
            object = new FunctionObject(string2, methodArray[i], scriptable2);
            if (((FunctionObject)object).isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", executable2.getName());
            }
            Scriptable scriptable3 = object2 == "jsStaticFunction_" ? functionObject : scriptable2;
            ScriptableObject.defineProperty(scriptable3, string2, object, 2);
            if (!bl) continue;
            ((ScriptableObject)object).sealObject();
        }
        if (method != null) {
            Object[] objectArray = new Object[]{scriptable, functionObject, scriptable2};
            method.invoke(null, objectArray);
        }
        if (bl) {
            functionObject.sealObject();
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
            }
        }
    }

    public void defineProperty(String string, Object object, int n) {
        this.put(string, (Scriptable)this, object);
        this.setAttributes(string, n);
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        if (!(scriptable instanceof ScriptableObject)) {
            scriptable.put(string, scriptable, object);
            return;
        }
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty(string, object, n);
    }

    public void defineProperty(String string, Class clazz, int n) throws PropertyException {
        int n2 = string.length();
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[3 + n2];
        string.getChars(0, n2, cArray, 3);
        cArray[3] = Character.toUpperCase(cArray[3]);
        cArray[0] = 103;
        cArray[1] = 101;
        cArray[2] = 116;
        String string2 = new String(cArray);
        cArray[0] = 115;
        String string3 = new String(cArray);
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        Method method = FunctionObject.findSingleMethod(methodArray, string2);
        Method method2 = FunctionObject.findSingleMethod(methodArray, string3);
        if (method2 == null) {
            n |= 1;
        }
        this.defineProperty(string, null, method, method2 == null ? null : method2, n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) throws PropertyException {
        Object object2;
        Class<?>[] classArray;
        int n2 = 1;
        if (object == null && Modifier.isStatic(method.getModifiers())) {
            object = HAS_STATIC_ACCESSORS;
        }
        if ((classArray = method.getParameterTypes()).length != 0) {
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableObjectClass) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", method.toString());
            }
        } else if (object != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", method.toString());
        }
        if (method2 != null) {
            int n3;
            n2 |= 2;
            if (object == HAS_STATIC_ACCESSORS != Modifier.isStatic(method2.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            classArray = method2.getParameterTypes();
            if (classArray.length == 2) {
                if (classArray[0] != ScriptRuntime.ScriptableObjectClass) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (object == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", method2.toString());
                }
            } else if (classArray.length == 1) {
                if (object != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", method2.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
            if ((n3 = FunctionObject.getTypeTag((Class)(object2 = classArray[classArray.length - 1]))) == 0) {
                throw PropertyException.withMessage2("msg.setter2.expected", ((Class)object2).getName(), method2.toString());
            }
        }
        object2 = ClassCache.get(this);
        GetterSlot getterSlot = new GetterSlot();
        getterSlot.delegateTo = object;
        getterSlot.getter = new MemberBox(method, (ClassCache)object2);
        getterSlot.getter.prepareInvokerOptimization();
        if (method2 != null) {
            getterSlot.setter = new MemberBox(method2, (ClassCache)object2);
            getterSlot.setter.prepareInvokerOptimization();
            getterSlot.setterReturnsValue = method2.getReturnType() != Void.TYPE;
        }
        getterSlot.value = null;
        getterSlot.attributes = (short)n;
        getterSlot.flags = (byte)n2;
        Slot slot = this.addSlot(string, string.hashCode(), getterSlot);
        if (slot != getterSlot) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] stringArray, Class clazz, int n) throws PropertyException {
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Method method = FunctionObject.findSingleMethod(methodArray, string);
            if (method == null) {
                throw PropertyException.withMessage2("msg.method.not.found", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, method, this);
            this.defineProperty(string, functionObject, n);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object == NOT_FOUND || !(object instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable2 = (Scriptable)object;
        if (!scriptable2.has("prototype", scriptable2)) {
            return null;
        }
        Object object2 = scriptable2.get("prototype", scriptable2);
        if (!(object2 instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)object2;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        while ((scriptable2 = (scriptable = scriptable2).getParentScope()) != null) {
        }
        return scriptable;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.getBase(scriptable, string);
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.getBase(scriptable, n);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        if (scriptable == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray = scriptable.getIds();
        ObjToIntMap objToIntMap = null;
        while ((scriptable = scriptable.getPrototype()) != null) {
            int n;
            Object[] objectArray2 = scriptable.getIds();
            if (objectArray2.length == 0) continue;
            if (objectArray.length == 0) {
                objectArray = objectArray2;
                continue;
            }
            if (objToIntMap == null) {
                for (n = 0; n != objectArray.length; ++n) {
                    objToIntMap.intern(objectArray[n]);
                }
                objectArray = null;
            }
            for (n = 0; n != objectArray2.length; ++n) {
                objToIntMap.intern(objectArray2[n]);
            }
        }
        if (objToIntMap != null) {
            objectArray = objToIntMap.getKeys();
        }
        return objectArray;
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) throws JavaScriptException {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (!(object instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(scriptable) + '.' + string);
        }
        Function function = (Function)object;
        return Context.call(function, ScriptableObject.getTopLevelScope(scriptable), scriptable, objectArray);
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable.has(string, scriptable2) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable.has(n, scriptable2) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    public final Object getAssociatedValue(Object object) {
        Hashtable hashtable = this.associatedValues;
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object associateValue(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        Hashtable hashtable = this.associatedValues;
        if (hashtable == null) {
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                hashtable = this.associatedValues;
                if (hashtable == null) {
                    this.associatedValues = hashtable = new Hashtable();
                }
            }
        }
        return Kit.initHash(hashtable, object, object2);
    }

    private Slot getNamedSlot(String string) {
        Slot slot = this.lastAccess;
        if (string == slot.stringKey && slot.wasDeleted == 0) {
            return slot;
        }
        Slot[] slotArray = this.slots;
        int n = string.hashCode();
        int n2 = ScriptableObject.getSlotPosition(slotArray, string, n);
        if (n2 < 0) {
            return null;
        }
        slot = slotArray[n2];
        slot.stringKey = string;
        this.lastAccess = slot;
        return slot;
    }

    private Slot getSlot(String string, int n) {
        Slot[] slotArray = this.slots;
        int n2 = ScriptableObject.getSlotPosition(slotArray, string, n);
        return n2 < 0 ? null : slotArray[n2];
    }

    private static int getSlotPosition(Slot[] slotArray, String string, int n) {
        if (slotArray != null) {
            Slot slot;
            int n2;
            int n3 = n2 = (n & Integer.MAX_VALUE) % slotArray.length;
            while ((slot = slotArray[n3]) != null) {
                if (slot != REMOVED && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                    return n3;
                }
                if (++n3 == slotArray.length) {
                    n3 = 0;
                }
                if (n3 != n2) continue;
            }
        }
        return -1;
    }

    private synchronized Slot addSlot(String string, int n, Slot slot) {
        if (this.isSealed()) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeError1("msg.add.sealed", string2);
        }
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        return this.addSlotImpl(string, n, slot);
    }

    private Slot addSlotImpl(String string, int n, Slot slot) {
        int n2;
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot2;
            if ((slot2 = this.slots[n3]) == null || slot2 == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.addSlotImpl(string, n, slot);
                }
                slot2 = slot == null ? new Slot() : slot;
                slot2.stringKey = string;
                slot2.intKey = n;
                this.slots[n3] = slot2;
                ++this.count;
                return slot2;
            }
            if (slot2.intKey == n && (slot2.stringKey == string || string != null && string.equals(slot2.stringKey))) {
                return slot2;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        Kit.codeBug();
        return null;
    }

    private synchronized void removeSlot(String string, int n) {
        if (this.isSealed()) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeError1("msg.remove.sealed", string2);
        }
        int n2 = ScriptableObject.getSlotPosition(this.slots, string, n);
        if (n2 >= 0) {
            Slot slot = this.slots[n2];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                this.slots[n2] = REMOVED;
                --this.count;
                if (slot == this.lastAccess) {
                    this.lastAccess = REMOVED;
                }
            }
        }
    }

    private void grow() {
        Slot[] slotArray = new Slot[this.slots.length * 2 + 1];
        for (int i = this.slots.length - 1; i >= 0; --i) {
            Slot slot = this.slots[i];
            if (slot == null || slot == REMOVED) continue;
            int n = (slot.intKey & Integer.MAX_VALUE) % slotArray.length;
            while (slotArray[n] != null) {
                if (++n != slotArray.length) continue;
                n = 0;
            }
            slotArray[n] = slot;
        }
        this.slots = slotArray;
    }

    Object[] getIds(boolean bl) {
        Slot[] slotArray = this.slots;
        Object[] objectArray = ScriptRuntime.emptyArgs;
        if (slotArray == null) {
            return objectArray;
        }
        int n = 0;
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            if (slot == null || slot == REMOVED || !bl && (slot.attributes & 2) != 0) continue;
            if (n == 0) {
                objectArray = new Object[slotArray.length - i];
            }
            objectArray[n++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Slot[] slotArray;
        objectOutputStream.defaultWriteObject();
        int n = this.count;
        if (n < 0) {
            n = -1 - this.count;
        }
        if ((slotArray = this.slots) == null) {
            if (n != 0) {
                Kit.codeBug();
            }
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(slotArray.length);
            int n2 = 0;
            while (n != 0) {
                Slot slot = slotArray[n2];
                if (slot != null && slot != REMOVED) {
                    --n;
                    objectOutputStream.writeObject(slot);
                }
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lastAccess = REMOVED;
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.slots = new Slot[n];
            int n2 = this.count;
            boolean bl = false;
            if (n2 < 0) {
                n2 = -1 - n2;
                bl = true;
            }
            this.count = 0;
            for (int i = 0; i != n2; ++i) {
                Slot slot = (Slot)objectInputStream.readObject();
                this.addSlotImpl(slot.stringKey, slot.intKey, slot);
            }
            if (bl) {
                this.count = -1 - this.count;
            }
        }
    }

    static class GetterSlot
    extends Slot {
        Object delegateTo;
        MemberBox getter;
        MemberBox setter;
        boolean setterReturnsValue;

        GetterSlot() {
        }
    }

    private static class Slot
    implements Serializable {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        static final long serialVersionUID = -2158009919774350004L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }
    }
}

