/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.optimizer.Codegen;

public class ClassCompiler {
    private CompilerEnvirons compilerEnv;
    private Class targetExtends;
    private Class[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnvirons) {
        if (compilerEnvirons == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnvirons;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class clazz) {
        this.targetExtends = clazz;
    }

    public Class[] getTargetImplements() {
        return this.targetImplements;
    }

    public void setTargetImplements(Class[] classArray) {
        this.targetImplements = classArray;
    }

    protected String makeAuxiliaryClassName(String string, String string2) {
        return string + string2;
    }

    public Object[] compileToClassFiles(String string, String string2, int n, String string3) {
        String string4;
        Parser parser = new Parser(this.compilerEnv);
        ScriptOrFnNode scriptOrFnNode = parser.parse(string, string2, n);
        int n2 = this.compilerEnv.getSyntaxErrorCount();
        if (n2 == 0) {
            string4 = parser.getEncodedSource();
            Class clazz = this.getTargetExtends();
            Class[] classArray = this.getTargetImplements();
            boolean bl = classArray == null && clazz == null;
            String string5 = bl ? string3 : this.makeAuxiliaryClassName(string3, "1");
            Codegen codegen = new Codegen();
            byte[] byArray = codegen.compileToClassFile(this.compilerEnv, string5, scriptOrFnNode, string4, false);
            n2 = this.compilerEnv.getSyntaxErrorCount();
            if (n2 == 0) {
                if (bl) {
                    return new Object[]{string5, byArray};
                }
                int n3 = scriptOrFnNode.getFunctionCount();
                ObjToIntMap objToIntMap = new ObjToIntMap(n3);
                for (int i = 0; i != n3; ++i) {
                    FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
                    String string6 = functionNode.getFunctionName();
                    if (string6 == null || string6.length() == 0) continue;
                    objToIntMap.put(string6, functionNode.getParamCount());
                }
                if (clazz == null) {
                    clazz = ScriptRuntime.ObjectClass;
                }
                byte[] byArray2 = JavaAdapter.createAdapterCode(objToIntMap, string3, clazz, classArray, string5);
                return new Object[]{string3, byArray2, string5, byArray};
            }
        }
        string4 = ScriptRuntime.getMessage1("msg.got.syntax.errors", String.valueOf(n2));
        throw this.compilerEnv.getErrorReporter().runtimeError(string4, string2, n, null, 0);
    }
}

