/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.optimizer.BodyCodegen;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    private static final String SUPER_CLASS_NAME = "org.mozilla.javascript.NativeFunction";
    static final String DIRECT_CALL_PARENT_FIELD = "_dcp";
    private static final String ID_FIELD_NAME = "_id";
    private static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    private static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/RegExpProxy;Lorg/mozilla/javascript/Context;)V";
    static final String REGEXP_ARRAY_FIELD_NAME = "_re";
    static final String REGEXP_ARRAY_FIELD_TYPE = "[Ljava/lang/Object;";
    static final String FUNCTION_INIT_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V";
    static final String FUNCTION_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V";
    private CompilerEnvirons compilerEnv;
    private ObjArray directCallTargets;
    ScriptOrFnNode[] scriptOrFnNodes;
    private ObjToIntMap scriptOrFnIndexes;
    String mainClassName;
    String mainClassSignature;
    boolean itsUseDynamicScope;
    int languageVersion;
    private double[] itsConstantList;
    private int itsConstantListSize;

    @Override
    public Object compile(Scriptable scriptable, CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl, Object object) {
        Object object2;
        Object[] objectArray;
        Object object3;
        Object object4;
        Object object5;
        Context context = Context.getCurrentContext();
        OptClassNameHelper optClassNameHelper = (OptClassNameHelper)ClassNameHelper.get(context);
        Class[] classArray = optClassNameHelper.getTargetImplements();
        Class clazz = optClassNameHelper.getTargetExtends();
        boolean bl2 = classArray == null && clazz == null;
        String string2 = optClassNameHelper.getScriptClassName(bl2);
        byte[] byArray = this.compileToClassFile(compilerEnvirons, string2, scriptOrFnNode, string, bl);
        boolean bl3 = false;
        ClassRepository classRepository = optClassNameHelper.getClassRepository();
        if (classRepository != null) {
            try {
                if (!classRepository.storeClass(string2, byArray, true)) {
                    bl3 = true;
                }
            }
            catch (IOException iOException) {
                throw Context.throwAsScriptRuntimeEx(iOException);
            }
            if (!bl2) {
                object5 = optClassNameHelper.getScriptClassName(true);
                int n = scriptOrFnNode.getFunctionCount();
                object4 = new ObjToIntMap(n);
                for (int i = 0; i != n; ++i) {
                    object3 = scriptOrFnNode.getFunctionNode(i);
                    objectArray = ((FunctionNode)object3).getFunctionName();
                    if (objectArray == null || objectArray.length() == 0) continue;
                    ((ObjToIntMap)object4).put(objectArray, ((ScriptOrFnNode)object3).getParamCount());
                }
                if (clazz == null) {
                    clazz = ScriptRuntime.ObjectClass;
                }
                object2 = JavaAdapter.createAdapterCode((ObjToIntMap)object4, (String)object5, clazz, classArray, string2);
                try {
                    if (!classRepository.storeClass((String)object5, (byte[])object2, true)) {
                        bl3 = true;
                    }
                }
                catch (IOException iOException) {
                    throw Context.throwAsScriptRuntimeEx(iOException);
                }
            }
        }
        if (bl3) {
            return null;
        }
        object5 = null;
        Class clazz2 = null;
        object4 = SecurityController.createLoader(null, object);
        try {
            clazz2 = object4.defineClass(string2, byArray);
            object4.linkClass(clazz2);
        }
        catch (SecurityException securityException) {
            object5 = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object5 = illegalArgumentException;
        }
        if (object5 != null) {
            throw new RuntimeException("Malformed optimizer package " + object5);
        }
        if (scriptOrFnNode.getType() == 87) {
            try {
                object3 = clazz2.getConstructors()[0];
                objectArray = new Object[]{scriptable, context, new Integer(0)};
                object2 = (NativeFunction)((Constructor)object3).newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
            }
            int n = ((FunctionNode)scriptOrFnNode).getFunctionType();
            OptRuntime.initFunction((NativeFunction)object2, n, scriptable, context);
            return object2;
        }
        try {
            object2 = (Script)clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return object2;
    }

    public void notifyDebuggerCompilationDone(Context context, ScriptOrFnNode scriptOrFnNode, String string) {
    }

    byte[] compileToClassFile(CompilerEnvirons compilerEnvirons, String string, ScriptOrFnNode scriptOrFnNode, String string2, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        this.transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.initScriptOrFnNodesData(scriptOrFnNode);
        this.mainClassName = string;
        this.mainClassSignature = ClassFileWriter.classNameToSignature(string);
        return this.generateCode(string2);
    }

    private void transform(ScriptOrFnNode scriptOrFnNode) {
        Codegen.initOptFunctions_r(scriptOrFnNode);
        int n = this.compilerEnv.getOptimizationLevel();
        Hashtable<String, OptFunctionNode> hashtable = null;
        if (n > 0 && scriptOrFnNode.getType() == 118) {
            int n2 = scriptOrFnNode.getFunctionCount();
            for (int i = 0; i != n2; ++i) {
                String string;
                OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode, i);
                if (optFunctionNode.fnode.getFunctionType() != 1 || (string = optFunctionNode.fnode.getFunctionName()).length() == 0) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, OptFunctionNode>();
                }
                hashtable.put(string, optFunctionNode);
            }
        }
        if (hashtable != null) {
            this.directCallTargets = new ObjArray();
        }
        OptTransformer optTransformer = new OptTransformer(this.compilerEnv, hashtable, this.directCallTargets);
        optTransformer.transform(scriptOrFnNode);
        if (n > 0) {
            new Optimizer().optimize(scriptOrFnNode, n);
        }
    }

    private static void initOptFunctions_r(ScriptOrFnNode scriptOrFnNode) {
        int n = scriptOrFnNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            new OptFunctionNode(functionNode);
            Codegen.initOptFunctions_r(functionNode);
        }
    }

    private void initScriptOrFnNodesData(ScriptOrFnNode scriptOrFnNode) {
        ObjArray objArray = new ObjArray();
        Codegen.collectScriptOrFnNodes_r(scriptOrFnNode, objArray);
        int n = objArray.size();
        this.scriptOrFnNodes = new ScriptOrFnNode[n];
        objArray.toArray(this.scriptOrFnNodes);
        this.scriptOrFnIndexes = new ObjToIntMap(n);
        for (int i = 0; i != n; ++i) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[i], i);
        }
    }

    private static void collectScriptOrFnNodes_r(ScriptOrFnNode scriptOrFnNode, ObjArray objArray) {
        objArray.add(scriptOrFnNode);
        int n = scriptOrFnNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            Codegen.collectScriptOrFnNodes_r(scriptOrFnNode.getFunctionNode(i), objArray);
        }
    }

    private byte[] generateCode(String string) {
        int n;
        boolean bl = this.scriptOrFnNodes[0].getType() == 118;
        boolean bl2 = this.scriptOrFnNodes.length > 1 || !bl;
        String string2 = null;
        if (this.compilerEnv.isGenerateDebugInfo()) {
            string2 = this.scriptOrFnNodes[0].getSourceName();
        }
        ClassFileWriter classFileWriter = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, string2);
        classFileWriter.addField(ID_FIELD_NAME, "I", (short)2);
        classFileWriter.addField(DIRECT_CALL_PARENT_FIELD, this.mainClassSignature, (short)2);
        classFileWriter.addField(REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE, (short)2);
        if (bl2) {
            this.generateFunctionConstructor(classFileWriter);
        }
        if (bl) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[0];
            classFileWriter.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(classFileWriter, scriptOrFnNode);
            Codegen.generateMain(classFileWriter);
            this.generateExecute(classFileWriter, scriptOrFnNode);
        }
        this.generateCallMethod(classFileWriter);
        if (string != null) {
            this.generateGetEncodedSource(classFileWriter, string);
        }
        int n2 = this.scriptOrFnNodes.length;
        for (n = 0; n != n2; ++n) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n];
            BodyCodegen bodyCodegen = new BodyCodegen();
            bodyCodegen.cfw = classFileWriter;
            bodyCodegen.codegen = this;
            bodyCodegen.compilerEnv = this.compilerEnv;
            bodyCodegen.scriptOrFn = scriptOrFnNode;
            bodyCodegen.generateBodyCode();
            if (scriptOrFnNode.getType() != 87) continue;
            OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode);
            this.generateFunctionInit(classFileWriter, optFunctionNode);
            if (!optFunctionNode.isTargetOfDirectCall()) continue;
            this.emitDirectConstructor(classFileWriter, optFunctionNode);
        }
        if (this.directCallTargets != null) {
            n = this.directCallTargets.size();
            for (int i = 0; i != n; ++i) {
                classFileWriter.addField(Codegen.getDirectTargetFieldName(i), this.mainClassSignature, (short)2);
            }
        }
        this.emitRegExpInit(classFileWriter);
        this.emitConstantDudeInitializers(classFileWriter);
        return classFileWriter.toByteArray();
    }

    private void emitDirectConstructor(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        int n;
        classFileWriter.startMethod(this.getDirectCtorName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode), (short)10);
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = 4 + n2 * 3 + 1;
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke((byte)-74, "org/mozilla/javascript/BaseFunction", "createObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addAStore(n3);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(n3);
        for (n = 0; n < n2; ++n) {
            classFileWriter.addALoad(4 + n * 3);
            classFileWriter.addDLoad(5 + n * 3);
        }
        classFileWriter.addALoad(4 + n2 * 3);
        classFileWriter.addInvoke((byte)-72, this.mainClassName, this.getBodyMethodName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode));
        n = classFileWriter.acquireLabel();
        classFileWriter.add((byte)89);
        classFileWriter.add((byte)-63, "org/mozilla/javascript/Scriptable");
        classFileWriter.add((byte)-103, n);
        classFileWriter.add((byte)89);
        Codegen.pushUndefined(classFileWriter);
        classFileWriter.add((byte)-91, n);
        classFileWriter.add((byte)-64, "org/mozilla/javascript/Scriptable");
        classFileWriter.add((byte)-80);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(n3);
        classFileWriter.add((byte)-80);
        classFileWriter.stopMethod((short)(n3 + 1), null);
    }

    private void generateCallMethod(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        int n = this.scriptOrFnNodes.length;
        boolean bl = 2 <= n;
        int n2 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addLoadThis();
            classFileWriter.add((byte)-76, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
            n2 = classFileWriter.addTableSwitch(1, n - 1);
        }
        for (int i = 0; i != n; ++i) {
            int n3;
            OptFunctionNode optFunctionNode;
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[i];
            if (bl) {
                if (i == 0) {
                    classFileWriter.markTableSwitchDefault(n2);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n2, i - 1, s);
                }
            }
            if (scriptOrFnNode.getType() == 87 && (optFunctionNode = OptFunctionNode.get(scriptOrFnNode)).isTargetOfDirectCall() && (n3 = optFunctionNode.fnode.getParamCount()) != 0) {
                for (int j = 0; j != n3; ++j) {
                    classFileWriter.add((byte)-66);
                    classFileWriter.addPush(j);
                    int n4 = classFileWriter.acquireLabel();
                    int n5 = classFileWriter.acquireLabel();
                    classFileWriter.add((byte)-92, n4);
                    classFileWriter.addALoad(4);
                    classFileWriter.addPush(j);
                    classFileWriter.add((byte)50);
                    classFileWriter.add((byte)-89, n5);
                    classFileWriter.markLabel(n4);
                    Codegen.pushUndefined(classFileWriter);
                    classFileWriter.markLabel(n5);
                    classFileWriter.adjustStackTop(-1);
                    classFileWriter.addPush(0.0);
                    classFileWriter.addALoad(4);
                }
            }
            classFileWriter.addInvoke((byte)-72, this.mainClassName, this.getBodyMethodName(scriptOrFnNode), this.getBodyMethodSignature(scriptOrFnNode));
            classFileWriter.add((byte)-80);
        }
        classFileWriter.stopMethod((short)5, null);
    }

    private static void generateMain(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        classFileWriter.add((byte)-69, classFileWriter.getClassName());
        classFileWriter.add((byte)89);
        classFileWriter.addInvoke((byte)-73, classFileWriter.getClassName(), "<init>", "()V");
        classFileWriter.add((byte)42);
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", "main", "(Lorg/mozilla/javascript/Script;[Ljava/lang/String;)V");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)1, null);
    }

    private void generateExecute(ClassFileWriter classFileWriter, ScriptOrFnNode scriptOrFnNode) {
        classFileWriter.startMethod("exec", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;", (short)17);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.add((byte)89);
        classFileWriter.add((byte)1);
        classFileWriter.addInvoke((byte)-74, classFileWriter.getClassName(), "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add((byte)-80);
        classFileWriter.stopMethod((short)3, null);
    }

    private void generateScriptCtor(ClassFileWriter classFileWriter, ScriptOrFnNode scriptOrFnNode) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.addLoadThis();
        classFileWriter.addInvoke((byte)-73, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addPush(0);
        classFileWriter.add((byte)-75, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.addLoadThis();
        classFileWriter.addPush(this.compilerEnv.getLanguageVersion());
        classFileWriter.addPush("");
        Codegen.pushParamNamesArray(classFileWriter, scriptOrFnNode);
        classFileWriter.addPush(0);
        classFileWriter.addInvoke((byte)-74, "org/mozilla/javascript/NativeFunction", "initScriptFunction", "(ILjava/lang/String;[Ljava/lang/String;I)V");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)1, null);
    }

    private void generateFunctionConstructor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", FUNCTION_CONSTRUCTOR_SIGNATURE, (short)1);
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke((byte)-73, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addILoad(3);
        classFileWriter.add((byte)-75, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(1);
        int n = this.scriptOrFnNodes[0].getType() == 118 ? 1 : 0;
        int n2 = this.scriptOrFnNodes.length;
        if (n == n2) {
            Codegen.badTree();
        }
        boolean bl = 2 <= n2 - n;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addILoad(3);
            n3 = classFileWriter.addTableSwitch(n + 1, n2 - 1);
        }
        for (int i = n; i != n2; ++i) {
            if (bl) {
                if (i == n) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, i - 1 - n, s);
                }
            }
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFnNodes[i]);
            classFileWriter.addInvoke((byte)-74, this.mainClassName, this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE);
            classFileWriter.add((byte)-79);
        }
        classFileWriter.stopMethod((short)4, null);
    }

    private void generateFunctionInit(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        classFileWriter.startMethod(this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE, (short)18);
        classFileWriter.addLoadThis();
        classFileWriter.addPush(this.compilerEnv.getLanguageVersion());
        classFileWriter.addPush(optFunctionNode.fnode.getFunctionName());
        Codegen.pushParamNamesArray(classFileWriter, optFunctionNode.fnode);
        classFileWriter.addPush(optFunctionNode.fnode.getParamCount());
        classFileWriter.addInvoke((byte)-74, "org/mozilla/javascript/NativeFunction", "initScriptFunction", "(ILjava/lang/String;[Ljava/lang/String;I)V");
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke((byte)-74, "org/mozilla/javascript/ScriptableObject", "setParentScope", "(Lorg/mozilla/javascript/Scriptable;)V");
        int n = optFunctionNode.fnode.getRegexpCount();
        if (n != 0) {
            classFileWriter.addLoadThis();
            this.pushRegExpArray(classFileWriter, optFunctionNode.fnode, 1, 2);
            classFileWriter.add((byte)-75, this.mainClassName, REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE);
        }
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)3, null);
    }

    private void generateGetEncodedSource(ClassFileWriter classFileWriter, String string) {
        classFileWriter.startMethod("getEncodedSource", "()Ljava/lang/String;", (short)1);
        classFileWriter.addPush(string);
        int n = this.scriptOrFnNodes.length;
        if (n == 1) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[0];
            classFileWriter.addPush(scriptOrFnNode.getEncodedSourceStart());
            classFileWriter.addPush(scriptOrFnNode.getEncodedSourceEnd());
        } else {
            classFileWriter.addLoadThis();
            classFileWriter.add((byte)-76, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
            int n2 = classFileWriter.addTableSwitch(1, n - 1);
            int n3 = classFileWriter.acquireLabel();
            short s = 0;
            for (int i = 0; i != n; ++i) {
                ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[i];
                if (i == 0) {
                    classFileWriter.markTableSwitchDefault(n2);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n2, i - 1, s);
                }
                classFileWriter.addPush(scriptOrFnNode.getEncodedSourceStart());
                classFileWriter.addPush(scriptOrFnNode.getEncodedSourceEnd());
                if (i + 1 == n) continue;
                classFileWriter.add((byte)-89, n3);
            }
            classFileWriter.markLabel(n3);
        }
        classFileWriter.addInvoke((byte)-74, "java/lang/String", "substring", "(II)Ljava/lang/String;");
        classFileWriter.add((byte)-80);
        classFileWriter.stopMethod((short)1, null);
    }

    private void emitRegExpInit(ClassFileWriter classFileWriter) {
        int n;
        int n2 = 0;
        for (n = 0; n != this.scriptOrFnNodes.length; ++n) {
            n2 += this.scriptOrFnNodes[n].getRegexpCount();
        }
        if (n2 == 0) {
            return;
        }
        classFileWriter.startMethod(REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE, (short)42);
        classFileWriter.addField("_reInitDone", "Z", (short)10);
        classFileWriter.add((byte)-78, this.mainClassName, "_reInitDone", "Z");
        n = classFileWriter.acquireLabel();
        classFileWriter.add((byte)-103, n);
        classFileWriter.add((byte)-79);
        classFileWriter.markLabel(n);
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[i];
            int n3 = scriptOrFnNode.getRegexpCount();
            for (int j = 0; j != n3; ++j) {
                String string = this.getCompiledRegexpName(scriptOrFnNode, j);
                String string2 = "Ljava/lang/Object;";
                String string3 = scriptOrFnNode.getRegexpString(j);
                String string4 = scriptOrFnNode.getRegexpFlags(j);
                classFileWriter.addField(string, string2, (short)10);
                classFileWriter.addALoad(0);
                classFileWriter.addALoad(1);
                classFileWriter.addPush(string3);
                if (string4 == null) {
                    classFileWriter.add((byte)1);
                } else {
                    classFileWriter.addPush(string4);
                }
                classFileWriter.addInvoke((byte)-71, "org/mozilla/javascript/RegExpProxy", "compileRegExp", "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                classFileWriter.add((byte)-77, this.mainClassName, string, string2);
            }
        }
        classFileWriter.addPush(1);
        classFileWriter.add((byte)-77, this.mainClassName, "_reInitDone", "Z");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)2, null);
    }

    private void emitConstantDudeInitializers(ClassFileWriter classFileWriter) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        classFileWriter.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        for (int i = 0; i != n; ++i) {
            double d = dArray[i];
            String string = "_k" + i;
            String string2 = Codegen.getStaticConstantWrapperType(d);
            classFileWriter.addField(string, string2, (short)10);
            int n2 = (int)d;
            if ((double)n2 == d) {
                classFileWriter.add((byte)-69, "java/lang/Integer");
                classFileWriter.add((byte)89);
                classFileWriter.addPush(n2);
                classFileWriter.addInvoke((byte)-73, "java/lang/Integer", "<init>", "(I)V");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
            classFileWriter.add((byte)-77, this.mainClassName, string, string2);
        }
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)0, null);
    }

    private static void pushParamNamesArray(ClassFileWriter classFileWriter, ScriptOrFnNode scriptOrFnNode) {
        int n = scriptOrFnNode.getParamAndVarCount();
        if (n == 0) {
            classFileWriter.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyStrings", "[Ljava/lang/String;");
        } else {
            classFileWriter.addPush(n);
            classFileWriter.add((byte)-67, "java/lang/String");
            for (int i = 0; i != n; ++i) {
                classFileWriter.add((byte)89);
                classFileWriter.addPush(i);
                classFileWriter.addPush(scriptOrFnNode.getParamOrVarName(i));
                classFileWriter.add((byte)83);
            }
        }
    }

    void pushRegExpArray(ClassFileWriter classFileWriter, ScriptOrFnNode scriptOrFnNode, int n, int n2) {
        int n3 = scriptOrFnNode.getRegexpCount();
        if (n3 == 0) {
            Codegen.badTree();
        }
        classFileWriter.addPush(n3);
        classFileWriter.add((byte)-67, "java/lang/Object");
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", "checkRegExpProxy", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/RegExpProxy;");
        classFileWriter.add((byte)89);
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke((byte)-72, this.mainClassName, REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE);
        for (int i = 0; i != n3; ++i) {
            classFileWriter.add((byte)92);
            classFileWriter.addALoad(n);
            classFileWriter.addALoad(n2);
            classFileWriter.add((byte)-78, this.mainClassName, this.getCompiledRegexpName(scriptOrFnNode, i), "Ljava/lang/Object;");
            classFileWriter.addInvoke((byte)-71, "org/mozilla/javascript/RegExpProxy", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            classFileWriter.addPush(i);
            classFileWriter.add((byte)95);
            classFileWriter.add((byte)83);
        }
        classFileWriter.add((byte)87);
    }

    void pushNumberAsObject(ClassFileWriter classFileWriter, double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                classFileWriter.add((byte)-78, "org/mozilla/javascript/optimizer/OptRuntime", "zeroObj", "Ljava/lang/Double;");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
        } else {
            if (d == 1.0) {
                classFileWriter.add((byte)-78, "org/mozilla/javascript/optimizer/OptRuntime", "oneObj", "Ljava/lang/Double;");
                return;
            }
            if (d == -1.0) {
                classFileWriter.add((byte)-78, "org/mozilla/javascript/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Double;");
            } else if (d != d) {
                classFileWriter.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else if (this.itsConstantListSize >= 2000) {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            } else {
                int n;
                Object object;
                int n2 = this.itsConstantListSize;
                if (n2 == 0) {
                    this.itsConstantList = new double[64];
                } else {
                    object = this.itsConstantList;
                    for (n = 0; n != n2 && object[n] != d; ++n) {
                    }
                    if (n2 == ((double[])object).length) {
                        object = new double[n2 * 2];
                        System.arraycopy(this.itsConstantList, 0, object, 0, n2);
                        this.itsConstantList = object;
                    }
                }
                if (n == n2) {
                    this.itsConstantList[n2] = d;
                    this.itsConstantListSize = n2 + 1;
                }
                object = "_k" + n;
                String string = Codegen.getStaticConstantWrapperType(d);
                classFileWriter.add((byte)-78, this.mainClassName, (String)object, string);
            }
        }
    }

    private static void addDoubleWrap(ClassFileWriter classFileWriter) {
        classFileWriter.addInvoke((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    private static String getStaticConstantWrapperType(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    static void pushUndefined(ClassFileWriter classFileWriter) {
        classFileWriter.add((byte)-78, "org/mozilla/javascript/Undefined", "instance", "Lorg/mozilla/javascript/Scriptable;");
    }

    int getIndex(ScriptOrFnNode scriptOrFnNode) {
        return this.scriptOrFnIndexes.getExisting(scriptOrFnNode);
    }

    static String getDirectTargetFieldName(int n) {
        return "_dt" + n;
    }

    String getDirectCtorName(ScriptOrFnNode scriptOrFnNode) {
        return "_n" + this.getIndex(scriptOrFnNode);
    }

    String getBodyMethodName(ScriptOrFnNode scriptOrFnNode) {
        return "_c" + this.getIndex(scriptOrFnNode);
    }

    String getBodyMethodSignature(ScriptOrFnNode scriptOrFnNode) {
        OptFunctionNode optFunctionNode;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.mainClassSignature);
        stringBuffer.append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        if (scriptOrFnNode.getType() == 87 && (optFunctionNode = OptFunctionNode.get(scriptOrFnNode)).isTargetOfDirectCall()) {
            int n = optFunctionNode.fnode.getParamCount();
            for (int i = 0; i != n; ++i) {
                stringBuffer.append("Ljava/lang/Object;D");
            }
        }
        stringBuffer.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return stringBuffer.toString();
    }

    String getFunctionInitMethodName(OptFunctionNode optFunctionNode) {
        return "_i" + this.getIndex(optFunctionNode.fnode);
    }

    String getCompiledRegexpName(ScriptOrFnNode scriptOrFnNode, int n) {
        return REGEXP_ARRAY_FIELD_NAME + this.getIndex(scriptOrFnNode) + "_" + n;
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }
}

