/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class OptTransformer
extends NodeTransformer {
    private Hashtable possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(CompilerEnvirons compilerEnvirons, Hashtable hashtable, ObjArray objArray) {
        super(compilerEnvirons);
        this.possibleDirectCalls = hashtable;
        this.directCallTargets = objArray;
    }

    @Override
    protected void visitNew(Node node, ScriptOrFnNode scriptOrFnNode) {
        this.detectDirectCall(node, scriptOrFnNode);
        super.visitNew(node, scriptOrFnNode);
    }

    @Override
    protected void visitCall(Node node, ScriptOrFnNode scriptOrFnNode) {
        Node node2;
        Object object;
        this.detectDirectCall(node, scriptOrFnNode);
        Node node3 = node.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 39) {
            boolean bl2;
            object = node3.getString();
            boolean bl3 = bl2 = scriptOrFnNode.getType() == 87;
            if (bl2 && scriptOrFnNode.hasParamOrVar((String)object) && !this.inWithStatement()) {
                node3.setType(59);
            } else {
                node.removeChild(node3);
                node3.setType(58);
                node2 = Node.newString(node3.getString());
                Node node4 = new Node(34, node3, node2);
                node.addChildToFront(node4);
                node3 = node4;
                boolean bl4 = bl = this.inWithStatement() || !bl2;
            }
        }
        if (node3.getType() != 34 && node3.getType() != 36) {
            node.removeChild(node3);
            object = OptTransformer.createNewTemp(node3);
            Node node5 = OptTransformer.createUseTemp((Node)object);
            node5.putProp(2, object);
            node2 = new Node(114, node5);
            node.addChildToFront(node2);
            node.addChildToFront((Node)object);
            return;
        }
        object = node3.getFirstChild();
        node3.removeChild((Node)object);
        Node node6 = OptTransformer.createNewTemp((Node)object);
        node3.addChildToFront(node6);
        node2 = OptTransformer.createUseTemp(node6);
        node2.putProp(2, node6);
        if (bl) {
            node2 = new Node(68, node2);
        }
        node.addChildAfter(node2, node3);
        super.visitCall(node, scriptOrFnNode);
    }

    private void detectDirectCall(Node node, ScriptOrFnNode scriptOrFnNode) {
        if (scriptOrFnNode.getType() == 87) {
            Node node2 = node.getFirstChild();
            int n = 0;
            Node node3 = node2.getNext();
            while (node3 != null) {
                node3 = node3.getNext();
                ++n;
            }
            if (n == 0) {
                OptFunctionNode.get((ScriptOrFnNode)scriptOrFnNode).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode optFunctionNode;
                String string = null;
                if (node2.getType() == 39) {
                    string = node2.getString();
                } else if (node2.getType() == 34) {
                    string = node2.getFirstChild().getNext().getString();
                }
                if (string != null && (optFunctionNode = (OptFunctionNode)this.possibleDirectCalls.get(string)) != null && n == optFunctionNode.fnode.getParamCount() && n <= 32) {
                    node.putProp(16, optFunctionNode);
                    if (!optFunctionNode.isTargetOfDirectCall()) {
                        int n2 = this.directCallTargets.size();
                        this.directCallTargets.add(optFunctionNode);
                        optFunctionNode.setDirectTargetIndex(n2);
                    }
                }
            }
        }
    }

    static Node createNewTemp(Node node) {
        int n = node.getType();
        if (n == 41 || n == 40) {
            return node;
        }
        return new Node(116, node);
    }

    static Node createUseTemp(Node node) {
        switch (node.getType()) {
            case 116: {
                Node node2 = new Node(117);
                node2.putProp(2, node);
                int n = node.getIntProp(6, 0);
                if (n != Integer.MAX_VALUE) {
                    node.putIntProp(6, n + 1);
                }
                return node2;
            }
            case 41: {
                return Node.newString(node.getString());
            }
            case 40: {
                return Node.newNumber(node.getDouble());
            }
        }
        throw Kit.codeBug();
    }
}

