/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.util.Hashtable;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.Block;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

class Optimizer {
    static final int NoType = 0;
    static final int NumberType = 1;
    static final int AnyType = 3;
    static final int TO_OBJECT = 125;
    static final int TO_DOUBLE = 126;
    private static final boolean DEBUG_OPTIMIZER = false;
    private static int debug_blockCount;
    private int itsOptLevel;
    private boolean inDirectCallFunction;
    private boolean parameterUsedInNumberContext;

    Optimizer() {
    }

    void optimize(ScriptOrFnNode scriptOrFnNode, int n) {
        this.itsOptLevel = n;
        int n2 = scriptOrFnNode.getFunctionCount();
        for (int i = 0; i != n2; ++i) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode, i);
            this.optimizeFunction(optFunctionNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimizeFunction(OptFunctionNode optFunctionNode) {
        if (optFunctionNode.fnode.requiresActivation()) {
            return;
        }
        this.inDirectCallFunction = optFunctionNode.isTargetOfDirectCall();
        ObjArray objArray = new ObjArray();
        Optimizer.buildStatementList_r(optFunctionNode.fnode, objArray);
        Object[] objectArray = new Node[objArray.size()];
        objArray.toArray(objectArray);
        Block[] blockArray = Block.buildBlocks((Node[])objectArray);
        Object var5_5 = null;
        try {
            int n;
            optFunctionNode.establishVarsIndices();
            for (n = 0; n < objectArray.length; ++n) {
                Optimizer.replaceVariableAccess((Node)objectArray[n], optFunctionNode);
            }
            Optimizer.reachingDefDataFlow(optFunctionNode, blockArray);
            Optimizer.typeFlow(optFunctionNode, blockArray);
            Optimizer.findSinglyTypedVars(optFunctionNode, blockArray);
            Optimizer.localCSE(blockArray, optFunctionNode);
            if (!optFunctionNode.fnode.requiresActivation()) {
                this.parameterUsedInNumberContext = false;
                for (n = 0; n < objectArray.length; ++n) {
                    this.rewriteForNumberVariables((Node)objectArray[n]);
                }
                optFunctionNode.setParameterNumberContext(this.parameterUsedInNumberContext);
            }
        }
        catch (IOException iOException) {}
    }

    private static void findSinglyTypedVars(OptFunctionNode optFunctionNode, Block[] blockArray) {
        for (int i = 0; i < optFunctionNode.getVarCount(); ++i) {
            int n;
            OptLocalVariable optLocalVariable = optFunctionNode.getVar(i);
            if (optLocalVariable.isParameter() || (n = optLocalVariable.getTypeUnion()) != 1) continue;
            optLocalVariable.setIsNumber();
        }
    }

    private static void doBlockLocalCSE(Block[] blockArray, Block block, Hashtable hashtable, boolean[] blArray, OptFunctionNode optFunctionNode) {
        if (!blArray[block.getBlockID()]) {
            blArray[block.getBlockID()] = true;
            hashtable = block.localCSE(hashtable, optFunctionNode);
            Block[] blockArray2 = blockArray[block.getBlockID()].getSuccessorList();
            if (blockArray2 != null) {
                for (int i = 0; i < blockArray2.length; ++i) {
                    int n = blockArray2[i].getBlockID();
                    Block[] blockArray3 = blockArray[n].getPredecessorList();
                    if (blockArray3.length != 1) continue;
                    Optimizer.doBlockLocalCSE(blockArray, blockArray2[i], (Hashtable)hashtable.clone(), blArray, optFunctionNode);
                }
            }
        }
    }

    private static void localCSE(Block[] blockArray, OptFunctionNode optFunctionNode) {
        boolean[] blArray = new boolean[blockArray.length];
        Optimizer.doBlockLocalCSE(blockArray, blockArray[0], null, blArray, optFunctionNode);
        for (int i = 0; i < blockArray.length; ++i) {
            if (blArray[i]) continue;
            blockArray[i].localCSE(null, optFunctionNode);
        }
    }

    private static void typeFlow(OptFunctionNode optFunctionNode, Block[] blockArray) {
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = 0;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doTypeFlow() && (blockArray2 = blockArray[n].getSuccessorList()) != null) {
                    for (int i = 0; i < blockArray2.length; ++i) {
                        int n2 = blockArray2[i].getBlockID();
                        blArray[n2] = true;
                        bl |= n2 < n;
                    }
                }
            }
            if (n == blockArray.length - 1) {
                if (!bl) break;
                n = 0;
                bl = false;
                continue;
            }
            ++n;
        }
    }

    private static void reachingDefDataFlow(OptFunctionNode optFunctionNode, Block[] blockArray) {
        for (int i = 0; i < blockArray.length; ++i) {
            blockArray[i].initLiveOnEntrySets(optFunctionNode);
        }
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = blockArray.length - 1;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doReachedUseDataFlow() && (blockArray2 = blockArray[n].getPredecessorList()) != null) {
                    for (int i = 0; i < blockArray2.length; ++i) {
                        int n2 = blockArray2[i].getBlockID();
                        blArray[n2] = true;
                        bl |= n2 > n;
                    }
                }
            }
            if (n == 0) {
                if (!bl) break;
                n = blockArray.length - 1;
                bl = false;
                continue;
            }
            --n;
        }
        for (int i = 0; i < blockArray.length; ++i) {
            blockArray[i].markVolatileVariables(optFunctionNode);
        }
        blockArray[0].markAnyTypeVariables(optFunctionNode);
    }

    private void markDCPNumberContext(Node node) {
        OptLocalVariable optLocalVariable;
        if (this.inDirectCallFunction && node.getType() == 59 && (optLocalVariable = (OptLocalVariable)node.getProp(13)) != null && optLocalVariable.isParameter()) {
            this.parameterUsedInNumberContext = true;
        }
    }

    private boolean convertParameter(Node node) {
        OptLocalVariable optLocalVariable;
        if (this.inDirectCallFunction && node.getType() == 59 && (optLocalVariable = (OptLocalVariable)node.getProp(13)) != null && optLocalVariable.isParameter()) {
            node.removeProp(15);
            return true;
        }
        return false;
    }

    private int rewriteForNumberVariables(Node node) {
        Object object;
        switch (node.getType()) {
            case 51: {
                Node node2 = node.getFirstChild();
                int n = this.rewriteForNumberVariables(node2);
                if (n == 1) {
                    node.putIntProp(15, 0);
                }
                return 0;
            }
            case 40: {
                node.putIntProp(15, 0);
                return 1;
            }
            case 59: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(13);
                if (optLocalVariable != null) {
                    if (this.inDirectCallFunction && optLocalVariable.isParameter()) {
                        node.putIntProp(15, 0);
                        return 1;
                    }
                    if (optLocalVariable.isNumber()) {
                        node.putIntProp(15, 0);
                        return 1;
                    }
                }
                return 0;
            }
            case 84: 
            case 85: {
                Node node3 = node.getFirstChild();
                if (node3.getType() == 59) {
                    OptLocalVariable optLocalVariable = (OptLocalVariable)node3.getProp(13);
                    if (optLocalVariable != null && optLocalVariable.isNumber()) {
                        node.putIntProp(15, 0);
                        this.markDCPNumberContext(node3);
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            case 60: {
                Node node4 = node.getFirstChild();
                Node node5 = node4.getNext();
                int n = this.rewriteForNumberVariables(node5);
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(13);
                if (this.inDirectCallFunction && optLocalVariable.isParameter()) {
                    if (n == 1) {
                        if (!this.convertParameter(node5)) {
                            node.putIntProp(15, 0);
                            return 1;
                        }
                        this.markDCPNumberContext(node5);
                        return 0;
                    }
                    return n;
                }
                if (optLocalVariable != null && optLocalVariable.isNumber()) {
                    if (n != 1) {
                        node.removeChild(node5);
                        node.addChildToBack(new Node(126, node5));
                    }
                    node.putIntProp(15, 0);
                    this.markDCPNumberContext(node5);
                    return 1;
                }
                if (n == 1 && !this.convertParameter(node5)) {
                    node.removeChild(node5);
                    node.addChildToBack(new Node(125, node5));
                }
                return 0;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                Node node6 = node.getFirstChild();
                Node node7 = node6.getNext();
                int n = this.rewriteForNumberVariables(node6);
                int n2 = this.rewriteForNumberVariables(node7);
                this.markDCPNumberContext(node6);
                this.markDCPNumberContext(node7);
                if (this.convertParameter(node6)) {
                    if (this.convertParameter(node7)) {
                        return 0;
                    }
                    if (n2 == 1) {
                        node.putIntProp(15, 2);
                    }
                } else if (this.convertParameter(node7)) {
                    if (n == 1) {
                        node.putIntProp(15, 1);
                    }
                } else if (n == 1) {
                    if (n2 == 1) {
                        node.putIntProp(15, 0);
                    } else {
                        node.putIntProp(15, 1);
                    }
                } else if (n2 == 1) {
                    node.putIntProp(15, 2);
                }
                return 0;
            }
            case 22: {
                Node node8 = node.getFirstChild();
                Node node9 = node8.getNext();
                int n = this.rewriteForNumberVariables(node8);
                int n3 = this.rewriteForNumberVariables(node9);
                if (this.convertParameter(node8)) {
                    if (this.convertParameter(node9)) {
                        return 0;
                    }
                    if (n3 == 1) {
                        node.putIntProp(15, 2);
                    }
                } else if (this.convertParameter(node9)) {
                    if (n == 1) {
                        node.putIntProp(15, 1);
                    }
                } else if (n == 1) {
                    if (n3 == 1) {
                        node.putIntProp(15, 0);
                        return 1;
                    }
                    node.putIntProp(15, 1);
                } else if (n3 == 1) {
                    node.putIntProp(15, 2);
                }
                return 0;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                Node node10 = node.getFirstChild();
                Node node11 = node10.getNext();
                int n = this.rewriteForNumberVariables(node10);
                int n4 = this.rewriteForNumberVariables(node11);
                this.markDCPNumberContext(node10);
                this.markDCPNumberContext(node11);
                if (n == 1) {
                    if (n4 == 1) {
                        node.putIntProp(15, 0);
                        return 1;
                    }
                    if (!this.convertParameter(node11)) {
                        node.removeChild(node11);
                        node.addChildToBack(new Node(126, node11));
                        node.putIntProp(15, 0);
                    }
                    return 1;
                }
                if (n4 == 1) {
                    if (!this.convertParameter(node10)) {
                        node.removeChild(node10);
                        node.addChildToFront(new Node(126, node10));
                        node.putIntProp(15, 0);
                    }
                    return 1;
                }
                if (!this.convertParameter(node10)) {
                    node.removeChild(node10);
                    node.addChildToFront(new Node(126, node10));
                }
                if (!this.convertParameter(node11)) {
                    node.removeChild(node11);
                    node.addChildToBack(new Node(126, node11));
                }
                node.putIntProp(15, 0);
                return 1;
            }
            case 37: 
            case 122: {
                int n;
                int n5;
                Node node12 = node.getFirstChild();
                Node node13 = node12.getNext();
                Node node14 = node13.getNext();
                int n6 = this.rewriteForNumberVariables(node12);
                if (n6 == 1 && !this.convertParameter(node12)) {
                    node.removeChild(node12);
                    node.addChildToFront(new Node(125, node12));
                }
                if ((n5 = this.rewriteForNumberVariables(node13)) == 1) {
                    node.putIntProp(15, 1);
                    this.markDCPNumberContext(node13);
                }
                if ((n = this.rewriteForNumberVariables(node14)) == 1 && !this.convertParameter(node14)) {
                    node.removeChild(node14);
                    node.addChildToBack(new Node(125, node14));
                }
                return 0;
            }
            case 36: {
                int n;
                Node node15 = node.getFirstChild();
                Node node16 = node15.getNext();
                int n7 = this.rewriteForNumberVariables(node15);
                if (n7 == 1 && !this.convertParameter(node15)) {
                    node.removeChild(node15);
                    node.addChildToFront(new Node(125, node15));
                }
                if ((n = this.rewriteForNumberVariables(node16)) == 1 && !this.convertParameter(node16)) {
                    node.putIntProp(15, 2);
                }
                return 0;
            }
            case 38: {
                object = (OptFunctionNode)node.getProp(16);
                if (object == null) break;
                Node node17 = node.getFirstChild();
                this.rewriteForNumberVariables(node17);
                node17 = node17.getNext();
                this.rewriteForNumberVariables(node17);
                for (node17 = node17.getNext(); node17 != null; node17 = node17.getNext()) {
                    int n = this.rewriteForNumberVariables(node17);
                    if (n != 1) continue;
                    this.markDCPNumberContext(node17);
                }
                return 0;
            }
        }
        object = node.getFirstChild();
        while (object != null) {
            Node node18 = ((Node)object).getNext();
            int n = this.rewriteForNumberVariables((Node)object);
            if (n == 1 && !this.convertParameter((Node)object)) {
                node.removeChild((Node)object);
                Node node19 = new Node(125, (Node)object);
                if (node18 == null) {
                    node.addChildToBack(node19);
                } else {
                    node.addChildBefore(node19, node18);
                }
            }
            object = node18;
        }
        return 0;
    }

    private static void replaceVariableAccess(Node node, OptFunctionNode optFunctionNode) {
        String string;
        OptLocalVariable optLocalVariable;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            Optimizer.replaceVariableAccess(node2, optFunctionNode);
        }
        int n = node.getType();
        if (n == 60) {
            String string2 = node.getFirstChild().getString();
            OptLocalVariable optLocalVariable2 = optFunctionNode.getVar(string2);
            if (optLocalVariable2 != null) {
                node.putProp(13, optLocalVariable2);
            }
        } else if (n == 59 && (optLocalVariable = optFunctionNode.getVar(string = node.getString())) != null) {
            node.putProp(13, optLocalVariable);
        }
    }

    private static void buildStatementList_r(Node node, ObjArray objArray) {
        int n = node.getType();
        if (n == 107 || n == 124 || n == 112 || n == 87) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Optimizer.buildStatementList_r(node2, objArray);
            }
        } else {
            objArray.add(node);
        }
    }
}

