/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.REBackTrackData;
import org.mozilla.javascript.regexp.RECharSet;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.REGlobalData;
import org.mozilla.javascript.regexp.REMatchState;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.REProgState;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptable
implements Function {
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_NCCLASS = 37;
    private static final byte REOP_DOTSTARMIN = 38;
    private static final byte REOP_LPARENNON = 39;
    private static final byte REOP_RPARENNON = 40;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_ASSERTTEST = 43;
    private static final byte REOP_ASSERTNOTTEST = 44;
    private static final byte REOP_MINIMALSTAR = 45;
    private static final byte REOP_MINIMALPLUS = 46;
    private static final byte REOP_MINIMALOPT = 47;
    private static final byte REOP_MINIMALQUANT = 48;
    private static final byte REOP_ENDCHILD = 49;
    private static final byte REOP_CLASS = 50;
    private static final byte REOP_REPEAT = 51;
    private static final byte REOP_MINIMALREPEAT = 52;
    private static final byte REOP_END = 53;
    private static final int OFFSET_LEN = 2;
    private static final int ARG_LEN = 2;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 6;
    private static final int Id_toString = 7;
    private static final int Id_toSource = 8;
    private static final int Id_exec = 9;
    private static final int Id_test = 10;
    private static final int Id_prefix = 11;
    private static final int MAX_PROTOTYPE_ID = 11;
    private boolean prototypeFlag;
    RECompiled re;
    private double lastIndex;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.re = (RECompiled)NativeRegExp.compileRE("", null, false);
        nativeRegExp.prototypeFlag = true;
        nativeRegExp.setMaxId(11);
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(NativeRegExp.getObjectPrototype(scriptable));
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        ScriptRuntime.setFunctionProtoAndParent(scriptable, nativeRegExpCtor);
        nativeRegExpCtor.setImmunePrototypeProperty(nativeRegExp);
        if (bl) {
            nativeRegExp.sealObject();
            nativeRegExpCtor.sealObject();
        }
        NativeRegExp.defineProperty(scriptable, "RegExp", nativeRegExpCtor, 2);
    }

    NativeRegExp(Scriptable scriptable, Object object) {
        this.setMaxId(5);
        this.re = (RECompiled)object;
        this.lastIndex = 0.0;
        scriptable = NativeRegExp.getTopLevelScope(scriptable);
        this.setPrototype(NativeRegExp.getClassPrototype(scriptable, "RegExp"));
        this.setParentScope(scriptable);
    }

    @Override
    public String getClassName() {
        return "RegExp";
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.execSub(context, scriptable, objectArray, 1);
    }

    Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
            if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.bad.regexp.compile");
            }
            NativeRegExp nativeRegExp = (NativeRegExp)objectArray[0];
            this.re = nativeRegExp.re;
            this.lastIndex = nativeRegExp.lastIndex;
            return this;
        }
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 && objectArray[1] != Undefined.instance ? ScriptRuntime.toString(objectArray[1]) : null;
        this.re = (RECompiled)NativeRegExp.compileRE(string, string2, false);
        this.lastIndex = 0.0;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        if (this.re.source.length != 0) {
            stringBuffer.append(this.re.source);
        } else {
            stringBuffer.append("(?:)");
        }
        stringBuffer.append('/');
        if ((this.re.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.re.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((this.re.flags & 4) != 0) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    NativeRegExp() {
        this.setMaxId(5);
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    private Object execSub(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        Object object;
        double d;
        String string;
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        if (objectArray.length == 0) {
            string = regExpImpl.input;
            if (string == null) {
                NativeRegExp.reportError("msg.no.re.input.for", this.toString());
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        double d2 = d = (this.re.flags & 1) != 0 ? this.lastIndex : 0.0;
        if (d < 0.0 || (double)string.length() < d) {
            this.lastIndex = 0.0;
            object = null;
        } else {
            int[] nArray = new int[]{(int)d};
            object = this.executeRegExp(context, scriptable, regExpImpl, string, nArray, n);
            if ((this.re.flags & 1) != 0) {
                this.lastIndex = object == null || object == Undefined.instance ? 0.0 : (double)nArray[0];
            }
        }
        return object;
    }

    static Object compileRE(String string, String string2, boolean bl) {
        int n;
        RECompiled rECompiled = new RECompiled();
        rECompiled.source = string.toCharArray();
        int n2 = string.length();
        int n3 = 0;
        if (string2 != null) {
            for (int i = 0; i < string2.length(); ++i) {
                n = string2.charAt(i);
                if (n == 103) {
                    n3 |= 1;
                    continue;
                }
                if (n == 105) {
                    n3 |= 2;
                    continue;
                }
                if (n == 109) {
                    n3 |= 4;
                    continue;
                }
                NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf((char)n));
            }
        }
        rECompiled.flags = n3;
        CompilerState compilerState = new CompilerState(rECompiled.source, n2, n3);
        if (bl && n2 > 0) {
            compilerState.result = new RENode(21);
            compilerState.result.chr = compilerState.cpbegin[0];
            compilerState.result.length = n2;
            compilerState.result.flatIndex = 0;
            compilerState.progLength += 5;
        } else if (!NativeRegExp.parseDisjunction(compilerState)) {
            return null;
        }
        rECompiled.program = new byte[compilerState.progLength + 1];
        if (compilerState.classCount != 0) {
            rECompiled.classList = new RECharSet[compilerState.classCount];
            for (n = 0; n < compilerState.classCount; ++n) {
                rECompiled.classList[n] = new RECharSet();
            }
            rECompiled.classCount = compilerState.classCount;
        }
        n = NativeRegExp.emitREBytecode(compilerState, rECompiled, 0, compilerState.result);
        rECompiled.program[n++] = 53;
        rECompiled.parenCount = compilerState.parenCount;
        switch (rECompiled.program[0]) {
            case 28: 
            case 35: {
                rECompiled.anchorCh = (char)NativeRegExp.GET_ARG(rECompiled.program, 1);
                break;
            }
            case 22: 
            case 33: {
                rECompiled.anchorCh = (char)(rECompiled.program[1] & 0xFF);
                break;
            }
            case 21: 
            case 32: {
                int n4 = NativeRegExp.GET_ARG(rECompiled.program, 1);
                rECompiled.anchorCh = rECompiled.source[n4];
            }
        }
        return rECompiled;
    }

    static char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    static int unDigit(char c) {
        return c - 48;
    }

    static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static int unHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private static boolean isLineTerm(char c) {
        return TokenStream.isJSLineTerminator(c);
    }

    private static boolean isREWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 8232 || n == 8233 || n == 12 || n == 11 || n == 160 || Character.getType((char)n) == 12;
    }

    private static char upcase(char c) {
        if (c < '\u0080') {
            if ('a' <= c && c <= 'z') {
                return (char)(c + -32);
            }
            return c;
        }
        char c2 = Character.toUpperCase(c);
        if (c >= '\u0080' && c2 < '\u0080') {
            return c;
        }
        return c2;
    }

    private static char downcase(char c) {
        if (c < '\u0080') {
            if ('A' <= c && c <= 'Z') {
                return (char)(c + 32);
            }
            return c;
        }
        char c2 = Character.toLowerCase(c);
        if (c >= '\u0080' && c2 < '\u0080') {
            return c;
        }
        return c2;
    }

    private static int toASCIIHexDigit(int n) {
        if (n < 48) {
            return -1;
        }
        if (n <= 57) {
            return n - 48;
        }
        if (97 <= (n |= 0x20) && n <= 102) {
            return n - 97 + 10;
        }
        return -1;
    }

    private static boolean parseDisjunction(CompilerState compilerState) {
        int n;
        if (!NativeRegExp.parseAlternative(compilerState)) {
            return false;
        }
        char[] cArray = compilerState.cpbegin;
        if ((n = compilerState.cp++) != cArray.length && cArray[n] == '|') {
            RENode rENode = new RENode(1);
            rENode.kid = compilerState.result;
            if (!NativeRegExp.parseDisjunction(compilerState)) {
                return false;
            }
            rENode.kid2 = compilerState.result;
            compilerState.result = rENode;
            compilerState.progLength += 9;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean parseAlternative(CompilerState var0) {
        var1_1 = null;
        var2_2 = null;
        var3_3 = var0.cpbegin;
        block0: while (true) {
            if (var0.cp == var0.cpend || var3_3[var0.cp] == '|' || var0.parenNesting != 0 && var3_3[var0.cp] == ')') {
                var0.result = var1_1 == null ? new RENode(0) : var1_1;
                return true;
            }
            if (!NativeRegExp.parseTerm(var0)) {
                return false;
            }
            if (var1_1 == null) {
                var1_1 = var0.result;
                continue;
            }
            if (var2_2 == null) {
                var1_1.next = var0.result;
                var2_2 = var0.result;
                while (true) {
                    if (var2_2.next == null) continue block0;
                    var2_2 = var2_2.next;
                }
            }
            var2_2 = var2_2.next = var0.result;
            while (true) {
                if (var2_2.next != null) ** break;
                continue block0;
                var2_2 = var2_2.next;
            }
            break;
        }
    }

    private static boolean calculateBitmapSize(CompilerState compilerState, RENode rENode, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        rENode.bmsize = 0;
        if (n == n2) {
            return true;
        }
        if (cArray[n] == '^') {
            ++n;
        }
        while (n != n2) {
            int n5 = 0;
            int n6 = 2;
            block0 : switch (cArray[n]) {
                case '\\': {
                    int n7 = ++n;
                    ++n;
                    int n8 = cArray[n7];
                    switch (n8) {
                        case 98: {
                            n5 = 8;
                            break block0;
                        }
                        case 102: {
                            n5 = 12;
                            break block0;
                        }
                        case 110: {
                            n5 = 10;
                            break block0;
                        }
                        case 114: {
                            n5 = 13;
                            break block0;
                        }
                        case 116: {
                            n5 = 9;
                            break block0;
                        }
                        case 118: {
                            n5 = 11;
                            break block0;
                        }
                        case 99: {
                            if (n + 1 < n2 && Character.isLetter(cArray[n + 1])) {
                                n5 = (char)(cArray[n++] & 0x1F);
                                break block0;
                            }
                            n5 = 92;
                            break block0;
                        }
                        case 117: {
                            n6 += 2;
                        }
                        case 120: {
                            int n9;
                            int n10 = 0;
                            for (n9 = 0; n9 < n6 && n < n2; ++n9) {
                                if (!NativeRegExp.isHex((char)(n8 = cArray[n++]))) {
                                    n -= n9 + 1;
                                    n10 = 92;
                                    break;
                                }
                                n10 = n10 << 4 | NativeRegExp.unHex((char)n8);
                            }
                            n5 = n10;
                            break block0;
                        }
                        case 100: {
                            if (bl) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            n5 = 57;
                            break block0;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 115: 
                        case 119: {
                            if (bl) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            rENode.bmsize = 65535;
                            return true;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int n9;
                            int n10 = n8 - 48;
                            n8 = cArray[n];
                            if (48 <= n8 && n8 <= 55) {
                                n10 = 8 * n10 + (n8 - 48);
                                if (48 <= (n8 = cArray[++n]) && n8 <= 55) {
                                    ++n;
                                    n9 = 8 * n10 + (n8 - 48);
                                    if (n9 <= 255) {
                                        n10 = n9;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            n5 = n10;
                            break block0;
                        }
                    }
                    n5 = n8;
                    break;
                }
                default: {
                    n5 = cArray[n++];
                }
            }
            if (bl) {
                if (n3 > n5) {
                    NativeRegExp.reportError("msg.bad.range", "");
                    return false;
                }
                bl = false;
            } else if (n < n2 - 1 && cArray[n] == '-') {
                ++n;
                bl = true;
                n3 = (char)n5;
                continue;
            }
            if ((compilerState.flags & 2) != 0) {
                int n11;
                int n12 = NativeRegExp.upcase((char)n5);
                int n13 = n5 = n12 >= (n11 = NativeRegExp.downcase((char)n5)) ? n12 : n11;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        rENode.bmsize = n4;
        return true;
    }

    private static void doFlat(CompilerState compilerState, char c) {
        compilerState.result = new RENode(21);
        compilerState.result.chr = c;
        compilerState.result.length = 1;
        compilerState.result.flatIndex = -1;
        compilerState.progLength += 3;
    }

    private static int getDecimalValue(char c, CompilerState compilerState, int n, String string) {
        boolean bl = false;
        int n2 = compilerState.cp;
        char[] cArray = compilerState.cpbegin;
        int n3 = c - 48;
        while (compilerState.cp != compilerState.cpend && NativeRegExp.isDigit(c = cArray[compilerState.cp])) {
            if (!bl) {
                int n4 = c - 48;
                if (n3 < (n - n4) / 10) {
                    n3 = n3 * 10 + n4;
                } else {
                    bl = true;
                    n3 = n;
                }
            }
            ++compilerState.cp;
        }
        if (bl) {
            NativeRegExp.reportError(string, String.valueOf(cArray, n2, compilerState.cp - n2));
        }
        return n3;
    }

    private static boolean parseTerm(CompilerState compilerState) {
        int n;
        char[] cArray = compilerState.cpbegin;
        char c = cArray[compilerState.cp++];
        int n2 = 2;
        int n3 = compilerState.parenCount;
        int n4 = compilerState.cp;
        block0 : switch (c) {
            case '^': {
                compilerState.result = new RENode(2);
                ++compilerState.progLength;
                return true;
            }
            case '$': {
                compilerState.result = new RENode(3);
                ++compilerState.progLength;
                return true;
            }
            case '\\': {
                if (compilerState.cp < compilerState.cpend) {
                    c = cArray[compilerState.cp++];
                    switch (c) {
                        case 'b': {
                            compilerState.result = new RENode(4);
                            ++compilerState.progLength;
                            return true;
                        }
                        case 'B': {
                            compilerState.result = new RENode(5);
                            ++compilerState.progLength;
                            return true;
                        }
                        case '0': {
                            int n5 = 0;
                            while (compilerState.cp < compilerState.cpend && (c = cArray[compilerState.cp]) >= '0' && c <= '7') {
                                ++compilerState.cp;
                                int n6 = 8 * n5 + (c - 48);
                                if (n6 > 255) break;
                                n5 = n6;
                            }
                            c = (char)n5;
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int n7 = compilerState.cp - 1;
                            int n8 = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.backref");
                            if (n8 > 9 && n8 > compilerState.parenCount) {
                                compilerState.cp = n7;
                                n8 = 0;
                                while (compilerState.cp < compilerState.cpend && (c = cArray[compilerState.cp]) >= '0' && c <= '7') {
                                    ++compilerState.cp;
                                    int n9 = 8 * n8 + (c - 48);
                                    if (n9 > 255) break;
                                    n8 = n9;
                                }
                                c = (char)n8;
                                NativeRegExp.doFlat(compilerState, c);
                                break block0;
                            }
                            compilerState.result = new RENode(20);
                            compilerState.result.parenIndex = n8 - 1;
                            compilerState.progLength += 3;
                            break block0;
                        }
                        case 'f': {
                            c = '\f';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'n': {
                            c = '\n';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'r': {
                            c = '\r';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 't': {
                            c = '\t';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'v': {
                            c = '\u000b';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'c': {
                            if (compilerState.cp + 1 < compilerState.cpend && Character.isLetter(cArray[compilerState.cp + 1])) {
                                c = (char)(cArray[compilerState.cp++] & 0x1F);
                            } else {
                                --compilerState.cp;
                                c = '\\';
                            }
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'u': {
                            n2 += 2;
                        }
                        case 'x': {
                            int n10 = 0;
                            for (n = 0; n < n2 && compilerState.cp < compilerState.cpend; ++n) {
                                if (!NativeRegExp.isHex(c = cArray[compilerState.cp++])) {
                                    compilerState.cp -= n + 2;
                                    n10 = cArray[compilerState.cp++];
                                    break;
                                }
                                n10 = n10 << 4 | NativeRegExp.unHex(c);
                            }
                            c = (char)n10;
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'd': {
                            compilerState.result = new RENode(14);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'D': {
                            compilerState.result = new RENode(15);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 's': {
                            compilerState.result = new RENode(18);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'S': {
                            compilerState.result = new RENode(19);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'w': {
                            compilerState.result = new RENode(16);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'W': {
                            compilerState.result = new RENode(17);
                            ++compilerState.progLength;
                            break block0;
                        }
                    }
                    compilerState.result = new RENode(21);
                    compilerState.result.chr = c;
                    compilerState.result.length = 1;
                    compilerState.result.flatIndex = compilerState.cp - 1;
                    compilerState.progLength += 3;
                    break;
                }
                NativeRegExp.reportError("msg.trail.backslash", "");
                return false;
            }
            case '(': {
                RENode rENode = null;
                int n11 = compilerState.cp;
                if (compilerState.cp + 1 < compilerState.cpend && cArray[compilerState.cp] == '?' && ((c = cArray[compilerState.cp + 1]) == '=' || c == '!' || c == ':')) {
                    compilerState.cp += 2;
                    if (c == '=') {
                        rENode = new RENode(41);
                        compilerState.progLength += 4;
                    } else if (c == '!') {
                        rENode = new RENode(42);
                        compilerState.progLength += 4;
                    }
                } else {
                    rENode = new RENode(10);
                    compilerState.progLength += 6;
                    rENode.parenIndex = compilerState.parenCount++;
                }
                ++compilerState.parenNesting;
                if (!NativeRegExp.parseDisjunction(compilerState)) {
                    return false;
                }
                if (compilerState.cp == compilerState.cpend || cArray[compilerState.cp] != ')') {
                    NativeRegExp.reportError("msg.unterm.paren", "");
                    return false;
                }
                ++compilerState.cp;
                --compilerState.parenNesting;
                if (rENode == null) break;
                rENode.kid = compilerState.result;
                compilerState.result = rENode;
                break;
            }
            case ')': {
                NativeRegExp.reportError("msg.re.unmatched.right.paren", "");
                return false;
            }
            case '[': {
                int n12;
                compilerState.result = new RENode(50);
                compilerState.result.startIndex = n12 = compilerState.cp;
                while (true) {
                    if (compilerState.cp == compilerState.cpend) {
                        NativeRegExp.reportError("msg.unterm.class", "");
                        return false;
                    }
                    if (cArray[compilerState.cp] == '\\') {
                        ++compilerState.cp;
                    } else if (cArray[compilerState.cp] == ']') break;
                    ++compilerState.cp;
                }
                compilerState.result.kidlen = compilerState.cp - n12;
                compilerState.result.index = compilerState.classCount++;
                if (!NativeRegExp.calculateBitmapSize(compilerState, compilerState.result, cArray, n12, compilerState.cp++)) {
                    return false;
                }
                compilerState.progLength += 3;
                break;
            }
            case '.': {
                compilerState.result = new RENode(12);
                ++compilerState.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': {
                NativeRegExp.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.cp - 1]));
                return false;
            }
            default: {
                compilerState.result = new RENode(21);
                compilerState.result.chr = c;
                compilerState.result.length = 1;
                compilerState.result.flatIndex = compilerState.cp - 1;
                compilerState.progLength += 3;
            }
        }
        RENode rENode = compilerState.result;
        if (compilerState.cp == compilerState.cpend) {
            return true;
        }
        boolean bl = false;
        switch (cArray[compilerState.cp]) {
            case '+': {
                compilerState.result = new RENode(6);
                compilerState.result.min = 1;
                compilerState.result.max = -1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '*': {
                compilerState.result = new RENode(6);
                compilerState.result.min = 0;
                compilerState.result.max = -1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '?': {
                compilerState.result = new RENode(6);
                compilerState.result.min = 0;
                compilerState.result.max = 1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '{': {
                n = 0;
                int n13 = -1;
                int n14 = compilerState.cp++;
                c = cArray[compilerState.cp];
                if (NativeRegExp.isDigit(c)) {
                    ++compilerState.cp;
                    n = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.min");
                    c = cArray[compilerState.cp];
                    if (c == ',') {
                        if (NativeRegExp.isDigit(c = cArray[++compilerState.cp])) {
                            ++compilerState.cp;
                            n13 = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.max");
                            c = cArray[compilerState.cp];
                            if (n > n13) {
                                NativeRegExp.reportError("msg.max.lt.min", String.valueOf(cArray[compilerState.cp]));
                                return false;
                            }
                        }
                    } else {
                        n13 = n;
                    }
                    if (c == '}') {
                        compilerState.result = new RENode(6);
                        compilerState.result.min = n;
                        compilerState.result.max = n13;
                        compilerState.progLength += 12;
                        bl = true;
                    }
                }
                if (bl) break;
                compilerState.cp = n14;
                break;
            }
        }
        if (!bl) {
            return true;
        }
        ++compilerState.cp;
        compilerState.result.kid = rENode;
        compilerState.result.parenIndex = n3;
        compilerState.result.parenCount = compilerState.parenCount - n3;
        if (compilerState.cp < compilerState.cpend && cArray[compilerState.cp] == '?') {
            ++compilerState.cp;
            compilerState.result.greedy = false;
        } else {
            compilerState.result.greedy = true;
        }
        return true;
    }

    private static void CHECK_OFFSET(int n) {
        if ((short)n != n) {
            throw new RuntimeException();
        }
    }

    private static void SET_OFFSET(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8);
        byArray[n + 1] = (byte)n2;
    }

    private static int GET_OFFSET(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int GET_ARG(byte[] byArray, int n) {
        return NativeRegExp.GET_OFFSET(byArray, n);
    }

    private static void SET_ARG(byte[] byArray, int n, int n2) {
        NativeRegExp.SET_OFFSET(byArray, n, n2);
    }

    private static int emitREBytecode(CompilerState compilerState, RECompiled rECompiled, int n, RENode rENode) {
        byte[] byArray = rECompiled.program;
        while (rENode != null) {
            byArray[n++] = rENode.op;
            switch (rENode.op) {
                case 0: {
                    --n;
                    break;
                }
                case 1: {
                    RENode rENode2 = rENode.kid2;
                    int n2 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 23;
                    int n3 = n;
                    int n4 = (n += 2) - n2;
                    NativeRegExp.CHECK_OFFSET(n4);
                    NativeRegExp.SET_OFFSET(byArray, n2, n4);
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode2);
                    byArray[n++] = 23;
                    n2 = n;
                    n4 = (n += 2) - n3;
                    NativeRegExp.CHECK_OFFSET(n4);
                    NativeRegExp.SET_OFFSET(byArray, n3, n4);
                    n4 = n - n2;
                    NativeRegExp.CHECK_OFFSET(n4);
                    NativeRegExp.SET_OFFSET(byArray, n2, n4);
                    break;
                }
                case 21: {
                    if (rENode.flatIndex != -1) {
                        while (rENode.next != null && rENode.next.op == 21 && rENode.flatIndex + rENode.length == rENode.next.flatIndex) {
                            rENode.length += rENode.next.length;
                            rENode.next = rENode.next.next;
                        }
                    }
                    if (rENode.flatIndex != -1 && rENode.length > 1) {
                        byArray[n - 1] = (compilerState.flags & 2) != 0 ? 32 : 21;
                        NativeRegExp.SET_ARG(byArray, n, rENode.flatIndex);
                        NativeRegExp.SET_ARG(byArray, n += 2, rENode.length);
                        n += 2;
                        break;
                    }
                    if (rENode.chr < '\u0100') {
                        byArray[n - 1] = (compilerState.flags & 2) != 0 ? 33 : 22;
                        byArray[n++] = (byte)rENode.chr;
                        break;
                    }
                    byArray[n - 1] = (compilerState.flags & 2) != 0 ? 35 : 28;
                    NativeRegExp.SET_ARG(byArray, n, rENode.chr);
                    n += 2;
                    break;
                }
                case 10: {
                    NativeRegExp.SET_ARG(byArray, n, rENode.parenIndex);
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 11;
                    NativeRegExp.SET_ARG(byArray, n, rENode.parenIndex);
                    n += 2;
                    break;
                }
                case 20: {
                    NativeRegExp.SET_ARG(byArray, n, rENode.parenIndex);
                    n += 2;
                    break;
                }
                case 41: {
                    int n3 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 43;
                    int n4 = n - n3;
                    NativeRegExp.CHECK_OFFSET(n4);
                    NativeRegExp.SET_OFFSET(byArray, n3, n4);
                    break;
                }
                case 42: {
                    int n3 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 44;
                    int n4 = n - n3;
                    NativeRegExp.CHECK_OFFSET(n4);
                    NativeRegExp.SET_OFFSET(byArray, n3, n4);
                    break;
                }
                case 6: {
                    if (rENode.min == 0 && rENode.max == -1) {
                        byArray[n - 1] = rENode.greedy ? 7 : 45;
                    } else if (rENode.min == 0 && rENode.max == 1) {
                        byArray[n - 1] = rENode.greedy ? 9 : 47;
                    } else if (rENode.min == 1 && rENode.max == -1) {
                        byArray[n - 1] = rENode.greedy ? 8 : 46;
                    } else {
                        if (!rENode.greedy) {
                            byArray[n - 1] = 48;
                        }
                        NativeRegExp.SET_ARG(byArray, n, rENode.min);
                        NativeRegExp.SET_ARG(byArray, n += 2, rENode.max);
                        n += 2;
                    }
                    NativeRegExp.SET_ARG(byArray, n, rENode.parenCount);
                    NativeRegExp.SET_ARG(byArray, n += 2, rENode.parenIndex);
                    int n3 = n += 2;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 49;
                    int n4 = n - n3;
                    NativeRegExp.CHECK_OFFSET(n4);
                    NativeRegExp.SET_OFFSET(byArray, n3, n4);
                    break;
                }
                case 50: {
                    NativeRegExp.SET_ARG(byArray, n, rENode.index);
                    n += 2;
                    RECharSet rECharSet = rECompiled.classList[rENode.index];
                    rECharSet.converted = false;
                    rECharSet.length = rENode.bmsize;
                    rECharSet.startIndex = rENode.startIndex;
                    rECharSet.strlength = rENode.kidlen;
                    break;
                }
            }
            rENode = rENode.next;
        }
        return n;
    }

    private static REBackTrackData pushBackTrackState(REGlobalData rEGlobalData, byte by, int n, REMatchState rEMatchState) {
        if (rEGlobalData.backTrackStackTop == rEGlobalData.maxBackTrack) {
            int n2;
            rEGlobalData.maxBackTrack <<= 1;
            REBackTrackData[] rEBackTrackDataArray = new REBackTrackData[rEGlobalData.maxBackTrack];
            for (n2 = 0; n2 < rEGlobalData.backTrackStackTop; ++n2) {
                rEBackTrackDataArray[n2] = rEGlobalData.backTrackStack[n2];
            }
            for (n2 = rEGlobalData.backTrackStackTop; n2 < rEGlobalData.maxBackTrack; ++n2) {
                rEBackTrackDataArray[n2] = new REBackTrackData(rEMatchState);
            }
            rEGlobalData.backTrackStack = rEBackTrackDataArray;
        }
        REBackTrackData rEBackTrackData = new REBackTrackData(rEMatchState);
        rEGlobalData.backTrackStack[rEGlobalData.backTrackStackTop++] = rEBackTrackData;
        rEBackTrackData.continuation_op = by;
        rEBackTrackData.continuation_pc = n;
        rEBackTrackData.lastParen = rEGlobalData.lastParen;
        rEBackTrackData.currentState = new REProgState(rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1]);
        if (rEGlobalData.stateStackTop > 1) {
            rEBackTrackData.precedingStateTop = rEGlobalData.stateStackTop - 1;
            rEBackTrackData.precedingState = new REProgState[rEBackTrackData.precedingStateTop];
            for (int i = 0; i < rEBackTrackData.precedingStateTop; ++i) {
                rEBackTrackData.precedingState[i] = new REProgState(rEGlobalData.stateStack[i]);
            }
        } else {
            rEBackTrackData.precedingStateTop = 0;
            rEBackTrackData.precedingState = null;
        }
        return rEBackTrackData;
    }

    private static REMatchState flatNMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n, int n2, char[] cArray, int n3) {
        if (rEMatchState.cp + n2 > n3) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            if (rEGlobalData.regexp.source[n + i] == cArray[rEMatchState.cp + i]) continue;
            return null;
        }
        rEMatchState.cp += n2;
        return rEMatchState;
    }

    private static REMatchState flatNIMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n, int n2, char[] cArray, int n3) {
        if (rEMatchState.cp + n2 > n3) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            if (NativeRegExp.upcase(rEGlobalData.regexp.source[n + i]) == NativeRegExp.upcase(cArray[rEMatchState.cp + i])) continue;
            return null;
        }
        rEMatchState.cp += n2;
        return rEMatchState;
    }

    private static REMatchState backrefMatcher(REGlobalData rEGlobalData, REMatchState rEMatchState, int n, char[] cArray, int n2) {
        int n3 = rEMatchState.parens_index(n);
        if (n3 == -1) {
            return rEMatchState;
        }
        int n4 = rEMatchState.parens_length(n);
        if (rEMatchState.cp + n4 > n2) {
            return null;
        }
        if ((rEGlobalData.regexp.flags & 2) != 0) {
            for (int i = 0; i < n4; ++i) {
                if (NativeRegExp.upcase(cArray[n3 + i]) == NativeRegExp.upcase(cArray[rEMatchState.cp + i])) continue;
                return null;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                if (cArray[n3 + i] == cArray[rEMatchState.cp + i]) continue;
                return null;
            }
        }
        rEMatchState.cp += n4;
        return rEMatchState;
    }

    private static void addCharacterToCharSet(RECharSet rECharSet, char c) {
        int n = c / 8;
        if (c > rECharSet.length) {
            throw new RuntimeException();
        }
        int n2 = n;
        rECharSet.bits[n2] = (byte)(rECharSet.bits[n2] | 1 << (c & 7));
    }

    private static void addCharacterRangeToCharSet(RECharSet rECharSet, char c, char c2) {
        int n = c / 8;
        int n2 = c2 / 8;
        if (c2 > rECharSet.length || c > c2) {
            throw new RuntimeException();
        }
        c = (char)(c & 7);
        c2 = (char)(c2 & 7);
        if (n == n2) {
            int n3 = n;
            rECharSet.bits[n3] = (byte)(rECharSet.bits[n3] | 255 >> 7 - (c2 - c) << c);
        } else {
            int n4 = n;
            rECharSet.bits[n4] = (byte)(rECharSet.bits[n4] | 255 << c);
            for (int i = n + 1; i < n2; ++i) {
                rECharSet.bits[i] = -1;
            }
            int n5 = n2;
            rECharSet.bits[n5] = (byte)(rECharSet.bits[n5] | 255 >> 7 - c2);
        }
    }

    private static void processCharSet(REGlobalData rEGlobalData, RECharSet rECharSet) {
        int n = rECharSet.startIndex;
        int n2 = n + rECharSet.strlength;
        char c = '\u0000';
        boolean bl = false;
        rECharSet.sense = true;
        int n3 = rECharSet.length / 8 + 1;
        rECharSet.bits = new byte[n3];
        if (n == n2) {
            return;
        }
        if (rEGlobalData.regexp.source[n] == '^') {
            rECharSet.sense = false;
            ++n;
        }
        block21: while (n != n2) {
            char c2;
            int n4 = 2;
            block0 : switch (rEGlobalData.regexp.source[n]) {
                case '\\': {
                    int n5 = ++n;
                    ++n;
                    char c3 = rEGlobalData.regexp.source[n5];
                    switch (c3) {
                        case 'b': {
                            c2 = '\b';
                            break block0;
                        }
                        case 'f': {
                            c2 = '\f';
                            break block0;
                        }
                        case 'n': {
                            c2 = '\n';
                            break block0;
                        }
                        case 'r': {
                            c2 = '\r';
                            break block0;
                        }
                        case 't': {
                            c2 = '\t';
                            break block0;
                        }
                        case 'v': {
                            c2 = '\u000b';
                            break block0;
                        }
                        case 'c': {
                            if (n + 1 < n2 && NativeRegExp.isWord(rEGlobalData.regexp.source[n + 1])) {
                                c2 = (char)(rEGlobalData.regexp.source[n++] & 0x1F);
                                break block0;
                            }
                            --n;
                            c2 = '\\';
                            break block0;
                        }
                        case 'u': {
                            n4 += 2;
                        }
                        case 'x': {
                            int n6;
                            int n7 = 0;
                            for (n6 = 0; n6 < n4 && n < n2; ++n6) {
                                int n8;
                                if ((n8 = NativeRegExp.toASCIIHexDigit(c3 = rEGlobalData.regexp.source[n++])) < 0) {
                                    n -= n6 + 1;
                                    n7 = 92;
                                    break;
                                }
                                n7 = n7 << 4 | n8;
                            }
                            c2 = (char)n7;
                            break block0;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int n6;
                            int n7 = c3 - 48;
                            c3 = rEGlobalData.regexp.source[n];
                            if ('0' <= c3 && c3 <= '7') {
                                n7 = 8 * n7 + (c3 - 48);
                                if ('0' <= (c3 = rEGlobalData.regexp.source[++n]) && c3 <= '7') {
                                    ++n;
                                    n6 = 8 * n7 + (c3 - 48);
                                    if (n6 <= 255) {
                                        n7 = n6;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            c2 = (char)n7;
                            break block0;
                        }
                        case 'd': {
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, '0', '9');
                            continue block21;
                        }
                        case 'D': {
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, '\u0000', '/');
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, ':', (char)rECharSet.length);
                            continue block21;
                        }
                        case 's': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (!NativeRegExp.isREWhiteSpace(n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'S': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (NativeRegExp.isREWhiteSpace(n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'w': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (!NativeRegExp.isWord((char)n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'W': {
                            int n6;
                            for (n6 = rECharSet.length; n6 >= 0; --n6) {
                                if (NativeRegExp.isWord((char)n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                    }
                    c2 = c3;
                    break;
                }
                default: {
                    c2 = rEGlobalData.regexp.source[n++];
                }
            }
            if (bl) {
                if ((rEGlobalData.regexp.flags & 2) != 0) {
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, NativeRegExp.upcase(c), NativeRegExp.upcase(c2));
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, NativeRegExp.downcase(c), NativeRegExp.downcase(c2));
                } else {
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, c, c2);
                }
                bl = false;
                continue;
            }
            if ((rEGlobalData.regexp.flags & 2) != 0) {
                NativeRegExp.addCharacterToCharSet(rECharSet, NativeRegExp.upcase(c2));
                NativeRegExp.addCharacterToCharSet(rECharSet, NativeRegExp.downcase(c2));
            } else {
                NativeRegExp.addCharacterToCharSet(rECharSet, c2);
            }
            if (n >= n2 - 1 || rEGlobalData.regexp.source[n] != '-') continue;
            ++n;
            bl = true;
            c = c2;
        }
    }

    private static boolean classMatcher(REGlobalData rEGlobalData, RECharSet rECharSet, char c) {
        if (!rECharSet.converted) {
            NativeRegExp.processCharSet(rEGlobalData, rECharSet);
            rECharSet.converted = true;
        }
        int n = c / 8;
        return !(rECharSet.sense ? rECharSet.length == 0 || c > rECharSet.length || (rECharSet.bits[n] & 1 << (c & 7)) == 0 : rECharSet.length != 0 && c <= rECharSet.length && (rECharSet.bits[n] & 1 << (c & 7)) != 0);
    }

    private static REMatchState executeREBytecode(REGlobalData rEGlobalData, REMatchState rEMatchState, char[] cArray, int n) {
        int n2 = 0;
        byte[] byArray = rEGlobalData.regexp.program;
        int n3 = byArray[n2++];
        REMatchState rEMatchState2 = null;
        int n4 = 0;
        int n5 = 53;
        block42: while (true) {
            int n6;
            switch (n3) {
                case 0: {
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 2: {
                    if (rEMatchState.cp != 0) {
                        if (rEGlobalData.multiline || (rEGlobalData.regexp.flags & 4) != 0) {
                            if (!NativeRegExp.isLineTerm(cArray[rEMatchState.cp - 1])) {
                                rEMatchState2 = null;
                                break;
                            }
                        } else {
                            rEMatchState2 = null;
                            break;
                        }
                    }
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 3: {
                    if (rEMatchState.cp != n) {
                        if (rEGlobalData.multiline || (rEGlobalData.regexp.flags & 4) != 0) {
                            if (!NativeRegExp.isLineTerm(cArray[rEMatchState.cp])) {
                                rEMatchState2 = null;
                                break;
                            }
                        } else {
                            rEMatchState2 = null;
                            break;
                        }
                    }
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 4: {
                    if ((rEMatchState.cp == 0 || !NativeRegExp.isWord(cArray[rEMatchState.cp - 1])) ^ (rEMatchState.cp >= n || !NativeRegExp.isWord(cArray[rEMatchState.cp]))) {
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 5: {
                    if ((rEMatchState.cp == 0 || !NativeRegExp.isWord(cArray[rEMatchState.cp - 1])) ^ (rEMatchState.cp < n && NativeRegExp.isWord(cArray[rEMatchState.cp]))) {
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 12: {
                    if (rEMatchState.cp != n && !NativeRegExp.isLineTerm(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 14: {
                    if (rEMatchState.cp != n && NativeRegExp.isDigit(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 15: {
                    if (rEMatchState.cp != n && !NativeRegExp.isDigit(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 18: {
                    if (rEMatchState.cp != n && NativeRegExp.isREWhiteSpace(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 19: {
                    if (rEMatchState.cp != n && !NativeRegExp.isREWhiteSpace(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 16: {
                    if (rEMatchState.cp != n && NativeRegExp.isWord(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 17: {
                    if (rEMatchState.cp != n && !NativeRegExp.isWord(cArray[rEMatchState.cp])) {
                        rEMatchState2 = rEMatchState;
                        ++rEMatchState2.cp;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 21: {
                    int n7 = NativeRegExp.GET_ARG(byArray, n2);
                    int n8 = NativeRegExp.GET_ARG(byArray, n2 += 2);
                    n2 += 2;
                    rEMatchState2 = NativeRegExp.flatNMatcher(rEGlobalData, rEMatchState, n7, n8, cArray, n);
                    break;
                }
                case 32: {
                    int n7 = NativeRegExp.GET_ARG(byArray, n2);
                    int n8 = NativeRegExp.GET_ARG(byArray, n2 += 2);
                    n2 += 2;
                    rEMatchState2 = NativeRegExp.flatNIMatcher(rEGlobalData, rEMatchState, n7, n8, cArray, n);
                    break;
                }
                case 22: {
                    char c = (char)(byArray[n2++] & 0xFF);
                    if (rEMatchState.cp != n && cArray[rEMatchState.cp] == c) {
                        ++rEMatchState.cp;
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 33: {
                    char c = (char)(byArray[n2++] & 0xFF);
                    if (rEMatchState.cp != n && NativeRegExp.upcase(cArray[rEMatchState.cp]) == NativeRegExp.upcase(c)) {
                        ++rEMatchState.cp;
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 28: {
                    char c = (char)NativeRegExp.GET_ARG(byArray, n2);
                    n2 += 2;
                    if (rEMatchState.cp != n && cArray[rEMatchState.cp] == c) {
                        ++rEMatchState.cp;
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 35: {
                    char c = (char)NativeRegExp.GET_ARG(byArray, n2);
                    n2 += 2;
                    if (rEMatchState.cp != n && NativeRegExp.upcase(cArray[rEMatchState.cp]) == NativeRegExp.upcase(c)) {
                        ++rEMatchState.cp;
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 1: {
                    int n9 = n2 + NativeRegExp.GET_OFFSET(byArray, n2);
                    byte by = byArray[n9++];
                    rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_pc = n4;
                    rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    NativeRegExp.pushBackTrackState(rEGlobalData, by, n9, rEMatchState);
                    n2 += 2;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 23: {
                    --rEGlobalData.stateStackTop;
                    n4 = rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_pc;
                    n5 = rEGlobalData.stateStack[rEGlobalData.stateStackTop].continuation_op;
                    int n7 = NativeRegExp.GET_OFFSET(byArray, n2);
                    n2 += n7;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 10: {
                    int n10 = NativeRegExp.GET_ARG(byArray, n2);
                    n2 += 2;
                    rEMatchState.set_parens(n10, rEMatchState.cp, 0);
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 11: {
                    int n10 = NativeRegExp.GET_ARG(byArray, n2);
                    n2 += 2;
                    int n11 = rEMatchState.parens_index(n10);
                    rEMatchState.set_parens(n10, n11, rEMatchState.cp - n11);
                    if (n10 > rEGlobalData.lastParen) {
                        rEGlobalData.lastParen = n10;
                    }
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 20: {
                    int n10 = NativeRegExp.GET_ARG(byArray, n2);
                    n2 += 2;
                    rEMatchState2 = NativeRegExp.backrefMatcher(rEGlobalData, rEMatchState, n10, cArray, n);
                    break;
                }
                case 41: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    rEProgState.max = rEGlobalData.backTrackStackTop;
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)43, n2 + NativeRegExp.GET_OFFSET(byArray, n2), rEMatchState);
                    n2 += 2;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 42: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    rEProgState.max = rEGlobalData.backTrackStackTop;
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)44, n2 + NativeRegExp.GET_OFFSET(byArray, n2), rEMatchState);
                    n2 += 2;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 43: {
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEMatchState.cp = rEProgState.index;
                    rEGlobalData.backTrackStackTop = rEProgState.max;
                    n4 = rEProgState.continuation_pc;
                    n5 = rEProgState.continuation_op;
                    if (rEMatchState2 == null) break;
                    rEMatchState2 = rEMatchState;
                    break;
                }
                case 44: {
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEMatchState.cp = rEProgState.index;
                    rEGlobalData.backTrackStackTop = rEProgState.max;
                    n4 = rEProgState.continuation_pc;
                    n5 = rEProgState.continuation_op;
                    if (rEMatchState2 == null) {
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 50: {
                    int n12 = NativeRegExp.GET_ARG(byArray, n2);
                    n2 += 2;
                    if (rEMatchState.cp != n && NativeRegExp.classMatcher(rEGlobalData, rEGlobalData.regexp.classList[n12], cArray[rEMatchState.cp])) {
                        ++rEMatchState.cp;
                        rEMatchState2 = rEMatchState;
                        break;
                    }
                    rEMatchState2 = null;
                    break;
                }
                case 53: {
                    if (rEMatchState == null) break;
                    return rEMatchState;
                }
                case 7: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 8: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 1;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 9: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = 1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 6: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = NativeRegExp.GET_ARG(byArray, n2);
                    rEProgState.max = NativeRegExp.GET_ARG(byArray, n2 += 2);
                    n2 += 2;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    n2 += 6;
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 49: {
                    n2 = n4;
                    n3 = n5;
                    continue block42;
                }
                case 51: {
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    if (rEMatchState2 == null) {
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        if (rEProgState.min == 0) {
                            rEMatchState2 = rEMatchState;
                        }
                        n2 += 4;
                        n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                        break;
                    }
                    if (rEProgState.min == 0 && rEMatchState.cp == rEProgState.index) {
                        rEMatchState2 = null;
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                        break;
                    }
                    if (rEProgState.min != 0) {
                        --rEProgState.min;
                    }
                    if (rEProgState.max != -1) {
                        --rEProgState.max;
                    }
                    if (rEProgState.max == 0) {
                        rEMatchState2 = rEMatchState;
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                        break;
                    }
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    n5 = 51;
                    n4 = n2;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2, rEMatchState);
                    int n13 = NativeRegExp.GET_ARG(byArray, n2);
                    int n10 = NativeRegExp.GET_ARG(byArray, n2 += 2);
                    n2 += 4;
                    n3 = byArray[n2++];
                    n6 = 0;
                    while (true) {
                        if (n6 >= n13) continue block42;
                        rEMatchState.set_parens(n10 + n6, -1, 0);
                        ++n6;
                    }
                }
                case 45: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 46: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 1;
                    rEProgState.max = -1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 47: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = 0;
                    rEProgState.max = 1;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 48: {
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    rEProgState.min = NativeRegExp.GET_ARG(byArray, n2);
                    rEProgState.max = NativeRegExp.GET_ARG(byArray, n2 += 2);
                    n2 += 2;
                    rEProgState.index = rEMatchState.cp;
                    rEProgState.continuation_pc = n4;
                    rEProgState.continuation_op = n5;
                    ++rEGlobalData.stateStackTop;
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n2 += 6;
                        n3 = byArray[n2++];
                        continue block42;
                    }
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                    n3 = byArray[n2++];
                    continue block42;
                }
                case 52: {
                    int n13;
                    int n10;
                    --rEGlobalData.stateStackTop;
                    REProgState rEProgState = rEGlobalData.stateStack[rEGlobalData.stateStackTop];
                    if (rEMatchState2 == null) {
                        if (rEProgState.max == -1 || rEProgState.max > 0) {
                            rEProgState.index = rEMatchState.cp;
                            n5 = 52;
                            n4 = n2;
                            n13 = NativeRegExp.GET_ARG(byArray, n2);
                            n10 = NativeRegExp.GET_ARG(byArray, n2 += 2);
                            n2 += 4;
                            for (n6 = 0; n6 < n13; ++n6) {
                                rEMatchState.set_parens(n10 + n6, -1, 0);
                            }
                            ++rEGlobalData.stateStackTop;
                            n3 = byArray[n2++];
                            continue block42;
                        }
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        break;
                    }
                    if (rEProgState.min == 0 && rEMatchState.cp == rEProgState.index) {
                        rEMatchState2 = null;
                        n4 = rEProgState.continuation_pc;
                        n5 = rEProgState.continuation_op;
                        break;
                    }
                    if (rEProgState.min != 0) {
                        --rEProgState.min;
                    }
                    if (rEProgState.max != -1) {
                        --rEProgState.max;
                    }
                    if (rEProgState.min != 0) {
                        n5 = 52;
                        n4 = n2;
                        n13 = NativeRegExp.GET_ARG(byArray, n2);
                        n10 = NativeRegExp.GET_ARG(byArray, n2 += 2);
                        n2 += 4;
                        for (n6 = 0; n6 < n13; ++n6) {
                            rEMatchState.set_parens(n10 + n6, -1, 0);
                        }
                        rEProgState.index = rEMatchState.cp;
                        ++rEGlobalData.stateStackTop;
                        n3 = byArray[n2++];
                        continue block42;
                    }
                    n4 = rEProgState.continuation_pc;
                    n5 = rEProgState.continuation_op;
                    rEProgState.index = rEMatchState.cp;
                    ++rEGlobalData.stateStackTop;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2, rEMatchState);
                    --rEGlobalData.stateStackTop;
                    n2 += 4;
                    n2 += NativeRegExp.GET_OFFSET(byArray, n2);
                    n3 = byArray[n2++];
                    continue block42;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (rEMatchState2 == null) {
                if (rEGlobalData.backTrackStackTop > 0) {
                    --rEGlobalData.backTrackStackTop;
                    REBackTrackData rEBackTrackData = rEGlobalData.backTrackStack[rEGlobalData.backTrackStackTop];
                    rEGlobalData.lastParen = rEBackTrackData.lastParen;
                    rEMatchState = new REMatchState(rEBackTrackData.state);
                    for (n6 = 0; n6 < rEBackTrackData.precedingStateTop; ++n6) {
                        rEGlobalData.stateStack[n6] = rEBackTrackData.precedingState[n6];
                    }
                    rEGlobalData.stateStackTop = rEBackTrackData.precedingStateTop + 1;
                    rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1] = rEBackTrackData.currentState;
                    n5 = rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1].continuation_op;
                    n4 = rEGlobalData.stateStack[rEGlobalData.stateStackTop - 1].continuation_pc;
                    n2 = rEBackTrackData.continuation_pc;
                    n3 = rEBackTrackData.continuation_op;
                    continue;
                }
                return null;
            }
            rEMatchState = rEMatchState2;
            if ((n3 = byArray[n2++]) != 49) continue;
            n2 = n4;
            n3 = n5;
        }
    }

    private static REMatchState matchRegExp(REGlobalData rEGlobalData, RECompiled rECompiled, char[] cArray, int n, int n2, boolean bl) {
        char c;
        REMatchState rEMatchState = new REMatchState(rECompiled.parenCount);
        rEGlobalData.maxBackTrack = 20;
        rEGlobalData.backTrackStack = new REBackTrackData[20];
        for (c = '\u0000'; c < '\u0014'; ++c) {
            rEGlobalData.backTrackStack[c] = new REBackTrackData(rEMatchState);
        }
        rEGlobalData.backTrackStackTop = 0;
        rEGlobalData.maxStateStack = 20;
        rEGlobalData.stateStack = new REProgState[20];
        for (c = '\u0000'; c < '\u0014'; ++c) {
            rEGlobalData.stateStack[c] = new REProgState();
        }
        rEGlobalData.stateStackTop = 0;
        rEGlobalData.multiline = bl;
        rEGlobalData.regexp = rECompiled;
        rEGlobalData.lastParen = 0;
        c = rEGlobalData.regexp.anchorCh;
        for (int i = n; i <= n2; ++i) {
            char c2;
            if (c >= '\u0000') {
                while (true) {
                    if (i == n2) {
                        return null;
                    }
                    c2 = cArray[i];
                    if (c2 == c || (rEGlobalData.regexp.flags & 2) != 0 && NativeRegExp.upcase(c2) == NativeRegExp.upcase(c)) break;
                    ++i;
                }
            }
            rEMatchState.cp = i;
            for (c2 = '\u0000'; c2 < rEMatchState.parenCount; ++c2) {
                rEMatchState.set_parens(c2, -1, 0);
            }
            REMatchState rEMatchState2 = NativeRegExp.executeREBytecode(rEGlobalData, rEMatchState, cArray, n2);
            rEGlobalData.backTrackStackTop = 0;
            rEGlobalData.stateStackTop = 0;
            if (rEMatchState2 == null) continue;
            rEGlobalData.skipped = i - n;
            return rEMatchState2;
        }
        return null;
    }

    Object executeRegExp(Context context, Scriptable scriptable, RegExpImpl regExpImpl, String string, int[] nArray, int n) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n2;
        int n3;
        REMatchState rEMatchState;
        REGlobalData rEGlobalData = new REGlobalData();
        int n4 = nArray[0];
        char[] cArray = string.toCharArray();
        int n5 = cArray.length;
        if (n4 > n5) {
            n4 = n5;
        }
        if ((rEMatchState = NativeRegExp.matchRegExp(rEGlobalData, this.re, cArray, n4, n5, regExpImpl.multiline)) == null) {
            if (n != 2) {
                return null;
            }
            return Undefined.instance;
        }
        nArray[0] = n3 = (n2 = rEMatchState.cp);
        int n6 = n3 - (n4 + rEGlobalData.skipped);
        int n7 = n2;
        n2 -= n6;
        if (n == 0) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = NativeRegExp.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n2, n6);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (rEMatchState.parenCount > this.re.parenCount) {
            throw new RuntimeException();
        }
        if (rEMatchState.parenCount == 0) {
            regExpImpl.parens = null;
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens = new SubString[this.re.parenCount];
            for (int i = 0; i < this.re.parenCount; ++i) {
                int n8 = rEMatchState.parens_index(i);
                if (n8 != -1) {
                    int n9 = rEMatchState.parens_length(i);
                    regExpImpl.parens[i] = object = new SubString(cArray, n8, n9);
                    if (n == 0) continue;
                    String string3 = ((SubString)object).toString();
                    scriptable2.put(i + 1, scriptable2, (Object)string3);
                    continue;
                }
                if (n == 0) continue;
                scriptable2.put(i + 1, scriptable2, (Object)Undefined.instance);
            }
            regExpImpl.lastParen = object;
        }
        if (n != 0) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n4 + rEGlobalData.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.charArray = cArray;
        regExpImpl.lastMatch.index = n2;
        regExpImpl.lastMatch.length = n6;
        regExpImpl.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n4;
            regExpImpl.leftContext.length = rEGlobalData.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n4 + rEGlobalData.skipped;
        }
        regExpImpl.rightContext.charArray = cArray;
        regExpImpl.rightContext.index = n7;
        regExpImpl.rightContext.length = n5 - n7;
        return object2;
    }

    int getFlags() {
        return this.re.flags;
    }

    private static void reportError(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        throw ScriptRuntime.constructError("SyntaxError", string3);
    }

    @Override
    protected int getIdAttributes(int n) {
        switch (n) {
            case 1: {
                return 6;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 7;
            }
        }
        return super.getIdAttributes(n);
    }

    @Override
    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.wrap_double(this.lastIndex);
            }
            case 2: {
                return new String(this.re.source);
            }
            case 3: {
                return this.wrap_boolean((this.re.flags & 1) != 0);
            }
            case 4: {
                return this.wrap_boolean((this.re.flags & 2) != 0);
            }
            case 5: {
                return this.wrap_boolean((this.re.flags & 4) != 0);
            }
        }
        return super.getIdValue(n);
    }

    @Override
    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.setLastIndex(ScriptRuntime.toNumber(object));
            return;
        }
        super.setIdValue(n, object);
    }

    void setLastIndex(double d) {
        this.lastIndex = d;
    }

    @Override
    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 0;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    @Override
    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return NativeRegExp.realThis(scriptable2, idFunction).compile(context, scriptable, objectArray);
                }
                case 7: 
                case 8: {
                    return NativeRegExp.realThis(scriptable2, idFunction).toString();
                }
                case 9: {
                    return NativeRegExp.realThis(scriptable2, idFunction).execSub(context, scriptable, objectArray, 1);
                }
                case 10: {
                    Object object = NativeRegExp.realThis(scriptable2, idFunction).execSub(context, scriptable, objectArray, 0);
                    return Boolean.TRUE.equals(object) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 11: {
                    return NativeRegExp.realThis(scriptable2, idFunction).execSub(context, scriptable, objectArray, 2);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static NativeRegExp realThis(Scriptable scriptable, IdFunction idFunction) {
        if (!(scriptable instanceof NativeRegExp)) {
            throw NativeRegExp.incompatibleCallError(idFunction);
        }
        return (NativeRegExp)scriptable;
    }

    @Override
    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return "compile";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "toSource";
                }
                case 9: {
                    return "exec";
                }
                case 10: {
                    return "test";
                }
                case 11: {
                    return "prefix";
                }
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String string) {
        char c;
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            c = string.charAt(0);
            if (c == 'g') {
                string2 = "global";
                n = 3;
            } else if (c == 's') {
                string2 = "source";
                n = 2;
            }
        } else if (n2 == 9) {
            c = string.charAt(0);
            if (c == 'l') {
                string2 = "lastIndex";
                n = 1;
            } else if (c == 'm') {
                string2 = "multiline";
                n = 5;
            }
        } else if (n2 == 10) {
            string2 = "ignoreCase";
            n = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n != 0 || !this.prototypeFlag) {
            return n;
        }
        n = 0;
        string2 = null;
        switch (string.length()) {
            case 4: {
                c = string.charAt(0);
                if (c == 'e') {
                    string2 = "exec";
                    n = 9;
                    break;
                }
                if (c != 't') break;
                string2 = "test";
                n = 10;
                break;
            }
            case 6: {
                string2 = "prefix";
                n = 11;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 6;
                break;
            }
            case 8: {
                c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 8;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 7;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

