/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    String input;
    boolean multiline;
    SubString[] parens;
    SubString lastMatch;
    SubString lastParen;
    SubString leftContext;
    SubString rightContext;

    @Override
    public boolean isRegExp(Scriptable scriptable) {
        return scriptable instanceof NativeRegExp;
    }

    @Override
    public Object compileRegExp(Context context, String string, String string2) {
        return NativeRegExp.compileRE(string, string2, false);
    }

    @Override
    public Scriptable wrapRegExp(Context context, Scriptable scriptable, Object object) {
        return new NativeRegExp(scriptable, object);
    }

    @Override
    public Object match(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        GlobData globData = new GlobData();
        globData.optarg = 1;
        globData.mode = 1;
        Object object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, false);
        return globData.arrayobj == null ? object : globData.arrayobj;
    }

    @Override
    public Object search(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        GlobData globData = new GlobData();
        globData.optarg = 1;
        globData.mode = (byte)3;
        return RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, false);
    }

    @Override
    public Object replace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable3 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
        String string = null;
        Function function = null;
        if (scriptable3 instanceof Function) {
            function = (Function)scriptable3;
        } else {
            string = ScriptRuntime.toString(scriptable3);
        }
        GlobData globData = new GlobData();
        globData.optarg = 2;
        globData.mode = (byte)2;
        globData.lambda = function;
        globData.repstr = string;
        globData.dollar = string == null ? -1 : string.indexOf(36);
        globData.charBuf = null;
        globData.leftIndex = 0;
        Object object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, true);
        SubString subString = this.rightContext;
        if (globData.charBuf == null) {
            if (globData.global || object == null || !object.equals(Boolean.TRUE)) {
                return globData.str;
            }
            SubString subString2 = this.leftContext;
            RegExpImpl.replace_glob(globData, context, scriptable, this, subString2.index, subString2.length);
        }
        globData.charBuf.append(subString.charArray, subString.index, subString.length);
        return globData.charBuf.toString();
    }

    private static Object matchOrReplace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, RegExpImpl regExpImpl, GlobData globData, boolean bl) throws JavaScriptException {
        Object object;
        NativeRegExp nativeRegExp;
        Object object2;
        String string;
        globData.str = string = ScriptRuntime.toString(scriptable2);
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable);
        if (objectArray.length == 0) {
            object2 = NativeRegExp.compileRE("", "", false);
            nativeRegExp = new NativeRegExp(scriptable3, object2);
        } else if (objectArray[0] instanceof NativeRegExp) {
            nativeRegExp = (NativeRegExp)objectArray[0];
        } else {
            object2 = ScriptRuntime.toString(objectArray[0]);
            if (globData.optarg < objectArray.length) {
                objectArray[0] = object2;
                object = ScriptRuntime.toString(objectArray[globData.optarg]);
            } else {
                object = null;
            }
            Object object3 = NativeRegExp.compileRE((String)object2, object, bl);
            nativeRegExp = new NativeRegExp(scriptable3, object3);
        }
        globData.regexp = nativeRegExp;
        globData.global = (nativeRegExp.getFlags() & 1) != 0;
        object2 = new int[]{0};
        object = null;
        if (globData.mode == 3) {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, 0);
            object = object != null && object.equals(Boolean.TRUE) ? new Integer(regExpImpl.leftContext.length) : new Integer(-1);
        } else if (globData.global) {
            nativeRegExp.setLastIndex(0.0);
            int n = 0;
            while (object2[0] <= string.length() && (object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, 0)) != null && object.equals(Boolean.TRUE)) {
                if (globData.mode == 1) {
                    RegExpImpl.match_glob(globData, context, scriptable, n, regExpImpl);
                } else {
                    if (globData.mode != 2) {
                        Kit.codeBug();
                    }
                    SubString subString = regExpImpl.lastMatch;
                    int n2 = globData.leftIndex;
                    int n3 = subString.index - n2;
                    globData.leftIndex = subString.index + subString.length;
                    RegExpImpl.replace_glob(globData, context, scriptable, regExpImpl, n2, n3);
                }
                if (regExpImpl.lastMatch.length == 0) {
                    if (object2[0] == string.length()) break;
                    Object object4 = object2;
                    object4[0] = object4[0] + true;
                }
                ++n;
            }
        } else {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, globData.mode == 2 ? 0 : 1);
        }
        return object;
    }

    @Override
    public int find_split(Context context, Scriptable scriptable, String string, String string2, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n;
        SubString subString;
        int n2;
        block5: {
            int n3 = nArray[0];
            int n4 = string.length();
            int n5 = context.getLanguageVersion();
            NativeRegExp nativeRegExp = (NativeRegExp)scriptable2;
            while (true) {
                n2 = nArray[0];
                nArray[0] = ++n3;
                Object object = nativeRegExp.executeRegExp(context, scriptable, this, string, nArray, 0);
                if (object != Boolean.TRUE) {
                    nArray[0] = n2;
                    nArray2[0] = 1;
                    blArray[0] = false;
                    return n4;
                }
                n3 = nArray[0];
                nArray[0] = n2;
                blArray[0] = true;
                subString = this.lastMatch;
                nArray2[0] = subString.length;
                if (nArray2[0] != 0 || n3 != nArray[0]) break;
                if (n3 != n4) continue;
                if (n5 == 120) {
                    nArray2[0] = 1;
                    n = n3;
                } else {
                    n = -1;
                }
                break block5;
            }
            n = n3 - nArray2[0];
        }
        n2 = this.parens == null ? 0 : this.parens.length;
        stringArray[0] = new String[n2];
        for (int i = 0; i < n2; ++i) {
            subString = this.getParenSubString(i);
            stringArray[0][i] = subString.toString();
        }
        return n;
    }

    SubString getParenSubString(int n) {
        SubString subString;
        if (this.parens != null && n < this.parens.length && (subString = this.parens[n]) != null) {
            return subString;
        }
        return SubString.emptySubString;
    }

    private static void match_glob(GlobData globData, Context context, Scriptable scriptable, int n, RegExpImpl regExpImpl) {
        Object object;
        if (globData.arrayobj == null) {
            object = ScriptableObject.getTopLevelScope(scriptable);
            globData.arrayobj = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
        }
        object = regExpImpl.lastMatch;
        String string = ((SubString)object).toString();
        globData.arrayobj.put(n, globData.arrayobj, (Object)string);
    }

    private static void replace_glob(GlobData globData, Context context, Scriptable scriptable, RegExpImpl regExpImpl, int n, int n2) throws JavaScriptException {
        int n3;
        String string;
        int n4;
        Object[] objectArray;
        if (globData.lambda != null) {
            Object object;
            objectArray = regExpImpl.parens;
            n4 = objectArray == null ? 0 : objectArray.length;
            Object[] objectArray2 = new Object[n4 + 3];
            objectArray2[0] = regExpImpl.lastMatch.toString();
            for (int i = 0; i < n4; ++i) {
                object = objectArray[i];
                objectArray2[i + 1] = object != null ? ((SubString)object).toString() : Undefined.instance;
            }
            objectArray2[n4 + 1] = new Integer(regExpImpl.leftContext.length);
            objectArray2[n4 + 2] = globData.str;
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
            object = globData.lambda.call(context, scriptable2, scriptable2, objectArray2);
            string = ScriptRuntime.toString(object);
            n3 = string.length();
        } else {
            string = null;
            n3 = globData.repstr.length();
            if (globData.dollar >= 0) {
                objectArray = new int[1];
                n4 = globData.dollar;
                do {
                    SubString subString;
                    if ((subString = RegExpImpl.interpretDollar(context, regExpImpl, globData.repstr, n4, (int[])objectArray)) != null) {
                        n3 += subString.length - objectArray[0];
                        n4 += objectArray[0];
                        continue;
                    }
                    ++n4;
                } while ((n4 = globData.repstr.indexOf(36, n4)) >= 0);
            }
        }
        int n5 = n2 + n3 + regExpImpl.rightContext.length;
        StringBuffer stringBuffer = globData.charBuf;
        if (stringBuffer == null) {
            globData.charBuf = stringBuffer = new StringBuffer(n5);
        } else {
            stringBuffer.ensureCapacity(globData.charBuf.length() + n5);
        }
        stringBuffer.append(regExpImpl.leftContext.charArray, n, n2);
        if (globData.lambda != null) {
            stringBuffer.append(string);
        } else {
            RegExpImpl.do_replace(globData, context, regExpImpl);
        }
    }

    private static SubString interpretDollar(Context context, RegExpImpl regExpImpl, String string, int n, int[] nArray) {
        int n2;
        if (string.charAt(n) != '$') {
            Kit.codeBug();
        }
        if ((n2 = context.getLanguageVersion()) != 0 && n2 <= 140 && n > 0 && string.charAt(n - 1) == '\\') {
            return null;
        }
        int n3 = string.length();
        if (n + 1 >= n3) {
            return null;
        }
        char c = string.charAt(n + 1);
        if (NativeRegExp.isDigit(c)) {
            int n4;
            int n5;
            int n6;
            if (n2 != 0 && n2 <= 140) {
                if (c == '0') {
                    return null;
                }
                n6 = 0;
                n5 = n;
                while (++n5 < n3 && NativeRegExp.isDigit(c = string.charAt(n5)) && (n4 = 10 * n6 + NativeRegExp.unDigit(c)) >= n6) {
                    n6 = n4;
                }
            } else {
                int n7 = regExpImpl.parens == null ? 0 : regExpImpl.parens.length;
                n6 = NativeRegExp.unDigit(c);
                if (n6 > n7) {
                    return null;
                }
                n5 = n + 2;
                if (n + 2 < n3 && NativeRegExp.isDigit(c = string.charAt(n + 2)) && (n4 = 10 * n6 + NativeRegExp.unDigit(c)) <= n7) {
                    ++n5;
                    n6 = n4;
                }
                if (n6 == 0) {
                    return null;
                }
            }
            nArray[0] = n5 - n;
            return regExpImpl.getParenSubString(--n6);
        }
        nArray[0] = 2;
        switch (c) {
            case '$': {
                return new SubString("$");
            }
            case '&': {
                return regExpImpl.lastMatch;
            }
            case '+': {
                return regExpImpl.lastParen;
            }
            case '`': {
                if (n2 == 120) {
                    regExpImpl.leftContext.index = 0;
                    regExpImpl.leftContext.length = regExpImpl.lastMatch.index;
                }
                return regExpImpl.leftContext;
            }
            case '\'': {
                return regExpImpl.rightContext;
            }
        }
        return null;
    }

    private static void do_replace(GlobData globData, Context context, RegExpImpl regExpImpl) {
        int n;
        StringBuffer stringBuffer = globData.charBuf;
        int n2 = 0;
        String string = globData.repstr;
        int n3 = globData.dollar;
        if (n3 != -1) {
            int[] nArray = new int[1];
            do {
                int n4 = n3 - n2;
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3;
                SubString subString = RegExpImpl.interpretDollar(context, regExpImpl, string, n3, nArray);
                if (subString != null) {
                    n4 = subString.length;
                    if (n4 > 0) {
                        stringBuffer.append(subString.charArray, subString.index, n4);
                    }
                    n2 += nArray[0];
                    n3 += nArray[0];
                    continue;
                }
                ++n3;
            } while ((n3 = string.indexOf(36, n3)) >= 0);
        }
        if ((n = string.length()) > n2) {
            stringBuffer.append(string.substring(n2, n));
        }
    }
}

