/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.serialize.ScriptableOutputStream;

public class ScriptableInputStream
extends ObjectInputStream {
    private Scriptable scope;

    public ScriptableInputStream(InputStream inputStream, Scriptable scriptable) throws IOException {
        super(inputStream);
        this.scope = scriptable;
        this.enableResolveObject(true);
    }

    @Override
    protected Object resolveObject(Object object) throws IOException {
        if (object instanceof ScriptableOutputStream.PendingLookup) {
            String string = ((ScriptableOutputStream.PendingLookup)object).getName();
            if ((object = ScriptableOutputStream.lookupQualifiedName(this.scope, string)) == Scriptable.NOT_FOUND) {
                throw new IOException("Object " + string + " not found upon " + "deserialization.");
            }
        } else if (object instanceof UniqueTag) {
            object = ((UniqueTag)object).readResolve();
        } else if (object instanceof Undefined) {
            object = ((Undefined)object).readResolve();
        }
        return object;
    }
}

