/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.javascript.Scriptable;

public class ScriptableOutputStream
extends ObjectOutputStream {
    private Scriptable scope;
    private Hashtable table;

    public ScriptableOutputStream(OutputStream outputStream, Scriptable scriptable) throws IOException {
        super(outputStream);
        this.scope = scriptable;
        this.table = new Hashtable(31);
        this.table.put(scriptable, "");
        this.enableReplaceObject(true);
        this.excludeStandardObjectNames();
    }

    public void addExcludedName(String string) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string);
        if (!(object instanceof Scriptable)) {
            throw new IllegalArgumentException("Object for excluded name " + string + " not found.");
        }
        this.table.put(object, string);
    }

    public boolean hasExcludedName(String string) {
        return this.table.get(string) != null;
    }

    public void removeExcludedName(String string) {
        this.table.remove(string);
    }

    public void excludeStandardObjectNames() {
        String[] stringArray = new String[]{"Object", "Object.prototype", "Function", "Function.prototype", "String", "String.prototype", "Math", "Array", "Array.prototype", "Error", "Error.prototype", "Number", "Number.prototype", "Date", "Date.prototype", "RegExp", "RegExp.prototype", "Script", "Script.prototype"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExcludedName(stringArray[i]);
        }
    }

    static Object lookupQualifiedName(Scriptable scriptable, String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Object object = scriptable;
        while (stringTokenizer.hasMoreTokens() && (object = object.get(string2 = stringTokenizer.nextToken(), (Scriptable)object)) != null && object instanceof Scriptable) {
        }
        return object;
    }

    @Override
    protected Object replaceObject(Object object) throws IOException {
        String string = (String)this.table.get(object);
        if (string == null) {
            return object;
        }
        return new PendingLookup(string);
    }

    static class PendingLookup
    implements Serializable {
        private String name;

        PendingLookup(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }
    }
}

