/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class FileWindow
extends JInternalFrame
implements ActionListener,
DocumentListener {
    Main db;
    SourceInfo sourceInfo;
    FileTextArea textArea;
    FileHeader fileHeader;
    JScrollPane p;
    int currentPos;
    JLabel statusBar;
    boolean isModified = false;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cut")) {
            this.textArea.cut();
        } else if (string.equals("Copy")) {
            this.textArea.copy();
        } else if (string.equals("Paste")) {
            this.textArea.paste();
        }
    }

    void runToCursor(ActionEvent actionEvent) {
        try {
            this.db.runToCursor(this.getUrl(), this.textArea.getLineOfOffset(this.textArea.getCaretPosition()) + 1, actionEvent);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void load() {
        Scriptable scriptable = this.db.officeScripts.getScriptScope(this.getUrl());
        if (scriptable == null) {
            scriptable = this.db.getScope();
        }
        if (scriptable == null) {
            MessageDialogWrapper.showMessageDialog(this.db, "Can't load scripts: no scope available", "Run", 0);
        } else {
            String string = this.getUrl();
            if (string != null) {
                new Thread(new LoadFile(this.db, scriptable, string, new StringReader(this.textArea.getText()))).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        if (this.getUrl() != null) {
            OutputStream outputStream = null;
            try {
                Object object;
                if (this.getUrl().startsWith("vnd.sun.star")) {
                    object = this.db.officeScripts.getScriptUrl(this.getUrl());
                    if (object == null) {
                        throw new IOException("Can't optain stream for " + this.getUrl());
                    }
                    outputStream = ((URL)object).openConnection().getOutputStream();
                } else {
                    outputStream = new FileOutputStream(this.getUrl());
                }
                object = this.textArea.getText();
                outputStream.write(((String)object).getBytes(), 0, ((String)object).length());
                this.isModified = false;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error saving file: " + iOException.getMessage(), "Error", 0);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        System.err.println("Error closing stream: " + iOException.getMessage());
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    public boolean isEditable() {
        return this.db.isSourceEditingEnabled();
    }

    public int getPosition(int n) {
        int n2 = -1;
        try {
            n2 = this.textArea.getLineStartOffset(n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n2;
    }

    boolean isBreakPoint(int n) {
        return this.sourceInfo.hasBreakpoint(n);
    }

    void toggleBreakPoint(int n) {
        if (!this.isBreakPoint(n)) {
            this.setBreakPoint(n);
        } else {
            this.clearBreakPoint(n);
        }
    }

    void setBreakPoint(int n) {
        if (this.sourceInfo.placeBreakpoint(n)) {
            this.fileHeader.repaint();
        }
    }

    void clearBreakPoint(int n) {
        if (this.sourceInfo.removeBreakpoint(n)) {
            this.fileHeader.repaint();
        }
    }

    public Main getDB() {
        return this.db;
    }

    FileWindow(Main main, SourceInfo sourceInfo) {
        super(SourceInfo.getShortName(sourceInfo.getUrl()), true, true, true, true);
        this.db = main;
        this.sourceInfo = sourceInfo;
        this.updateToolTip();
        this.currentPos = -1;
        this.textArea = new FileTextArea(this);
        this.textArea.setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.updateText();
        this.textArea.select(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                FileWindow.this.getDB().removeScript(FileWindow.this.getUrl());
                FileWindow.this.getDB().officeScripts.deleteScript(FileWindow.this.getUrl());
            }
        });
    }

    private void updateToolTip() {
        Component component = this.getComponent(1);
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.getUrl());
        }
    }

    public String getUrl() {
        return this.sourceInfo.getUrl();
    }

    void updateText() {
        String string = this.sourceInfo.getSource();
        if (!this.textArea.getText().equals(string)) {
            this.textArea.getDocument().removeDocumentListener(this);
            this.textArea.setText(string);
            this.isModified = false;
            this.textArea.getDocument().addDocumentListener(this);
            int n = 0;
            if (this.currentPos != -1) {
                n = this.currentPos;
            }
            this.textArea.select(n);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doChanged(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doChanged(documentEvent);
    }

    public void doChanged(DocumentEvent documentEvent) {
        this.isModified = true;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getText() {
        return this.textArea.getText();
    }

    void setPosition(int n) {
        this.textArea.select(n);
        this.currentPos = n;
        this.fileHeader.repaint();
    }

    void select(int n, int n2) {
        int n3 = this.textArea.getDocument().getLength();
        this.textArea.select(n3, n3);
        this.textArea.select(n, n2);
    }

    @Override
    public void dispose() {
        this.db.removeWindow(this);
        super.dispose();
    }
}

