/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.ScriptItem;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class FindFunction
extends JDialog
implements ActionListener {
    private String value = null;
    private JList list;
    Hashtable functionNames;
    Main db;
    JButton setButton;
    JButton refreshButton;
    JButton cancelButton;

    public String showDialog(Component component) {
        this.value = null;
        this.setLocationRelativeTo(component);
        this.setVisible(true);
        return this.value;
    }

    private void setValue(String string) {
        this.value = string;
        this.list.setSelectedValue(this.value, true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            this.setVisible(false);
            this.value = null;
        } else if (string.equals("Select")) {
            if (this.list.getSelectedIndex() < 0) {
                return;
            }
            try {
                this.value = (String)this.list.getSelectedValue();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
            this.setVisible(false);
            ScriptItem scriptItem = (ScriptItem)this.functionNames.get(this.value);
            if (scriptItem != null) {
                SourceInfo sourceInfo = scriptItem.getSourceInfo();
                String string2 = sourceInfo.getUrl();
                int n = scriptItem.getFirstLine();
                FileWindow fileWindow = this.db.getFileWindow(string2);
                if (fileWindow == null) {
                    CreateFileWindow.action(this.db, sourceInfo, n).run();
                    fileWindow = this.db.getFileWindow(string2);
                    fileWindow.setPosition(-1);
                }
                int n2 = fileWindow.getPosition(n - 1);
                int n3 = fileWindow.getPosition(n) - 1;
                fileWindow.textArea.select(n2);
                fileWindow.textArea.setCaretPosition(n2);
                fileWindow.textArea.moveCaretPosition(n3);
                try {
                    fileWindow.show();
                    this.db.requestFocus();
                    fileWindow.requestFocus();
                    fileWindow.textArea.requestFocus();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    FindFunction(Main main, Hashtable hashtable, String string, String string2) {
        super(main, string, true);
        this.functionNames = hashtable;
        this.db = main;
        this.cancelButton = new JButton("Cancel");
        this.setButton = new JButton("Select");
        this.cancelButton.addActionListener(this);
        this.setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.setButton);
        this.list = new JList(new DefaultListModel());
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        defaultListModel.clear();
        Enumeration enumeration = hashtable.keys();
        Object[] objectArray = new String[hashtable.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = enumeration.nextElement().toString();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            defaultListModel.addElement(objectArray[n]);
        }
        this.list.setSelectedIndex(0);
        this.setButton.setEnabled(objectArray.length > 0);
        this.list.setSelectionMode(1);
        this.list.addMouseListener(new MouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(320, 240));
        jScrollPane.setMinimumSize(new Dimension(250, 80));
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(string2);
        jLabel.setLabelFor(this.list);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.cancelButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(this.setButton);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    keyEvent.consume();
                    FindFunction.this.value = null;
                    FindFunction.this.setVisible(false);
                }
            }
        });
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                FindFunction.this.setButton.doClick();
            }
        }
    }
}

