/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.ScriptItem;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class FrameHelper
implements DebugFrame {
    private Main db;
    private ContextData contextData;
    private Scriptable activation;
    private DebuggableScript fnOrScript;
    private SourceInfo sourceInfo;
    private int lineNumber;

    FrameHelper(Context context, Main main, DebuggableScript debuggableScript) {
        this.db = main;
        this.contextData = ContextData.get(context);
        this.fnOrScript = debuggableScript;
        ScriptItem scriptItem = main.getScriptItem(debuggableScript);
        if (scriptItem != null) {
            this.sourceInfo = scriptItem.getSourceInfo();
            this.lineNumber = scriptItem.getFirstLine();
        }
        this.contextData.pushFrame(this);
    }

    @Override
    public void onEnter(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        this.activation = scriptable;
        if (this.db.breakOnEnter) {
            this.db.handleBreakpointHit(context);
        }
    }

    @Override
    public void onLineChange(Context context, int n) {
        this.lineNumber = n;
        if (this.contextData.breakNextLine || this.sourceInfo != null && this.sourceInfo.hasBreakpoint(n)) {
            this.db.handleBreakpointHit(context);
        }
    }

    @Override
    public void onExceptionThrown(Context context, Throwable throwable) {
        this.db.handleExceptionThrown(context, throwable, this);
    }

    @Override
    public void onExit(Context context, boolean bl, Object object) {
        if (this.db.breakOnReturn && !bl) {
            this.db.handleBreakpointHit(context);
        }
        this.contextData.popFrame();
    }

    SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    Scriptable getVariableObject() {
        return this.activation;
    }

    String getUrl() {
        if (this.sourceInfo != null) {
            return this.sourceInfo.getUrl();
        }
        return this.db.getNormilizedUrl(this.fnOrScript);
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    DebuggableScript getScript() {
        return this.fnOrScript;
    }
}

