/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class LoadFile
implements Runnable {
    Scriptable scope;
    String fileName;
    Main db;
    Reader reader = null;
    Object result = null;
    Exception exception = null;
    int lineNum = -1;
    boolean sfExecute = false;

    LoadFile(Main main, Scriptable scriptable, String string) {
        this.scope = scriptable;
        this.fileName = string;
        this.db = main;
    }

    LoadFile(Main main, Scriptable scriptable, String string, Reader reader) {
        this(main, scriptable, string);
        this.reader = reader;
    }

    LoadFile(Main main, Scriptable scriptable, String string, Reader reader, boolean bl) {
        this(main, scriptable, string);
        this.reader = reader;
        this.sfExecute = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.db.officeScripts.isScriptRunning(this.fileName)) {
            this.exception = new Exception("The script is already executing");
            if (!this.sfExecute) {
                MessageDialogWrapper.showMessageDialog(this.db, "Script already executing", "Run", 0);
            }
            return;
        }
        this.db.officeScripts.setScriptRunning(this.fileName, true);
        Context context = Context.enter();
        ContextData contextData = ContextData.get(context);
        contextData.breakNextLine = !this.sfExecute;
        try {
            this.result = context.evaluateReader(this.scope, this.reader == null ? new FileReader(this.fileName) : this.reader, this.fileName, 1, null);
        }
        catch (Exception exception) {
            this.exception = exception;
            String string = exception.getMessage();
            if (exception instanceof EcmaError) {
                EcmaError ecmaError = (EcmaError)exception;
                string = ecmaError.getSourceName() + ", line " + ecmaError.getLineNumber() + ": " + string;
                int n = ecmaError.getLineNumber();
                if (!this.sfExecute) {
                    MessageDialogWrapper.showMessageDialog(this.db, string, "Run", 0);
                }
            }
        }
        finally {
            this.db.officeScripts.setScriptRunning(this.fileName, false);
            context.exit();
        }
    }
}

