/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class Menubar
extends JMenuBar
implements ActionListener {
    Main db;
    JMenu windowMenu;
    JCheckBoxMenuItem breakOnExceptions;
    JCheckBoxMenuItem breakOnEnter;
    JCheckBoxMenuItem breakOnReturn;
    JMenuItem saveItem;

    JMenu getDebugMenu() {
        return this.getMenu(2);
    }

    Menubar(Main main) {
        KeyStroke keyStroke;
        JMenuItem jMenuItem;
        int n;
        this.db = main;
        String[] stringArray = new String[]{"Run", "Save", "", "Exit"};
        String[] stringArray2 = new String[]{"Run", "Save", "", "Exit"};
        char[] cArray = new char[]{'0', 'N', '\u0000', 'X'};
        int[] nArray = new int[]{79, 78, 0, 81};
        String[] stringArray3 = new String[]{"Cut", "Copy", "Paste", "Go to function..."};
        char[] cArray2 = new char[]{'T', 'C', 'P', 'F'};
        String[] stringArray4 = new String[]{"Break", "Go", "Step Into", "Step Over", "Step Out"};
        char[] cArray3 = new char[]{'B', 'G', 'I', 'O', 'T'};
        String[] stringArray5 = new String[]{"Metal", "Windows", "Motif"};
        char[] cArray4 = new char[]{'M', 'W', 'F'};
        int[] nArray2 = new int[]{19, 116, 122, 118, 119, 0, 0};
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenu jMenu3 = new JMenu("Platform");
        jMenu3.setMnemonic('P');
        JMenu jMenu4 = new JMenu("Debug");
        jMenu4.setMnemonic('D');
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('W');
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() == 0) {
                jMenu.addSeparator();
                continue;
            }
            jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.setActionCommand(stringArray2[n]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            if (nArray[n] != 0) {
                keyStroke = KeyStroke.getKeyStroke(nArray[n], 2);
                jMenuItem.setAccelerator(keyStroke);
            }
            if (!stringArray[n].equals("Save")) continue;
            this.saveItem = jMenuItem;
        }
        for (n = 0; n < stringArray3.length; ++n) {
            jMenuItem = new JMenuItem(stringArray3[n], cArray2[n]);
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
        }
        for (n = 0; n < stringArray5.length; ++n) {
            jMenuItem = new JMenuItem(stringArray5[n], cArray4[n]);
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
        }
        for (n = 0; n < stringArray4.length; ++n) {
            jMenuItem = new JMenuItem(stringArray4[n], cArray3[n]);
            jMenuItem.addActionListener(this);
            if (nArray2[n] != 0) {
                keyStroke = KeyStroke.getKeyStroke(nArray2[n], 0);
                jMenuItem.setAccelerator(keyStroke);
            }
            if (n != 0) {
                jMenuItem.setEnabled(false);
            }
            jMenu4.add(jMenuItem);
        }
        this.breakOnExceptions = new JCheckBoxMenuItem("Break on Exceptions");
        this.breakOnExceptions.setMnemonic('X');
        this.breakOnExceptions.addActionListener(this);
        this.breakOnExceptions.setSelected(false);
        jMenu4.add(this.breakOnExceptions);
        this.breakOnEnter = new JCheckBoxMenuItem("Break on Function Enter");
        this.breakOnEnter.setMnemonic('E');
        this.breakOnEnter.addActionListener(this);
        this.breakOnEnter.setSelected(false);
        jMenu4.add(this.breakOnEnter);
        this.breakOnReturn = new JCheckBoxMenuItem("Break on Function Return");
        this.breakOnReturn.setMnemonic('R');
        this.breakOnReturn.addActionListener(this);
        this.breakOnReturn.setSelected(false);
        jMenu4.add(this.breakOnReturn);
        this.add(jMenu);
        this.add(jMenu2);
        this.add(jMenu4);
        JMenuItem jMenuItem2 = new JMenuItem("Cascade", 65);
        this.windowMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(this);
        jMenuItem2 = new JMenuItem("Tile", 84);
        this.windowMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(this);
        this.add(this.windowMenu);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = null;
        if (string.equals("Metal")) {
            string2 = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else if (string.equals("Windows")) {
            string2 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (string.equals("Motif")) {
            string2 = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else {
            Object object = actionEvent.getSource();
            if (object == this.breakOnExceptions) {
                this.db.setBreakOnExceptions(this.breakOnExceptions.isSelected());
            } else if (object == this.breakOnEnter) {
                this.db.setBreakOnEnter(this.breakOnEnter.isSelected());
            } else if (object == this.breakOnReturn) {
                this.db.setBreakOnReturn(this.breakOnReturn.isSelected());
            } else {
                this.db.actionPerformed(actionEvent);
            }
            return;
        }
        try {
            UIManager.setLookAndFeel(string2);
            SwingUtilities.updateComponentTreeUI(this.db);
            SwingUtilities.updateComponentTreeUI(this.db.dlg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addFile(String string) {
        JMenuItem jMenuItem;
        int n = this.windowMenu.getItemCount();
        if (n == 4) {
            this.windowMenu.addSeparator();
            ++n;
        }
        JMenuItem jMenuItem2 = this.windowMenu.getItem(n - 1);
        boolean bl = false;
        int n2 = 5;
        if (jMenuItem2 != null && jMenuItem2.getText().equals("More Windows...")) {
            bl = true;
            ++n2;
        }
        if (!bl && n - 4 == 5) {
            JMenuItem jMenuItem3 = new JMenuItem("More Windows...", 77);
            this.windowMenu.add(jMenuItem3);
            jMenuItem3.setActionCommand("More Windows...");
            jMenuItem3.addActionListener(this);
            return;
        }
        if (n - 4 <= n2) {
            if (bl) {
                --n;
                this.windowMenu.remove(jMenuItem2);
            }
            String string2 = SourceInfo.getShortName(string);
            jMenuItem = new JMenuItem((char)(48 + (n - 4)) + " " + string2, 48 + (n - 4));
            this.windowMenu.add(jMenuItem);
            if (bl) {
                this.windowMenu.add(jMenuItem2);
            }
        } else {
            return;
        }
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
    }

    public void setSaveEnabled(boolean bl) {
        this.saveItem.setEnabled(bl);
    }
}

