/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class OpenFile
implements Runnable {
    String fileName;
    Main db;
    Reader reader = null;

    OpenFile(Main main, String string) {
        this.fileName = string;
        this.db = main;
    }

    OpenFile(Main main, String string, Reader reader) {
        this(main, string);
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Context context = Context.enter();
        ContextData contextData = ContextData.get(context);
        contextData.breakNextLine = true;
        try {
            context.compileReader(this.reader == null ? new FileReader(this.fileName) : this.reader, this.fileName, 1, null);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (exception instanceof EcmaError) {
                EcmaError ecmaError = (EcmaError)exception;
                string = ecmaError.getSourceName() + ", line " + ecmaError.getLineNumber() + ": " + string;
            }
            MessageDialogWrapper.showMessageDialog(this.db, string, "Error Compiling File", 0);
        }
        finally {
            context.exit();
        }
    }
}

