/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.mozilla.javascript.tools.shell.ConsoleWriter;

public class ConsoleTextArea
extends JTextArea
implements KeyListener,
DocumentListener {
    private ConsoleWriter console1;
    private ConsoleWriter console2;
    private PrintStream out;
    private PrintStream err;
    private PrintWriter inPipe;
    private PipedInputStream in;
    private Vector history = new Vector();
    private int historyIndex = -1;
    private int outputMark = 0;

    @Override
    public void select(int n, int n2) {
        this.requestFocus();
        super.select(n, n2);
    }

    public ConsoleTextArea(String[] stringArray) {
        this.console1 = new ConsoleWriter(this);
        this.console2 = new ConsoleWriter(this);
        this.out = new PrintStream(this.console1);
        this.err = new PrintStream(this.console2);
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        this.inPipe = new PrintWriter(pipedOutputStream);
        this.in = new PipedInputStream();
        try {
            pipedOutputStream.connect(this.in);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.getDocument().addDocumentListener(this);
        this.addKeyListener(this);
        this.setLineWrap(true);
        this.setFont(new Font("Monospaced", 0, 12));
    }

    synchronized void returnPressed() {
        Document document = this.getDocument();
        int n = document.getLength();
        Segment segment = new Segment();
        try {
            document.getText(this.outputMark, n - this.outputMark, segment);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (segment.count > 0) {
            this.history.addElement(segment.toString());
        }
        this.historyIndex = this.history.size();
        this.inPipe.write(segment.array, segment.offset, segment.count);
        this.append("\n");
        this.outputMark = document.getLength();
        this.inPipe.write("\n");
        this.inPipe.flush();
        this.console1.flush();
    }

    public void eval(String string) {
        this.inPipe.write(string);
        this.inPipe.write("\n");
        this.inPipe.flush();
        this.console1.flush();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 8 || n == 37) {
            if (this.outputMark == this.getCaretPosition()) {
                keyEvent.consume();
            }
        } else if (n == 36) {
            int n2 = this.getCaretPosition();
            if (n2 == this.outputMark) {
                keyEvent.consume();
            } else if (n2 > this.outputMark && !keyEvent.isControlDown()) {
                if (keyEvent.isShiftDown()) {
                    this.moveCaretPosition(this.outputMark);
                } else {
                    this.setCaretPosition(this.outputMark);
                }
                keyEvent.consume();
            }
        } else if (n == 10) {
            this.returnPressed();
            keyEvent.consume();
        } else if (n == 38) {
            --this.historyIndex;
            if (this.historyIndex >= 0) {
                if (this.historyIndex >= this.history.size()) {
                    this.historyIndex = this.history.size() - 1;
                }
                if (this.historyIndex >= 0) {
                    String string = (String)this.history.elementAt(this.historyIndex);
                    int n3 = this.getDocument().getLength();
                    this.replaceRange(string, this.outputMark, n3);
                    int n4 = this.outputMark + string.length();
                    this.select(n4, n4);
                } else {
                    ++this.historyIndex;
                }
            } else {
                ++this.historyIndex;
            }
            keyEvent.consume();
        } else if (n == 40) {
            int n5 = this.outputMark;
            if (this.history.size() > 0) {
                ++this.historyIndex;
                if (this.historyIndex < 0) {
                    this.historyIndex = 0;
                }
                int n6 = this.getDocument().getLength();
                if (this.historyIndex < this.history.size()) {
                    String string = (String)this.history.elementAt(this.historyIndex);
                    this.replaceRange(string, this.outputMark, n6);
                    n5 = this.outputMark + string.length();
                } else {
                    this.historyIndex = this.history.size();
                    this.replaceRange("", this.outputMark, n6);
                }
            }
            this.select(n5, n5);
            keyEvent.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            if (this.outputMark == this.getCaretPosition()) {
                keyEvent.consume();
            }
        } else if (this.getCaretPosition() < this.outputMark) {
            this.setCaretPosition(this.outputMark);
        }
    }

    @Override
    public synchronized void keyReleased(KeyEvent keyEvent) {
    }

    public synchronized void write(String string) {
        this.insert(string, this.outputMark);
        int n = string.length();
        this.outputMark += n;
        this.select(this.outputMark, this.outputMark);
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getLength();
        int n2 = documentEvent.getOffset();
        if (this.outputMark > n2) {
            this.outputMark += n;
        }
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getLength();
        int n2 = documentEvent.getOffset();
        if (this.outputMark > n2) {
            this.outputMark = this.outputMark >= n2 + n ? (this.outputMark -= n) : n2;
        }
    }

    public synchronized void postUpdateUI() {
        this.requestFocus();
        this.setCaret(this.getCaret());
        this.select(this.outputMark, this.outputMark);
    }

    @Override
    public synchronized void changedUpdate(DocumentEvent documentEvent) {
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }
}

