/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.SecurityProxy;

public class JavaPolicySecurity
extends SecurityProxy {
    public JavaPolicySecurity() {
        new CodeSource(null, (Certificate[])null);
    }

    @Override
    protected void callProcessFileSecure(final Context context, final Scriptable scriptable, final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL = JavaPolicySecurity.this.getUrlObj(string);
                ProtectionDomain protectionDomain = JavaPolicySecurity.this.getUrlDomain(uRL);
                Main.processFileSecure(context, scriptable, uRL.toExternalForm(), protectionDomain);
                return null;
            }
        });
    }

    private URL getUrlObj(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = System.getProperty("user.dir");
            string2 = string2.replace('\\', '/');
            if (!string2.endsWith("/")) {
                string2 = string2 + '/';
            }
            try {
                URL uRL2 = new URL("file:" + string2);
                uRL = new URL(uRL2, string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new RuntimeException("Can not construct file URL for '" + string + "':" + malformedURLException2.getMessage());
            }
        }
        return uRL;
    }

    private ProtectionDomain getUrlDomain(URL uRL) {
        CodeSource codeSource = new CodeSource(uRL, (Certificate[])null);
        PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
        return new ProtectionDomain(codeSource, permissionCollection);
    }

    @Override
    public GeneratedClassLoader createClassLoader(ClassLoader classLoader, Object object) {
        ProtectionDomain protectionDomain = (ProtectionDomain)object;
        return new Loader(classLoader, protectionDomain);
    }

    @Override
    public Object getDynamicSecurityDomain(Object object) {
        ProtectionDomain protectionDomain = (ProtectionDomain)object;
        return this.getDynamicDomain(protectionDomain);
    }

    private ProtectionDomain getDynamicDomain(ProtectionDomain protectionDomain) {
        ContextPermissions contextPermissions = new ContextPermissions(protectionDomain);
        ProtectionDomain protectionDomain2 = new ProtectionDomain(null, contextPermissions);
        return protectionDomain2;
    }

    @Override
    public Object callWithDomain(Object object, final Context context, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) throws JavaScriptException {
        ProtectionDomain protectionDomain = (ProtectionDomain)object;
        ProtectionDomain protectionDomain2 = this.getDynamicDomain(protectionDomain);
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{protectionDomain2};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws JavaScriptException {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        };
        try {
            return AccessController.doPrivileged(privilegedExceptionAction, accessControlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (JavaScriptException)privilegedActionException.getException();
        }
    }

    private static class ContextPermissions
    extends PermissionCollection {
        AccessControlContext _context = AccessController.getContext();
        PermissionCollection _statisPermissions;

        ContextPermissions(ProtectionDomain protectionDomain) {
            if (protectionDomain != null) {
                this._statisPermissions = protectionDomain.getPermissions();
            }
            this.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        @Override
        public boolean implies(Permission permission) {
            if (this._statisPermissions != null && !this._statisPermissions.implies(permission)) {
                return false;
            }
            try {
                this._context.checkPermission(permission);
                return true;
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }

        public Enumeration elements() {
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('@');
            stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuffer.append(" (context=");
            stringBuffer.append(this._context);
            stringBuffer.append(", static_permitions=");
            stringBuffer.append(this._statisPermissions);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    private static class Loader
    extends ClassLoader
    implements GeneratedClassLoader {
        private ProtectionDomain domain;

        Loader(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            super(classLoader != null ? classLoader : Loader.getSystemClassLoader());
            this.domain = protectionDomain;
        }

        @Override
        public Class defineClass(String string, byte[] byArray) {
            return super.defineClass(string, byArray, 0, byArray.length, this.domain);
        }

        @Override
        public void linkClass(Class clazz) {
            this.resolveClass(clazz);
        }
    }
}

