/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Main;

class Runner
implements Runnable {
    private Scriptable scope;
    private Function f;
    private Script s;
    private Object[] args;

    Runner(Scriptable scriptable, Function function, Object[] objectArray) {
        this.scope = scriptable;
        this.f = function;
        this.args = objectArray;
    }

    Runner(Scriptable scriptable, Script script) {
        this.scope = scriptable;
        this.s = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Context context = Main.enterContext();
        try {
            if (this.f != null) {
                this.f.call(context, this.scope, this.scope, this.args);
            } else {
                this.s.exec(context, this.scope);
            }
        }
        catch (JavaScriptException javaScriptException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", javaScriptException.getMessage()));
        }
        finally {
            Context.exit();
        }
    }
}

