/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tools.uno;

import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.InvalidValueException;
import com.sun.star.registry.RegistryKeyType;
import com.sun.star.registry.RegistryValueType;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;
import java.util.Enumeration;
import java.util.Hashtable;

class RegistryKey
implements XRegistryKey {
    protected RegistryValueType _registryValueType = RegistryValueType.NOT_DEFINED;
    protected String _name;
    protected Hashtable _keys = new Hashtable();
    protected int _long;
    protected int[] _long_list;
    protected String _ascii;
    protected String[] _ascii_list;
    protected String _string;
    protected String[] _string_list;
    protected byte[] _binary;

    public RegistryKey(String string) {
        this._name = string;
    }

    @Override
    public String getKeyName() throws RuntimeException {
        return this._name;
    }

    @Override
    public boolean isReadOnly() throws InvalidRegistryException, RuntimeException {
        return false;
    }

    @Override
    public boolean isValid() throws RuntimeException {
        return true;
    }

    @Override
    public RegistryKeyType getKeyType(String string) throws InvalidRegistryException, RuntimeException {
        return RegistryKeyType.KEY;
    }

    @Override
    public RegistryValueType getValueType() throws InvalidRegistryException, RuntimeException {
        return this._registryValueType;
    }

    @Override
    public int getLongValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.LONG) {
            throw new InvalidValueException("long");
        }
        return this._long;
    }

    @Override
    public void setLongValue(int n) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.LONG;
        this._long = n;
    }

    @Override
    public int[] getLongListValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.LONGLIST) {
            throw new InvalidValueException("longlist");
        }
        return this._long_list;
    }

    @Override
    public void setLongListValue(int[] nArray) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.LONGLIST;
        this._long_list = nArray;
    }

    @Override
    public String getAsciiValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.ASCII) {
            throw new InvalidValueException("ascii");
        }
        return this._ascii;
    }

    @Override
    public void setAsciiValue(String string) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.ASCII;
        this._ascii = string;
    }

    @Override
    public String[] getAsciiListValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.ASCIILIST) {
            throw new InvalidValueException("asciilist");
        }
        return this._ascii_list;
    }

    @Override
    public void setAsciiListValue(String[] stringArray) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.ASCIILIST;
        this._ascii_list = stringArray;
    }

    @Override
    public String getStringValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.STRING) {
            throw new InvalidValueException("string");
        }
        return this._string;
    }

    @Override
    public void setStringValue(String string) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.STRING;
        this._string = string;
    }

    @Override
    public String[] getStringListValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.STRINGLIST) {
            throw new InvalidValueException("string_list");
        }
        return this._string_list;
    }

    @Override
    public void setStringListValue(String[] stringArray) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.STRINGLIST;
        this._string_list = stringArray;
    }

    @Override
    public byte[] getBinaryValue() throws InvalidRegistryException, InvalidValueException, RuntimeException {
        if (this._registryValueType != RegistryValueType.BINARY) {
            throw new InvalidValueException("longlist");
        }
        return this._binary;
    }

    @Override
    public void setBinaryValue(byte[] byArray) throws InvalidRegistryException, RuntimeException {
        this._registryValueType = RegistryValueType.BINARY;
        this._binary = byArray;
    }

    @Override
    public XRegistryKey openKey(String string) throws InvalidRegistryException, RuntimeException {
        return (XRegistryKey)this._keys.get(string);
    }

    @Override
    public XRegistryKey createKey(String string) throws InvalidRegistryException, RuntimeException {
        XRegistryKey xRegistryKey = this.openKey(string);
        if (xRegistryKey == null) {
            xRegistryKey = new RegistryKey(string);
            this._keys.put(string, xRegistryKey);
        }
        return xRegistryKey;
    }

    @Override
    public void closeKey() throws InvalidRegistryException, RuntimeException {
    }

    @Override
    public void deleteKey(String string) throws InvalidRegistryException, RuntimeException {
        this._keys.remove(string);
    }

    @Override
    public synchronized XRegistryKey[] openKeys() throws InvalidRegistryException, RuntimeException {
        XRegistryKey[] xRegistryKeyArray = new RegistryKey[this._keys.size()];
        Enumeration enumeration = this._keys.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            xRegistryKeyArray[n++] = (RegistryKey)enumeration.nextElement();
        }
        return xRegistryKeyArray;
    }

    @Override
    public synchronized String[] getKeyNames() throws InvalidRegistryException, RuntimeException {
        String[] stringArray = new String[this._keys.size()];
        Enumeration enumeration = this._keys.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    @Override
    public boolean createLink(String string, String string2) throws InvalidRegistryException, RuntimeException {
        return false;
    }

    @Override
    public void deleteLink(String string) throws InvalidRegistryException, RuntimeException {
    }

    @Override
    public String getLinkTarget(String string) throws InvalidRegistryException, RuntimeException {
        return null;
    }

    @Override
    public String getResolvedName(String string) throws InvalidRegistryException, RuntimeException {
        return null;
    }
}

