/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.KeyEvent;
import com.sun.star.awt.MouseEvent;
import com.sun.star.awt.Size;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.Renderer;
import com.sun.star.wizards.ui.PeerConfig;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.CommonListener;
import com.sun.star.wizards.ui.event.MethodInvocation;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ImageList
implements XItemEventBroadcaster,
ListDataListener {
    private XControl imgContainer;
    private XFixedText lblImageText;
    private XFixedText grbxSelectedImage;
    private XButton btnBack;
    private XButton btnNext;
    private XFixedText lblCounter;
    private XControl[] images;
    private boolean benabled = true;
    private UnoDialog2 oUnoDialog;
    private Size gap = new Size(4, 4);
    private int cols = 4;
    private int rows = 3;
    private Size imageSize = new Size(20, 20);
    private Size pos;
    private Size selectionGap = new Size(2, 2);
    private boolean showButtons = true;
    private Short step;
    private static final Short NO_BORDER = new Short(0);
    private boolean refreshOverNull = true;
    private int imageTextLines = 1;
    private boolean rowSelect = false;
    public int tabIndex;
    public Boolean scaleImages = Boolean.TRUE;
    public String name = "il";
    private int selected = -1;
    private int pageStart = 0;
    public int helpURL = 0;
    private CommonListener uiEventListener = new CommonListener();
    private ImageRenderer renderer;
    private ListModel listModel;
    public Renderer counterRenderer = new SimpleCounterRenderer();
    private Object dialogModel;
    private ImageKeyListener imageKeyListener;
    private static final Integer BACKGROUND_COLOR = new Integer(0x1000000);
    private static final Short HIDE_PAGE = new Short(99);
    private static final Integer TRANSPARENT = new Integer(-1);
    private static final int LINE_HEIGHT = 8;
    private MethodInvocation METHOD_MOUSE_PRESSED;
    private Integer _imageHeight;
    private Integer _imageWidth;
    private static final String[] IMAGE_PROPS = new String[]{"Border", "BackgroundColor", "Height", "HelpURL", "PositionX", "PositionY", "ScaleImage", "Step", "TabIndex", "Tabstop", "Width"};
    private Short tabIndex_;
    private static final String[] MOVE_SELECTION = new String[]{"PositionX", "PositionY", "Step"};
    private Object[] MOVE_SELECTION_VALS = new Object[3];
    private transient ArrayList itemListenerList;

    public Size getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(Size size) {
        this.imageSize = size;
    }

    public void create(UnoDialog2 unoDialog2) {
        this.oUnoDialog = unoDialog2;
        this.dialogModel = unoDialog2.xDialogModel;
        int n = this.imageTextLines * 8;
        PeerConfig peerConfig = new PeerConfig(unoDialog2);
        this.MOVE_SELECTION_VALS[2] = this.step;
        this.imgContainer = unoDialog2.insertImage(this.name + "lblContainer", new String[]{"BackgroundColor", "Border", "Height", "PositionX", "PositionY", "Step", "Width"}, new Object[]{BACKGROUND_COLOR, new Short(1), new Integer((this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + 1), new Integer(this.pos.Width), new Integer(this.pos.Height), this.step, new Integer((this.imageSize.Width + this.gap.Width) * this.cols + this.gap.Width)});
        peerConfig.setPeerProperties(this.imgContainer, new String[]{"MouseTransparent"}, new Object[]{Boolean.TRUE});
        int n2 = this.rowSelect ? (this.imageSize.Width + this.gap.Width) * this.cols - this.gap.Width + this.selectionGap.Width * 2 : this.imageSize.Width + this.selectionGap.Width * 2;
        this.grbxSelectedImage = unoDialog2.insertLabel(this.name + "_grbxSelected", new String[]{"BackgroundColor", "Border", "Height", "PositionX", "PositionY", "Step", "Tabstop", "Width"}, new Object[]{TRANSPARENT, new Short(1), new Integer(this.imageSize.Height + this.selectionGap.Height * 2), new Integer(0), new Integer(0), this.step, Boolean.TRUE, new Integer(n2)});
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.grbxSelectedImage);
        xWindow.addMouseListener(new XMouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
                ImageList.this.focus(ImageList.this.getImageIndexFor(ImageList.this.getSelected()));
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void disposing(EventObject eventObject) {
            }
        });
        String[] stringArray = new String[]{"Height", "HelpURL", "PositionX", "PositionY", "Step", "TabIndex", "Tabstop", "Width"};
        this.lblImageText = unoDialog2.insertLabel(this.name + "_imageText", stringArray, new Object[]{new Integer(n), "", new Integer(this.pos.Width + 1), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height), this.step, new Short(0), Boolean.FALSE, new Integer(this.cols * (this.imageSize.Width + this.gap.Width) + this.gap.Width - 2)});
        Integer n3 = new Integer(14);
        if (this.showButtons) {
            this.btnBack = unoDialog2.insertButton(this.name + "_btnBack", "prevPage", this, stringArray, new Object[]{n3, "HID:" + this.helpURL++, new Integer(this.pos.Width), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + 1), this.step, new Short((short)(this.tabIndex + 1)), Boolean.TRUE, n3});
            this.btnNext = unoDialog2.insertButton(this.name + "_btnNext", "nextPage", this, stringArray, new Object[]{n3, "HID:" + this.helpURL++, new Integer(this.pos.Width + (this.imageSize.Width + this.gap.Width) * this.cols + this.gap.Width - n3 + 1), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + 1), this.step, new Short((short)(this.tabIndex + 2)), Boolean.TRUE, n3});
            this.lblCounter = unoDialog2.insertLabel(this.name + "_lblCounter", stringArray, new Object[]{new Integer(8), "", new Integer(this.pos.Width + n3 + 1), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + n + (n3 - 8) / 2), this.step, new Short(0), Boolean.FALSE, new Integer(this.cols * (this.imageSize.Width + this.gap.Width) + this.gap.Width - 2 * n3 - 1)});
            Helper.setUnoPropertyValue(this.getModel(this.lblCounter), "Align", new Short(1));
            Helper.setUnoPropertyValue(this.getModel(this.btnBack), "Label", "<");
            Helper.setUnoPropertyValue(this.getModel(this.btnNext), "Label", ">");
        }
        this.imageKeyListener = new ImageKeyListener();
        this.tabIndex_ = new Short((short)this.tabIndex);
        this.images = new XControl[this.rows * this.cols];
        try {
            this.METHOD_MOUSE_PRESSED = new MethodInvocation("mousePressed", (Object)this, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this._imageHeight = new Integer(this.imageSize.Height);
        this._imageWidth = new Integer(this.imageSize.Width);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.images[i * this.cols + j] = this.createImage(unoDialog2, i, j);
            }
        }
        this.refreshImages();
        this.listModel.addListDataListener(this);
    }

    private XControl createImage(UnoDialog2 unoDialog2, int n, int n2) {
        String string = this.name + "_image" + (n * this.cols + n2);
        XControl xControl = unoDialog2.insertImage(string, IMAGE_PROPS, new Object[]{NO_BORDER, BACKGROUND_COLOR, this._imageHeight, "HID:" + this.helpURL++, new Integer(this.imagePosX(n2)), new Integer(this.imagePosY(n)), this.scaleImages, this.step, this.tabIndex_, Boolean.FALSE, this._imageWidth});
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        xWindow.addMouseListener((XMouseListener)this.uiEventListener);
        xWindow.addKeyListener((XKeyListener)this.imageKeyListener);
        this.uiEventListener.add(string, "MPR", this.METHOD_MOUSE_PRESSED);
        return xControl;
    }

    private int imagePosX(int n) {
        return this.pos.Width + n * (this.imageSize.Width + this.gap.Width) + this.gap.Width;
    }

    private int imagePosY(int n) {
        return this.pos.Height + n * (this.imageSize.Height + this.gap.Height) + this.gap.Height;
    }

    private void refreshImages() {
        int n;
        if (this.showButtons) {
            this.refreshCounterText();
        }
        this.hideSelection();
        if (this.refreshOverNull) {
            for (n = 0; n < this.images.length; ++n) {
                this.setVisible(this.images[n], false);
            }
        }
        n = 1;
        for (int i = 0; i < this.images.length; ++i) {
            Object[] objectArray = this.renderer.getImageUrls(this.getObjectFor(i));
            if (objectArray == null) continue;
            if (objectArray.length == 1) {
                Helper.setUnoPropertyValue(this.images[i].getModel(), "ImageURL", (String)objectArray[0]);
            } else if (objectArray.length == 2) {
                this.oUnoDialog.getPeerConfiguration().setImageUrl((Object)this.images[i].getModel(), objectArray[0], objectArray[1]);
            }
            Helper.setUnoPropertyValue(this.images[i].getModel(), "Tabstop", n != 0 ? Boolean.TRUE : Boolean.FALSE);
            if (this.refreshOverNull) {
                this.setVisible(this.images[i], true);
            }
            n = 0;
        }
        this.refreshSelection();
    }

    private void refreshCounterText() {
        Helper.setUnoPropertyValue(this.getModel(this.lblCounter), "Label", this.counterRenderer.render(new Counter(this.pageStart + 1, this.pageEnd(), this.listModel.getSize())));
    }

    private int pageEnd() {
        int n = this.pageStart + this.cols * this.rows;
        if (n > this.listModel.getSize() - 1) {
            return this.listModel.getSize();
        }
        return n;
    }

    private void refreshSelection() {
        if (this.selected < this.pageStart || this.selected >= this.pageStart + this.rows * this.cols) {
            this.hideSelection();
        } else {
            this.moveSelection(this.getImageIndexFor(this.selected));
        }
    }

    private void hideSelection() {
        Helper.setUnoPropertyValue(this.getModel(this.grbxSelectedImage), "Step", HIDE_PAGE);
        this.setVisible(this.grbxSelectedImage, false);
    }

    private void moveSelection(int n) {
        this.setVisible(this.grbxSelectedImage, false);
        int n2 = n / this.cols;
        int n3 = this.rowSelect ? 0 : n - n2 * this.cols;
        this.MOVE_SELECTION_VALS[0] = new Integer(this.imagePosX(n3) - this.selectionGap.Width);
        this.MOVE_SELECTION_VALS[1] = new Integer(this.imagePosY(n2) - this.selectionGap.Height);
        Helper.setUnoPropertyValues(this.getModel(this.grbxSelectedImage), MOVE_SELECTION, this.MOVE_SELECTION_VALS);
        if (((Number)Helper.getUnoPropertyValue(this.dialogModel, "Step")).shortValue() == this.step.shortValue()) {
            this.setVisible(this.grbxSelectedImage, true);
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (i != n) {
                this.defocus(i);
                continue;
            }
            Helper.setUnoPropertyValue(this.images[n].getModel(), "Tabstop", Boolean.TRUE);
        }
    }

    private void setVisible(Object object, boolean bl) {
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)object)).setVisible(bl);
    }

    private Object getObjectFor(int n) {
        int n2 = this.getIndexFor(n);
        if (this.listModel.getSize() <= n2) {
            return null;
        }
        return this.listModel.getElementAt(n2);
    }

    private int getIndexFor(int n) {
        return this.pageStart + n;
    }

    private int getImageIndexFor(int n) {
        return n - this.pageStart;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() <= this.selected && listDataEvent.getIndex1() <= this.selected) {
            this.selected += listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
        }
        if (listDataEvent.getIndex0() < this.pageStart || listDataEvent.getIndex1() < this.pageStart + this.getRows() + this.getCols()) {
            this.refreshImages();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public synchronized void addItemListener(XItemListener xItemListener) {
        if (this.itemListenerList == null) {
            this.itemListenerList = new ArrayList();
        }
        this.itemListenerList.add(xItemListener);
    }

    public synchronized void removeItemListener(XItemListener xItemListener) {
        if (this.itemListenerList != null) {
            this.itemListenerList.remove(xItemListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireItemSelected() {
        ArrayList arrayList;
        ImageList imageList = this;
        synchronized (imageList) {
            if (this.itemListenerList == null) {
                return;
            }
            arrayList = (ArrayList)this.itemListenerList.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((XItemListener)arrayList.get(i)).itemStateChanged(null);
        }
    }

    public int getCols() {
        return this.cols;
    }

    public Size getGap() {
        return this.gap;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public Short getStep() {
        return this.step;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public Size getPos() {
        return this.pos;
    }

    public ImageRenderer getRenderer() {
        return this.renderer;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSelected() {
        return this.selected;
    }

    public Size getSelectionGap() {
        return this.selectionGap;
    }

    public boolean isShowButtons() {
        return this.showButtons;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public void setGap(Size size) {
        this.gap = size;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public void setStep(Short s) {
        this.step = s;
    }

    public void setPageStart(int n) {
        if (n == this.pageStart) {
            return;
        }
        this.pageStart = n;
        this.enableButtons();
        this.refreshImages();
    }

    public void setPos(Size size) {
        this.pos = size;
    }

    public void setRenderer(ImageRenderer imageRenderer) {
        this.renderer = imageRenderer;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setSelected(int n) {
        if (this.rowSelect && n >= 0) {
            n = n / this.cols * this.cols;
        }
        if (this.selected == n) {
            return;
        }
        this.selected = n;
        this.refreshImageText();
        this.refreshSelection();
        this.fireItemSelected();
    }

    public void setSelected(Object object) {
        if (object == null) {
            this.setSelected(-1);
        } else {
            for (int i = 0; i < this.getListModel().getSize(); ++i) {
                if (!this.getListModel().getElementAt(i).equals(object)) continue;
                this.setSelected(i);
                return;
            }
        }
        this.setSelected(-1);
    }

    private void refreshImageText() {
        Object var1_1 = this.selected >= 0 ? this.getListModel().getElementAt(this.selected) : null;
        Helper.setUnoPropertyValue(this.getModel(this.lblImageText), "Label", " " + this.renderer.render(var1_1));
    }

    public void setSelectionGap(Size size) {
        this.selectionGap = size;
    }

    public void setShowButtons(boolean bl) {
        this.showButtons = bl;
    }

    public void nextPage() {
        if (this.pageStart < this.getListModel().getSize() - this.rows * this.cols) {
            this.setPageStart(this.pageStart + this.rows * this.cols);
        }
    }

    public void prevPage() {
        if (this.pageStart == 0) {
            return;
        }
        int n = this.pageStart - this.rows * this.cols;
        if (n < 0) {
            n = 0;
        }
        this.setPageStart(n);
    }

    private void enableButtons() {
        this.enable(this.btnNext, new Boolean(this.pageStart + this.rows * this.cols < this.listModel.getSize()));
        this.enable(this.btnBack, new Boolean(this.pageStart > 0));
    }

    private void enable(Object object, Boolean bl) {
        Helper.setUnoPropertyValue(this.getModel(object), "Enabled", bl);
    }

    private Object getModel(Object object) {
        return ((XControl)UnoRuntime.queryInterface(XControl.class, (Object)object)).getModel();
    }

    private void setBorder(Object object, Short s) {
        Helper.setUnoPropertyValue(this.getModel(object), "Border", s);
    }

    private int getImageFromEvent(Object object) {
        Object object2 = ((EventObject)object).Source;
        String string = (String)Helper.getUnoPropertyValue(this.getModel(object2), "Name");
        return Integer.valueOf(string.substring(6 + this.name.length()));
    }

    public void mousePressed(Object object) {
        int n = this.getImageFromEvent(object);
        int n2 = this.getIndexFor(n);
        if (n2 < this.listModel.getSize()) {
            this.focus(n);
            this.setSelected(n2);
        }
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.getListModel().getElementAt(this.selected)};
    }

    public Object getSelectedObject() {
        return this.selected >= 0 ? this.getListModel().getElementAt(this.selected) : null;
    }

    public void showSelected() {
        int n = this.pageStart;
        this.pageStart = this.selected == -1 ? (this.pageStart += 0) : this.selected / this.images.length * this.images.length;
        if (n != this.pageStart) {
            this.enableButtons();
            this.refreshImages();
        }
    }

    public void setRowSelect(boolean bl) {
        this.rowSelect = bl;
    }

    public boolean isRowSelect() {
        return this.rowSelect;
    }

    private final void focus(int n) {
        Helper.setUnoPropertyValue(this.images[n].getModel(), "Tabstop", Boolean.TRUE);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.images[n]);
        xWindow.setFocus();
    }

    private final void defocus(int n) {
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.images[n]), "Tabstop", Boolean.FALSE);
    }

    public void display(int n) {
        int n2 = this.getCols() * this.getRows();
        int n3 = this.listModel.getSize() / n2 * n2;
        this.setPageStart(n3);
    }

    public boolean isenabled() {
        return this.benabled;
    }

    public void setenabled(boolean bl) {
        for (int i = 0; i < this.images.length; ++i) {
            UnoDialog2.setEnabled((Object)this.images[i], bl);
        }
        UnoDialog2.setEnabled((Object)this.grbxSelectedImage, bl);
        UnoDialog2.setEnabled((Object)this.lblImageText, bl);
        if (this.showButtons) {
            UnoDialog2.setEnabled((Object)this.btnBack, bl);
            UnoDialog2.setEnabled((Object)this.btnNext, bl);
            UnoDialog2.setEnabled((Object)this.lblCounter, bl);
        }
        this.benabled = bl;
    }

    private class ImageKeyListener
    implements XKeyListener {
        private ImageKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2;
            int n3;
            int n4 = ImageList.this.getImageFromEvent(keyEvent);
            int n5 = n4 + (n3 = this.getKeyMove(keyEvent, n2 = n4 / ImageList.this.getCols(), n = n4 - n2 * ImageList.this.getCols()));
            if (n5 == n4) {
                return;
            }
            if (this.isFocusable(n5)) {
                this.changeFocus(n4, n5);
            }
        }

        private boolean isFocusable(int n) {
            return n >= 0 && ImageList.this.getIndexFor(n) < ImageList.this.listModel.getSize();
        }

        private void changeFocus(int n, int n2) {
            ImageList.this.focus(n2);
            ImageList.this.defocus(n);
        }

        private final int getKeyMove(KeyEvent keyEvent, int n, int n2) {
            switch (keyEvent.KeyCode) {
                case 1025: {
                    if (n <= 0) break;
                    return 0 - ImageList.this.getCols();
                }
                case 1024: {
                    if (n >= ImageList.this.getRows() - 1) break;
                    return ImageList.this.getCols();
                }
                case 1026: {
                    if (n2 <= 0) break;
                    return -1;
                }
                case 1027: {
                    if (n2 >= ImageList.this.getCols() - 1) break;
                    return 1;
                }
                case 1284: {
                    this.select(keyEvent);
                }
            }
            return 0;
        }

        private void select(KeyEvent keyEvent) {
            ImageList.this.setSelected(ImageList.this.getIndexFor(ImageList.this.getImageFromEvent(keyEvent)));
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void disposing(EventObject eventObject) {
        }
    }

    public static class Counter {
        public int start;
        public int end;
        public int max;

        public Counter(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.max = n3;
        }
    }

    private static class SimpleCounterRenderer
    implements Renderer {
        private SimpleCounterRenderer() {
        }

        @Override
        public String render(Object object) {
            return "" + ((Counter)object).start + ".." + ((Counter)object).end + "/" + ((Counter)object).max;
        }
    }

    public static interface ImageRenderer
    extends Renderer {
        public Object[] getImageUrls(Object var1);
    }
}

