/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.bibtex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openoffice.xmerge.Document;
import writer2latex.Application;
import writer2latex.latex.style.I18n;
import writer2latex.office.BibMark;
import writer2latex.util.ExportNameCollection;

public class BibTeXDocument
implements Document {
    private static final String FILE_EXTENSION = ".bib";
    private String sName;
    private Hashtable entries = new Hashtable();
    private ExportNameCollection exportNames = new ExportNameCollection(true);
    private I18n i18n;

    public BibTeXDocument(String string) {
        this.sName = this.trimDocumentName(string);
        this.i18n = new I18n("ascii");
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public String getFileName() {
        return new String(this.sName + FILE_EXTENSION);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ASCII");
        outputStreamWriter.write("%% This file was converted to BibTeX by Writer2BibTeX ver. " + Application.getVersion() + ".\n");
        outputStreamWriter.write("%% See http://www.hj-gym.dk/~hj/writer2latex for more info.\n");
        outputStreamWriter.write("\n");
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            BibMark bibMark = (BibMark)enumeration.nextElement();
            outputStreamWriter.write("@");
            outputStreamWriter.write(bibMark.getEntryType().toUpperCase());
            outputStreamWriter.write("{");
            outputStreamWriter.write(this.exportNames.getExportName(bibMark.getIdentifier()));
            outputStreamWriter.write(",\n");
            for (int i = 0; i < 31; ++i) {
                String string = bibMark.getField(i);
                if (string == null) continue;
                outputStreamWriter.write("    ");
                outputStreamWriter.write(BibTeXDocument.getFieldName(i).toUpperCase());
                outputStreamWriter.write(" = {");
                for (int j = 0; j < string.length(); ++j) {
                    String string2 = this.i18n.convert(string.charAt(j), false, "en");
                    if (string2.charAt(0) == '\\') {
                        outputStreamWriter.write("{");
                    }
                    outputStreamWriter.write(string2);
                    if (string2.charAt(0) != '\\') continue;
                    outputStreamWriter.write("}");
                }
                outputStreamWriter.write("},\n");
            }
            outputStreamWriter.write("}\n\n");
        }
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    public static final String getFieldName(int n) {
        switch (n) {
            case 0: {
                return "address";
            }
            case 1: {
                return "annote";
            }
            case 2: {
                return "author";
            }
            case 3: {
                return "booktitle";
            }
            case 4: {
                return "chapter";
            }
            case 6: {
                return "edition";
            }
            case 7: {
                return "editor";
            }
            case 8: {
                return "howpublished";
            }
            case 9: {
                return "institution";
            }
            case 10: {
                return "journal";
            }
            case 12: {
                return "month";
            }
            case 13: {
                return "note";
            }
            case 14: {
                return "number";
            }
            case 15: {
                return "organization";
            }
            case 16: {
                return "pages";
            }
            case 17: {
                return "publisher";
            }
            case 18: {
                return "school";
            }
            case 19: {
                return "series";
            }
            case 20: {
                return "title";
            }
            case 21: {
                return "type";
            }
            case 22: {
                return "volume";
            }
            case 23: {
                return "year";
            }
            case 24: {
                return "url";
            }
            case 25: {
                return "custom1";
            }
            case 26: {
                return "custom2";
            }
            case 27: {
                return "custom3";
            }
            case 28: {
                return "custom4";
            }
            case 29: {
                return "custom5";
            }
            case 30: {
                return "isbn";
            }
        }
        return null;
    }

    public boolean containsKey(String string) {
        return this.entries.containsKey(string);
    }

    public void put(BibMark bibMark) {
        this.entries.put(bibMark.getIdentifier(), bibMark);
        this.exportNames.addName(bibMark.getIdentifier());
    }

    public String getExportName(String string) {
        return this.exportNames.getExportName(string);
    }

    private String trimDocumentName(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(FILE_EXTENSION)) {
            int n = string.length();
            int n2 = n - FILE_EXTENSION.length();
            string = string.substring(0, n2);
        }
        return string;
    }
}

