/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.content.StarMathConverter;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public final class MathmlConverter
extends ConverterHelper {
    private StarMathConverter smc;
    private boolean bContainsFormulas = false;

    public MathmlConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
        this.smc = new StarMathConverter(converterPalette.getI18n(), config);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bContainsFormulas) {
            if (this.config.useOoomath()) {
                laTeXDocumentPortion.append("\\usepackage{ooomath}").nl();
            } else {
                this.smc.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
            }
            laTeXDocumentPortion2.append("\\everymath{\\displaystyle}").nl();
        }
    }

    public String convert(Node node, Node node2) {
        Element element;
        Element element2 = Misc.getChildByTagName(node2, "math:semantics");
        if (element2 != null && (element = Misc.getChildByTagName(element2, "math:annotation")) != null) {
            String string = "";
            if (element.hasChildNodes()) {
                NodeList nodeList = element.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    if (nodeList.item(i).getNodeType() != 3) continue;
                    string = string + nodeList.item(i).getNodeValue();
                }
                this.bContainsFormulas = true;
                return this.smc.convert(string);
            }
        }
        return "\\text{Warning: No StarMath annotation}";
    }
}

