/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.latex.style.StyleMap;
import writer2latex.office.FontDeclaration;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeStyle;
import writer2latex.office.ParStyle;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class ParStyleConverter
extends StyleConverter {
    private String[] sHeadingStyles = new String[11];

    public ParStyleConverter(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        super(writerStyleCollection, config, converterPalette);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.config.formatting() >= 3) {
            laTeXDocumentPortion2.append("\\raggedbottom").nl();
        }
        this.appendHeadingStyles(laTeXDocumentPortion2);
        if (this.config.formatting() >= 3) {
            laTeXDocumentPortion2.append("% Paragraph styles").nl();
            this.palette.getCharSc().applyDefaultFont(this.wsc.getDefaultParStyle(), laTeXDocumentPortion2);
            super.appendDeclarations(laTeXDocumentPortion, laTeXDocumentPortion2);
        }
    }

    public void applyParStyle(String string, BeforeAfter beforeAfter, Context context) {
        this.applyParStyle(string, beforeAfter, context, true);
    }

    private void applyParStyle(String string, BeforeAfter beforeAfter, Context context, boolean bl) {
        ParStyle parStyle;
        if (string == null) {
            return;
        }
        beforeAfter.add("", "\n");
        if (!this.styleMap.contains(string)) {
            this.createParStyle(string);
        }
        String string2 = this.styleMap.getBefore(string);
        String string3 = this.styleMap.getAfter(string);
        beforeAfter.add(string2, string3);
        if (bl && this.styleMap.getLineBreak(string)) {
            if (string2.length() > 0) {
                beforeAfter.add("\n", "");
            }
            if (string3.length() > 0 && !"}".equals(string3)) {
                beforeAfter.add("", "\n");
            }
        }
        if ((parStyle = this.wsc.getParStyle(string)) == null) {
            return;
        }
        this.palette.getPageSc().collectMasterPage(parStyle);
        context.updateFormattingFromStyle(parStyle);
        context.setVerbatim(this.styleMap.getVerbatim(string));
    }

    private void createParStyle(String string) {
        Context context = (Context)this.palette.getMainContext().clone();
        StyleMap styleMap = this.config.getParStyleMap();
        if (styleMap.contains(string)) {
            this.styleMap.put(string, styleMap.getBefore(string), styleMap.getAfter(string), styleMap.getLineBreak(string), styleMap.getVerbatim(string));
            return;
        }
        ParStyle parStyle = this.wsc.getParStyle(string);
        if (parStyle == null) {
            this.styleMap.put(string, "", "");
            return;
        }
        switch (this.config.formatting()) {
            case 3: {
                if (parStyle.isAutomatic()) {
                    this.createAutomaticParStyle(parStyle, context);
                    return;
                }
            }
            case 4: {
                this.createSoftParStyle(parStyle, context);
                return;
            }
            case 1: 
            case 2: {
                this.createSimpleParStyle(parStyle, context);
                return;
            }
        }
        this.styleMap.put(string, "", "");
    }

    private void createAutomaticParStyle(ParStyle parStyle, Context context) {
        BeforeAfter beforeAfter = new BeforeAfter();
        BeforeAfter beforeAfter2 = new BeforeAfter();
        BeforeAfter beforeAfter3 = new BeforeAfter();
        String string = parStyle.getParentName();
        if (this.styleMap.getVerbatim(string)) {
            this.styleMap.put(parStyle.getName(), this.styleMap.getBefore(string), this.styleMap.getAfter(string), this.styleMap.getLineBreak(string), this.styleMap.getVerbatim(string));
            return;
        }
        this.applyParStyle(string, beforeAfter2, context, false);
        this.applyPageBreak(parStyle, false, beforeAfter);
        this.palette.getI18n().applyLanguage(parStyle, true, false, beforeAfter3);
        this.palette.getCharSc().applyFont(parStyle, true, false, beforeAfter3, context);
        if (beforeAfter2.isEmpty() && !beforeAfter3.isEmpty()) {
            beforeAfter.add("{", "}");
        } else {
            beforeAfter.add(beforeAfter2.getBefore(), beforeAfter2.getAfter());
        }
        beforeAfter.add(beforeAfter3.getBefore(), beforeAfter3.getAfter());
        boolean bl = this.styleMap.getLineBreak(string);
        if (!bl && !beforeAfter3.isEmpty()) {
            beforeAfter.add(" ", "");
        }
        this.styleMap.put(parStyle.getName(), beforeAfter.getBefore(), beforeAfter.getAfter(), bl, false);
    }

    private void createSimpleParStyle(ParStyle parStyle, Context context) {
        if (parStyle.isAutomatic() && this.config.getParStyleMap().contains(parStyle.getParentName())) {
            this.createAutomaticParStyle(parStyle, context);
        }
        BeforeAfter beforeAfter = new BeforeAfter();
        BeforeAfter beforeAfter2 = new BeforeAfter();
        this.applyPageBreak(parStyle, false, beforeAfter);
        String string = parStyle.getProperty("fo:text-align", true);
        if ("center".equals(string)) {
            beforeAfter2.add("\\centering", "\\par");
        } else if ("end".equals(string)) {
            beforeAfter2.add("\\raggedleft", "\\par");
        }
        this.palette.getI18n().applyLanguage(parStyle, true, true, beforeAfter2);
        this.palette.getCharSc().applyFont(parStyle, true, true, beforeAfter2, context);
        if (!beforeAfter2.isEmpty()) {
            beforeAfter.add("{", "}");
        }
        beforeAfter.add(beforeAfter2.getBefore(), beforeAfter2.getAfter());
        this.styleMap.put(parStyle.getName(), beforeAfter.getBefore(), beforeAfter.getAfter());
    }

    private void createSoftParStyle(ParStyle parStyle, Context context) {
        if (parStyle.isAutomatic() && this.config.getParStyleMap().contains(parStyle.getParentName())) {
            this.createAutomaticParStyle(parStyle, context);
        }
        BeforeAfter beforeAfter = new BeforeAfter();
        this.applyParProperties(parStyle, beforeAfter);
        beforeAfter.add("\\writerlistparindent\\writerlistleftskip", "");
        this.palette.getI18n().applyLanguage(parStyle, true, true, beforeAfter);
        beforeAfter.add("\\leavevmode", "");
        this.palette.getCharSc().applyNormalFont(beforeAfter);
        this.palette.getCharSc().applyFont(parStyle, true, true, beforeAfter, context);
        beforeAfter.add("\\writerlistlabel", "");
        beforeAfter.add("\\ignorespaces", "");
        String string = "style" + this.styleNames.getExportName(parStyle.getName());
        this.styleMap.put(parStyle.getName(), "\\begin{" + string + "}", "\\end{" + string + "}");
        this.declarations.append("\\newenvironment{").append(string).append("}{").append(beforeAfter.getBefore()).append("}{").append(beforeAfter.getAfter()).append("}").nl();
    }

    public void applyHardHeadingStyle(int n, String string, BeforeAfter beforeAfter, BeforeAfter beforeAfter2, Context context) {
        ParStyle parStyle = this.wsc.getParStyle(string);
        if (parStyle == null) {
            return;
        }
        this.palette.getPageSc().collectMasterPage(parStyle);
        if (this.sHeadingStyles[n] == null) {
            String string2 = this.sHeadingStyles[n] = parStyle.isAutomatic() ? parStyle.getParentName() : string;
        }
        if (parStyle.isAutomatic()) {
            this.applyPageBreak(parStyle, false, beforeAfter);
            this.palette.getCharSc().applyHardCharFormatting(parStyle, beforeAfter2);
        }
        context.updateFormattingFromStyle(parStyle);
    }

    public String getFontName(String string) {
        ParStyle parStyle = this.wsc.getParStyle(string);
        if (parStyle == null) {
            return null;
        }
        String string2 = parStyle.getProperty("style:font-name");
        if (string2 == null) {
            return null;
        }
        FontDeclaration fontDeclaration = this.wsc.getFontDeclaration(string2);
        if (fontDeclaration == null) {
            return null;
        }
        return fontDeclaration.getProperty("fo:font-family");
    }

    public void applyPageBreak(ParStyle parStyle, boolean bl, BeforeAfter beforeAfter) {
        String string;
        if (parStyle == null) {
            return;
        }
        if (parStyle.isAutomatic() && this.config.ignoreHardPageBreaks()) {
            return;
        }
        String string2 = parStyle.getProperty("fo:break-before", bl);
        if ("page".equals(string2)) {
            beforeAfter.add("\\clearpage", "");
        }
        if ("page".equals(string2 = parStyle.getProperty("fo:break-after", bl))) {
            beforeAfter.add("", "\\clearpage");
        }
        if ((string = parStyle.getMasterPageName()) == null || string.length() == 0) {
            return;
        }
        beforeAfter.add("\\clearpage", "");
        this.palette.getPageSc().applyMasterPage(string, beforeAfter);
    }

    private void applyLineSpacing(ParStyle parStyle, BeforeAfter beforeAfter) {
        if (parStyle == null) {
            return;
        }
        String string = parStyle.getProperty("fo:line-height");
        if (string == null || !string.endsWith("%")) {
            return;
        }
        float f = Misc.getFloat(string.substring(0, string.length() - 1), 1.0f);
        beforeAfter.add("\\renewcommand\\baselinestretch{" + f / 120.0f + "}", "");
    }

    private String getLength(ParStyle parStyle, String string) {
        String string2 = parStyle.getAbsoluteProperty(string);
        if (string2 == null) {
            return "0cm";
        }
        return string2;
    }

    private String createBorder(String string, String string2, String string3, String string4, String string5) {
        BeforeAfter beforeAfter = new BeforeAfter();
        this.palette.getCharSc().applyThisColor(string5, false, beforeAfter);
        return "{\\setlength\\parindent{0pt}\\setlength\\leftskip{" + string + "}" + "\\setlength\\baselineskip{0pt}\\setlength\\parskip{" + string4 + "}" + beforeAfter.getBefore() + "\\rule{\\textwidth-" + string + "-" + string2 + "}{" + string4 + "}" + beforeAfter.getAfter() + "\\par}";
    }

    private void applyMargins(ParStyle parStyle, BeforeAfter beforeAfter) {
        String string = this.getLength(parStyle, "fo:padding-top");
        String string2 = this.getLength(parStyle, "fo:padding-bottom");
        String string3 = this.getLength(parStyle, "fo:padding-left");
        String string4 = this.getLength(parStyle, "fo:padding-right");
        String string5 = this.getLength(parStyle, "fo:margin-top");
        String string6 = this.getLength(parStyle, "fo:margin-bottom");
        String string7 = this.getLength(parStyle, "fo:margin-left");
        String string8 = this.getLength(parStyle, "fo:margin-right");
        String string9 = "true".equals(parStyle.getProperty("style:auto-text-indent")) ? "2em" : this.getLength(parStyle, "fo:text-indent");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string10 = parStyle.getProperty("fo:text-align");
        if ("center".equals(string10)) {
            bl = true;
            bl2 = true;
        } else if ("start".equals(string10)) {
            bl2 = true;
            bl3 = true;
        } else if ("end".equals(string10)) {
            bl = true;
        } else if (!"justify".equals(parStyle.getProperty("fo:text-align-last"))) {
            bl3 = true;
        }
        beforeAfter.add("\\setlength\\leftskip{" + string7 + (bl ? " plus 1fil" : "") + "}", "");
        beforeAfter.add("\\setlength\\rightskip{" + string8 + (bl2 ? " plus 1fil" : "") + "}", "");
        beforeAfter.add("\\setlength\\parindent{" + string9 + "}", "");
        beforeAfter.add("\\setlength\\parfillskip{" + (bl3 ? "0pt plus 1fil" : "0pt") + "}", "");
        beforeAfter.add("\\setlength\\parskip{" + string5 + "}", "\\unskip\\vspace{" + string6 + "}");
    }

    private void applyAlignment(ParStyle parStyle, boolean bl, boolean bl2, BeforeAfter beforeAfter) {
        if (bl || parStyle == null) {
            return;
        }
        String string = parStyle.getProperty("fo:text-align", bl2);
        if ("center".equals(string)) {
            beforeAfter.add("\\centering", "");
        } else if ("start".equals(string)) {
            beforeAfter.add("\\raggedright", "");
        } else if ("end".equals(string)) {
            beforeAfter.add("\\raggedleft", "");
        }
    }

    private void applyParProperties(ParStyle parStyle, BeforeAfter beforeAfter) {
        this.applyPageBreak(parStyle, true, beforeAfter);
        beforeAfter.add("", "\\par");
        this.applyLineSpacing(parStyle, beforeAfter);
        this.applyMargins(parStyle, beforeAfter);
    }

    private void appendHeadingStyles(LaTeXDocumentPortion laTeXDocumentPortion) {
        int n;
        CharSequence charSequence;
        String string;
        String string2;
        Object object;
        OfficeStyle officeStyle;
        int n2;
        int n3;
        if (this.config.formatting() <= 1) {
            return;
        }
        HeadingMap headingMap = this.config.getHeadingMap();
        int n4 = 0;
        for (n3 = 1; n3 <= 5; ++n3) {
            if (this.sHeadingStyles[n3] == null) continue;
            n4 = n3;
        }
        if (n4 == 0) {
            return;
        }
        if (n4 > headingMap.getMaxLevel()) {
            n4 = headingMap.getMaxLevel();
        }
        int n5 = n3 = this.config.formatting() == 2 ? 1 : 0;
        if (n3 != 0) {
            laTeXDocumentPortion.append("% Outline numbering").nl();
        } else {
            laTeXDocumentPortion.append("% Headings and outline numbering").nl().append("\\makeatletter").nl();
        }
        if (n3 == 0) {
            for (n2 = 1; n2 <= n4; ++n2) {
                if (this.sHeadingStyles[n2] == null || (officeStyle = this.wsc.getParStyle(this.sHeadingStyles[n2])) == null) continue;
                object = new BeforeAfter();
                BeforeAfter beforeAfter = new BeforeAfter();
                this.applyPageBreak((ParStyle)officeStyle, true, (BeforeAfter)object);
                this.palette.getCharSc().applyNormalFont((BeforeAfter)object);
                this.palette.getCharSc().applyFont((StyleWithProperties)officeStyle, true, true, (BeforeAfter)object, new Context());
                this.applyAlignment((ParStyle)officeStyle, false, true, (BeforeAfter)object);
                this.palette.getI18n().applyLanguage((StyleWithProperties)officeStyle, false, true, beforeAfter);
                this.palette.getCharSc().applyFontEffects((StyleWithProperties)officeStyle, true, beforeAfter);
                string2 = this.getLength((ParStyle)officeStyle, "fo:margin-top");
                string = this.getLength((ParStyle)officeStyle, "fo:margin-bottom");
                String string3 = this.getLength((ParStyle)officeStyle, "fo:margin-left");
                charSequence = headingMap.getName(n2);
                if (!beforeAfter.isEmpty()) {
                    laTeXDocumentPortion.append("\\newcommand\\cs").append((String)charSequence).append("[1]{").append(beforeAfter.getBefore()).append("#1").append(beforeAfter.getAfter()).append("}").nl();
                }
                laTeXDocumentPortion.append("\\renewcommand\\").append((String)charSequence).append("{\\@startsection{").append((String)charSequence).append("}{" + headingMap.getLevel(n2)).append("}{" + string3 + "}{");
                laTeXDocumentPortion.append(string2).append("}{").append(string).append("}{");
                laTeXDocumentPortion.append(((BeforeAfter)object).getBefore());
                if (!beforeAfter.isEmpty()) {
                    laTeXDocumentPortion.append("\\cs").append((String)charSequence);
                }
                laTeXDocumentPortion.append("}}").nl();
            }
        }
        if (n3 == 0) {
            laTeXDocumentPortion.append("\\renewcommand\\@seccntformat[1]{").append("\\csname @textstyle#1\\endcsname{\\csname the#1\\endcsname}").append("\\csname @distance#1\\endcsname}").nl();
        }
        n2 = n4;
        officeStyle = this.wsc.getOutlineStyle();
        object = new String[6];
        for (n = n4; n >= 1; --n) {
            object[n] = ListStyleConverter.numFormat(((ListStyle)officeStyle).getLevelProperty(n, "style:num-format"));
            if (object[n] != null && !"".equals(object[n])) continue;
            n2 = n - 1;
        }
        laTeXDocumentPortion.append("\\setcounter{secnumdepth}{" + n2 + "}").nl();
        for (n = 1; n <= n4; ++n) {
            if (object[n] == null || "".equals(object[n])) {
                if (n3 != 0) continue;
                laTeXDocumentPortion.append("\\newcommand\\@distance").append(headingMap.getName(n)).append("{}").nl().append("\\newcommand\\@textstyle").append(headingMap.getName(n)).append("[1]{#1}").nl();
                continue;
            }
            if (n3 == 0) {
                string2 = ((ListStyle)officeStyle).getLevelProperty(n, "text:min-label-distance");
                laTeXDocumentPortion.append("\\newcommand\\@distance").append(headingMap.getName(n)).append("{");
                if (string2 != null) {
                    laTeXDocumentPortion.append("\\hspace{").append(string2).append("{");
                }
                laTeXDocumentPortion.append("}").nl();
                string = ((ListStyle)officeStyle).getLevelProperty(n, "text:style-name");
                BeforeAfter beforeAfter = new BeforeAfter();
                if (n3 == 0) {
                    this.palette.getCharSc().applyTextStyle(string, beforeAfter, new Context());
                }
                laTeXDocumentPortion.append("\\newcommand\\@textstyle").append(headingMap.getName(n)).append("[1]{").append(beforeAfter.getBefore()).append("#1").append(beforeAfter.getAfter()).append("}").nl();
            }
            string2 = ((ListStyle)officeStyle).getLevelProperty(n, "style:num-prefix");
            string = ((ListStyle)officeStyle).getLevelProperty(n, "style:num-suffix");
            int n6 = Misc.getPosInteger(((ListStyle)officeStyle).getLevelProperty(n, "text:display-levels"), 1);
            laTeXDocumentPortion.append("\\renewcommand\\the").append(headingMap.getName(n)).append("{");
            charSequence = new StringBuffer();
            if (string2 != null) {
                ((StringBuffer)charSequence).append(string2);
            }
            for (int i = n - n6 + 1; i < n; ++i) {
                ((StringBuffer)charSequence).append(object[i]).append("{").append(ParStyleConverter.sectionName(i)).append("}").append(".");
            }
            ((StringBuffer)charSequence).append(object[n]).append("{").append(headingMap.getName(n)).append("}");
            if (string != null) {
                ((StringBuffer)charSequence).append(string);
            }
            if (n3 != 0) {
                laTeXDocumentPortion.append(((StringBuffer)charSequence).toString().trim());
            } else {
                laTeXDocumentPortion.append(((StringBuffer)charSequence).toString());
            }
            laTeXDocumentPortion.append("}").nl();
        }
        if (n3 == 0) {
            laTeXDocumentPortion.append("\\makeatother").nl();
        }
    }

    static final String sectionName(int n) {
        switch (n) {
            case 1: {
                return "section";
            }
            case 2: {
                return "subsection";
            }
            case 3: {
                return "subsubsection";
            }
            case 4: {
                return "paragraph";
            }
            case 5: {
                return "subparagraph";
            }
        }
        return null;
    }
}

