/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewDOMDocument
extends DOMDocument {
    public NewDOMDocument(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.write(this.getContentDOM().getDocumentElement(), 0, outputStreamWriter);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    private void write(Node node, int n, OutputStreamWriter outputStreamWriter) throws IOException {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                if (node.hasChildNodes()) {
                    int n2;
                    NodeList nodeList = node.getChildNodes();
                    int n3 = nodeList.getLength();
                    boolean bl = false;
                    if (n >= 0) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            bl |= nodeList.item(n2).getNodeType() == 3;
                        }
                    }
                    if (n >= 0) {
                        this.writeSpaces(n, outputStreamWriter);
                    }
                    outputStreamWriter.write("<" + node.getNodeName());
                    this.writeAttributes(node, outputStreamWriter);
                    outputStreamWriter.write(">");
                    if (n >= 0 && !bl) {
                        outputStreamWriter.write("\n");
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        int n4 = bl || n < 0 ? -1 : n + 1;
                        this.write(nodeList.item(n2), n4, outputStreamWriter);
                    }
                    if (n >= 0 && !bl) {
                        this.writeSpaces(n, outputStreamWriter);
                    }
                    outputStreamWriter.write("</" + node.getNodeName() + ">");
                    if (n < 0) break;
                    outputStreamWriter.write("\n");
                    break;
                }
                if (n >= 0) {
                    this.writeSpaces(n, outputStreamWriter);
                }
                outputStreamWriter.write("<" + node.getNodeName());
                this.writeAttributes(node, outputStreamWriter);
                outputStreamWriter.write(" />");
                if (n < 0) break;
                outputStreamWriter.write("\n");
                break;
            }
            case 3: {
                this.write(node.getNodeValue(), outputStreamWriter);
                break;
            }
            case 8: {
                if (n >= 0) {
                    this.writeSpaces(n, outputStreamWriter);
                }
                outputStreamWriter.write("<!-- ");
                this.write(node.getNodeValue(), outputStreamWriter);
                outputStreamWriter.write(" -->");
                if (n < 0) break;
                outputStreamWriter.write("\n");
            }
        }
    }

    private void writeAttributes(Node node, OutputStreamWriter outputStreamWriter) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            outputStreamWriter.write(" ");
            this.write(node2.getNodeName(), outputStreamWriter);
            outputStreamWriter.write("=\"");
            this.write(node2.getNodeValue(), outputStreamWriter);
            outputStreamWriter.write("\"");
        }
    }

    private void writeSpaces(int n, OutputStreamWriter outputStreamWriter) throws IOException {
        for (int i = 0; i < n; ++i) {
            outputStreamWriter.write("  ");
        }
    }

    private void write(String string, OutputStreamWriter outputStreamWriter) throws IOException {
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    outputStreamWriter.write("&lt;");
                    continue block7;
                }
                case '>': {
                    outputStreamWriter.write("&gt;");
                    continue block7;
                }
                case '&': {
                    outputStreamWriter.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    outputStreamWriter.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    outputStreamWriter.write("&apos;");
                    continue block7;
                }
                default: {
                    outputStreamWriter.write(c);
                }
            }
        }
    }
}

