/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XTextListener;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.QueryMetaData;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.report.Dataimport;
import com.sun.star.wizards.report.Finalizer;
import com.sun.star.wizards.report.GroupFieldHandler;
import com.sun.star.wizards.report.ReportDocument;
import com.sun.star.wizards.report.ReportLayouter;
import com.sun.star.wizards.ui.CommandFieldSelection;
import com.sun.star.wizards.ui.FieldSelection;
import com.sun.star.wizards.ui.SortingComponent;
import com.sun.star.wizards.ui.TitlesComponent;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import com.sun.star.wizards.ui.XCompletion;
import com.sun.star.wizards.ui.XFieldSelectionListener;
import java.util.Vector;

public class ReportWizard
extends WizardDialog
implements XTextListener,
XCompletion {
    XMultiServiceFactory xMSF;
    QueryMetaData CurDBMetaData;
    FieldSelection CurGroupFieldSelection;
    SortingComponent CurSortingComponent;
    UnoDialog CurUnoProgressDialog;
    TitlesComponent CurTitlesComponent;
    CommandFieldSelection CurDBCommandFieldSelection;
    GroupFieldHandler CurGroupFieldHandler;
    ReportLayouter CurReportLayouter;
    Finalizer CurReportFinalizer;
    public static String ReportPath;
    PropertyValue[] DBGPROPERTYVALUE;
    String sCommandName = "";
    int nCommandType = -1;
    int nReportMode = 1;
    String sReportName = "";
    public static final String SOREPORTFORMNAME = "ReportSource";
    final int SOSELGROUPLST = 33;
    final int SOTXTCOLTITLE = 48;
    final int SOTITLESCROLLBAR = 49;
    public static final int SONULLPAGE = 0;
    public static final int SOMAINPAGE = 1;
    public static final int SOTITLEPAGE = 2;
    public static final int SOGROUPPAGE = 3;
    public static final int SOSORTPAGE = 4;
    public static final int SOTEMPLATEPAGE = 5;
    public static final int SOSTOREPAGE = 6;
    ReportDocument CurReportDocument;
    static String sMsgWizardName;
    static String slblFields;
    static String slblSelFields;
    static String sShowBinaryFields;
    static String sGroupings;
    String[] WizardHeaderText = new String[6];
    static String[] WizardTitle;
    static String sWriterFilterName;
    static String slstDatabasesDefaultText;
    static String slstTablesDefaultText;
    static String sMsgErrorOccured;
    static String sMsgSavingImpossible;
    static String sMsgNoConnection;
    static String slblColumnTitles;
    static String slblColumnNames;
    static String sMsgNoConnectionforDataimport;
    static String sMsgQueryCreationImpossible;
    public static String sMsgFilePathInvalid;
    static String slblTables;
    public static String sBlindTextNote;
    public static boolean bCloseDocument;
    public boolean bHasEscapeProcessing = true;

    public ReportWizard(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory, 34320);
        super.addResourceHandler("Report Wizard", "dbw");
        if (this.getReportResources(false)) {
            Helper.setUnoPropertyValues(this.xDialogModel, new String[]{"Height", "Moveable", "Name", "PositionX", "PositionY", "Step", "TabIndex", "Title", "Width"}, new Object[]{new Integer(210), Boolean.TRUE, "DialogReport", new Integer(102), new Integer(41), new Integer(1), new Short(0), sMsgWizardName, new Integer(310)});
            this.drawNaviBar();
            this.setRightPaneHeaders(this.WizardHeaderText);
        }
    }

    @Override
    protected void enterStep(int n, int n2) {
        if (n >= 5 && n2 < 5) {
            this.CurReportDocument.oTextSectionHandler.removeTextSectionbyName("RecordSection");
            this.CurReportDocument.oTextTableHandler.removeTextTablebyName("Tbl_RecordSection");
        }
        switch (n2) {
            case 1: {
                this.CurDBCommandFieldSelection.setModified(false);
                break;
            }
            case 2: {
                this.CurTitlesComponent.initialize(this.CurReportDocument.CurDBMetaData.getFieldNames(), this.CurReportDocument.CurDBMetaData.getFieldTitleSet());
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.initialize();
                break;
            }
            case 4: {
                this.CurSortingComponent.initialize(this.CurReportDocument.CurDBMetaData.getFieldNames(), this.CurReportDocument.CurDBMetaData.SortFieldNames);
                this.CurSortingComponent.setReadOnlyUntil(this.CurReportDocument.CurDBMetaData.GroupFieldNames.length, false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.CurReportFinalizer.initialize(this.CurReportDocument.CurDBMetaData);
                break;
            }
        }
    }

    @Override
    protected void leaveStep(int n, int n2) {
        switch (n) {
            case 1: {
                this.CurReportDocument.CurDBMetaData.initializeFieldColumns(this.CurDBCommandFieldSelection.getSelectedFieldNames(), this.CurDBCommandFieldSelection.getSelectedCommandName());
                if (!this.CurDBCommandFieldSelection.isModified()) break;
                this.CurReportDocument.oTextSectionHandler.removeAllTextSections();
                this.CurReportDocument.oTextTableHandler.removeAllTextTables();
                this.CurReportDocument.DBColumnsVector = new Vector();
                this.CurReportDocument.CurDBMetaData.setGroupFieldNames(new String[0]);
                this.CurGroupFieldHandler.removeGroupFieldNames();
                break;
            }
            case 2: {
                this.CurReportDocument.CurDBMetaData.setFieldTitles(this.CurTitlesComponent.getFieldTitles());
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.getGroupFieldNames(this.CurReportDocument.CurDBMetaData);
                this.CurReportDocument.CurDBMetaData.prependSortFieldNames(this.CurReportDocument.CurDBMetaData.GroupFieldNames);
                break;
            }
            case 4: {
                this.CurReportDocument.CurDBMetaData.SortFieldNames = this.CurSortingComponent.getSortFieldNames();
                super.enablefromStep(5, true);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
        if (n < 5 && super.getNewStep() >= 5) {
            this.CurReportDocument.CurDBMetaData.setRecordFieldNames();
            this.CurReportLayouter.initialize(ReportPath + "/cnt-default.ott");
        }
    }

    private boolean executeQuery() {
        boolean bl = false;
        if (this.CurDBCommandFieldSelection.getSelectedCommandType() == 0) {
            bl = this.CurDBMetaData.oSQLQueryComposer.setQueryCommand(sMsgWizardName, this.xWindow, false, false);
            this.CurDBMetaData.Command = this.CurDBMetaData.oSQLQueryComposer.getQuery();
        } else {
            try {
                String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
                DBMetaData.CommandObject commandObject = this.CurDBMetaData.getQueryByName(string);
                this.bHasEscapeProcessing = this.CurDBMetaData.hasEscapeProcessing(commandObject.xPropertySet);
                String string2 = (String)commandObject.xPropertySet.getPropertyValue("Command");
                if (this.bHasEscapeProcessing) {
                    bl = !string2.equals("");
                    this.CurDBMetaData.oSQLQueryComposer.xQueryAnalyzer.setQuery(string2);
                    this.CurDBMetaData.oSQLQueryComposer.prependSortingCriteria();
                    this.CurDBMetaData.Command = this.CurDBMetaData.oSQLQueryComposer.getQuery();
                    bl = true;
                } else {
                    this.CurDBMetaData.Command = string2;
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        if (!bl) {
            super.vetoableChange(null);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string);
            ReportWizard reportWizard = new ReportWizard(xMultiServiceFactory);
            if (xMultiServiceFactory != null) {
                System.out.println("Connected to " + string);
                PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("DataSourceName", "MyTestDatabase")};
                reportWizard.startReportWizard(xMultiServiceFactory, propertyValueArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void buildSteps() {
        this.CurReportDocument.xProgressBar.setValue(30);
        this.CurDBCommandFieldSelection = new CommandFieldSelection(this, this.CurReportDocument.CurDBMetaData, 100, slblFields, slblSelFields, slblTables, true, 34330);
        this.CurDBCommandFieldSelection.addFieldSelectionListener(new FieldSelectionListener());
        this.insertLabel("lblBinaryFields", new String[]{"Height", "Label", "PositionX", "PositionY", "Step", "Width"}, new Object[]{new Integer(16), sShowBinaryFields, new Integer(95), new Integer(162), new Integer(1), new Integer(210)});
        this.CurReportDocument.xProgressBar.setValue(40);
        this.CurTitlesComponent = new TitlesComponent((WizardDialog)this, 2, 97, 37, 210, 7, slblColumnNames, slblColumnTitles, 34381);
        this.CurTitlesComponent.addTextListener(this);
        this.CurReportDocument.xProgressBar.setValue(50);
        this.CurGroupFieldHandler = new GroupFieldHandler(this.CurReportDocument, this);
        this.CurReportDocument.xProgressBar.setValue(60);
        this.CurSortingComponent = new SortingComponent(this, 4, 95, 30, 210, 34346);
        this.CurReportDocument.xProgressBar.setValue(70);
        this.CurReportLayouter = new ReportLayouter(this.CurReportDocument, this);
        this.CurReportDocument.xProgressBar.setValue(80);
        this.CurReportFinalizer = new Finalizer(this.CurReportDocument, this);
        this.CurReportDocument.xProgressBar.setValue(100);
        bCloseDocument = true;
        this.CurReportDocument.xProgressBar.end();
        this.enableNavigationButtons(false, false, false);
    }

    @Override
    public void finishWizard() {
        int n = this.getCurrentStep();
        if ((this.switchToStep(n, 6) || n == 6) && this.executeQuery() && this.CurReportFinalizer.finish()) {
            this.nReportMode = this.CurReportFinalizer.getReportOpenMode();
            this.sReportName = this.CurReportFinalizer.getStoreName();
            this.xDialog.endExecute();
        }
    }

    @Override
    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    public void insertQueryRelatedSteps() {
        this.setRMItemLabels(this.oResource, 2380);
        this.addRoadmap();
        int n = 0;
        n = this.insertRoadmapItem(0, true, this.oResource.getResText(2380), 1);
        n = this.insertRoadmapItem(n, false, this.oResource.getResText(2468), 2);
        n = this.insertRoadmapItem(n, false, this.oResource.getResText(2411), 3);
        n = this.insertRoadmapItem(n, false, this.oResource.getResText(2412), 4);
        n = this.insertRoadmapItem(n, false, this.oResource.getResText(2413), 5);
        n = this.insertRoadmapItem(n, false, this.oResource.getResText(2414), 6);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    public XComponent[] startReportWizard(XMultiServiceFactory xMultiServiceFactory, PropertyValue[] propertyValueArray) {
        XComponent[] xComponentArray = null;
        try {
            this.xMSF = xMultiServiceFactory;
            ReportPath = FileAccess.getOfficePath(this.xMSF, "Template", "share", "/wizard");
            ReportPath = FileAccess.combinePaths(this.xMSF, ReportPath, "/wizard/report");
            if (ReportPath.equals("")) {
                return xComponentArray;
            }
            this.DBGPROPERTYVALUE = propertyValueArray;
            this.CurReportDocument = new ReportDocument(this.xMSF, ReportPath + "/stl-default.ott", this.oResource);
            this.CurDBMetaData = this.CurReportDocument.CurDBMetaData;
            if (this.CurDBMetaData.getConnection(propertyValueArray)) {
                this.CurReportDocument.xProgressBar.setValue(20);
                this.CurDBMetaData.oSQLQueryComposer = new SQLQueryComposer(this.CurReportDocument.CurDBMetaData);
                this.buildSteps();
                this.CurDBCommandFieldSelection.preselectCommand(propertyValueArray, false);
                this.createWindowPeer(this.CurReportDocument.xWindowPeer);
                this.CurDBMetaData.setWindowPeer(this.xControl.getPeer());
                this.insertQueryRelatedSteps();
                short s = this.executeDialog(this.CurReportDocument.xFrame.getComponentWindow().getPosSize());
                boolean bl = true;
                switch (s) {
                    case 0: {
                        this.xComponent.dispose();
                        if (bCloseDocument) {
                            OfficeDocument.dispose(this.xMSF, this.CurReportDocument.xComponent);
                            return xComponentArray;
                        }
                        if (this.nReportMode == 2 || this.nReportMode == 3) {
                            bl = false;
                            this.CurReportDocument.CurDBMetaData.addReportDocument(this.CurReportDocument.xComponent, true);
                            boolean bl2 = this.nReportMode == 2;
                            xComponentArray = this.CurDBMetaData.openReportDocument(this.sReportName, true, bl2);
                        } else {
                            bl = false;
                            Dataimport dataimport = new Dataimport(this.xMSF);
                            dataimport.CurReportDocument = this.CurReportDocument;
                            dataimport.showProgressDisplay(this.xMSF, false);
                            this.importReportData(this.xMSF, dataimport);
                            xComponentArray = this.CurDBMetaData.openReportDocument(this.sReportName, false, false);
                        }
                        return xComponentArray;
                    }
                    case 1: {
                        if (!bl) break;
                        this.CurReportDocument.unlockallControllers();
                    }
                }
            }
            this.CurDBMetaData.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return xComponentArray;
    }

    public void importReportData(XMultiServiceFactory xMultiServiceFactory, Dataimport dataimport) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            bl2 = !this.bHasEscapeProcessing ? this.CurReportDocument.CurDBMetaData.executeCommand(1) : this.CurReportDocument.CurDBMetaData.executeCommand(2);
            if (bl2) {
                bl2 = this.CurReportDocument.CurDBMetaData.getFields(this.CurReportDocument.CurDBMetaData.getFieldNames(), false);
            }
            if (bl2) {
                dataimport.insertDatabaseDatatoReportDocument(xMultiServiceFactory);
            }
            if (this.CurReportFinalizer.getReportOpenMode() == 1) {
                bl = this.CurReportDocument.CurDBMetaData.storeDatabaseDocumentToTempPath(this.CurReportDocument.xComponent, this.CurReportFinalizer.getStoreName());
            }
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        dataimport.xComponent.dispose();
        if (bl) {
            this.CurReportDocument.CurDBMetaData.addReportDocument(this.CurReportDocument.xComponent, false);
        }
        this.CurReportDocument.CurDBMetaData.dispose();
    }

    public boolean getReportResources(boolean bl) {
        sMsgWizardName = this.oResource.getResText(2400);
        if (!bl) {
            sShowBinaryFields = this.oResource.getResText(2460);
            slstDatabasesDefaultText = this.oResource.getResText(1037);
            slstTablesDefaultText = this.oResource.getResText(1038);
            sMsgErrorOccured = this.oResource.getResText(1006);
            slblTables = this.oResource.getResText(2206);
            slblFields = this.oResource.getResText(2212);
            slblSelFields = this.oResource.getResText(2409);
            this.WizardHeaderText[0] = this.oResource.getResText(2428);
            this.WizardHeaderText[1] = this.oResource.getResText(2469);
            this.WizardHeaderText[2] = this.oResource.getResText(2429);
            this.WizardHeaderText[3] = this.oResource.getResText(2430);
            this.WizardHeaderText[4] = this.oResource.getResText(2431);
            this.WizardHeaderText[5] = this.oResource.getResText(2432);
            sMsgSavingImpossible = this.oResource.getResText(1030);
        }
        sMsgFilePathInvalid = this.oResource.getResText(1036);
        slblColumnTitles = this.oResource.getResText(2470);
        slblColumnNames = this.oResource.getResText(2471);
        sBlindTextNote = this.oResource.getResText(2475);
        sBlindTextNote = JavaTools.replaceSubString(sBlindTextNote, String.valueOf('\r'), "<BR>");
        return true;
    }

    public void enableRoadmapItems(boolean bl) {
        try {
            Object object = null;
            int n = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, "Step"));
            boolean bl2 = false;
            for (int i = 0; i < this.getRMItemCount(); ++i) {
                object = this.xIndexContRoadmap.getByIndex(i);
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(object, "ID"));
                bl2 = n2 > n ? bl : true;
                Helper.setUnoPropertyValue(object, "Enabled", new Boolean(bl2));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void enableWizardSteps(String[] stringArray) {
        boolean bl = stringArray.length > 0;
        this.setControlProperty("btnWizardNext", "Enabled", new Boolean(bl));
        this.setControlProperty("btnWizardFinish", "Enabled", new Boolean(bl));
        this.enableRoadmapItems(bl);
    }

    public void textChanged(TextEvent textEvent) {
        try {
            Object object = UnoDialog.getModel(textEvent.Source);
            String string = (String)Helper.getUnoPropertyValue(object, "Text");
            String string2 = this.CurTitlesComponent.getFieldNameByTitleControl(object);
            this.CurReportDocument.oTextFieldHandler.changeUserFieldContent(string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void disposing(EventObject eventObject) {
    }

    @Override
    public void setmodified(int n, Object object, Object object2) {
        switch (n) {
            case 1: {
                break;
            }
        }
    }

    private void toggleSortingPage() {
        boolean bl;
        int n = this.CurDBCommandFieldSelection.getSelectedCommandType();
        boolean bl2 = bl = n == 0;
        if (!bl) {
            String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
            DBMetaData.CommandObject commandObject = this.CurDBMetaData.getQueryByName(string);
            bl = this.CurDBMetaData.hasEscapeProcessing(commandObject.xPropertySet);
        }
        super.setStepEnabled(4, bl);
    }

    static {
        WizardTitle = new String[6];
    }

    public class FieldSelectionListener
    implements XFieldSelectionListener {
        protected int ID;

        @Override
        public int getID() {
            return this.ID;
        }

        @Override
        public void setID(String string) {
            this.ID = 1;
            if (string != null && !string.equals("") && !string.equals("_")) {
                String string2 = JavaTools.ArrayoutofString(string, "_")[1];
                this.ID = Integer.parseInt(string2);
            }
        }

        @Override
        public void shiftFromLeftToRight(String[] stringArray, String[] stringArray2) {
            if (this.ID == 1) {
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
                ReportWizard.this.enableWizardSteps(stringArray2);
                ReportWizard.this.toggleSortingPage();
            } else {
                boolean bl = ReportWizard.this.CurGroupFieldSelection.getSelectedFieldNames().length > 0;
                Helper.setUnoPropertyValue(ReportWizard.this.getRoadmapItemByID(3), "Enabled", new Boolean(bl));
            }
        }

        @Override
        public void shiftFromRightToLeft(String[] stringArray, String[] stringArray2) {
            if (this.ID == 1) {
                ReportWizard.this.enableWizardSteps(stringArray2);
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
            } else {
                boolean bl = ReportWizard.this.CurGroupFieldSelection.getSelectedFieldNames().length > 0;
                Helper.setUnoPropertyValue(ReportWizard.this.getRoadmapItemByID(3), "Enabled", new Boolean(bl));
            }
        }

        @Override
        public void moveItemDown(String string) {
        }

        @Override
        public void moveItemUp(String string) {
        }
    }
}

