( cd usr/bin ; rm -rf bvnc )
( cd usr/bin ; ln -sf bssh bvnc )
( cd usr/bin ; rm -rf avahi-resolve-address )
( cd usr/bin ; ln -sf avahi-resolve avahi-resolve-address )
( cd usr/bin ; rm -rf avahi-browse-domains )
( cd usr/bin ; ln -sf avahi-browse avahi-browse-domains )
( cd usr/bin ; rm -rf avahi-publish-service )
( cd usr/bin ; ln -sf avahi-publish avahi-publish-service )
( cd usr/bin ; rm -rf bshell )
( cd usr/bin ; ln -sf bssh bshell )
( cd usr/bin ; rm -rf avahi-resolve-host-name )
( cd usr/bin ; ln -sf avahi-resolve avahi-resolve-host-name )
( cd usr/bin ; rm -rf avahi-publish-address )
( cd usr/bin ; ln -sf avahi-publish avahi-publish-address )
( cd usr/lib ; rm -rf libavahi-client.so )
( cd usr/lib ; ln -sf libavahi-client.so.3.2.4 libavahi-client.so )
( cd usr/lib ; rm -rf libavahi-ui.so )
( cd usr/lib ; ln -sf libavahi-ui.so.0.1.0 libavahi-ui.so )
( cd usr/lib ; rm -rf libavahi-core.so.5 )
( cd usr/lib ; ln -sf libavahi-core.so.5.0.4 libavahi-core.so.5 )
( cd usr/lib ; rm -rf libavahi-glib.so.1 )
( cd usr/lib ; ln -sf libavahi-glib.so.1.0.1 libavahi-glib.so.1 )
( cd usr/lib ; rm -rf libavahi-ui.so.0 )
( cd usr/lib ; ln -sf libavahi-ui.so.0.1.0 libavahi-ui.so.0 )
( cd usr/lib ; rm -rf libavahi-glib.so )
( cd usr/lib ; ln -sf libavahi-glib.so.1.0.1 libavahi-glib.so )
( cd usr/lib ; rm -rf libavahi-gobject.so.0 )
( cd usr/lib ; ln -sf libavahi-gobject.so.0.0.0 libavahi-gobject.so.0 )
( cd usr/lib ; rm -rf libavahi-common.so )
( cd usr/lib ; ln -sf libavahi-common.so.3.5.0 libavahi-common.so )
( cd usr/lib ; rm -rf libavahi-common.so.3 )
( cd usr/lib ; ln -sf libavahi-common.so.3.5.0 libavahi-common.so.3 )
( cd usr/lib ; rm -rf libavahi-gobject.so )
( cd usr/lib ; ln -sf libavahi-gobject.so.0.0.0 libavahi-gobject.so )
( cd usr/lib ; rm -rf libavahi-client.so.3 )
( cd usr/lib ; ln -sf libavahi-client.so.3.2.4 libavahi-client.so.3 )
( cd usr/lib ; rm -rf libavahi-core.so )
( cd usr/lib ; ln -sf libavahi-core.so.5.0.4 libavahi-core.so )
( cd usr/man/man1 ; rm -rf avahi-resolve-host-name.1 )
( cd usr/man/man1 ; ln -sf avahi-resolve.1 avahi-resolve-host-name.1 )
( cd usr/man/man1 ; rm -rf avahi-publish-address.1 )
( cd usr/man/man1 ; ln -sf avahi-publish.1 avahi-publish-address.1 )
( cd usr/man/man1 ; rm -rf avahi-publish-service.1 )
( cd usr/man/man1 ; ln -sf avahi-publish.1 avahi-publish-service.1 )
( cd usr/man/man1 ; rm -rf bvnc.1 )
( cd usr/man/man1 ; ln -sf bssh.1 bvnc.1 )
( cd usr/man/man1 ; rm -rf avahi-resolve-address.1 )
( cd usr/man/man1 ; ln -sf avahi-resolve.1 avahi-resolve-address.1 )
( cd usr/man/man1 ; rm -rf avahi-browse-domains.1 )
( cd usr/man/man1 ; ln -sf avahi-browse.1 avahi-browse-domains.1 )

#!/bin/sh

##
## Configuration Preservation
##

ldconfig -r .

function install_file() {
  # $1 = File to process

  FILE="$(dirname "$1")/$(basename "$1" .new)"
  if [ ! -e "$FILE" ]
  then
    mv "$FILE.new" "$FILE"
  elif [ "$(cat "$FILE" | md5sum)" != "$(cat "$FILE.new" | md5sum)" ]
  then
    #     |--------|--------------------------------------------------|
    echo "WARNING: $FILE has been customised."
    echo "         Examine the $FILE.new file"
    echo "         and integrate any changes into the custom file."
    echo
  else
    rm -f "$FILE.new"
  fi
}

install_file etc/rc.d/rc.avahidaemon.new
install_file etc/rc.d/rc.avahidnsconfd.new
install_file etc/dbus-1/system.d/avahi-dbus.conf.new

##
## Modify passwd and group to add avahi and netdev groups
##

##
## If the avahi user don't exist, add them:
## 
if grep "^avahi:x:" etc/passwd 1> /dev/null 2> /dev/null ; then
  true
else
  echo "avahi:x:86:86:avahi:/etc/avahi:" >> etc/passwd
fi
if grep "^avahi:" etc/shadow 1> /dev/null 2> /dev/null ; then
  true
else
  echo "avahi:*:86:0:::::" >> etc/shadow
fi

##
## If the avahi group don't exist, add them:
## 
if grep "^avahi::" etc/group 1> /dev/null 2> /dev/null ; then
  true
else
  echo "avahi::86:avahi" >> etc/group
fi

##
## If the netdev group don't exist, add them:
## 
if grep "^netdev::" etc/group 1> /dev/null 2> /dev/null ; then
  true
else
  echo "netdev::85:avahi" >> etc/group
fi

##
## If rc.local doesn't exist, create it
##
if [ ! -e etc/rc.d/rc.local ]; then
	echo "#!/bin/sh" > etc/rc.d/rc.local
	chmod 755 etc/rc.d/rc.local
fi

##
## If rc.local_shutdown doesn't exist, create it
##
if [ ! -e etc/rc.d/rc.local_shutdown ]; then
	echo "#!/bin/sh" > etc/rc.d/rc.local_shutdown
	chmod 755 etc/rc.d/rc.local_shutdown
fi
	
# If rc.avahi is executable, run it on startup
run=`grep ". /etc/rc.d/rc.avahidaemon" etc/rc.d/rc.local`
if [ "${run}" == "" ]; then	
cat << EOF >> etc/rc.d/rc.local

# To disable avahi, chmod rc.avahidaemon to 644
if [ -x /etc/rc.d/rc.avahidaemon -a -x /etc/rc.d/rc.avahidnsconfd ]; then
  . /etc/rc.d/rc.avahidaemon start
  . /etc/rc.d/rc.avahidnsconfd start
fi
EOF
fi

# If rc.avahi is executable, make sure to shutdown properly
run=`grep ". /etc/rc.d/rc.avahidaemon" etc/rc.d/rc.local_shutdown`
if [ "${run}" == "" ]; then	
cat << EOF >> etc/rc.d/rc.local_shutdown

# To disable avahi shutdown, chmod rc.avahidaemon to 644
if [ -x /etc/rc.d/rc.avahidaemon -a -x /etc/rc.d/rc.avahidnsconfd ]; then
  . /etc/rc.d/rc.avahidaemon stop
  . /etc/rc.d/rc.avahidnsconfd stop
fi
EOF
fi

##
## Update Desktop Database with Avahi .desktops
##
if [ -x usr/bin/update-desktop-database ]; then
  usr/bin/update-desktop-database 1> /dev/null 2> /dev/null
fi

## 
## Complain if dbus somehow was removed, and disable autostart.
##
if [ ! -f etc/rc.d/rc.messagebus ]; then
	echo "Avahi requires dbus.  You appear to be missing /etc/rc.d/rc.messagebus."
	echo "Perhaps you need to reinstall the dbus package?"
	chmod -x etc/rc.d/rc.avahi*
fi;

## 
## Make dbus executable if avahi is installed
##
if [ ! -x etc/rc.d/rc.messagebus ]; then
	chmod +x etc/rc.d/rc.messagebus;
fi;

##
## Restart dbus (reload avahi info), and start services
##
if [ -x etc/rc.d/rc.messagebus ]; then
	chmod +x etc/rc.d/rc.avahi*;
fi;

#By default, disable avahi at runtime.  Users must enable if they wish.
#chmod -x etc/rc.d/rc.avahi*;

#By default, enable avahi at runtime.  More and more of GNOME is using it
chmod +x etc/rc.d/rc.avahi*;
