#!/usr/bin/env python

############################################################################
#    Copyright (C) 2007 by Giovanni Bezicheri   #
#    ioannissecundi@gmail.com   #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import sys
import os
import support
import glob
import gobject
import gtkrcengine
import savedialog
import previewdialog
import commands

try:
 	import pygtk
  	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)
	
class MurrineConfigurator:
	"""Murrine configurator class"""
	def __init__(self):
		pathname = os.path.dirname(sys.argv[0])
		self.WORKDIR = os.path.abspath(pathname)
		self.currdir = os.getcwd()
		# load from glade
		self.gladefile = self.WORKDIR + "/murrine-config.glade"
		self.glade = gtk.glade.XML(self.gladefile, "appwindow")
		self.dlg = self.glade.get_widget("appwindow")
		self.themesScrollbar = self.glade.get_widget("themesScrollbar")
		self.infoLabel = self.glade.get_widget("infoLabel")
		self.glazeLabel = self.glade.get_widget("glazeLabel")
		frame0 = self.glade.get_widget("frame0")
		self.engine = gtkrcengine.GtkrcEngine()
		# init and place options lists gui
		self.selection = None # prec selection in save dialog
		self.previewShow = False # preview is show or not
		self.themesView = gtk.TreeView()
		self.themesView.set_size_request(410, 222)
		frame0.add(self.themesView)
		self.themesView.show()
		self.previewDialog = None
		self.previewPage = 0
		self.optionSelected = None
		# set position
		self.dlg.move(self.dlg.get_position()[0] + 180, self.dlg.get_position()[1])
		# show all
		self.dlg.show_all
		# apply models
		self.themesScrollbar.connect('value-changed', self.onScroll, self.themesView)
		self.themesView.connect('scroll-event', self.onScrollEvent)
		# themes
		dir = os.chdir(os.environ.get("HOME") + "/.themes") # chdir ~/.themes
		self.infoLabel.set_text("Here are shown the Murrine placed in " + os.getcwd() + "\nClick on column header to sort themes or type first letters of your\nsearch's target to find it.")
		self.themesView.set_model(self.makeThemesFileModel())
		os.chdir(self.currdir) # restore dir
		self.initView("", "Themes").connect('toggled', self.onToggle)
		self.themesView.get_column(1).clicked()
		# connections
		connections = {"on_mainWindow_destroy" : gtk.main_quit
				, "closeDialog" : gtk.main_quit, 
				"saveConfig" : self.saveConfig,
				"preview" : self.preview}
		self.glade.signal_autoconnect(connections)
		# manage groups
		self.glazeGroup = support.RadioWrapper("glazestyle", ["Flat Hilight","Curved Hilight","Concave style","Top Curved Hilight","Beryl Hilight"],self.glade.get_widget("glazeFlat"), self.engine, self)
		self.animationGroup = support.RadioWrapper("animation", ["Disable","Enable"],self.glade.get_widget("animationEnable"), self.engine, self)
		self.menubarGroup = support.RadioWrapper("menubarstyle", ["Flat","Glassy (it follows selected glazestyle)","Gradient","Striped"],self.glade.get_widget("menubarFlat"), self.engine, self)
		self.menubaritemsGroup = support.RadioWrapper("menubaritemsstyle", ["Menuitem look","Button look"],self.glade.get_widget("menubaritemsMenuitem"), self.engine, self)
		self.menuitemsGroup = support.RadioWrapper("menuitemsstyle", ["Flat","Glassy (it follows selected glazestyle)", "Striped"],self.glade.get_widget("menuitemsFlat"), self.engine, self)
		self.listviewheadersGroup = support.RadioWrapper("listviewheadersstyle", ["Flat","Glassy (it follows selected glazestyle)", "Raised"],self.glade.get_widget("listviewHeadersFlat"), self.engine, self)
		self.listviewGroup = support.RadioWrapper("listviewstyle", ["Nothing (completely flat)","Dotted separators"],self.glade.get_widget("listviewSepMenuitem"), self.engine, self)
		self.scrollbarGroup = support.RadioWrapper("scrollbarstyle", ["Nothing added","Circles","Handles","Diagonal stripes", "Diagonal stripes and handles","Horizontal stripes","Horizontal stripes and handles"],self.glade.get_widget("scrollbarNothing"), self.engine, self)
		self.gradientsGroup = support.RadioWrapper("gradients", ["Disable","Enable"],self.glade.get_widget("gradientsEnable"), self.engine, self)
		# init roundness combo
		self.roundnessGroup = support.ComboWrapper("roundnessstyle",self.glade.get_widget("roundness"), self.engine, self)
		# init hilight scale
		self.hilightGroup = support.ScaleWrapper("hilight_ratio", 1, self.glade.get_widget("hilightRatio"), self.engine)
		self.contrastGroup = support.ScaleWrapper("contrast", 1, self.glade.get_widget("contrastRatio"), self.engine)
		# menus vertical bar controls
		self.menuvbarGroup = support.RadioWrapper("menustyle", ["Disable","Enable"],self.glade.get_widget("verticalbarGroup"), self.engine, self)
		# color controls
		self.scrollbarCB = support.colorWrapper( "scrollbar_color", self.glade.get_widget("scrollbarColorButton"), self.engine, self)
		
		
	def onScroll(self, range, view):
		view.scroll_to_point(0, int(range.get_value()))
	def onScrollEvent(self, view, event):
		if event.direction == gtk.gdk.SCROLL_UP:
			self.themesScrollbar.set_value(self.themesScrollbar.get_value() - 10)
		else:
			self.themesScrollbar.set_value(self.themesScrollbar.get_value() + 10)
	def makeThemesFileModel(self):
		# makes theme file list model
		themesFileList = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)
		for theme in glob.glob('*Murrina*'):
			themesFileList.append([False, theme])
		self.themesScrollbar.set_range(0, len(themesFileList)*20)
		return themesFileList
	def initView(self, caption1 = "", caption2 = ""):
		self.themesView.set_rules_hint(True)
		cellToggle = gtk.CellRendererToggle()
		cellText = gtk.CellRendererText()
		column1 = gtk.TreeViewColumn("")
		column1.pack_start(cellToggle, True)
		column1.set_attributes(cellToggle, active = 0)
		cellToggle.set_radio(True)
		self.themesView.get_selection().set_mode(gtk.SELECTION_NONE)
		column1.set_clickable(True)
		column2 = gtk.TreeViewColumn(caption2)
		column2.pack_end(cellText, True)
		column2.set_attributes(cellText, text = 1)
		column1.set_clickable(False)
		self.themesView.set_enable_search(True)
		self.themesView.set_search_column(1)
		# sorting
		column2.set_sort_column_id(1)
		column2.set_sort_order(gtk.SORT_ASCENDING)
		column2.set_sort_indicator(True)
		# append columns
		self.themesView.append_column(column1)
		self.themesView.append_column(column2)
		return cellToggle
	def resetToggle(self, model, path, iter, n):
		if int(n) != int(path[0]):
			model.set_value(iter, 0, False)
	def onToggle(self, object, path):
		self.themesView.get_model().set_value(self.themesView.get_model().get_iter(path), 0, True)
		iter = self.themesView.get_model().get_iter("0")
		self.themesView.get_model().foreach(self.resetToggle, path)
		self.optionSelected = str(self.themesView.get_model().get_value(self.themesView.get_model().get_iter(path), 1)) # working theme
		self.engine.setrc(os.environ.get("HOME") + "/.themes/" + self.optionSelected + "/gtk-2.0/gtkrc", self.optionSelected)
		self.glazeGroup.initStatus()
		self.menubarGroup.initStatus()
		self.menubaritemsGroup.initStatus()
		self.menuitemsGroup.initStatus()
		self.animationGroup.initStatus()
		self.listviewheadersGroup.initStatus()
		self.listviewGroup.initStatus()
		self.scrollbarGroup.initStatus()
		self.roundnessGroup.initStatus()
		self.gradientsGroup.initStatus()
		self.contrastGroup.initStatus()
		self.hilightGroup.initStatus()
		self.menuvbarGroup.initStatus()
		self.scrollbarCB.initStatus()
	def writeProperties(self):
		self.glazeGroup.writeProperty()
		self.menubarGroup.writeProperty()
		self.menubaritemsGroup.writeProperty()
		self.menuitemsGroup.writeProperty()
		self.animationGroup.writeProperty()
		self.listviewheadersGroup.writeProperty()
		self.listviewGroup.writeProperty()
		self.scrollbarGroup.writeProperty()
		self.roundnessGroup.writeProperty()
		self.gradientsGroup.writeProperty()
		self.contrastGroup.writeProperty()
		self.hilightGroup.writeProperty()
		self.menuvbarGroup.writeProperty()
		self.scrollbarCB.writeProperty()
	def saveConfig(self, widget):
		self.writeProperties()
		savedialog.SaveDialog(self, self.optionSelected, self.engine) # save dialog
	def preview(self, widget):
		if self.optionSelected != None:
			if self.previewShow == False:
				self.writeProperties()
				self.previewDialog = previewdialog.PreviewDialog(self.dlg, self.engine.getRcStyle(), self, self.previewPage) # preview dialog
				self.previewShow = True
			else:
				self.previewPage = self.previewDialog.getCurrPage()
				self.previewDialog.closeDialog(None)
				self.previewShow = False
	def updatePreview(self):
		if self.previewShow == True:
			page = self.previewDialog.getCurrPage()
			self.previewDialog.closeDialog(None)
			self.writeProperties()
			style = self.dlg.get_style()
			self.previewDialog = previewdialog.PreviewDialog(self.dlg, self.engine.getRcStyle(), self, page) # preview dialog
			self.dlg.set_style(style)

if __name__ == "__main__":
	configurator = MurrineConfigurator()
	gtk.main()