############################################################################
#    Copyright (C) 2007 by Giovanni Bezicheri   #
#    ioannissecundi@gmail.com   #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import sys
import os
import support
import gobject

try:
	import pygtk
	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)
	
class PreviewDialog:
	"""a dialog to show previews"""
	def __init__(self, widget, style, mainwnd, tab = 0):
		# parse style
		pathname = os.path.dirname(sys.argv[0])
		self.WORKDIR = os.path.abspath(pathname)
		# load from glade
		self.gladefile = self.WORKDIR + "/preview.glade"
		self.glade = gtk.glade.XML(self.gladefile, "previewDialog")
		self.dlg = self.glade.get_widget("previewDialog")
		self.view = self.glade.get_widget("treeview")
		self.viewscrollbar = self.glade.get_widget("vscrollbar")
		self.notebook = self.glade.get_widget("notebook")
		self.treeviewLabel = self.glade.get_widget("treeviewLabel")
		self.dlg.reset_rc_styles()
		gtk.rc_parse_string(style)
		self.dlg.modify_style(self.dlg.get_modifier_style())
		# set position
		self.dlg.move(20, 20)
		self.dlg.move(widget.get_position()[0] - 430, widget.get_position()[1])
		# connections
		self.dlg.show_all()
		# init widgets
		self.initView()
		self.view.set_model(self.makeModel())
		self.viewscrollbar.connect('value-changed', self.onScroll, self.view)
		self.view.connect('scroll-event', self.onScrollEvent)
		self.notebook.set_current_page(tab)
		self.treeviewLabel.set_markup("In the bottom window you can see a typical series of\nwidget displayed with <b>" + mainwnd.optionSelected + "</b> theme.\n")
			
	def closeDialog(self, widget):
		self.dlg.destroy()
	def getCurrPage(self):
		return self.notebook.get_current_page()
	def initView(self):
		self.view.set_rules_hint(True)
		cellText = gtk.CellRendererText()
		column1 = gtk.TreeViewColumn("Column1")
		column1.pack_start(cellText, True)
		column1.set_attributes(cellText, text = 0)
		column1.set_clickable(False)
		column2 = gtk.TreeViewColumn("Column2")
		column2.pack_end(cellText, True)
		column2.set_attributes(cellText, text = 1)
		column2.set_clickable(False)
		# append columns
		self.view.append_column(column1)
		self.view.append_column(column2)
	def makeModel(self):
		# makes an example model
		list = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
		for n in range(50):
			list.append(["item " + str(n), "item " + str(n)])
		self.viewscrollbar.set_range(0, len(list)*25)
		return list
	def onScroll(self, range, view):
		view.scroll_to_point(0, int(range.get_value()))
	def onScrollEvent(self, view, event):
		if event.direction == gtk.gdk.SCROLL_UP:
			self.viewscrollbar.set_value(self.viewscrollbar.get_value() - 10)
		else:
			self.viewscrollbar.set_value(self.viewscrollbar.get_value() + 10)