############################################################################
#    Copyright (C) 2007 by Giovanni Bezicheri   #
#    ioannissecundi@gmail.com   #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import sys
import gtkrcengine
import os
import support

try:
	import pygtk
	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)

class SaveDialog:
	"""a dialog to save config changes"""
	def __init__(self, caller, theme, rcEngine):
		self.theme = theme
		self.engine = rcEngine
		self.caller = caller
		if self.caller.selection == None:
			pathname = os.path.dirname(sys.argv[0])
			self.WORKDIR = os.path.abspath(pathname)
			# load from glade
			self.gladefile = self.WORKDIR + "/savedialog.glade"
			self.glade = gtk.glade.XML(self.gladefile, "saveDialog")
			self.dlg = self.glade.get_widget("saveDialog")
			# connections
			connections = {"on_mainWindow_destroy" : gtk.main_quit
					, "closeDialog" : self.closeDialog, "accept" : self.onAccept}
			self.glade.signal_autoconnect(connections)
			# init widgets
			self.label1 = self.glade.get_widget("label1")
			self.frame1 = self.glade.get_widget("frame1")
			self.dlg.set_title("Configuration for " + self.theme + " done!")
			self.label1.set_markup("Now you can choose the theme into the your theme manager to load your new configuration.\n\nWould you like to use <b>" + self.theme + "</b> now?")
			self.themesEngineView = support.RoundTreeMetaView("Desktop Environment", None)
			self.themesEngineView.set_size_request(517, 133)
			self.frame1.add(self.themesEngineView)
			self.themesEngineView.set_model(support.makeModel(["Gnome", "Xfce", "None - ~/.gtkrc"], ["Gnome", "Xfce", "None - ~/.gtkrc"]))
			self.themesEngineView.show()
			self.dlg.show_all
		else:
			self.save(self.caller.selection)
			
	def closeDialog(self, widget):
		self.dlg.destroy()
	def onAccept(self, widget):
		self.save(str(self.themesEngineView.getOptionSelected()))
		self.closeDialog(widget)
	def save(self, option):
		if self.caller.selection == None:
			self.caller.selection = str(self.themesEngineView.getOptionSelected())
		self.engine.writeChanges()
		if option == "Gnome":
			self.engine.writeGnome()
		elif option == "Xfce":
			self.engine.writeXfce()
		else:
			self.engine.writeGtk2()