############################################################################
#    Copyright (C) 2007 by Giovanni Bezicheri   #
#    ioannissecundi@gmail.com   #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import sys
import os
import gobject

try:
	import pygtk
	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)
	
class RoundTreeMetaView(gtk.TreeView):
	"""Generic window to select options"""
	def initView(self):
		self.set_rules_hint(True)
		cellToggle = gtk.CellRendererToggle()
		cellText = gtk.CellRendererText()
		column1 = gtk.TreeViewColumn("")
		column1.pack_start(cellToggle, True)
		column1.set_attributes(cellToggle, active = 0)
		cellToggle.set_radio(True)
		self.get_selection().set_mode(gtk.SELECTION_NONE)
		column1.set_clickable(True)
		column2 = gtk.TreeViewColumn(self.caption1)
		column2.pack_end(cellText, True)
		column2.set_attributes(cellText, text = 1)
		if self.caption2 != None:
			column3 = gtk.TreeViewColumn(self.caption2)
			column3.pack_end(cellText, True)
			column3.set_attributes(cellText, text = 2)
		self.append_column(column1)
		self.append_column(column2)
		if self.caption2 != None:
			self.append_column(column3)
		return cellToggle
	def resetToggle(self, model, path, iter, n):
		if int(n) != int(path[0]):
			model.set_value(iter, 0, False)
	def onToggle(self, object, path):
		self.get_model().set_value(self.get_model().get_iter(path), 0, True)
		iter = self.get_model().get_iter("0")
		self.get_model().foreach(self.resetToggle, path)
		self.optionSelected = str(self.get_model().get_value(self.get_model().get_iter(path), 1))
	def initControl(self):
		self.initView().connect('toggled', self.onToggle)
	def __init__(self, caption1 = "Value", caption2 = "Description"):
		gtk.TreeView.__init__(self)
		self.caption1 = caption1
		self.caption2 = caption2
		self.initControl()
	def resetAll(self, model, path, iter):
		model.set_value(iter, 0, False)
	def getOptionSelected(self):
		return self.optionSelected
	def initStatus(self, value):
		self.get_model().foreach(self.resetAll)
		if value == None:
			pass
		else:
			self.get_model().set_value(self.get_model().get_iter_from_string(str(value)), 0, True)

class RoundTreeView(RoundTreeMetaView):
	"""Window with specific behaviour"""
	def __init__(self, rcEngine, property, caption1 = "Value", caption2 = "Description"):
		RoundTreeMetaView.__init__(self, caption1, caption2)
		self.property = property
		self.caption1 = caption1
		self.caption2 = caption2
		self.rcEngine = rcEngine
	def onToggle(self, object, path):
		RoundTreeMetaView.onToggle(self, object, path)
		self.rcEngine.setStyleOpt(self.property, path)
	def initControl(self):
		self.initView().connect('toggled', self.onToggle)
	def initStatus(self):
		opt = self.rcEngine.getStyleOpt(self.property)
		RoundTreeMetaView.initStatus(self, opt)

def makeModel(ordOptList, values = None):
	list = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_STRING)
	n = 0
	for opt in ordOptList:
		if values != None:
			list.append([False, str(values[n]), str(opt)])
		else:
			list.append([False, str(n), str(opt)])
		n = n + 1
	return list
	
class RadioWrapper:
	"""a wrapper to manage init and control of radio buttons' groups"""
	def __init__(self, property, values, master, engine, mainwnd):
		self.engine = engine
		self.property = property
		self.master = master
		self.values = values
		self.activeRadio = None
		self.config = False
		self.mainwnd = mainwnd
		for b in master.get_group():
			b.connect("toggled", self.onToggle, b.get_label()) # connects radio
	def onToggle(self, button, data):
		self.activeRadio = data # keep active radio label
		if self.config:
			self.master.set_inconsistent(False)
			self.mainwnd.updatePreview() # update preview
	def writeProperty(self):
		# find match property value and write it
		if self.activeRadio != None:
			n = 0
			for i in self.values:
				if str(i) == str(self.activeRadio):
					self.engine.setStyleOpt(self.property, str(n))
					return
				n = n + 1
	def initStatus(self):
		try:
			self.master.set_inconsistent(False)
			self.checkMatches(self.engine.getStyleOpt(self.property)).set_active(True)
		except:
			self.master.set_inconsistent(True)
		self.config = True
	def checkMatches(self, pvalue):
		# ret button by property value
		for b in self.master.get_group():
			if str(b.get_label()) == str(self.values[int(pvalue)]):
				return b
			
class ComboWrapper:
	"""a wrapper to manage init and control of combo groups"""
	def __init__(self, property, master, engine, mainwnd):
		self.engine = engine
		self.property = property
		self.master = master
		self.mainwnd = mainwnd
		self.config = False
		self.master.connect("changed", self.onChange)
	def writeProperty(self):
		if self.master.get_active() != -1:
			self.engine.setStyleOpt(self.property, str(self.master.get_active()))
	def initStatus(self):
		try:
			self.master.set_active(int(self.engine.getStyleOpt(self.property)))
		except:
			pass
		self.config = True
	def onChange(self, value):
		if self.config:
			self.mainwnd.updatePreview() # update preview
		
class ScaleWrapper:
	"""a wrapper to manage init and control of scale groups"""
	def __init__(self, property, defvalue, master, engine):
		self.engine = engine
		self.property = property
		self.master = master
		self.defvalue = defvalue
	def initStatus(self):
		try:
			self.master.set_value(float(self.engine.getStyleOpt(self.property)))
		except:
			self.master.set_value(float(self.defvalue)) # if the option isn't present set to def value
	def writeProperty(self):
		self.engine.setStyleOpt(self.property, str(self.master.get_value()))
class colorWrapper:
	"""a wrapper to manage init and control of color button"""
	def __init__(self, property, master, engine, mainwnd):
		self.engine = engine
		self.property = property
		self.master = master
		self.config = False
		self.mainwnd = mainwnd
		self.master.connect("color-set", self.onChange)
	def initStatus(self):
		try:
			self.master.set_color(gtk.gdk.color_parse(self.engine.getStyleOpt(self.property)))
		except:
			self.master.set_sensitive(False) # if the option isn't present set to def value
		self.config = True
	def writeProperty(self):
		self.engine.setStyleOpt(self.property, '"' + gtk.color_selection_palette_to_string([self.master.get_color()]) + '"')
	def onChange(self, button):
		if self.config:
			self.mainwnd.updatePreview() # update preview
