/* Generated from telepathy-glib



 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 *
TpConnMgrParamFlags:
 * @TP_CONN_MGR_PARAM_FLAG_REQUIRED: <![CDATA[           This parameter is required for connecting to the server.         ]]>
 * @TP_CONN_MGR_PARAM_FLAG_REGISTER: <![CDATA[           This parameter is required for registering an account on the           server.         ]]>
 * @TP_CONN_MGR_PARAM_FLAG_HAS_DEFAULT: <![CDATA[           This parameter has a default value, which is returned in           GetParameters; not providing this parameter is equivalent to           providing the default.         ]]>
 * @TP_CONN_MGR_PARAM_FLAG_SECRET: <![CDATA[           This parameter should be considered private or secret; for             instance, clients should store it in a "password safe" like             gnome-keyring or kwallet, omit it from debug logs, and use a             text input widget that hides the value of the parameter.            (Clients that support older connection managers may also treat             any parameter whose name contains "password" as though it had this             flag.)         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CONN_MGR_PARAM_FLAG_REQUIRED = 1,
    TP_CONN_MGR_PARAM_FLAG_REGISTER = 2,
    TP_CONN_MGR_PARAM_FLAG_HAS_DEFAULT = 4,
    TP_CONN_MGR_PARAM_FLAG_SECRET = 8,
} TpConnMgrParamFlags;

/**
 *
TpHandleType:
 * @TP_HANDLE_TYPE_NONE: <![CDATA[           A "null" handle type used to indicate the absence of a handle.           When a handle type and a handle appear as a pair, if the handle           type is zero, the handle must also be zero.         ]]>
 * @TP_HANDLE_TYPE_CONTACT: <![CDATA[           A contact         ]]>
 * @TP_HANDLE_TYPE_ROOM: <![CDATA[           A chat room         ]]>
 * @TP_HANDLE_TYPE_LIST: <![CDATA[           A server-generated contact list (see Channel.Interface.Group)         ]]>
 * @TP_HANDLE_TYPE_GROUP: <![CDATA[           A user-defined contact list (see Channel.Interface.Group)         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_HANDLE_TYPE_NONE = 0,
    TP_HANDLE_TYPE_CONTACT = 1,
    TP_HANDLE_TYPE_ROOM = 2,
    TP_HANDLE_TYPE_LIST = 3,
    TP_HANDLE_TYPE_GROUP = 4,
} TpHandleType;

/**
 * NUM_TP_HANDLE_TYPES:
 *
 * 1 higher than the highest valid value of #TpHandleType.
 */
#define NUM_TP_HANDLE_TYPES (4+1)

/**
 *
TpConnectionStatus:
 * @TP_CONNECTION_STATUS_CONNECTED: <![CDATA[             The connection is alive and all methods are available.         ]]>
 * @TP_CONNECTION_STATUS_CONNECTING: <![CDATA[             The connection has not yet been established, or has been             severed and reconnection is being attempted. Some methods may fail             until the connection has been established.         ]]>
 * @TP_CONNECTION_STATUS_DISCONNECTED: <![CDATA[             The connection has been severed and no method calls are             valid. The object may be removed from the bus at any time.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CONNECTION_STATUS_CONNECTED = 0,
    TP_CONNECTION_STATUS_CONNECTING = 1,
    TP_CONNECTION_STATUS_DISCONNECTED = 2,
} TpConnectionStatus;

/**
 * NUM_TP_CONNECTION_STATUSES:
 *
 * 1 higher than the highest valid value of #TpConnectionStatus.
 */
#define NUM_TP_CONNECTION_STATUSES (2+1)

/**
 *
TpConnectionStatusReason:
 * @TP_CONNECTION_STATUS_REASON_NONE_SPECIFIED: <![CDATA[             There is no reason set for this state change.         ]]>
 * @TP_CONNECTION_STATUS_REASON_REQUESTED: <![CDATA[             The change is in response to a user request.         ]]>
 * @TP_CONNECTION_STATUS_REASON_NETWORK_ERROR: <![CDATA[             There was an error sending or receiving on the network socket.         ]]>
 * @TP_CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED: <![CDATA[             The username or password was invalid.         ]]>
 * @TP_CONNECTION_STATUS_REASON_ENCRYPTION_ERROR: <![CDATA[             There was an error negotiating SSL on this connection, or             encryption was unavailable and require-encryption was set when the             connection was created.         ]]>
 * @TP_CONNECTION_STATUS_REASON_NAME_IN_USE: <![CDATA[             Someone is already connected to the server using the name             you are trying to connect with.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED: <![CDATA[             The server did not provide a SSL certificate.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_UNTRUSTED: <![CDATA[             The server's SSL certificate could not be trusted.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_EXPIRED: <![CDATA[             The server's SSL certificate has expired.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED: <![CDATA[             The server's SSL certificate is not yet valid.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH: <![CDATA[             The server's SSL certificate did not match its hostname.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH: <![CDATA[             The server's SSL certificate does not have the expected             fingerprint.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_SELF_SIGNED: <![CDATA[             The server's SSL certificate is self-signed.         ]]>
 * @TP_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR: <![CDATA[             There was some other error validating the server's SSL certificate.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CONNECTION_STATUS_REASON_NONE_SPECIFIED = 0,
    TP_CONNECTION_STATUS_REASON_REQUESTED = 1,
    TP_CONNECTION_STATUS_REASON_NETWORK_ERROR = 2,
    TP_CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED = 3,
    TP_CONNECTION_STATUS_REASON_ENCRYPTION_ERROR = 4,
    TP_CONNECTION_STATUS_REASON_NAME_IN_USE = 5,
    TP_CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED = 6,
    TP_CONNECTION_STATUS_REASON_CERT_UNTRUSTED = 7,
    TP_CONNECTION_STATUS_REASON_CERT_EXPIRED = 8,
    TP_CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED = 9,
    TP_CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH = 10,
    TP_CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH = 11,
    TP_CONNECTION_STATUS_REASON_CERT_SELF_SIGNED = 12,
    TP_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR = 13,
} TpConnectionStatusReason;

/**
 * NUM_TP_CONNECTION_STATUS_REASONS:
 *
 * 1 higher than the highest valid value of #TpConnectionStatusReason.
 */
#define NUM_TP_CONNECTION_STATUS_REASONS (13+1)

/**
 *
TpConnectionAliasFlags:
 * @TP_CONNECTION_ALIAS_FLAG_USER_SET: <![CDATA[           The aliases of contacts on this connection may be changed by the             user of the service, not just by the contacts themselves. This is             the case on Jabber, for instance.           It is possible that aliases can be changed by the contacts too -             which alias takes precedence is not defined by this             specification, and depends on the server and/or connection manager             implementation.           This flag only applies to the aliases of "globally valid" contact             handles. At this time, clients should not expect to be able to             change the aliases corresponding to any channel-specific             handles. If this becomes possible in future, a new flag will             be defined.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CONNECTION_ALIAS_FLAG_USER_SET = 1,
} TpConnectionAliasFlags;

/**
 *
TpConnectionCapabilityFlags:
 * @TP_CONNECTION_CAPABILITY_FLAG_CREATE: <![CDATA[           The given channel type and handle can be given to RequestChannel to           create a new channel of this type.         ]]>
 * @TP_CONNECTION_CAPABILITY_FLAG_INVITE: <![CDATA[           The given contact can be invited to an existing channel of this type.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CONNECTION_CAPABILITY_FLAG_CREATE = 1,
    TP_CONNECTION_CAPABILITY_FLAG_INVITE = 2,
} TpConnectionCapabilityFlags;

/**
 *
TpConnectionPresenceType:
 * @TP_CONNECTION_PRESENCE_TYPE_UNSET: <![CDATA[           An invalid presence type used as a null value         ]]>
 * @TP_CONNECTION_PRESENCE_TYPE_OFFLINE: <![CDATA[           Offline         ]]>
 * @TP_CONNECTION_PRESENCE_TYPE_AVAILABLE: <![CDATA[           Available         ]]>
 * @TP_CONNECTION_PRESENCE_TYPE_AWAY: <![CDATA[           Away         ]]>
 * @TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY: <![CDATA[           Away for an extended time         ]]>
 * @TP_CONNECTION_PRESENCE_TYPE_HIDDEN: <![CDATA[           Hidden (invisible)         ]]>
 * @TP_CONNECTION_PRESENCE_TYPE_BUSY: <![CDATA[           Busy, Do Not Disturb.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CONNECTION_PRESENCE_TYPE_UNSET = 0,
    TP_CONNECTION_PRESENCE_TYPE_OFFLINE = 1,
    TP_CONNECTION_PRESENCE_TYPE_AVAILABLE = 2,
    TP_CONNECTION_PRESENCE_TYPE_AWAY = 3,
    TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY = 4,
    TP_CONNECTION_PRESENCE_TYPE_HIDDEN = 5,
    TP_CONNECTION_PRESENCE_TYPE_BUSY = 6,
} TpConnectionPresenceType;

/**
 * NUM_TP_CONNECTION_PRESENCE_TYPES:
 *
 * 1 higher than the highest valid value of #TpConnectionPresenceType.
 */
#define NUM_TP_CONNECTION_PRESENCE_TYPES (6+1)

/**
 *
TpMediaStreamType:
 * @TP_MEDIA_STREAM_TYPE_AUDIO: <![CDATA[An audio stream]]>
 * @TP_MEDIA_STREAM_TYPE_VIDEO: <![CDATA[A video stream]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_TYPE_AUDIO = 0,
    TP_MEDIA_STREAM_TYPE_VIDEO = 1,
} TpMediaStreamType;

/**
 * NUM_TP_MEDIA_STREAM_TYPES:
 *
 * 1 higher than the highest valid value of #TpMediaStreamType.
 */
#define NUM_TP_MEDIA_STREAM_TYPES (1+1)

/**
 *
TpMediaStreamState:
 * @TP_MEDIA_STREAM_STATE_DISCONNECTED: <![CDATA[The stream is disconnected.]]>
 * @TP_MEDIA_STREAM_STATE_CONNECTING: <![CDATA[The stream is trying to connect.]]>
 * @TP_MEDIA_STREAM_STATE_CONNECTED: <![CDATA[The stream is connected.]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_STATE_DISCONNECTED = 0,
    TP_MEDIA_STREAM_STATE_CONNECTING = 1,
    TP_MEDIA_STREAM_STATE_CONNECTED = 2,
} TpMediaStreamState;

/**
 * NUM_TP_MEDIA_STREAM_STATES:
 *
 * 1 higher than the highest valid value of #TpMediaStreamState.
 */
#define NUM_TP_MEDIA_STREAM_STATES (2+1)

/**
 *
TpMediaStreamDirection:
 * @TP_MEDIA_STREAM_DIRECTION_NONE: <![CDATA[Media are not being sent or received]]>
 * @TP_MEDIA_STREAM_DIRECTION_SEND: <![CDATA[Media are being sent, but not received]]>
 * @TP_MEDIA_STREAM_DIRECTION_RECEIVE: <![CDATA[Media are being received, but not sent]]>
 * @TP_MEDIA_STREAM_DIRECTION_BIDIRECTIONAL: <![CDATA[Media are being sent and received]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_DIRECTION_NONE = 0,
    TP_MEDIA_STREAM_DIRECTION_SEND = 1,
    TP_MEDIA_STREAM_DIRECTION_RECEIVE = 2,
    TP_MEDIA_STREAM_DIRECTION_BIDIRECTIONAL = 3,
} TpMediaStreamDirection;

/**
 * NUM_TP_MEDIA_STREAM_DIRECTIONS:
 *
 * 1 higher than the highest valid value of #TpMediaStreamDirection.
 */
#define NUM_TP_MEDIA_STREAM_DIRECTIONS (3+1)

/**
 *
TpMediaStreamPendingSend:
 * @TP_MEDIA_STREAM_PENDING_LOCAL_SEND: <![CDATA[             The local user has been asked to send media by the remote user.             Call RequestStreamDirection to indicate whether or not this is             acceptable.         ]]>
 * @TP_MEDIA_STREAM_PENDING_REMOTE_SEND: <![CDATA[             The remote user has been asked to send media by the local user.             The StreamDirectionChanged signal will be emitted when the remote             user accepts or rejects this change.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_PENDING_LOCAL_SEND = 1,
    TP_MEDIA_STREAM_PENDING_REMOTE_SEND = 2,
} TpMediaStreamPendingSend;

/**
 *
TpChannelMediaCapabilities:
 * @TP_CHANNEL_MEDIA_CAPABILITY_AUDIO: <![CDATA[           The handle is capable of using audio streams within a media channel.         ]]>
 * @TP_CHANNEL_MEDIA_CAPABILITY_VIDEO: <![CDATA[           The handle is capable of using video streams within a media channel.         ]]>
 * @TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_STUN: <![CDATA[           The handle is capable of performing STUN to traverse NATs.         ]]>
 * @TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_GTALK_P2P: <![CDATA[           The handle is capable of establishing Google Talk peer-to-peer           connections (as implemented in libjingle 0.3) to traverse NATs.         ]]>
 *
 * <![CDATA[         The channel-type-specific capability flags used for         Channel.Type.StreamedMedia in the Connection.Interface.Capabilities         interface.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_MEDIA_CAPABILITY_AUDIO = 1,
    TP_CHANNEL_MEDIA_CAPABILITY_VIDEO = 2,
    TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_STUN = 4,
    TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_GTALK_P2P = 8,
} TpChannelMediaCapabilities;

/**
 *
TpChannelTextSendError:
 * @TP_CHANNEL_TEXT_SEND_ERROR_UNKNOWN: <![CDATA[         An unknown error occurred         ]]>
 * @TP_CHANNEL_TEXT_SEND_ERROR_OFFLINE: <![CDATA[         The requested contact was offline         ]]>
 * @TP_CHANNEL_TEXT_SEND_ERROR_INVALID_CONTACT: <![CDATA[         The requested contact is not valid         ]]>
 * @TP_CHANNEL_TEXT_SEND_ERROR_PERMISSION_DENIED: <![CDATA[         The user does not have permission to speak on this channel         ]]>
 * @TP_CHANNEL_TEXT_SEND_ERROR_TOO_LONG: <![CDATA[         The outgoing message was too long and was rejected by the server         ]]>
 * @TP_CHANNEL_TEXT_SEND_ERROR_NOT_IMPLEMENTED: <![CDATA[         The channel doesn't support sending text messages to the requested         contact         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_TEXT_SEND_ERROR_UNKNOWN = 0,
    TP_CHANNEL_TEXT_SEND_ERROR_OFFLINE = 1,
    TP_CHANNEL_TEXT_SEND_ERROR_INVALID_CONTACT = 2,
    TP_CHANNEL_TEXT_SEND_ERROR_PERMISSION_DENIED = 3,
    TP_CHANNEL_TEXT_SEND_ERROR_TOO_LONG = 4,
    TP_CHANNEL_TEXT_SEND_ERROR_NOT_IMPLEMENTED = 5,
} TpChannelTextSendError;

/**
 * NUM_TP_CHANNEL_TEXT_SEND_ERRORS:
 *
 * 1 higher than the highest valid value of #TpChannelTextSendError.
 */
#define NUM_TP_CHANNEL_TEXT_SEND_ERRORS (5+1)

/**
 *
TpChannelTextMessageType:
 * @TP_CHANNEL_TEXT_MESSAGE_TYPE_NORMAL: <![CDATA[         A standard message         ]]>
 * @TP_CHANNEL_TEXT_MESSAGE_TYPE_ACTION: <![CDATA[         An action which might be presented to the user as         "* <sender> <action>", such as an IRC CTCP         ACTION (typically selected by the "/me" command). For example, the         text of the message might be "drinks more coffee".         ]]>
 * @TP_CHANNEL_TEXT_MESSAGE_TYPE_NOTICE: <![CDATA[         A one-off or automated message not necessarily expecting a reply         ]]>
 * @TP_CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY: <![CDATA[         An automatically-generated reply message         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_TEXT_MESSAGE_TYPE_NORMAL = 0,
    TP_CHANNEL_TEXT_MESSAGE_TYPE_ACTION = 1,
    TP_CHANNEL_TEXT_MESSAGE_TYPE_NOTICE = 2,
    TP_CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY = 3,
} TpChannelTextMessageType;

/**
 * NUM_TP_CHANNEL_TEXT_MESSAGE_TYPES:
 *
 * 1 higher than the highest valid value of #TpChannelTextMessageType.
 */
#define NUM_TP_CHANNEL_TEXT_MESSAGE_TYPES (3+1)

/**
 *
TpChannelTextMessageFlags:
 * @TP_CHANNEL_TEXT_MESSAGE_FLAG_TRUNCATED: <![CDATA[         The incoming message was truncated to a shorter length by the         server or the connection manager.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_TEXT_MESSAGE_FLAG_TRUNCATED = 1,
} TpChannelTextMessageFlags;

/**
 *
TpTubeType:
 * @TP_TUBE_TYPE_DBUS: <![CDATA[           An ordered reliable transport, for transporting D-Bus             traffic.            For each D-Bus tube, the connection manager listens on a D-Bus             server address, as detailed in the D-Bus specification. On this             address, it emulates a bus upon which each tube participant appears             as an endpoint.            The objects and interfaces which are expected to exist on the             emulated bus depend on the well-known name; typically, either the             participant who initiated the tube is expected to export the same             objects/interfaces that would be exported by a service of that name             on a bus, or all participants are expected to export those             objects/interfaces.            In a multi-user context (Handle_Type_Room) the tube behaves             like the D-Bus bus daemon, so participants can send each other             private messages, or can send broadcast messages which are             received by everyone in the tube (including themselves).             Each participant has a D-Bus unique name; connection managers             must prevent participants from sending messages with the wrong             sender unique name, and should attempt to avoid participants             receiving messages not intended for them.            In a 1-1 context (Handle_Type_Contact) the tube behaves like             a peer-to-peer D-Bus connection - arbitrary D-Bus messages with             any sender and/or destination can be sent by each participant,             and each participant receives all messages sent by the other             participant.         ]]>
 * @TP_TUBE_TYPE_STREAM: <![CDATA[           A transport for ordered, reliable data transfer, similar to             SOCK_STREAM sockets.            When accepting a Stream Unix tube, a new listening local socket is             created. Each time the client connects to this socket, the             connection manager of the initiator of the tube opens a new             connection to its local socket. Both sides can then use this pair             of sockets to communicate together.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_TUBE_TYPE_DBUS = 0,
    TP_TUBE_TYPE_STREAM = 1,
} TpTubeType;

/**
 * NUM_TP_TUBE_TYPES:
 *
 * 1 higher than the highest valid value of #TpTubeType.
 */
#define NUM_TP_TUBE_TYPES (1+1)

/**
 *
TpTubeState:
 * @TP_TUBE_STATE_LOCAL_PENDING: <![CDATA[           The tube is waiting to be accepted/closed locally.         ]]>
 * @TP_TUBE_STATE_REMOTE_PENDING: <![CDATA[           The tube is waiting to be accepted/closed remotely.         ]]>
 * @TP_TUBE_STATE_OPEN: <![CDATA[           The tube is open for traffic.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_TUBE_STATE_LOCAL_PENDING = 0,
    TP_TUBE_STATE_REMOTE_PENDING = 1,
    TP_TUBE_STATE_OPEN = 2,
} TpTubeState;

/**
 * NUM_TP_TUBE_STATES:
 *
 * 1 higher than the highest valid value of #TpTubeState.
 */
#define NUM_TP_TUBE_STATES (2+1)

/**
 *
TpSocketAddressType:
 * @TP_SOCKET_ADDRESS_TYPE_UNIX: <![CDATA[           A Unix socket. The variant contains a byte-array, signature 'ay',           containing the path of the socket.         ]]>
 * @TP_SOCKET_ADDRESS_TYPE_ABSTRACT_UNIX: <![CDATA[           An abstract Unix socket. The variant contains a byte-array,           signature 'ay', containing the path of the socket including the           leading null byte.         ]]>
 * @TP_SOCKET_ADDRESS_TYPE_IPV4: <![CDATA[           An IPv4 socket. The variant contains a Socket_Address_IPv4,           i.e. a structure with signature (sq)           in which the string is an IPv4 dotted-quad address literal           (and must not be a DNS name), while the 16-bit unsigned integer is           the port number.         ]]>
 * @TP_SOCKET_ADDRESS_TYPE_IPV6: <![CDATA[           An IPv6 socket. The variant contains a Socket_Address_IPv6,           i.e. a structure with signature (sq)           in which the string is an IPv6 address literal as specified in           RFC2373 (and must not be a DNS name), while the 16-bit unsigned           integer is the port number.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_SOCKET_ADDRESS_TYPE_UNIX = 0,
    TP_SOCKET_ADDRESS_TYPE_ABSTRACT_UNIX = 1,
    TP_SOCKET_ADDRESS_TYPE_IPV4 = 2,
    TP_SOCKET_ADDRESS_TYPE_IPV6 = 3,
} TpSocketAddressType;

/**
 * NUM_TP_SOCKET_ADDRESS_TYPES:
 *
 * 1 higher than the highest valid value of #TpSocketAddressType.
 */
#define NUM_TP_SOCKET_ADDRESS_TYPES (3+1)

/**
 *
TpSocketAccessControl:
 * @TP_SOCKET_ACCESS_CONTROL_LOCALHOST: <![CDATA[           The IP or Unix socket can be accessed by any local user (e.g.           a Unix socket that accepts all local connections, or an IP socket           listening on 127.0.0.1 (or ::1) or rejecting connections not from           that address). The associated variant must be ignored.         ]]>
 * @TP_SOCKET_ACCESS_CONTROL_PORT: <![CDATA[           May only be used on IP sockets. The associated variant must contain           a struct Socket_Address_IPv4 (or Socket_Address_IPv6)           containing the string form of an IP address of the appropriate           version, and a port number. The socket can only be accessed if the           connecting process has that address and port number; all other           connections will be rejected.         ]]>
 * @TP_SOCKET_ACCESS_CONTROL_NETMASK: <![CDATA[           May only be used on IP sockets. The associated variant must contain           a struct Socket_Netmask_IPv4 (or Socket_Netmask_IPv6) with           signature (sy), containing the string form of an           IP address of the appropriate version, and a prefix length "n".           The socket can only be accessed if the first n bits of the           connecting address match the first n bits of the given address.         ]]>
 * @TP_SOCKET_ACCESS_CONTROL_CREDENTIALS: <![CDATA[           The connecting process must send a single zero (NUL) byte when             it first connects, which is not considered to be part of the data             stream. If the operating system uses sendmsg() with SCM_CREDS or             SCM_CREDENTIALS to pass credentials over sockets, the connecting             process must do so if possible; if not, it must still send the             byte.            The listening process will disconnect the connection unless it             can determine by OS-specific means that the connecting process             has the same user ID as the listening process.            The associated variant must be ignored.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_SOCKET_ACCESS_CONTROL_LOCALHOST = 0,
    TP_SOCKET_ACCESS_CONTROL_PORT = 1,
    TP_SOCKET_ACCESS_CONTROL_NETMASK = 2,
    TP_SOCKET_ACCESS_CONTROL_CREDENTIALS = 3,
} TpSocketAccessControl;

/**
 * NUM_TP_SOCKET_ACCESS_CONTROLS:
 *
 * 1 higher than the highest valid value of #TpSocketAccessControl.
 */
#define NUM_TP_SOCKET_ACCESS_CONTROLS (3+1)

/**
 *
TpChannelCallStateFlags:
 * @TP_CHANNEL_CALL_STATE_RINGING: <![CDATA[           The contact has been alerted about the call but has not responded           (e.g. 180 Ringing in SIP).         ]]>
 * @TP_CHANNEL_CALL_STATE_QUEUED: <![CDATA[           The contact is temporarily unavailable, and the call has been placed           in a queue (e.g. 182 Queued in SIP, or call-waiting in telephony).         ]]>
 * @TP_CHANNEL_CALL_STATE_HELD: <![CDATA[           The contact has placed the call on hold, and will not receive           media from the local user or any other participants until they           unhold the call again.         ]]>
 *
 * <![CDATA[         A set of flags representing call states.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_CALL_STATE_RINGING = 1,
    TP_CHANNEL_CALL_STATE_QUEUED = 2,
    TP_CHANNEL_CALL_STATE_HELD = 4,
} TpChannelCallStateFlags;

/**
 *
TpChannelChatState:
 * @TP_CHANNEL_CHAT_STATE_GONE: <![CDATA[         The contact has effectively ceased participating in the chat.         ]]>
 * @TP_CHANNEL_CHAT_STATE_INACTIVE: <![CDATA[         The contact has not been active for some time.         ]]>
 * @TP_CHANNEL_CHAT_STATE_ACTIVE: <![CDATA[         The contact is actively participating in the chat.         ]]>
 * @TP_CHANNEL_CHAT_STATE_PAUSED: <![CDATA[         The contact has paused composing a message.         ]]>
 * @TP_CHANNEL_CHAT_STATE_COMPOSING: <![CDATA[         The contact is composing a message to be sent to the chat.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_CHAT_STATE_GONE = 0,
    TP_CHANNEL_CHAT_STATE_INACTIVE = 1,
    TP_CHANNEL_CHAT_STATE_ACTIVE = 2,
    TP_CHANNEL_CHAT_STATE_PAUSED = 3,
    TP_CHANNEL_CHAT_STATE_COMPOSING = 4,
} TpChannelChatState;

/**
 * NUM_TP_CHANNEL_CHAT_STATES:
 *
 * 1 higher than the highest valid value of #TpChannelChatState.
 */
#define NUM_TP_CHANNEL_CHAT_STATES (4+1)

/**
 *
TpDTMFEvent:
 * @TP_DTMF_EVENT_DIGIT_0: <![CDATA[0]]>
 * @TP_DTMF_EVENT_DIGIT_1: <![CDATA[1]]>
 * @TP_DTMF_EVENT_DIGIT_2: <![CDATA[2]]>
 * @TP_DTMF_EVENT_DIGIT_3: <![CDATA[3]]>
 * @TP_DTMF_EVENT_DIGIT_4: <![CDATA[4]]>
 * @TP_DTMF_EVENT_DIGIT_5: <![CDATA[5]]>
 * @TP_DTMF_EVENT_DIGIT_6: <![CDATA[6]]>
 * @TP_DTMF_EVENT_DIGIT_7: <![CDATA[7]]>
 * @TP_DTMF_EVENT_DIGIT_8: <![CDATA[8]]>
 * @TP_DTMF_EVENT_DIGIT_9: <![CDATA[9]]>
 * @TP_DTMF_EVENT_ASTERISK: <![CDATA[*]]>
 * @TP_DTMF_EVENT_HASH: <![CDATA[#]]>
 * @TP_DTMF_EVENT_LETTER_A: <![CDATA[A]]>
 * @TP_DTMF_EVENT_LETTER_B: <![CDATA[B]]>
 * @TP_DTMF_EVENT_LETTER_C: <![CDATA[C]]>
 * @TP_DTMF_EVENT_LETTER_D: <![CDATA[D]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_DTMF_EVENT_DIGIT_0 = 0,
    TP_DTMF_EVENT_DIGIT_1 = 1,
    TP_DTMF_EVENT_DIGIT_2 = 2,
    TP_DTMF_EVENT_DIGIT_3 = 3,
    TP_DTMF_EVENT_DIGIT_4 = 4,
    TP_DTMF_EVENT_DIGIT_5 = 5,
    TP_DTMF_EVENT_DIGIT_6 = 6,
    TP_DTMF_EVENT_DIGIT_7 = 7,
    TP_DTMF_EVENT_DIGIT_8 = 8,
    TP_DTMF_EVENT_DIGIT_9 = 9,
    TP_DTMF_EVENT_ASTERISK = 10,
    TP_DTMF_EVENT_HASH = 11,
    TP_DTMF_EVENT_LETTER_A = 12,
    TP_DTMF_EVENT_LETTER_B = 13,
    TP_DTMF_EVENT_LETTER_C = 14,
    TP_DTMF_EVENT_LETTER_D = 15,
} TpDTMFEvent;

/**
 * NUM_TP_DTMF_EVENTS:
 *
 * 1 higher than the highest valid value of #TpDTMFEvent.
 */
#define NUM_TP_DTMF_EVENTS (15+1)

/**
 *
TpChannelGroupFlags:
 * @TP_CHANNEL_GROUP_FLAG_CAN_ADD: <![CDATA[             The AddMembers method can be used to add or invite members who are             not already in the local pending list (which is always valid).         ]]>
 * @TP_CHANNEL_GROUP_FLAG_CAN_REMOVE: <![CDATA[             The RemoveMembers method can be used to remove channel members             (removing those on the pending local list is always valid).         ]]>
 * @TP_CHANNEL_GROUP_FLAG_CAN_RESCIND: <![CDATA[             The RemoveMembers method can be used on people on the remote             pending list.         ]]>
 * @TP_CHANNEL_GROUP_FLAG_MESSAGE_ADD: <![CDATA[             A message may be sent to the server when calling AddMembers on             contacts who are not currently pending members.         ]]>
 * @TP_CHANNEL_GROUP_FLAG_MESSAGE_REMOVE: <![CDATA[             A message may be sent to the server when calling RemoveMembers on             contacts who are currently channel members.         ]]>
 * @TP_CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT: <![CDATA[             A message may be sent to the server when calling AddMembers on             contacts who are locally pending.         ]]>
 * @TP_CHANNEL_GROUP_FLAG_MESSAGE_REJECT: <![CDATA[             A message may be sent to the server when calling RemoveMembers on             contacts who are locally pending.         ]]>
 * @TP_CHANNEL_GROUP_FLAG_MESSAGE_RESCIND: <![CDATA[             A message may be sent to the server when calling RemoveMembers on             contacts who are remote pending.         ]]>
 * @TP_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES: <![CDATA[                        The members of this group have handles which are specific to             this channel, and are not valid as general-purpose handles on             the connection. Depending on the channel, it may be possible to             call GetHandleOwners to find the owners of these handles, which             should be done if you wish to eg subscribe to the contact's             presence.                                    Connection managers must ensure that any given handle is not             simultaneously a general-purpose handle and a channel-specific             handle.                    ]]>
 * @TP_CHANNEL_GROUP_FLAG_ONLY_ONE_GROUP: <![CDATA[             Placing a contact in multiple groups of this type is not allowed             and will raise NotAvailable (on services where contacts may only             be in one user-defined group, user-defined groups will have             this flag).         ]]>
 * @TP_CHANNEL_GROUP_FLAG_HANDLE_OWNERS_NOT_AVAILABLE: <![CDATA[           In rooms with channel specific handles (ie Channel_Specific_Handles           flag is set), this flag indicates that none of the handle owners are           available, and that GetHandleOwners method will always return 0 for           channel members other than the self handle.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_GROUP_FLAG_CAN_ADD = 1,
    TP_CHANNEL_GROUP_FLAG_CAN_REMOVE = 2,
    TP_CHANNEL_GROUP_FLAG_CAN_RESCIND = 4,
    TP_CHANNEL_GROUP_FLAG_MESSAGE_ADD = 8,
    TP_CHANNEL_GROUP_FLAG_MESSAGE_REMOVE = 16,
    TP_CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT = 32,
    TP_CHANNEL_GROUP_FLAG_MESSAGE_REJECT = 64,
    TP_CHANNEL_GROUP_FLAG_MESSAGE_RESCIND = 128,
    TP_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES = 256,
    TP_CHANNEL_GROUP_FLAG_ONLY_ONE_GROUP = 512,
    TP_CHANNEL_GROUP_FLAG_HANDLE_OWNERS_NOT_AVAILABLE = 1024,
} TpChannelGroupFlags;

/**
 *
TpChannelGroupChangeReason:
 * @TP_CHANNEL_GROUP_CHANGE_REASON_NONE: <![CDATA[             No reason was provided for this change.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_OFFLINE: <![CDATA[             The change is due to a user going offline. Also used when             user is already offline, but this wasn't known previously.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_KICKED: <![CDATA[             The change is due to a kick operation.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_BUSY: <![CDATA[             The change is due to a busy indication.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_INVITED: <![CDATA[             The change is due to an invitation.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_BANNED: <![CDATA[             The change is due to a kick+ban operation.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_ERROR: <![CDATA[             The change is due to an error occurring.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_INVALID_CONTACT: <![CDATA[             The change is because the requested contact does not exist.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_NO_ANSWER: <![CDATA[             The change is because the requested contact did not respond.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_RENAMED: <![CDATA[           The change is because a contact's unique identifier changed.           There must be exactly one handle in the removed set and exactly           one handle in one of the added sets. The Renamed signal on the           Renaming interface will have been emitted for the same handles,           shortly before this MembersChanged signal is emitted.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_PERMISSION_DENIED: <![CDATA[             The change is because there was no permission to contact the             requested handle.         ]]>
 * @TP_CHANNEL_GROUP_CHANGE_REASON_SEPARATED: <![CDATA[           If members are removed with this reason code, the change is             because the group has split into unconnected parts which can only             communicate within themselves (e.g. netsplits on IRC use this             reason code).                                   If members are added with this reason code, the change is because             unconnected parts of the group have rejoined. If this channel             carries messages (e.g. Text or Tubes channels) applications must             assume that the contacts being added are likely to have missed some             messages as a result of the separation, and that the contacts             in the group are likely to have missed some messages from the             contacts being added.                      Note that from the added contacts' perspective, they have been             in the group all along, and the contacts we indicate to be in             the group (including the local user) have just rejoined             the group with reason Separated. Application protocols in Tubes             should be prepared to cope with this situation.                    ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_GROUP_CHANGE_REASON_NONE = 0,
    TP_CHANNEL_GROUP_CHANGE_REASON_OFFLINE = 1,
    TP_CHANNEL_GROUP_CHANGE_REASON_KICKED = 2,
    TP_CHANNEL_GROUP_CHANGE_REASON_BUSY = 3,
    TP_CHANNEL_GROUP_CHANGE_REASON_INVITED = 4,
    TP_CHANNEL_GROUP_CHANGE_REASON_BANNED = 5,
    TP_CHANNEL_GROUP_CHANGE_REASON_ERROR = 6,
    TP_CHANNEL_GROUP_CHANGE_REASON_INVALID_CONTACT = 7,
    TP_CHANNEL_GROUP_CHANGE_REASON_NO_ANSWER = 8,
    TP_CHANNEL_GROUP_CHANGE_REASON_RENAMED = 9,
    TP_CHANNEL_GROUP_CHANGE_REASON_PERMISSION_DENIED = 10,
    TP_CHANNEL_GROUP_CHANGE_REASON_SEPARATED = 11,
} TpChannelGroupChangeReason;

/**
 * NUM_TP_CHANNEL_GROUP_CHANGE_REASONS:
 *
 * 1 higher than the highest valid value of #TpChannelGroupChangeReason.
 */
#define NUM_TP_CHANNEL_GROUP_CHANGE_REASONS (11+1)

/**
 *
TpChannelPasswordFlags:
 * @TP_CHANNEL_PASSWORD_FLAG_PROVIDE: <![CDATA[           The ProvidePassword method must be called now for the user to join           the channel         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_CHANNEL_PASSWORD_FLAG_PROVIDE = 8,
} TpChannelPasswordFlags;

/**
 *
TpMediaStreamError:
 * @TP_MEDIA_STREAM_ERROR_UNKNOWN: <![CDATA[         An unknown error occured.         ]]>
 * @TP_MEDIA_STREAM_ERROR_EOS: <![CDATA[         The end of the stream was reached.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_ERROR_UNKNOWN = 0,
    TP_MEDIA_STREAM_ERROR_EOS = 1,
} TpMediaStreamError;

/**
 * NUM_TP_MEDIA_STREAM_ERRORS:
 *
 * 1 higher than the highest valid value of #TpMediaStreamError.
 */
#define NUM_TP_MEDIA_STREAM_ERRORS (1+1)

/**
 *
TpMediaStreamBaseProto:
 * @TP_MEDIA_STREAM_BASE_PROTO_UDP: <![CDATA[UDP (User Datagram Protocol)]]>
 * @TP_MEDIA_STREAM_BASE_PROTO_TCP: <![CDATA[TCP (Transmission Control Protocol)]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_BASE_PROTO_UDP = 0,
    TP_MEDIA_STREAM_BASE_PROTO_TCP = 1,
} TpMediaStreamBaseProto;

/**
 * NUM_TP_MEDIA_STREAM_BASE_PROTOS:
 *
 * 1 higher than the highest valid value of #TpMediaStreamBaseProto.
 */
#define NUM_TP_MEDIA_STREAM_BASE_PROTOS (1+1)

/**
 *
TpMediaStreamTransportType:
 * @TP_MEDIA_STREAM_TRANSPORT_TYPE_LOCAL: <![CDATA[           A local address         ]]>
 * @TP_MEDIA_STREAM_TRANSPORT_TYPE_DERIVED: <![CDATA[           An external address derived by a method such as STUN         ]]>
 * @TP_MEDIA_STREAM_TRANSPORT_TYPE_RELAY: <![CDATA[           An external stream relay         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_MEDIA_STREAM_TRANSPORT_TYPE_LOCAL = 0,
    TP_MEDIA_STREAM_TRANSPORT_TYPE_DERIVED = 1,
    TP_MEDIA_STREAM_TRANSPORT_TYPE_RELAY = 2,
} TpMediaStreamTransportType;

/**
 * NUM_TP_MEDIA_STREAM_TRANSPORT_TYPES:
 *
 * 1 higher than the highest valid value of #TpMediaStreamTransportType.
 */
#define NUM_TP_MEDIA_STREAM_TRANSPORT_TYPES (2+1)

/**
 *
TpPropertyFlags:
 * @TP_PROPERTY_FLAG_READ: <![CDATA[The property can be read]]>
 * @TP_PROPERTY_FLAG_WRITE: <![CDATA[The property can be written]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    TP_PROPERTY_FLAG_READ = 1,
    TP_PROPERTY_FLAG_WRITE = 2,
} TpPropertyFlags;


#ifdef __cplusplus
}
#endif
